/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.baiwangcloud.client;

import com.baiwang.baiwangcloud.common.HttpClientUtil;
import com.baiwang.baiwangcloud.common.Security;
import com.baiwang.baiwangcloud.utils.StringUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class BaiwangCouldAPIClient {
    private static String charsetName = "UTF-8";
    private String couldKey = null;
    private String reqKey = null;
    private String serviceUrl = null;
    private String jrmkey = null;
    private int connectTimeout = 60000;
    private static final String RESULT_SUCCESS = "success";
    private static final String RESULT_ERROR = "error";
    private static final String RESULT_TIMEOUT = "timeout";
    private boolean isHttps = false;
    private String proxyHost = null;
    private int proxyPort = 0;
    private volatile int connectionCount = 0;

    public BaiwangCouldAPIClient() {
    }

    public BaiwangCouldAPIClient(String string) {
        this.serviceUrl = string;
    }

    public String getCouldKey() {
        return this.couldKey;
    }

    public static void main(String[] stringArray) {
        BaiwangCouldAPIClient baiwangCouldAPIClient = new BaiwangCouldAPIClient();
        String string = "110107102287575";
        String string2 = "88888889";
        String string3 = "http://api.baiwang.com/api/service/bwapi";
        try {
            String string4 = "<?xml version=";
            baiwangCouldAPIClient.login(string3, string, string2);
            System.out.println("\u767b\u5f55\u6210\u529f\uff01");
            String string5 = baiwangCouldAPIClient.rpc(string4);
            System.out.println("---" + string5);
        }
        catch (Exception exception) {
            System.out.println(">>>>>>" + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public void setHttps(boolean bl) {
        this.isHttps = bl;
    }

    public void setProxy(String string, int n) {
        this.proxyHost = string;
        this.proxyPort = n;
    }

    public void login(String string, String string2, String string3) throws Exception {
        String string4 = this.isHttps ? "https" : "http:";
        String string5 = string.substring(0, 5);
        if (string != null && !string5.toLowerCase().equals(string4)) {
            throw new GeneralSecurityException("\u8f93\u5165\u7684\u5730\u5740\u4e0e\u8bbe\u7f6e\u7684HTTP\u534f\u8bae\u4e0d\u4e00\u81f4\uff01");
        }
        HttpPost httpPost = new HttpPost(string);
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        arrayList.add((NameValuePair)new BasicNameValuePair("METHOD", "login"));
        this.reqKey = StringUtil.getLoginKey(string2, string3);
        String string6 = this.sendHttp(httpPost, arrayList, this.reqKey);
        if (string6 == null || string6.trim().equals("")) {
            throw new GeneralSecurityException("\u767b\u5f55\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u6838\u5bf9\u8fde\u63a5IP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e");
        }
        int n = string6.indexOf(",");
        if (n > 0) {
            String string7 = string6.substring(0, n);
            if (RESULT_SUCCESS.equals(string7)) {
                this.jrmkey = string3;
                String string8 = string6.substring(n + 1);
                String string9 = Security.decrypt(string8, string3 = this.processKey(string3));
                String[] stringArray = string9.split(",");
                if (stringArray == null || stringArray.length != 2) {
                    throw new GeneralSecurityException("\u767b\u5f55\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u975e\u6cd5");
                }
                this.couldKey = stringArray[0];
                this.serviceUrl = string;
                this.connectionCount = 0;
            } else {
                if (RESULT_ERROR.equals(string7)) {
                    throw new GeneralSecurityException(string6.substring(n + 1));
                }
                throw new GeneralSecurityException("\u767b\u5f55\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u6838\u5bf9\u8fde\u63a5IP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e");
            }
        }
    }

    private String sendHttp(HttpPost httpPost, List<NameValuePair> list, String string) throws Exception {
        String string2 = "";
        HttpEntity httpEntity = null;
        long l = 0L;
        CloseableHttpClient closeableHttpClient = null;
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            RequestConfig requestConfig = null;
            if (StringUtil.isEmpty(this.proxyHost)) {
                requestConfig = RequestConfig.custom().setSocketTimeout(this.connectTimeout).setConnectTimeout(this.connectTimeout).build();
            } else {
                HttpHost httpHost = new HttpHost(this.proxyHost, this.proxyPort);
                requestConfig = RequestConfig.custom().setProxy(httpHost).setSocketTimeout(this.connectTimeout).setConnectTimeout(this.connectTimeout).build();
            }
            httpPost.setConfig(requestConfig);
            list.add((NameValuePair)new BasicNameValuePair("DATA", string));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, charsetName));
            l = System.currentTimeMillis();
            if (this.isHttps) {
                httpEntity = HttpClientUtil.createSSLClient(httpPost);
            } else {
                closeableHttpClient = HttpClients.createDefault();
                closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
                httpEntity = closeableHttpResponse.getEntity();
            }
            if (httpEntity != null) {
                string2 = EntityUtils.toString((HttpEntity)httpEntity, (String)charsetName);
            }
        }
        catch (Exception exception) {
            long l2 = System.currentTimeMillis();
            if ("Connection reset".equals(exception.getMessage())) {
                throw new GeneralSecurityException("\u7cfb\u7edf\u901a\u8baf\u6545\u969c,\u8bf7\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u6b63\u5e38!");
            }
            if (exception.getMessage().contains("Unrecognized SSL message")) {
                exception.printStackTrace();
                throw new GeneralSecurityException("https\u4e0d\u53ef\u7528\uff01");
            }
            if (exception.getMessage().contains("Read timed out")) {
                System.out.println(l - l2);
                throw new GeneralSecurityException("\u8bfb\u53d6\u8d85\u8fc7\u6700\u5927\u7684\u8bbe\u7f6e\u65f6\u95f4\uff01");
            }
            throw new GeneralSecurityException(exception.getMessage());
        }
        finally {
            if (!this.isHttps) {
                closeableHttpResponse.close();
                closeableHttpClient.close();
            }
        }
        return string2;
    }

    private String processKey(String string) {
        if (string == null) {
            string = "000000";
        } else if (string.length() > 8) {
            string = string.substring(0, 8);
        } else if (string.length() < 8) {
            while (string.length() < 8) {
                string = string + "0";
            }
        }
        return string;
    }

    public String rpc(String string) throws Exception {
        HttpPost httpPost = new HttpPost(this.serviceUrl);
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        arrayList.add((NameValuePair)new BasicNameValuePair("METHOD", "rpc"));
        String string2 = this.reqKey + "@" + Security.encrypt(string, this.couldKey);
        String string3 = this.sendHttp(httpPost, arrayList, string2);
        if (string3 == null || string3.trim().equals("")) {
            throw new GeneralSecurityException("\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u6838\u5bf9\u8fde\u63a5IP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e");
        }
        int n = string3.indexOf(",");
        if (n > 0) {
            String string4 = string3.substring(0, n);
            if (RESULT_SUCCESS.equals(string4)) {
                String string5 = string3.substring(n + 1);
                String string6 = Security.decrypt(string5, this.couldKey);
                return string6;
            }
            if (RESULT_ERROR.equals(string4)) {
                throw new GeneralSecurityException(string3.substring(n + 1));
            }
            if (RESULT_TIMEOUT.equals(string4)) {
                if (this.connectionCount == 3) {
                    throw new GeneralSecurityException("\u7cfb\u7edf\u901a\u8baf\u6545\u969c,\u8bf7\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u6b63\u5e38");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++this.connectionCount;
                String string7 = this.reConnect(arrayList, httpPost, string);
                return string7;
            }
            throw new GeneralSecurityException("\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u6838\u5bf9\u8fde\u63a5IP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e");
        }
        return null;
    }

    private String reConnect(List<NameValuePair> list, HttpPost httpPost, String string) throws Exception {
        String string2 = "";
        list.clear();
        list.add((NameValuePair)new BasicNameValuePair("METHOD", "login"));
        String string3 = this.sendHttp(httpPost, list, this.reqKey);
        if (string3 == null || string3.trim().equals("")) {
            throw new GeneralSecurityException("\u767b\u5f55\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u6838\u5bf9\u8fde\u63a5IP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e");
        }
        int n = string3.indexOf(",");
        if (n > 0) {
            String string4 = string3.substring(0, n);
            if (RESULT_SUCCESS.equals(string4)) {
                String string5 = string3.substring(n + 1);
                this.jrmkey = this.processKey(this.jrmkey);
                String string6 = Security.decrypt(string5, this.jrmkey);
                String[] stringArray = string6.split(",");
                if (stringArray == null || stringArray.length != 2) {
                    throw new GeneralSecurityException("\u767b\u5f55\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u975e\u6cd5");
                }
                this.couldKey = stringArray[0];
                string2 = this.rpc(string);
            } else {
                if (RESULT_ERROR.equals(string4)) {
                    throw new GeneralSecurityException(string3.substring(n + 1));
                }
                throw new GeneralSecurityException("\u767b\u5f55\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u6838\u5bf9\u8fde\u63a5IP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e");
            }
        }
        return string2;
    }

    public void logout() throws GeneralSecurityException, IOException {
        HttpPost httpPost = new HttpPost(this.serviceUrl);
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        arrayList.add((NameValuePair)new BasicNameValuePair("METHOD", "logout"));
        try {
            String string;
            String string2 = this.sendHttp(httpPost, arrayList, this.reqKey);
            if (string2 == null || string2.trim().equals("")) {
                throw new GeneralSecurityException("\u9000\u51fa\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u6838\u5bf9\u8fde\u63a5IP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e");
            }
            int n = string2.indexOf(",");
            if (n > 0 && !RESULT_SUCCESS.equals(string = string2.substring(0, n))) {
                if (RESULT_ERROR.equals(string)) {
                    throw new GeneralSecurityException(string2.substring(n + 1));
                }
                throw new GeneralSecurityException("\u9000\u51fa\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u6838\u5bf9\u8fde\u63a5IP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e");
            }
        }
        catch (Exception exception) {
            throw new GeneralSecurityException("\u9000\u51fa\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u6838\u5bf9\u8fde\u63a5IP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e");
        }
    }

    public String rpc2(String string, String string2, String string3) throws Exception {
        this.connectTimeout = 600000;
        HttpPost httpPost = new HttpPost(string);
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        arrayList.add((NameValuePair)new BasicNameValuePair("METHOD", "rpc"));
        arrayList.add((NameValuePair)new BasicNameValuePair("NSRSBH", string3));
        String string4 = this.sendHttp(httpPost, arrayList, string2);
        if (string4 == null || string4.trim().equals("")) {
            throw new GeneralSecurityException("\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u6838\u5bf9\u8fdc\u7a0b\u8bbf\u95ee\u8def\u5f84\u662f\u5426\u6b63\u5e38");
        }
        return string4;
    }
}

