/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.baiwangcloud.common;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class Security {
    public static String charsetName = "UTF-8";
    private static ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal();

    public static final String toHex(byte[] md) {
        int j = md.length;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] str = new char[j * 2];
        int k = 0;
        int i = 0;
        while (i < j) {
            byte byte0 = md[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
            ++i;
        }
        return new String(str);
    }

    private static int hexToNum(char c) {
        int num = 0;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int j = 0;
        while (j < hexDigits.length) {
            if (c == hexDigits[j]) {
                num = j;
            }
            ++j;
        }
        return num;
    }

    public static byte[] toDecimal(String msg) {
        byte[] result = new byte[msg.length() / 2];
        char[] origional = msg.toCharArray();
        int i = 0;
        while (i < origional.length - 1) {
            if (i % 2 == 0) {
                result[i / 2] = (byte)(Security.hexToNum(origional[i]) * 16 + Security.hexToNum(origional[i + 1]));
            }
            ++i;
        }
        return result;
    }

    public static final String MD5(String s) {
        try {
            byte[] btInput = s.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            return Security.toHex(md);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encrypt(String data, String key) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] src = data.getBytes(charsetName);
        Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        DESKeySpec desKeySpec = new DESKeySpec(key.getBytes(charsetName));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
        IvParameterSpec iv = new IvParameterSpec(key.getBytes(charsetName));
        cipher.init(1, (Key)secretKey, iv);
        return Security.toHex(cipher.doFinal(src));
    }

    public static String decrypt(String src, String key) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] data = Security.toDecimal(src);
        Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        DESKeySpec desKeySpec = new DESKeySpec(key.getBytes(charsetName));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(desKeySpec);
        IvParameterSpec iv = new IvParameterSpec(key.getBytes(charsetName));
        cipher.init(2, (Key)securekey, iv);
        return new String(cipher.doFinal(data), charsetName);
    }

    public static String getRandom(int num) {
        Double key = Math.random() * 100000.0;
        String result = new Integer(key.intValue()).toString();
        if (result.length() > num) {
            result = result.substring(result.length() - num);
        } else {
            int i = num - result.length();
            while (i > 0) {
                result = "0" + result;
                --i;
            }
        }
        return result;
    }

    public static String getCurrentString() {
        if (dateFormat.get() == null) {
            dateFormat.set(new SimpleDateFormat("yyyyMMddhhssmmSSS"));
        }
        return dateFormat.get().format(new Timestamp(System.currentTimeMillis()));
    }
}

