/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.toolkit;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DsConfigUtil {
    private static final Pattern LINE_PATTERN = Pattern.compile("-(\\w)");

    public static String lineToUpper(String str) {
        Matcher matcher = LINE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Map<String, Object> mergeMap(Map<String, Object> c, Map<String, Object> g) {
        int size = 1 + (int)((double)(c.size() + g.size()) / 0.75);
        HashMap<String, Object> map = new HashMap<String, Object>(size);
        map.putAll(g);
        map.putAll(c);
        return map;
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz) {
        HashMap<String, PropertyDescriptor> methodMap = new HashMap<String, PropertyDescriptor>();
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                if ("class".equals(pd.getName())) continue;
                methodMap.put(pd.getName(), pd);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return methodMap;
    }

    public static Map<String, Method> getGetterMethods(Class<?> clazz) {
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                Method method = pd.getReadMethod();
                if (method == null) continue;
                methodMap.put(pd.getName(), method);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return methodMap;
    }

    public static Map<String, Method> getSetterMethods(Class<?> clazz) {
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                Method method = pd.getWriteMethod();
                if (method == null) continue;
                methodMap.put(pd.getName(), method);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return methodMap;
    }

    public static Object convertValue(Method method, Object value) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 1) {
            Class<?> parameterType = parameterTypes[0];
            String propertyValue = String.valueOf(value);
            if (parameterType == String.class) {
                return propertyValue;
            }
            if (parameterType == Integer.class || parameterType == Integer.TYPE) {
                return Integer.valueOf(propertyValue);
            }
            if (parameterType == Long.class || parameterType == Long.TYPE) {
                return Long.valueOf(propertyValue);
            }
            if (parameterType == Boolean.class || parameterType == Boolean.TYPE) {
                return Boolean.valueOf(propertyValue);
            }
            if (parameterType == Double.class || parameterType == Double.TYPE) {
                return Double.valueOf(propertyValue);
            }
            if (parameterType == Float.class || parameterType == Float.TYPE) {
                return Float.valueOf(propertyValue);
            }
        }
        return value;
    }
}

