/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.DB2Dialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.GBase8sDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.Hive2Dialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.InformixDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.MySqlDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.Oracle12cDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.OracleDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.PostgreDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SQLServer2005Dialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SybaseDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.TrinoDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.XCloudDialect;
import java.util.EnumMap;
import java.util.Map;

public class DialectFactory {
    private static final Map<DbType, IDialect> DIALECT_ENUM_MAP = new EnumMap<DbType, IDialect>(DbType.class);

    public static IDialect getDialect(DbType dbType) {
        IDialect dialect = DIALECT_ENUM_MAP.get(dbType);
        if (null == dialect) {
            if (dbType == DbType.OTHER) {
                throw ExceptionUtils.mpe((String)"%s database not supported.", (Object[])new Object[]{dbType.getDb()});
            }
            if (dbType.mysqlSameType()) {
                dialect = new MySqlDialect();
            } else if (dbType.oracleSameType()) {
                dialect = new OracleDialect();
            } else if (dbType.postgresqlSameType()) {
                dialect = new PostgreDialect();
            } else if (dbType == DbType.ORACLE_12C || dbType == DbType.FIREBIRD || dbType == DbType.SQL_SERVER || dbType == DbType.DERBY) {
                dialect = new Oracle12cDialect();
            } else if (dbType == DbType.DB2) {
                dialect = new DB2Dialect();
            } else if (dbType == DbType.SQL_SERVER2005) {
                dialect = new SQLServer2005Dialect();
            } else if (dbType == DbType.SYBASE) {
                dialect = new SybaseDialect();
            } else if (dbType == DbType.XCloud) {
                dialect = new XCloudDialect();
            } else if (dbType == DbType.GBASE_8S || dbType == DbType.GBASEDBT || dbType == DbType.GBASE_INFORMIX || dbType == DbType.SINODB) {
                dialect = new GBase8sDialect();
            } else if (dbType == DbType.INFORMIX) {
                dialect = new InformixDialect();
            } else if (dbType == DbType.TRINO || dbType == DbType.PRESTO) {
                dialect = new TrinoDialect();
            } else if (dbType == DbType.HIVE2) {
                dialect = new Hive2Dialect();
            }
            DIALECT_ENUM_MAP.put(dbType, dialect);
        }
        return dialect;
    }
}

