/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.service.impl;

import com.baomidou.framework.service.IService;
import com.baomidou.mybatisplus.annotations.IdType;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.CollectionUtil;
import com.baomidou.mybatisplus.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.toolkit.TableInfo;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceImpl<M extends BaseMapper<T, PK>, T, PK extends Serializable>
implements IService<T, PK> {
    protected static final Logger logger = Logger.getLogger("ServiceImpl");
    @Autowired
    protected M baseMapper;

    protected boolean retBool(int result) {
        return result >= 1;
    }

    public boolean insertOrUpdate(T entity, boolean isSelective) {
        if (null != entity) {
            Class<?> cls = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            if (null != tableInfo) {
                Object idVal = ReflectionKit.getMethodValue(cls, entity, tableInfo.getKeyProperty());
                if (null == idVal || "".equals(idVal)) {
                    return isSelective ? this.insertSelective(entity) : this.insert(entity);
                }
                if (IdType.INPUT == tableInfo.getIdType()) {
                    T entityValue = this.selectById((Serializable)idVal);
                    if (null != entityValue) {
                        return isSelective ? this.updateSelectiveById(entity) : this.updateById(entity);
                    }
                    return isSelective ? this.insertSelective(entity) : this.insert(entity);
                }
                return isSelective ? this.updateSelectiveById(entity) : this.updateById(entity);
            }
            throw new MybatisPlusException("Error:  Cannot execute. Could not find @TableId.");
        }
        return false;
    }

    @Override
    public boolean insertOrUpdate(T entity) {
        return this.insertOrUpdate(entity, false);
    }

    @Override
    public boolean insertOrUpdateSelective(T entity) {
        return this.insertOrUpdate(entity, true);
    }

    @Override
    public boolean insert(T entity) {
        return this.retBool(this.baseMapper.insert(entity));
    }

    @Override
    public boolean insertSelective(T entity) {
        return this.retBool(this.baseMapper.insertSelective(entity));
    }

    @Override
    public boolean insertBatch(List<T> entityList) {
        if (CollectionUtil.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        return this.retBool(this.baseMapper.insertBatch(entityList));
    }

    @Override
    public boolean insertBatchSelective(List<T> entityList, int batchSize) {
        return this.insertBatch(entityList, batchSize, true);
    }

    @Override
    public boolean insertBatch(List<T> entityList, int batchSize) {
        return this.insertBatch(entityList, batchSize, false);
    }

    protected boolean insertBatch(List<T> entityList, int batchSize, boolean isSelective) {
        if (CollectionUtil.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.currentModleClass());
        if (null == tableInfo) {
            throw new MybatisPlusException("Error: Cannot execute insertBatch Method, ClassGenricType not found .");
        }
        SqlSession batchSqlSession = tableInfo.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        try {
            int size = entityList.size();
            for (int i = 0; i < size; ++i) {
                if (isSelective) {
                    this.baseMapper.insertSelective(entityList.get(i));
                } else {
                    this.baseMapper.insert(entityList.get(i));
                }
                if (i % batchSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Exception e) {
            logger.warning("Error: Cannot execute insertBatch Method. Cause:" + e);
            return false;
        }
        return true;
    }

    protected Class<T> currentModleClass() {
        return ReflectionKit.getSuperClassGenricType(this.getClass(), 1);
    }

    @Override
    public boolean insertBatchSelective(List<T> entityList) {
        T t;
        if (CollectionUtil.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        int result = 0;
        Iterator<T> iterator = entityList.iterator();
        while (iterator.hasNext() && (result = this.baseMapper.insertSelective(t = iterator.next())) > 0) {
        }
        return this.retBool(result);
    }

    @Override
    public boolean deleteById(Serializable id) {
        return this.retBool(this.baseMapper.deleteById(id));
    }

    @Override
    public boolean deleteByMap(Map<String, Object> columnMap) {
        return this.retBool(this.baseMapper.deleteByMap(columnMap));
    }

    @Override
    public boolean deleteSelective(T entity) {
        return this.retBool(this.baseMapper.deleteSelective(entity));
    }

    @Override
    public boolean deleteBatchIds(List<? extends Serializable> idList) {
        return this.retBool(this.baseMapper.deleteBatchIds(idList));
    }

    @Override
    public boolean updateById(T entity) {
        return this.retBool(this.baseMapper.updateById(entity));
    }

    @Override
    public boolean updateSelectiveById(T entity) {
        return this.retBool(this.baseMapper.updateSelectiveById(entity));
    }

    @Override
    public boolean update(T entity, T whereEntity) {
        return this.retBool(this.baseMapper.update(entity, whereEntity));
    }

    @Override
    public boolean updateSelective(T entity, T whereEntity) {
        return this.retBool(this.baseMapper.updateSelective(entity, whereEntity));
    }

    @Override
    public boolean updateBatchById(List<T> entityList) {
        return this.retBool(this.baseMapper.updateBatchById(entityList));
    }

    @Override
    public T selectById(Serializable id) {
        return this.baseMapper.selectById(id);
    }

    @Override
    public List<T> selectBatchIds(List<? extends Serializable> idList) {
        return this.baseMapper.selectBatchIds(idList);
    }

    @Override
    public List<T> selectByMap(Map<String, Object> columnMap) {
        return this.baseMapper.selectByMap(columnMap);
    }

    @Override
    public T selectOne(T entity) {
        return this.baseMapper.selectOne(entity);
    }

    @Override
    public T selectOne(EntityWrapper<T> entityWrapper) {
        List<T> list = this.baseMapper.selectList(entityWrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            int size = list.size();
            if (size > 1) {
                logger.warning(String.format("Warn: selectOne Method There are  %s results.", size));
            }
            return list.get(0);
        }
        return null;
    }

    @Override
    public int selectCount(T entity) {
        return this.baseMapper.selectCount(entity);
    }

    @Override
    public int selectCount(EntityWrapper<T> entityWrapper) {
        return this.baseMapper.selectCountByEw(entityWrapper);
    }

    @Override
    public List<T> selectList(EntityWrapper<T> entityWrapper) {
        return this.baseMapper.selectList(entityWrapper);
    }

    @Override
    public Page<T> selectPage(Page<T> page, EntityWrapper<T> entityWrapper) {
        if (null != entityWrapper) {
            entityWrapper.orderBy(page.getOrderByField(), page.isAsc());
        }
        page.setRecords(this.baseMapper.selectPage(page, entityWrapper));
        return page;
    }
}

