/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator;

import com.baomidou.mybatisplus.annotations.IdType;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.generator.ConfigDataSource;
import com.baomidou.mybatisplus.generator.ConfigGenerator;
import com.baomidou.mybatisplus.generator.ConfigIdType;
import com.baomidou.mybatisplus.mapper.DBType;
import com.baomidou.mybatisplus.toolkit.SqlReservedWords;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoGenerator {
    protected ConfigGenerator config;
    protected static String PATH_ENTITY = null;
    protected static String PATH_MAPPER = null;
    protected static String PATH_XML = null;
    protected static String PATH_SERVICE = null;
    protected static String PATH_SERVICE_IMPL = null;
    protected static String PATH_CONTROLLER_IMPL = null;
    protected static boolean FILE_OVERRIDE = false;
    protected static final String JAVA_SUFFIX = ".java";
    protected static final String XML_SUFFIX = ".xml";

    public ConfigGenerator getConfig() {
        return this.config;
    }

    public void setConfig(ConfigGenerator config) {
        this.config = config;
    }

    public AutoGenerator() {
    }

    public AutoGenerator(ConfigGenerator config) {
        this.config = config;
    }

    public static void run(ConfigGenerator config) {
        if (config == null) {
            throw new MybatisPlusException(" ConfigGenerator is null. ");
        }
        if (config.getIdType() == null) {
            throw new MybatisPlusException("ConfigGenerator IdType is null");
        }
        File gf = new File(config.getSaveDir());
        if (!gf.exists()) {
            gf.mkdirs();
        }
        String saveDir = gf.getPath();
        PATH_ENTITY = AutoGenerator.getFilePath(saveDir, AutoGenerator.getPathFromPackageName(config.getEntityPackage()));
        PATH_MAPPER = AutoGenerator.getFilePath(saveDir, AutoGenerator.getPathFromPackageName(config.getMapperPackage()));
        PATH_XML = AutoGenerator.getFilePath(saveDir, AutoGenerator.getPathFromPackageName(config.getXmlPackage()));
        PATH_SERVICE = AutoGenerator.getFilePath(saveDir, AutoGenerator.getPathFromPackageName(config.getServicePackage()));
        PATH_SERVICE_IMPL = AutoGenerator.getFilePath(saveDir, AutoGenerator.getPathFromPackageName(config.getServiceImplPackage()));
        PATH_CONTROLLER_IMPL = AutoGenerator.getFilePath(saveDir, AutoGenerator.getPathFromPackageName(config.getControllerPackage()));
        FILE_OVERRIDE = config.isFileOverride();
        new AutoGenerator(config).generate();
        try {
            String osName = System.getProperty("os.name");
            if (osName != null) {
                if (osName.contains("Mac")) {
                    Runtime.getRuntime().exec("open " + config.getSaveDir());
                } else if (osName.contains("Windows")) {
                    Runtime.getRuntime().exec("cmd /c start " + config.getSaveDir());
                } else {
                    System.err.println("save dir:" + config.getSaveDir());
                }
            }
            System.out.println(" generate success! ");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static String getPathFromPackageName(String packageName) {
        if (StringUtils.isEmpty(packageName)) {
            return "";
        }
        return packageName.replace(".", File.separator);
    }

    protected static String getFilePath(String savePath, String segment) {
        File folder = new File(savePath + File.separator + segment);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        Connection conn = null;
        try {
            List<String> tables;
            Class.forName(this.config.getDbDriverName());
            conn = DriverManager.getConnection(this.config.getDbUrl(), this.config.getDbUser(), this.config.getDbPassword());
            boolean isOracle = false;
            if (this.config.getConfigDataSource() == ConfigDataSource.ORACLE) {
                isOracle = true;
            }
            if (null == (tables = this.getTables(conn))) {
                return;
            }
            Map<String, String> tableComments = this.getTableComment(conn);
            for (String table : tables) {
                ArrayList<String> columns = new ArrayList<String>();
                ArrayList<String> types = new ArrayList<String>();
                ArrayList<String> comments = new ArrayList<String>();
                boolean idExist = false;
                HashMap<String, IdInfo> idMap = new HashMap<String, IdInfo>();
                String tableFieldsSql = String.format(this.config.getConfigDataSource().getTableFieldsSql(), table);
                ResultSet results = conn.prepareStatement(tableFieldsSql).executeQuery();
                while (results.next()) {
                    String key;
                    String field = results.getString(this.config.getConfigDataSource().getFieldName());
                    if (null != this.config.getConfigBaseEntity() && this.config.getConfigBaseEntity().includeColumns(field)) continue;
                    columns.add(field);
                    types.add(results.getString(this.config.getConfigDataSource().getFieldType()));
                    comments.add(results.getString(this.config.getConfigDataSource().getFieldComment()));
                    if (isOracle || idExist || !"PRI".equals(key = results.getString(this.config.getConfigDataSource().getFieldKey()))) continue;
                    boolean autoIncrement = false;
                    if ("auto_increment".equals(results.getString("EXTRA"))) {
                        autoIncrement = true;
                    }
                    idExist = true;
                    idMap.put(field, new IdInfo(field, autoIncrement));
                }
                if (isOracle) {
                    String idSql = String.format("SELECT A.COLUMN_NAME FROM USER_CONS_COLUMNS A, USER_CONSTRAINTS B WHERE A.CONSTRAINT_NAME = B.CONSTRAINT_NAME AND B.CONSTRAINT_TYPE = 'P' AND A.TABLE_NAME = '%s'", table);
                    ResultSet rs = conn.prepareStatement(idSql).executeQuery();
                    while (rs.next() && !idExist) {
                        String field = rs.getString(this.config.getConfigDataSource().getFieldKey());
                        idExist = true;
                        idMap.put(field, new IdInfo(field, false));
                    }
                }
                String beanName = this.getBeanName(table, this.config.isDbPrefix());
                String mapperName = String.format(this.config.getMapperName(), beanName);
                String mapperXMLName = String.format(this.config.getMapperXMLName(), beanName);
                String serviceName = String.format(this.config.getServiceName(), beanName);
                String serviceImplName = String.format(this.config.getServiceImplName(), beanName);
                String controllerName = String.format(this.config.getControllerName(), beanName);
                if (this.valideFile(PATH_ENTITY, beanName, JAVA_SUFFIX)) {
                    this.buildEntityBean(columns, types, comments, tableComments.get(table), idMap, table, beanName);
                }
                if (this.valideFile(PATH_MAPPER, mapperName, JAVA_SUFFIX)) {
                    this.buildMapper(beanName, mapperName);
                }
                if (this.valideFile(PATH_XML, mapperXMLName, XML_SUFFIX)) {
                    this.buildMapperXml(beanName, columns, types, comments, idMap, mapperName, mapperXMLName);
                }
                if (this.valideFile(PATH_SERVICE, serviceName, JAVA_SUFFIX)) {
                    this.buildService(beanName, serviceName);
                }
                if (this.valideFile(PATH_SERVICE_IMPL, serviceImplName, JAVA_SUFFIX)) {
                    this.buildServiceImpl(beanName, serviceImplName, serviceName, mapperName);
                }
                if (!this.valideFile(PATH_CONTROLLER_IMPL, controllerName, JAVA_SUFFIX)) continue;
                this.buildController(beanName, controllerName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected boolean valideFile(String dirPath, String beanName, String suffix) {
        File file = new File(dirPath, beanName + suffix);
        return !file.exists() || FILE_OVERRIDE;
    }

    protected List<String> getTables(Connection conn) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        PreparedStatement pstate = conn.prepareStatement(this.config.getConfigDataSource().getTablesSql());
        ResultSet results = pstate.executeQuery();
        while (results.next()) {
            tables.add(results.getString(1));
        }
        String[] tableNames = this.config.getTableNames();
        if (null == tableNames || tableNames.length == 0) {
            return tables;
        }
        List<String> custTables = Arrays.asList(tableNames);
        ArrayList<String> notExistTables = new ArrayList<String>();
        for (String tb : custTables) {
            if (tables.contains(tb)) continue;
            notExistTables.add(tb);
        }
        if (notExistTables.size() == 0) {
            return custTables;
        }
        System.err.println("tablename " + ((Object)notExistTables).toString() + " is not exist!! ==> stop generate!!");
        return null;
    }

    protected String getBeanName(String table, boolean includePrefix) {
        StringBuilder sb = new StringBuilder();
        if (table.contains("_")) {
            String[] tables = table.split("_");
            int l = tables.length;
            int s = 0;
            if (includePrefix) {
                s = 1;
            }
            for (int i = s; i < l; ++i) {
                String temp = tables[i].trim();
                sb.append(temp.substring(0, 1).toUpperCase()).append(temp.substring(1).toLowerCase());
            }
        } else {
            sb.append(table.substring(0, 1).toUpperCase()).append(table.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    protected String processType(String type) {
        if (this.config.getConfigDataSource() == ConfigDataSource.ORACLE) {
            return this.oracleProcessType(type);
        }
        return this.mysqlProcessType(type);
    }

    protected String mysqlProcessType(String type) {
        String t = type.toLowerCase();
        if (t.contains("char") || t.contains("text")) {
            return "String";
        }
        if (t.contains("bigint")) {
            return "Long";
        }
        if (t.contains("int")) {
            return "Integer";
        }
        if (t.contains("date") || t.contains("time") || t.contains("year")) {
            return "Date";
        }
        if (t.contains("text")) {
            return "String";
        }
        if (t.contains("bit")) {
            return "Boolean";
        }
        if (t.contains("decimal")) {
            return "BigDecimal";
        }
        if (t.contains("blob")) {
            return "byte[]";
        }
        if (t.contains("float")) {
            return "Float";
        }
        if (t.contains("double")) {
            return "Double";
        }
        if (t.contains("json") || t.contains("enum")) {
            return "String";
        }
        return null;
    }

    protected String oracleProcessType(String type) {
        String t = type.toUpperCase();
        if (t.contains("CHAR")) {
            return "String";
        }
        if (t.contains("DATE") || t.contains("TIMESTAMP")) {
            return "Date";
        }
        if (t.contains("NUMBER")) {
            if (t.matches("NUMBER\\(+\\d{1}+\\)")) {
                return "Integer";
            }
            if (t.matches("NUMBER\\(+\\d{2}+\\)")) {
                return "Long";
            }
            return "Double";
        }
        if (t.contains("FLOAT")) {
            return "Float";
        }
        if (t.contains("BLOB")) {
            return "Object";
        }
        if (t.contains("RAW")) {
            return "byte[]";
        }
        return null;
    }

    protected boolean isDate(List<String> types) {
        for (String type : types) {
            String t = type.toLowerCase();
            if (!t.contains("date") && !t.contains("time")) continue;
            return true;
        }
        return false;
    }

    protected boolean isDecimal(List<String> types) {
        for (String type : types) {
            if (!type.toLowerCase().contains("decimal")) continue;
            return true;
        }
        return false;
    }

    protected String processField(String field) {
        if (!field.contains("_")) {
            if (StringUtils.isUpperCase(field)) {
                return field.toLowerCase();
            }
            return field;
        }
        StringBuilder sb = new StringBuilder();
        String[] fields = field.split("_");
        sb.append(fields[0].toLowerCase());
        for (int i = 1; i < fields.length; ++i) {
            String temp = fields[i];
            sb.append(temp.substring(0, 1).toUpperCase());
            sb.append(temp.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    protected BufferedWriter buildClassComment(BufferedWriter bw, String text) throws IOException {
        bw.newLine();
        bw.write("/**");
        bw.newLine();
        bw.write(" *");
        bw.newLine();
        bw.write(" * " + text);
        bw.newLine();
        bw.write(" *");
        bw.newLine();
        bw.write(" */");
        return bw;
    }

    protected void buildEntityBean(List<String> columns, List<String> types, List<String> comments, String tableComment, Map<String, IdInfo> idMap, String table, String beanName) throws IOException {
        int i;
        File beanFile = new File(PATH_ENTITY, beanName + JAVA_SUFFIX);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(beanFile)));
        bw.write("package " + this.config.getEntityPackage() + ";");
        bw.newLine();
        bw.newLine();
        bw.write("import java.io.Serializable;");
        bw.newLine();
        if (this.isDate(types)) {
            bw.write("import java.util.Date;");
            bw.newLine();
        }
        if (this.isDecimal(types)) {
            bw.write("import java.math.BigDecimal;");
            bw.newLine();
        }
        bw.newLine();
        if (this.config.getIdType() != IdType.ID_WORKER) {
            bw.write("import com.baomidou.mybatisplus.annotations.IdType;");
            bw.newLine();
        }
        bw.newLine();
        if (null != this.config.getConfigBaseEntity() && null != this.config.getConfigBaseEntity().getPackageName() && !this.config.getEntityPackage().equals(this.config.getConfigBaseEntity().getPackageName())) {
            bw.write("import " + this.config.getConfigBaseEntity().getPackageName() + ";");
            bw.newLine();
        }
        bw.write("import com.baomidou.mybatisplus.annotations.TableField;");
        bw.newLine();
        if (null == this.config.getConfigBaseEntity()) {
            bw.write("import com.baomidou.mybatisplus.annotations.TableId;");
            bw.newLine();
        }
        if (table.contains("_")) {
            bw.write("import com.baomidou.mybatisplus.annotations.TableName;");
            bw.newLine();
        }
        bw = this.buildClassComment(bw, tableComment);
        bw.newLine();
        if (table.contains("_")) {
            bw.write("@TableName(\"" + table + "\")");
            bw.newLine();
        }
        if (null != this.config.getConfigBaseEntity()) {
            bw.write("public class " + beanName + " extends " + this.config.getConfigBaseEntity().getClassName() + " {");
        } else {
            bw.write("public class " + beanName + " implements Serializable {");
        }
        bw.newLine();
        bw.newLine();
        bw.write("\t@TableField(exist = false)");
        bw.newLine();
        bw.write("\tprivate static final long serialVersionUID = 1L;");
        bw.newLine();
        int size = columns.size();
        for (i = 0; i < size; ++i) {
            bw.newLine();
            bw.write("\t/** " + comments.get(i) + " */");
            bw.newLine();
            String column = columns.get(i);
            String field = this.processField(column);
            boolean isLine = column.contains("_");
            IdInfo idInfo = idMap.get(column);
            if (idInfo != null) {
                bw.write("\t@TableId");
                String idType = this.toIdType();
                if (isLine) {
                    if (this.config.isDbColumnUnderline()) {
                        if (null != idType) {
                            bw.write("(");
                            bw.write(idType);
                            bw.write(")");
                        }
                    } else {
                        bw.write("(value = \"" + column + "\"");
                        if (null != idType) {
                            bw.write(", ");
                            bw.write(idType);
                        }
                        bw.write(")");
                    }
                } else if (null != idType) {
                    bw.write("(");
                    bw.write(idType);
                    bw.write(")");
                }
                bw.newLine();
            } else if (isLine && !this.config.isDbColumnUnderline()) {
                bw.write("\t@TableField(value = \"" + column + "\")");
                bw.newLine();
            }
            bw.write("\tprivate " + this.processType(types.get(i)) + " " + field + ";");
            bw.newLine();
        }
        this.buildEntityBeanColumnConstant(columns, types, comments, bw, size);
        bw.newLine();
        for (i = 0; i < size; ++i) {
            String _tempType = this.processType(types.get(i));
            String _tempField = this.processField(columns.get(i));
            String _field = _tempField.substring(0, 1).toUpperCase() + _tempField.substring(1);
            bw.newLine();
            bw.write("\tpublic " + _tempType + " get" + _field + "() {");
            bw.newLine();
            bw.write("\t\treturn this." + _tempField + ";");
            bw.newLine();
            bw.write("\t}");
            bw.newLine();
            bw.newLine();
            if (this.config.isBuliderModel()) {
                bw.write("\tpublic " + beanName + " set" + _field + "(" + _tempType + " " + _tempField + ") {");
                bw.newLine();
                bw.write("\t\tthis." + _tempField + " = " + _tempField + ";");
                bw.newLine();
                bw.write("\t\treturn this;");
            } else {
                bw.write("\tpublic void set" + _field + "(" + _tempType + " " + _tempField + ") {");
                bw.newLine();
                bw.write("\t\tthis." + _tempField + " = " + _tempField + ";");
            }
            bw.newLine();
            bw.write("\t}");
            bw.newLine();
        }
        bw.newLine();
        bw.write("}");
        bw.newLine();
        bw.flush();
        bw.close();
    }

    protected void buildEntityBeanColumnConstant(List<String> columns, List<String> types, List<String> comments, BufferedWriter bw, int size) throws IOException {
        if (this.config.isColumnConstant()) {
            for (int i = 0; i < size; ++i) {
                String _tempType = this.processType(types.get(i));
                String _column = columns.get(i);
                bw.newLine();
                bw.write("\tpublic static final " + _tempType + " " + _column.toUpperCase() + " = \"" + _column + "\";");
            }
            bw.newLine();
        }
    }

    public String toIdType() {
        if (this.config.getIdType() == IdType.AUTO) {
            return "type = IdType.AUTO";
        }
        if (this.config.getIdType() == IdType.INPUT) {
            return "type = IdType.INPUT";
        }
        if (this.config.getIdType() == IdType.UUID) {
            return "type = IdType.UUID";
        }
        return null;
    }

    protected void buildMapper(String beanName, String mapperName) throws IOException {
        File mapperFile = new File(PATH_MAPPER, mapperName + JAVA_SUFFIX);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(mapperFile), "utf-8"));
        bw.write("package " + this.config.getMapperPackage() + ";");
        bw.newLine();
        bw.newLine();
        bw.write("import " + this.config.getEntityPackage() + "." + beanName + ";");
        bw.newLine();
        if (this.config.getConfigIdType() == ConfigIdType.STRING) {
            bw.write("import com.baomidou.mybatisplus.mapper.CommonMapper;");
        } else {
            bw.write("import com.baomidou.mybatisplus.mapper.AutoMapper;");
        }
        bw.newLine();
        bw = this.buildClassComment(bw, beanName + " \u8868\u6570\u636e\u5e93\u63a7\u5236\u5c42\u63a5\u53e3");
        bw.newLine();
        if (this.config.getConfigIdType() == ConfigIdType.STRING) {
            bw.write("public interface " + mapperName + " extends CommonMapper<" + beanName + "> {");
        } else {
            bw.write("public interface " + mapperName + " extends AutoMapper<" + beanName + "> {");
        }
        bw.newLine();
        bw.newLine();
        bw.newLine();
        bw.write("}");
        bw.flush();
        bw.close();
    }

    protected void buildMapperXml(String beanName, List<String> columns, List<String> types, List<String> comments, Map<String, IdInfo> idMap, String mapperName, String mapperXMLName) throws IOException {
        File mapperXmlFile = new File(PATH_XML, mapperXMLName + XML_SUFFIX);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(mapperXmlFile)));
        bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        bw.newLine();
        bw.write("<!DOCTYPE mapper PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\">");
        bw.newLine();
        bw.write("<mapper namespace=\"" + this.config.getMapperPackage() + "." + mapperName + "\">");
        bw.newLine();
        bw.newLine();
        if (this.config.isResultMap()) {
            this.buildResultMap(bw, beanName, idMap, columns);
        } else {
            this.buildSQL(bw, idMap, columns);
        }
        bw.write("</mapper>");
        bw.flush();
        bw.close();
    }

    protected void buildService(String beanName, String serviceName) throws IOException {
        File serviceFile = new File(PATH_SERVICE, serviceName + JAVA_SUFFIX);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(serviceFile), "utf-8"));
        bw.write("package " + this.config.getServicePackage() + ";");
        bw.newLine();
        bw.newLine();
        bw.write("import " + this.config.getEntityPackage() + "." + beanName + ";");
        bw.newLine();
        String superService = this.config.getSuperService();
        bw.write("import " + superService + ";");
        bw.newLine();
        bw = this.buildClassComment(bw, beanName + " \u8868\u6570\u636e\u670d\u52a1\u5c42\u63a5\u53e3");
        bw.newLine();
        superService = superService.substring(superService.lastIndexOf(".") + 1);
        bw.write("public interface " + serviceName + " extends " + superService + "<" + beanName + "> {");
        bw.newLine();
        bw.newLine();
        bw.newLine();
        bw.write("}");
        bw.flush();
        bw.close();
    }

    protected void buildServiceImpl(String beanName, String serviceImplName, String serviceName, String mapperName) throws IOException {
        File serviceFile = new File(PATH_SERVICE_IMPL, serviceImplName + JAVA_SUFFIX);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(serviceFile), "utf-8"));
        bw.write("package " + this.config.getServiceImplPackage() + ";");
        bw.newLine();
        bw.newLine();
        bw.write("import org.springframework.stereotype.Service;");
        bw.newLine();
        bw.newLine();
        bw.write("import " + this.config.getMapperPackage() + "." + mapperName + ";");
        bw.newLine();
        bw.write("import " + this.config.getEntityPackage() + "." + beanName + ";");
        bw.newLine();
        bw.write("import " + this.config.getServicePackage() + "." + serviceName + ";");
        bw.newLine();
        String superServiceImpl = this.config.getSuperServiceImpl();
        bw.write("import " + superServiceImpl + ";");
        bw.newLine();
        bw = this.buildClassComment(bw, beanName + " \u8868\u6570\u636e\u670d\u52a1\u5c42\u63a5\u53e3\u5b9e\u73b0\u7c7b");
        bw.newLine();
        bw.write("@Service");
        bw.newLine();
        superServiceImpl = superServiceImpl.substring(superServiceImpl.lastIndexOf(".") + 1);
        bw.write("public class " + serviceImplName + " extends " + superServiceImpl + "<" + mapperName + ", " + beanName + "> implements " + serviceName + " {");
        bw.newLine();
        bw.newLine();
        bw.newLine();
        bw.write("}");
        bw.flush();
        bw.close();
    }

    protected void buildController(String beanName, String controllerName) throws IOException {
        File serviceFile = new File(PATH_CONTROLLER_IMPL, controllerName + JAVA_SUFFIX);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(serviceFile), "utf-8"));
        bw.write("package " + this.config.getControllerPackage() + ";");
        bw.newLine();
        bw.newLine();
        bw.write("import org.springframework.stereotype.Controller;");
        bw.newLine();
        bw = this.buildClassComment(bw, beanName + " \u63a7\u5236\u5c42");
        bw.newLine();
        bw.write("@Controller");
        bw.newLine();
        bw.write("public class " + controllerName + " {");
        bw.newLine();
        bw.newLine();
        bw.newLine();
        bw.write("}");
        bw.flush();
        bw.close();
    }

    protected void buildSQL(BufferedWriter bw, Map<String, IdInfo> idMap, List<String> columns) throws IOException {
        int size = columns.size();
        bw.write("\t<!-- \u901a\u7528\u67e5\u8be2\u7ed3\u679c\u5217-->");
        bw.newLine();
        bw.write("\t<sql id=\"Base_Column_List\">");
        bw.newLine();
        bw.write("\t\t");
        DBType dbType = DBType.ORACLE;
        if (this.config.getConfigDataSource() == ConfigDataSource.MYSQL) {
            dbType = DBType.MYSQL;
        }
        if (null != this.config.getConfigBaseEntity()) {
            for (String column : this.config.getConfigBaseEntity().getColumns()) {
                bw.write(SqlReservedWords.convert(dbType, column));
                if (column.contains("_")) {
                    bw.write(" AS " + this.processField(column));
                }
                bw.write(", ");
            }
        }
        for (int i = 0; i < size; ++i) {
            String column = columns.get(i);
            IdInfo idInfo = idMap.get(column);
            if (idInfo != null) {
                bw.write(SqlReservedWords.convert(dbType, column));
                if (idInfo.getValue().contains("_")) {
                    bw.write(" AS " + this.processField(idInfo.getValue()));
                }
            } else {
                if (null == this.config.getConfigBaseEntity()) {
                    bw.write(" ");
                }
                bw.write(SqlReservedWords.convert(dbType, column));
                if (column.contains("_")) {
                    bw.write(" AS " + this.processField(column));
                }
            }
            if (i == size - 1) continue;
            bw.write(",");
        }
        bw.newLine();
        bw.write("\t</sql>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildResultMap(BufferedWriter bw, String beanName, Map<String, IdInfo> idMap, List<String> columns) throws IOException {
        int size = columns.size();
        bw.write("\t<!-- \u901a\u7528\u67e5\u8be2\u7ed3\u679c\u5217-->");
        bw.newLine();
        bw.write("\t<resultMap id=\"" + beanName + "ResultMap\" type=\"" + this.config.getEntityPackage() + "." + beanName + "\">");
        bw.newLine();
        DBType dbType = DBType.ORACLE;
        if (this.config.getConfigDataSource() == ConfigDataSource.MYSQL) {
            dbType = DBType.MYSQL;
        }
        if (null != this.config.getConfigBaseEntity()) {
            for (String column : this.config.getConfigBaseEntity().getColumns()) {
                bw.write("\t\t<result column=\"" + SqlReservedWords.convert(dbType, column) + "\" property=\"" + this.processField(column) + "\" />");
                bw.newLine();
            }
        }
        for (int i = 0; i < size; ++i) {
            String column = columns.get(i);
            IdInfo idInfo = idMap.get(column);
            if (idInfo != null) {
                bw.write("\t\t<id column=\"" + SqlReservedWords.convert(dbType, column) + "\" property=\"" + this.processField(idInfo.getValue()) + "\" />");
            } else {
                if (null == this.config.getConfigBaseEntity()) {
                    bw.write(" ");
                }
                bw.write("\t\t<result column=\"" + SqlReservedWords.convert(dbType, column) + "\" property=\"" + this.processField(column) + "\" />");
            }
            if (i == size - 1) continue;
            bw.newLine();
        }
        bw.newLine();
        bw.write("\t</resultMap>");
        bw.newLine();
        bw.newLine();
    }

    protected Map<String, String> getTableComment(Connection conn) throws SQLException {
        HashMap<String, String> maps = new HashMap<String, String>();
        PreparedStatement pstate = conn.prepareStatement(this.config.getConfigDataSource().getTableCommentsSql());
        ResultSet results = pstate.executeQuery();
        while (results.next()) {
            maps.put(results.getString(this.config.getConfigDataSource().getTableName()), results.getString(this.config.getConfigDataSource().getTableComment()));
        }
        return maps;
    }

    class IdInfo {
        private String value;
        private boolean autoIncrement;

        public IdInfo(String value, boolean autoIncrement) {
            this.value = value;
            this.autoIncrement = autoIncrement;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public void setAutoIncrement(boolean autoIncrement) {
            this.autoIncrement = autoIncrement;
        }
    }
}

