/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.mapper.TSqlPlus;
import com.baomidou.mybatisplus.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityWrapper<T>
implements Serializable {
    protected T entity = null;
    protected String sqlSelect = null;
    protected TSqlPlus sql = new TSqlPlus();

    public EntityWrapper() {
    }

    public EntityWrapper(T entity) {
        this.entity = entity;
    }

    public EntityWrapper(T entity, String sqlSelect) {
        this.entity = entity;
        this.sqlSelect = sqlSelect;
    }

    public T getEntity() {
        return this.entity;
    }

    public void setEntity(T entity) {
        this.entity = entity;
    }

    public String getSqlSelect() {
        if (StringUtils.isEmpty(this.sqlSelect)) {
            return null;
        }
        return this.stripSqlInjection(this.sqlSelect);
    }

    public void setSqlSelect(String sqlSelect) {
        if (StringUtils.isNotEmpty(sqlSelect)) {
            this.sqlSelect = sqlSelect;
        }
    }

    public String getSqlSegment() {
        String sqlWhere = this.sql.toString();
        if (StringUtils.isEmpty(sqlWhere)) {
            return null;
        }
        sqlWhere = ReflectionKit.checkFieldValueNotNull(this.entity) ? sqlWhere.replaceFirst("WHERE", "AND") : sqlWhere;
        return sqlWhere;
    }

    public EntityWrapper<T> where(String sqlWhere, Object ... params) {
        this.sql.WHERE(this.formatSql(sqlWhere, params));
        return this;
    }

    public EntityWrapper<T> and(String sqlAnd, Object ... params) {
        ((TSqlPlus)this.sql.AND()).WHERE(this.formatSql(sqlAnd, params));
        return this;
    }

    public EntityWrapper<T> andNew(String sqlAnd, Object ... params) {
        ((TSqlPlus)this.sql.AND_NEW()).WHERE(this.formatSql(sqlAnd, params));
        return this;
    }

    public EntityWrapper<T> or(String sqlOr, Object ... params) {
        ((TSqlPlus)this.sql.OR()).WHERE(this.formatSql(sqlOr, params));
        return this;
    }

    public EntityWrapper<T> orNew(String sqlOr, Object ... params) {
        ((TSqlPlus)this.sql.OR_NEW()).WHERE(this.formatSql(sqlOr, params));
        return this;
    }

    public EntityWrapper<T> groupBy(String columns) {
        this.sql.GROUP_BY(columns);
        return this;
    }

    public EntityWrapper<T> having(String sqlHaving, Object ... params) {
        this.sql.HAVING(this.formatSql(sqlHaving, params));
        return this;
    }

    public EntityWrapper<T> orderBy(String columns) {
        this.sql.ORDER_BY(columns);
        return this;
    }

    public EntityWrapper<T> orderBy(String columns, boolean isAsc) {
        if (StringUtils.isNotEmpty(columns)) {
            this.sql.ORDER_BY(columns + (isAsc ? " ASC" : " DESC"));
        }
        return this;
    }

    public EntityWrapper<T> like(String column, String value) {
        this.sql.LIKE(column, value);
        return this;
    }

    public EntityWrapper<T> notLike(String column, String value) {
        this.sql.NOT_LIKE(column, value);
        return this;
    }

    public EntityWrapper<T> isNotNull(String columns) {
        this.sql.IS_NOT_NULL(columns);
        return this;
    }

    public EntityWrapper<T> isNull(String columns) {
        this.sql.IS_NULL(columns);
        return this;
    }

    public EntityWrapper<T> exists(String value) {
        this.sql.EXISTS(value);
        return this;
    }

    public EntityWrapper<T> notExists(String value) {
        this.sql.NOT_EXISTS(value);
        return this;
    }

    public EntityWrapper<T> in(String column, String value) {
        this.sql.IN(column, value);
        return this;
    }

    public EntityWrapper<T> notIn(String column, String value) {
        this.sql.NOT_IN(column, value);
        return this;
    }

    public EntityWrapper<T> in(String column, Collection<?> value) {
        this.sql.IN(column, value);
        return this;
    }

    public EntityWrapper<T> notIn(String column, Collection<?> value) {
        this.sql.NOT_IN(column, value);
        return this;
    }

    public EntityWrapper<T> in(String column, Object[] value) {
        this.sql.IN(column, Arrays.asList(value));
        return this;
    }

    public EntityWrapper<T> notIn(String column, Object ... value) {
        this.sql.NOT_IN(column, Arrays.asList(value));
        return this;
    }

    public EntityWrapper<T> between(String column, String val1, String val2) {
        this.sql.BETWEEN_AND(column, val1, val2);
        return this;
    }

    public EntityWrapper<T> addFilter(String sqlWhere, Object ... params) {
        return this.and(sqlWhere, params);
    }

    public EntityWrapper<T> addFilterIfNeed(boolean need, String sqlWhere, Object ... params) {
        return need ? this.where(sqlWhere, params) : this;
    }

    protected String stripSqlInjection(String value) {
        return value.replaceAll("('.+--)|(--)|(\\|)|(%7C)", "");
    }

    protected String formatSql(String sqlStr, Object ... params) {
        return this.formatSqlIfNeed(true, sqlStr, params);
    }

    protected String formatSqlIfNeed(boolean need, String sqlStr, Object ... params) {
        int length;
        if (!need || StringUtils.isEmpty(sqlStr)) {
            return null;
        }
        if (null != params && (length = params.length) >= 1) {
            this.dealParams(params, length);
            sqlStr = MessageFormat.format(sqlStr, params);
        }
        return sqlStr;
    }

    protected void dealParams(Object[] params, int length) {
        for (int i = 0; i < length; ++i) {
            params[i] = StringUtils.quotaMark(params[i]);
        }
    }
}

