/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.MybatisAbstractSQL;
import com.baomidou.mybatisplus.toolkit.CollectionUtil;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TSqlPlus
extends MybatisAbstractSQL<TSqlPlus> {
    private final String IS_NOT_NULL = " IS NOT NULL";
    private final String IS_NULL = " IS NULL";
    private final String SQL_LIKE = " LIKE CONCAT(CONCAT({0},{1}),{2})";
    private final String SQL_BETWEEN_AND = " BETWEEN {0} AND {1}";

    @Override
    public TSqlPlus getSelf() {
        return this;
    }

    public TSqlPlus LIKE(String column, String value) {
        this.handerLike(column, value, false);
        return this;
    }

    public TSqlPlus NOT_LIKE(String column, String value) {
        this.handerLike(column, value, true);
        return this;
    }

    public TSqlPlus IS_NOT_NULL(String columns) {
        this.handerNull(columns, " IS NOT NULL");
        return this;
    }

    public TSqlPlus IS_NULL(String columns) {
        this.handerNull(columns, " IS NULL");
        return this;
    }

    private void handerLike(String column, String value, boolean isNot) {
        if (StringUtils.isNotEmpty(column) && StringUtils.isNotEmpty(value)) {
            StringBuilder inSql = new StringBuilder();
            inSql.append(column);
            if (isNot) {
                inSql.append(" NOT");
            }
            inSql.append(MessageFormat.format(" LIKE CONCAT(CONCAT({0},{1}),{2})", "'%'", StringUtils.quotaMark(value), "'%'"));
            this.WHERE(inSql.toString());
        }
    }

    public TSqlPlus IN(String column, Collection<?> value) {
        this.handerIn(column, value, false);
        return this;
    }

    public TSqlPlus NOT_IN(String column, Collection<?> value) {
        this.handerIn(column, value, true);
        return this;
    }

    public TSqlPlus IN(String column, String value) {
        this.handerIn(column, value, false);
        return this;
    }

    public TSqlPlus NOT_IN(String column, String value) {
        this.handerIn(column, value, true);
        return this;
    }

    public TSqlPlus EXISTS(String value) {
        this.handerExists(value, false);
        return this;
    }

    private void handerExists(String value, boolean isNot) {
        if (StringUtils.isNotEmpty(value)) {
            StringBuilder inSql = new StringBuilder();
            if (isNot) {
                inSql.append(" NOT");
            }
            inSql.append(" EXISTS (").append(value).append(")");
            this.WHERE(inSql.toString());
        }
    }

    public TSqlPlus NOT_EXISTS(String value) {
        this.handerExists(value, true);
        return this;
    }

    private void handerIn(String column, Collection<?> value, boolean isNot) {
        if (StringUtils.isNotEmpty(column) && CollectionUtil.isNotEmpty(value)) {
            StringBuilder inSql = new StringBuilder();
            inSql.append(column);
            if (isNot) {
                inSql.append(" NOT");
            }
            inSql.append(" IN (");
            int _size = value.size();
            int i = 0;
            Iterator<?> iterator = value.iterator();
            while (iterator.hasNext()) {
                String tempVal = StringUtils.quotaMark(iterator.next());
                if (i + 1 == _size) {
                    inSql.append(tempVal);
                } else {
                    inSql.append(tempVal);
                    inSql.append(",");
                }
                ++i;
            }
            inSql.append(")");
            this.WHERE(inSql.toString());
        }
    }

    private void handerIn(String column, String value, boolean isNot) {
        if (StringUtils.isNotEmpty(column) && StringUtils.isNotEmpty(value)) {
            StringBuilder inSql = new StringBuilder();
            inSql.append(column);
            if (isNot) {
                inSql.append(" NOT");
            }
            inSql.append(" IN (").append(value).append(")");
            this.WHERE(inSql.toString());
        }
    }

    public TSqlPlus BETWEEN_AND(String column, String val1, String val2) {
        this.between(column, val1, val2);
        return this;
    }

    private void between(String column, String val1, String val2) {
        if (StringUtils.isNotEmpty(column) && StringUtils.isNotEmpty(val1) && StringUtils.isNotEmpty(val2)) {
            StringBuilder betweenSql = new StringBuilder();
            betweenSql.append(column);
            betweenSql.append(MessageFormat.format(" BETWEEN {0} AND {1}", StringUtils.quotaMark(val1), StringUtils.quotaMark(val2)));
            this.WHERE(betweenSql.toString());
        }
    }

    private void handerNull(String columns, String sqlPart) {
        if (StringUtils.isNotEmpty(columns)) {
            String[] cols;
            for (String col : cols = columns.split(",")) {
                if (!StringUtils.isNotEmpty(col.trim())) continue;
                this.WHERE(col + sqlPart);
            }
        }
    }
}

