/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins;

import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.plugins.entity.CountOptimize;
import com.baomidou.mybatisplus.plugins.pagination.DialectFactory;
import com.baomidou.mybatisplus.plugins.pagination.IDialect;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.toolkit.SqlUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PaginationInterceptor
implements Interceptor {
    private boolean overflowCurrent = false;
    private String dialectType;
    private String dialectClazz;

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (target instanceof StatementHandler) {
            StatementHandler statementHandler = (StatementHandler)target;
            MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
            RowBounds rowBounds = (RowBounds)metaStatementHandler.getValue("delegate.rowBounds");
            if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
                return invocation.proceed();
            }
            IDialect dialect = null;
            if (StringUtils.isNotEmpty(this.dialectType)) {
                dialect = DialectFactory.getDialectByDbtype(this.dialectType);
            } else if (StringUtils.isNotEmpty(this.dialectClazz)) {
                try {
                    Class<?> clazz = Class.forName(this.dialectClazz);
                    if (IDialect.class.isAssignableFrom(clazz)) {
                        dialect = (IDialect)clazz.newInstance();
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new MybatisPlusException("Class :" + this.dialectClazz + " is not found");
                }
            }
            if (dialect == null) {
                throw new MybatisPlusException("The value of the dialect property in mybatis configuration.xml is not defined.");
            }
            BoundSql boundSql = (BoundSql)metaStatementHandler.getValue("delegate.boundSql");
            String originalSql = boundSql.getSql();
            metaStatementHandler.setValue("delegate.rowBounds.offset", (Object)0);
            metaStatementHandler.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
            if (rowBounds instanceof Pagination) {
                MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("delegate.mappedStatement");
                Connection connection = (Connection)invocation.getArgs()[0];
                Pagination page = (Pagination)rowBounds;
                boolean orderBy = true;
                if (page.isSearchCount()) {
                    CountOptimize countOptimize = SqlUtils.getCountOptimize(originalSql, page.isOptimizeCount());
                    orderBy = countOptimize.isOrderBy();
                    page = this.count(countOptimize.getCountSQL(), connection, mappedStatement, boundSql, page);
                    if (page.getTotal() <= 0) {
                        return invocation.proceed();
                    }
                }
                String buildSql = SqlUtils.concatOrderBy(originalSql, page, orderBy);
                originalSql = dialect.buildPaginationSql(buildSql, page.getOffsetCurrent(), page.getSize());
            }
            metaStatementHandler.setValue("delegate.boundSql.sql", (Object)originalSql);
        }
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pagination count(String sql, Connection connection, MappedStatement mappedStatement, BoundSql boundSql, Pagination page) {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement(sql);
            BoundSql countBS = new BoundSql(mappedStatement.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
            DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), countBS);
            parameterHandler.setParameters(pstmt);
            rs = pstmt.executeQuery();
            int total = 0;
            if (rs.next()) {
                total = rs.getInt(1);
            }
            page.setTotal(total);
            if (this.overflowCurrent && page.getCurrent() > page.getPages()) {
                page = new Pagination(1, page.getSize());
                page.setTotal(total);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return page;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties prop) {
        String dialectType = prop.getProperty("dialectType");
        String dialectClazz = prop.getProperty("dialectClazz");
        if (StringUtils.isNotEmpty(dialectType)) {
            this.dialectType = dialectType;
        }
        if (StringUtils.isNotEmpty(dialectClazz)) {
            this.dialectClazz = dialectClazz;
        }
    }

    public void setDialectType(String dialectType) {
        this.dialectType = dialectType;
    }

    public void setDialectClazz(String dialectClazz) {
        this.dialectClazz = dialectClazz;
    }

    public void setOverflowCurrent(boolean overflowCurrent) {
        this.overflowCurrent = overflowCurrent;
    }
}

