/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.baomidou.mybatisplus.toolkit.TableFieldInfo;
import com.baomidou.mybatisplus.toolkit.TableInfo;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionKit {
    protected static final Logger logger = Logger.getLogger("ReflectionKit");

    public static String getMethodCapitalize(String str) {
        return StringUtils.concatCapitalize("get", str);
    }

    public static Object getMethodValue(Class<?> cls, Object entity, String str) {
        Object obj = null;
        try {
            Method method = cls.getMethod(ReflectionKit.getMethodCapitalize(str), new Class[0]);
            obj = method.invoke(entity, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.warning(String.format("Warn: No such method. in %s.  Cause:", cls.getSimpleName()) + e);
        }
        catch (IllegalAccessException e) {
            logger.warning(String.format("Warn: Cannot execute a private method. in %s.  Cause:", cls.getSimpleName()) + e);
        }
        catch (InvocationTargetException e) {
            logger.warning("Warn: Unexpected exception on getMethodValue.  Cause:" + e);
        }
        return obj;
    }

    public static Object getMethodValue(Object entity, String str) {
        if (null == entity) {
            return null;
        }
        return ReflectionKit.getMethodValue(entity.getClass(), entity, str);
    }

    public static boolean checkFieldValueNotNull(Object bean) {
        if (null == bean) {
            return false;
        }
        Class<?> cls = bean.getClass();
        TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
        if (null == tableInfo) {
            logger.warning("Warn: Could not find @TableId.");
            return false;
        }
        boolean result = false;
        List<TableFieldInfo> fieldList = tableInfo.getFieldList();
        for (TableFieldInfo tableFieldInfo : fieldList) {
            Object val = ReflectionKit.getMethodValue(cls, bean, tableFieldInfo.getProperty());
            if (null == val) continue;
            result = true;
            break;
        }
        return result;
    }

    public static Class getSuperClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warning(String.format("Warn: %s's superclass not ParameterizedType", clazz.getSimpleName()));
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warning(String.format("Warn: Index: %s, Size of %s's Parameterized Type: %s .", index, clazz.getSimpleName(), params.length));
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warning(String.format("Warn: %s not set the actual class on superclass generic parameter", clazz.getSimpleName()));
            return Object.class;
        }
        return (Class)params[index];
    }
}

