/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.plugins.entity.CountOptimize;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.toolkit.StringUtils;

public class SqlUtils {
    public static CountOptimize getCountOptimize(String originalSql, boolean isOptimizeCount) {
        int formIndex;
        String tempSql;
        String indexOfSql;
        boolean optimize = false;
        CountOptimize countOptimize = CountOptimize.newInstance();
        StringBuffer countSql = new StringBuffer("SELECT COUNT(1) AS TOTAL ");
        if (isOptimizeCount && !(indexOfSql = (tempSql = originalSql.replaceAll("(?i)ORDER[\\s]+BY", "ORDER BY")).toUpperCase()).contains("DISTINCT") && (formIndex = indexOfSql.indexOf("FROM")) > -1) {
            int orderByIndex = indexOfSql.lastIndexOf("ORDER BY");
            if (orderByIndex > -1) {
                tempSql = tempSql.substring(0, orderByIndex);
                countSql.append(tempSql.substring(formIndex));
                countOptimize.setOrderBy(false);
            } else {
                countSql.append(tempSql.substring(formIndex));
            }
            optimize = true;
        }
        if (!optimize) {
            countSql.append("FROM (").append(originalSql).append(") A");
        }
        countOptimize.setCountSQL(countSql.toString());
        return countOptimize;
    }

    public static String concatOrderBy(String originalSql, Pagination page, boolean orderBy) {
        if (orderBy && StringUtils.isNotEmpty(page.getOrderByField())) {
            StringBuffer buildSql = new StringBuffer(originalSql);
            buildSql.append(" ORDER BY ").append(page.getOrderByField());
            buildSql.append(page.isAsc() ? " ASC " : " DESC ");
            return buildSql.toString();
        }
        return originalSql;
    }
}

