/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.MybatisConfiguration;
import com.baomidou.mybatisplus.MybatisPlusHolder;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.baomidou.mybatisplus.toolkit.TableFieldInfo;
import com.baomidou.mybatisplus.toolkit.TableInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableInfoHelper {
    protected static final Logger logger = Logger.getLogger("TableInfoHelper");
    private static Map<String, TableInfo> tableInfoCache = new ConcurrentHashMap<String, TableInfo>();

    public static TableInfo getTableInfo(Class<?> clazz) {
        return tableInfoCache.get(clazz.getName());
    }

    public static synchronized TableInfo initTableInfo(Class<?> clazz) {
        TableInfo ti = tableInfoCache.get(clazz.getName());
        if (ti != null) {
            return ti;
        }
        TableInfo tableInfo = new TableInfo();
        TableName table = clazz.getAnnotation(TableName.class);
        if (table != null && StringUtils.isNotEmpty(table.value())) {
            tableInfo.setTableName(table.value());
        } else {
            tableInfo.setTableName(StringUtils.camelToUnderline(clazz.getSimpleName()));
        }
        if (table != null && StringUtils.isNotEmpty(table.resultMap())) {
            tableInfo.setResultMap(table.resultMap());
        }
        ArrayList<TableFieldInfo> fieldList = new ArrayList<TableFieldInfo>();
        List<Field> list = TableInfoHelper.getAllFields(clazz);
        for (Field field : list) {
            TableId tableId = field.getAnnotation(TableId.class);
            if (tableId != null) {
                if (tableInfo.getKeyColumn() == null) {
                    tableInfo.setIdType(tableId.type());
                    if (StringUtils.isNotEmpty(tableId.value())) {
                        tableInfo.setKeyColumn(tableId.value());
                        tableInfo.setKeyRelated(true);
                    } else if (MybatisConfiguration.DB_COLUMN_UNDERLINE) {
                        tableInfo.setKeyColumn(StringUtils.camelToUnderline(field.getName()));
                    } else {
                        tableInfo.setKeyColumn(field.getName());
                    }
                    tableInfo.setKeyProperty(field.getName());
                    continue;
                }
                throw new MybatisPlusException("There must be only one, Discover multiple @TableId annotation in " + clazz);
            }
            TableField tableField = field.getAnnotation(TableField.class);
            if (tableField != null) {
                String columnName = field.getName();
                if (StringUtils.isNotEmpty(tableField.value())) {
                    columnName = tableField.value();
                }
                String el = field.getName();
                if (StringUtils.isNotEmpty(tableField.el())) {
                    el = tableField.el();
                }
                String[] columns = columnName.split(";");
                String[] els = el.split(";");
                if (null != columns && null != els && columns.length == els.length) {
                    for (int i = 0; i < columns.length; ++i) {
                        fieldList.add(new TableFieldInfo(true, columns[i], field.getName(), els[i], tableField.validate()));
                    }
                    continue;
                }
                String errorMsg = "Class: %s, Field: %s, 'value' 'el' Length must be consistent.";
                throw new MybatisPlusException(String.format(errorMsg, clazz.getName(), field.getName()));
            }
            if (MybatisConfiguration.DB_COLUMN_UNDERLINE) {
                fieldList.add(new TableFieldInfo(true, StringUtils.camelToUnderline(field.getName()), field.getName()));
                continue;
            }
            fieldList.add(new TableFieldInfo(field.getName()));
        }
        tableInfo.setFieldList(fieldList);
        if (null == tableInfo.getKeyColumn()) {
            logger.warning(String.format("Warn: Could not find @TableId in Class: %s, initTableInfo Method Fail.", clazz.getName()));
            return null;
        }
        tableInfo.setSqlSessionFactory(MybatisPlusHolder.getSqlSessionFactory());
        tableInfoCache.put(clazz.getName(), tableInfo);
        return tableInfo;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        Field[] fields;
        LinkedList<Field> result = new LinkedList<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            TableField tableField;
            if (Modifier.isTransient(field.getModifiers()) || (tableField = field.getAnnotation(TableField.class)) != null && !tableField.exist()) continue;
            result.add(field);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return result;
        }
        result.addAll(TableInfoHelper.getAllFields(superClass));
        return result;
    }
}

