/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.html;

import com.bstek.ureport.build.ReportBuilder;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.cache.CacheUtils;
import com.bstek.ureport.chart.ChartData;
import com.bstek.ureport.console.RenderPageServletAction;
import com.bstek.ureport.console.cache.TempObjectCache;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.console.html.Tools;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.export.ExportManager;
import com.bstek.ureport.export.FullPageData;
import com.bstek.ureport.export.PageBuilder;
import com.bstek.ureport.export.ReportRender;
import com.bstek.ureport.export.SinglePageData;
import com.bstek.ureport.export.html.HtmlProducer;
import com.bstek.ureport.export.html.HtmlReport;
import com.bstek.ureport.model.Report;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.jackson.map.ObjectMapper;

public class HtmlPreviewServletAction
extends RenderPageServletAction {
    private ExportManager exportManager;
    private ReportBuilder reportBuilder;
    private ReportRender reportRender;
    private HtmlProducer htmlProducer = new HtmlProducer();

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            HtmlReport htmlReport = null;
            String errorMsg = null;
            try {
                htmlReport = this.loadReport(req);
            }
            catch (Exception ex) {
                if (!(ex instanceof ReportDesignException)) {
                    ex.printStackTrace();
                }
                errorMsg = ex.toString();
            }
            if (htmlReport == null) {
                context.put("content", (Object)("<div style='color:red'><strong>\u62a5\u8868\u8ba1\u7b97\u9519\u8bef\uff1a</strong>" + errorMsg + "</div>"));
                context.put("error", (Object)true);
            } else {
                context.put("content", (Object)htmlReport.getContent());
                context.put("style", (Object)htmlReport.getStyle());
                context.put("reportAlign", (Object)htmlReport.getReportAlign());
                context.put("totalPage", (Object)htmlReport.getTotalPage());
                context.put("pageIndex", (Object)htmlReport.getPageIndex());
                context.put("chartDatas", (Object)this.convertJson(htmlReport.getChartDatas()));
                context.put("error", (Object)false);
                context.put("file", (Object)req.getParameter("_u"));
                context.put("intervalRefreshValue", (Object)htmlReport.getHtmlIntervalRefreshValue());
                String customParameters = this.buildCustomParameters(req);
                context.put("customParameters", (Object)customParameters);
                Tools tools = null;
                String toolsInfo = req.getParameter("_t");
                if (StringUtils.isNotBlank((String)toolsInfo)) {
                    tools = new Tools(false);
                    if (toolsInfo.equals("0")) {
                        tools.setShow(false);
                    } else {
                        String[] infos;
                        String[] stringArray = infos = toolsInfo.split(",");
                        int n = infos.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            tools.doInit(name);
                            ++n2;
                        }
                    }
                    context.put("_t", (Object)toolsInfo);
                    context.put("hasTools", (Object)true);
                } else {
                    tools = new Tools(true);
                }
                context.put("tools", (Object)tools);
            }
            context.put("contextPath", (Object)req.getContextPath());
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("ureport-html/html-preview.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    private String convertJson(Collection<ChartData> data) {
        if (data == null || data.size() == 0) {
            return "";
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = mapper.writeValueAsString(data);
            return json;
        }
        catch (Exception e) {
            throw new ReportComputeException(e);
        }
    }

    public void loadData(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HtmlReport htmlReport = this.loadReport(req);
        this.writeObjectToJson(resp, htmlReport);
    }

    public void loadPrintPages(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String file = req.getParameter("_u");
        if (StringUtils.isBlank((String)(file = this.decode(file)))) {
            throw new ReportComputeException("Report file can not be null.");
        }
        Map<String, Object> parameters = this.buildParameters(req);
        String fullName = String.valueOf(file) + parameters.toString();
        Report report = CacheUtils.getReport((String)fullName);
        if (report == null) {
            throw new ReportException("Report preview data has expired,can not do load pages for print.");
        }
        FullPageData pageData = PageBuilder.buildFullPageData((Report)report);
        StringBuilder sb = new StringBuilder();
        List list = pageData.getPageList();
        com.bstek.ureport.build.Context context = report.getContext();
        if (list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                String html;
                List columnPages = (List)list.get(i);
                if (i == 0) {
                    html = this.htmlProducer.produce(context, columnPages, pageData.getColumnMargin(), false);
                    sb.append(html);
                } else {
                    html = this.htmlProducer.produce(context, columnPages, pageData.getColumnMargin(), false);
                    sb.append(html);
                }
                ++i;
            }
        } else {
            List pages = report.getPages();
            int i = 0;
            while (i < pages.size()) {
                String html;
                Page page = (Page)pages.get(i);
                if (i == 0) {
                    html = this.htmlProducer.produce(context, page, false);
                    sb.append(html);
                } else {
                    html = this.htmlProducer.produce(context, page, true);
                    sb.append(html);
                }
                ++i;
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("html", sb.toString());
        this.writeObjectToJson(resp, map);
    }

    public void loadPagePaper(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String file = req.getParameter("_u");
        if (StringUtils.isBlank((String)(file = this.decode(file)))) {
            throw new ReportComputeException("Report file can not be null.");
        }
        ReportDefinition report = null;
        if (file.equals("p")) {
            report = (ReportDefinition)TempObjectCache.getObject("p");
            if (report == null) {
                throw new ReportDesignException("Report data has expired.");
            }
        } else {
            report = this.reportRender.getReportDefinition(file);
        }
        Paper paper = report.getPaper();
        this.writeObjectToJson(resp, paper);
    }

    private HtmlReport loadReport(HttpServletRequest req) {
        Map<String, Object> parameters = this.buildParameters(req);
        HtmlReport htmlReport = null;
        String file = req.getParameter("_u");
        file = this.decode(file);
        String fullName = String.valueOf(file) + parameters.toString();
        String pageIndex = req.getParameter("_i");
        String reload = req.getParameter("_r");
        if (StringUtils.isBlank((String)file)) {
            throw new ReportComputeException("Report file can not be null.");
        }
        if (file.equals("p")) {
            Report report = null;
            if (StringUtils.isNotBlank((String)pageIndex) && StringUtils.isBlank((String)reload)) {
                report = CacheUtils.getReport((String)fullName);
            }
            ReportDefinition reportDefinition = (ReportDefinition)TempObjectCache.getObject("p");
            if (report == null) {
                if (reportDefinition == null) {
                    throw new ReportDesignException("Report data has expired,can not do preview.");
                }
                report = this.reportBuilder.buildReport(reportDefinition, parameters);
                CacheUtils.storeReport((String)fullName, (Report)report);
            }
            htmlReport = new HtmlReport();
            String html = null;
            if (StringUtils.isNotBlank((String)pageIndex)) {
                com.bstek.ureport.build.Context context = report.getContext();
                int index = Integer.valueOf(pageIndex);
                SinglePageData pageData = PageBuilder.buildSinglePageData((int)index, (Report)report);
                List pages = pageData.getPages();
                if (pages.size() == 1) {
                    Page page = (Page)pages.get(0);
                    html = this.htmlProducer.produce(context, page, false);
                } else {
                    html = this.htmlProducer.produce(context, pages, pageData.getColumnMargin(), false);
                }
                htmlReport.setTotalPage(pageData.getTotalPages());
                htmlReport.setPageIndex(index);
            } else {
                html = this.htmlProducer.produce(report);
            }
            htmlReport.setChartDatas(report.getContext().getChartDataMap().values());
            htmlReport.setContent(html);
            htmlReport.setStyle(reportDefinition.getStyle());
            htmlReport.setReportAlign(report.getPaper().getHtmlReportAlign().name());
            htmlReport.setHtmlIntervalRefreshValue(report.getPaper().getHtmlIntervalRefreshValue());
        } else if (StringUtils.isNotBlank((String)pageIndex)) {
            int index = Integer.valueOf(pageIndex);
            htmlReport = this.exportManager.exportHtml(file, req.getContextPath(), parameters, index);
        } else {
            htmlReport = this.exportManager.exportHtml(file, req.getContextPath(), parameters);
        }
        return htmlReport;
    }

    private String buildCustomParameters(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        Enumeration enumeration = req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj == null) continue;
            String name = obj.toString();
            String value = req.getParameter(name);
            if (name == null || value == null || name.startsWith("_")) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(name);
            sb.append("=");
            sb.append(value);
        }
        return sb.toString();
    }

    public void setExportManager(ExportManager exportManager) {
        this.exportManager = exportManager;
    }

    public void setReportBuilder(ReportBuilder reportBuilder) {
        this.reportBuilder = reportBuilder;
    }

    public void setReportRender(ReportRender reportRender) {
        this.reportRender = reportRender;
    }

    @Override
    public String url() {
        return "/preview";
    }
}

