/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	SessionInfo.java
 * Author:		亮
 * Date:		2014-3-27 上午10:12:58
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.bstek.ureport.console;

import org.springframework.util.StringUtils;

/**
 * @author		亮
 * 
 * <p>增加门店类型和门店组，角色超级管理员标识    钱海兵  2022-03-07</p>
 */
public class ServiceSession {
	protected long ent_id;
	protected long user_id;
	protected String user_name;
	protected String locale;
	protected String api_version;
	protected String user_code;
	protected String erpCode;
	// 渠道编码
	protected String channelCode;
	//履约门店
	protected String deliveryShopCode;
	//作业门店
	protected String workShopCode;
	protected long   shop_id;
	protected String shop_code;
	protected String shop_Name;
	protected String trace_id;
	protected String shop_type;  // 门店类型
	protected String shop_group; // 门店组
	protected String moduleCode; // 模块编码
	
	//企业编码
	protected String entCode;
	//应用编码
	protected String appCode;
	//用户岗位ID
	protected long stationId;
	protected String stationName;
	//角色ID
	protected long roleId;
	// 是否超级管理员
	protected Boolean roleAdmin; 
	//数据范围ID
	protected long dataRangeId;
	
	// 加密信息  钱海兵  2021-05-10
	// 秘钥偏移量
	protected String encryptKey;
    // 秘钥
	protected String ivparameter;
    // 字符编码方式
	protected String encodingformat;
	//账号类型
	protected Integer accountType;
	// 授权用户ID
	protected long grantUID;
	//上次登录时间
	protected String lastLoginTime;

	/**
     * @return ent_id
     */
    public long getEnt_id()
    {
        return ent_id;
    }
    /**
     * @param ent_id 要设置的 ent_id
     */
    public void setEnt_id(long ent_id)
    {
        this.ent_id = ent_id;
    }
    
	/**
     * @return user_id
     */
    public long getUser_id()
    {
        return user_id;
    }
    /**
     * @param user_id 要设置的 user_id
     */
    public void setUser_id(long user_id)
    {
        this.user_id = user_id;
    }
    /**
     * @return user_name
     */
    public String getUser_name()
    {
        return user_name;
    }
    /**
     * @param user_name 要设置的 user_name
     */
    public void setUser_name(String user_name)
    {
        this.user_name = user_name;
    }
    /**
     * @return locale
     */
    public String getLocale()
    {
    	if (locale==null || locale.isEmpty()) locale="zh";
        return locale;
    }
    /**
     * @param locale 要设置的 locale
     */
    public void setLocale(String locale)
    {
        this.locale = locale;
    }
	public String getApi_version() {
		return api_version;
	}
	public void setApi_version(String api_version) {
		this.api_version = api_version;
	}
	public String getUser_code() {
		return user_code;
	}
	public void setUser_code(String user_code) {
		this.user_code = user_code;
	}
	public String getChannelCode() {
		return channelCode;
	}
	public void setChannelCode(String channelCode) {
		this.channelCode = channelCode;
	}
	public long getShop_id() {
		return shop_id;
	}
	public void setShop_id(long shop_id) {
		this.shop_id = shop_id;
	}
	
	public String getShop_code() {
		return shop_code;
	}
	public void setShop_code(String shop_code) {
		this.shop_code = shop_code;
	}

	public String getShop_Name() {
		return shop_Name;
	}
	public void setShop_Name(String shop_Name) {
		this.shop_Name = shop_Name;
	}
	public String getShop_type() {
		return shop_type;
	}
	public void setShop_type(String shop_Type) {
		this.shop_type = shop_Type;
	}
	public String getShop_group() {
		return shop_group;
	}
	public void setShop_group(String shop_group) {
		this.shop_group = shop_group;
	}
	public String getModuleCode() {
		return moduleCode;
	}
	public void setModuleCode(String moduleCode) {
		this.moduleCode = moduleCode;
	}
	public String getTrace_id() {
		if (StringUtils.isEmpty(trace_id)) {
			return "";
		}
		return trace_id;
	}
	public void setTrace_id(String trace_id) {
		this.trace_id = trace_id;
	}
	public String getEntCode() {
		return entCode;
	}
	public void setEntCode(String entCode) {
		this.entCode = entCode;
	}
	public String getAppCode() {
		return appCode;
	}
	public void setAppCode(String appCode) {
		this.appCode = appCode;
	}
	public long getStationId() {
		return stationId;
	}
	public void setStationId(long stationId) {
		this.stationId = stationId;
	}
	
	public String getStationName() {
		return stationName;
	}
	public void setStationName(String stationName) {
		this.stationName = stationName;
	}
	public long getRoleId() {
		return roleId;
	}
	public void setRoleId(long roleId) {
		this.roleId = roleId;
	}
	public Boolean getRoleAdmin() {
		return roleAdmin;
	}
	public void setRoleAdmin(Boolean roleAdmin) {
		this.roleAdmin = roleAdmin;
	}
	public long getDataRangeId() {
		return dataRangeId;
	}
	public void setDataRangeId(long dataRangeId) {
		this.dataRangeId = dataRangeId;
	}
	public String getErpCode() {
		return erpCode;
	}
	public void setErpCode(String erpCode) {
		this.erpCode = erpCode;
	}
	
	public String getDeliveryShopCode() {
		return deliveryShopCode;
	}
	public void setDeliveryShopCode(String deliveryShopCode) {
		this.deliveryShopCode = deliveryShopCode;
	}
	public String getWorkShopCode() {
		return workShopCode;
	}
	public void setWorkShopCode(String workShopCode) {
		this.workShopCode = workShopCode;
	}
	
	public String getEncryptKey() {
		return encryptKey;
	}
	public void setEncryptKey(String encryptKey) {
		this.encryptKey = encryptKey;
	}
	public String getIvparameter() {
		return ivparameter;
	}
	public void setIvparameter(String ivparameter) {
		this.ivparameter = ivparameter;
	}
	public String getEncodingformat() {
		return encodingformat;
	}
	public void setEncodingformat(String encodingformat) {
		this.encodingformat = encodingformat;
	}

	public Integer getAccountType() {
		return accountType;
	}

	public void setAccountType(Integer accountType) {
		this.accountType = accountType;
	}

	public long getGrantUID() {
		return grantUID;
	}
	public void setGrantUID(long grantUID) {
		this.grantUID = grantUID;
	}

	public String getLastLoginTime() {
		return lastLoginTime;
	}

	public void setLastLoginTime(String lastLoginTime) {
		this.lastLoginTime = lastLoginTime;
	}

	public static ServiceSession getSession() {
		ServiceSession session = new ServiceSession();
		session.setEnt_id(0L);
		return session;
	}
}
