/*******************************************************************************
 * Copyright 2017 Bstek
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License.  You may obtain a copy
 * of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 ******************************************************************************/
package com.bstek.ureport.console.html;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bstek.ureport.console.*;
import com.bstek.ureport.definition.PagingMode;
import com.bstek.ureport.utils.MetaDataUtil;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.codehaus.jackson.map.ObjectMapper;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.ReportBuilder;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.cache.CacheUtils;
import com.bstek.ureport.chart.ChartData;
import com.bstek.ureport.console.cache.TempObjectCache;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.searchform.FormPosition;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.export.ExportManager;
import com.bstek.ureport.export.FullPageData;
import com.bstek.ureport.export.PageBuilder;
import com.bstek.ureport.export.ReportRender;
import com.bstek.ureport.export.SinglePageData;
import com.bstek.ureport.export.html.HtmlProducer;
import com.bstek.ureport.export.html.HtmlReport;
import com.bstek.ureport.export.html.SearchFormData;
import com.bstek.ureport.model.Report;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

/**
 * @author Jacky.gao
 * @since 2017年2月15日
 */
public class HtmlPreviewServletAction extends RenderPageServletAction {
	private ExportManager exportManager;
	private ReportBuilder reportBuilder;
	private ReportRender reportRender;
	private HtmlProducer htmlProducer=new HtmlProducer();
	private boolean useIpage = true;
	@Value("${prefixurl}")
	String prefixurl;
	@Override
	public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		String method=retriveMethod(req);
		if(method!=null){
			//loadData--查询按钮
			//loadPrintPages--在线打印
			//loadPagePaper--打印预览
			invokeMethod(method, req, resp);
		}else{
			//第一次加载界面和服务,上一页下一页
			VelocityContext context = new VelocityContext();
			HtmlReport htmlReport=null;
			String errorMsg=null;
			ReportDefinition reportDefinition=null;
			try{
				reportDefinition=getReportDef(req);
				Boolean firstFlag=false;
				String pageIndex=req.getParameter("_i");

				//分页,未传入_i时为第一次打开界面
				if(!StringUtils.isEmpty(reportDefinition.getPaper())&&!StringUtils.isEmpty(reportDefinition.getPaper().getPagingMode())&& PagingMode.fixrows.toString().equals(reportDefinition.getPaper().getPagingMode().toString())){
					if(StringUtils.isEmpty(pageIndex)){
						firstFlag=true;
					}
					//如果第一次按照报表定义是否自动加载来执行查询，不是第一次执行查询
					if(firstFlag){
						htmlReport=loadReportByIPage(req,reportDefinition,reportDefinition.getPaper().isAutoloader(),firstFlag);
					}else{
						htmlReport=loadReportByIPage(req,reportDefinition,true,firstFlag);
					}

				}else{
					//不分页，第一次进入入口，不分页的查询执行loadData
					firstFlag=true;
					htmlReport=loadReport(req,reportDefinition,reportDefinition.getPaper().isAutoloader(),firstFlag);
				}
				context.put("pagingMode",reportDefinition.getPaper().getPagingMode().toString());
			}catch(Exception ex){
				if(!(ex instanceof ReportDesignException)){
					ex.printStackTrace();					
				}
				errorMsg=buildExceptionMessage(ex);
			}
			String title=buildTitle(req);
			context.put("title", title);
			if(htmlReport==null){
				context.put("content", "<div style='color:red'><strong>报表计算出错，错误信息如下：</strong><br><div style=\"margin:10px\">"+errorMsg+"</div></div>");
				context.put("error", true);
				context.put("searchFormJs", "");
				context.put("downSearchFormHtml", "");
				context.put("upSearchFormHtml", "");
				context.put("metadata", "");
			}else{
				SearchFormData formData=htmlReport.getSearchFormData();
				if(formData!=null){
					context.put("searchFormJs", formData.getJs());
					if(formData.getFormPosition().equals(FormPosition.up)){
						context.put("upSearchFormHtml", formData.getHtml());						
						context.put("downSearchFormHtml", "");						
					}else{
						context.put("downSearchFormHtml", formData.getHtml());						
						context.put("upSearchFormHtml", "");						
					}
				}else{
					context.put("searchFormJs", "");
					context.put("downSearchFormHtml", "");
					context.put("upSearchFormHtml", "");	
				}
				context.put("content", htmlReport.getContent());
				context.put("metadata", htmlReport.getMetadata());
				context.put("style", htmlReport.getStyle());
				context.put("reportAlign", htmlReport.getReportAlign());				
				context.put("totalPage", htmlReport.getTotalPage());
				context.put("totalPageWithCol", htmlReport.getTotalPageWithCol()); 
				context.put("pageIndex", htmlReport.getPageIndex());
				context.put("pageSize",htmlReport.getFixRows());
				context.put("totalRows",htmlReport.getTotalRows());
				context.put("chartDatas", convertJson(htmlReport.getChartDatas()));
				context.put("error", false);
				context.put("file", req.getParameter("_u"));
				context.put("intervalRefreshValue",htmlReport.getHtmlIntervalRefreshValue());
				String customParameters=buildCustomParameters(req);
				context.put("customParameters", customParameters);
				context.put("_t", "");
				Tools tools=null;
				if(MobileUtils.isMobile(req)){
					tools=new Tools(false);
					tools.setShow(false);
				}else{
					String toolsInfo=req.getParameter("_t");
					if(!StringUtils.isEmpty(toolsInfo)){
						tools=new Tools(false);
						if("0".equals(toolsInfo)){
							tools.setShow(false);
						}else{
							String[] infos=toolsInfo.split(",");
							for(String name:infos){
								tools.doInit(name);
							}						
						}
						context.put("_t", toolsInfo);
						context.put("hasTools", true);
					}else{
						tools=new Tools(true);
					}
				}
				filterTools(reportDefinition,tools);
				context.put("tools", tools);
			}
			context.put("contextPath", req.getContextPath());
			context.put("prefixurl", prefixurl);

			resp.setContentType("text/html");
			resp.setCharacterEncoding("utf-8");
			Template template=ve.getTemplate("ureport-html/html-preview.html","utf-8");
			PrintWriter writer=resp.getWriter();
			template.merge(context, writer);
			writer.close();
		}
	}

	private void filterTools(ReportDefinition reportDefinition,Tools tools){
		tools.setPagingExcel(false);
		//不分页的过滤掉分页导出和分页分sheet导出
		if("fitpage".equals(reportDefinition.getPaper().getPagingMode().toString())){
			tools.setSheetPagingExcel(false);
		}
	}
	
	private String buildTitle(HttpServletRequest req){
		String title=req.getParameter("_title");
		if(StringUtils.isEmpty(title)){
			title=req.getParameter("_u");
			title=decode(title);
			int point=title.lastIndexOf(".ureport.xml");
			if(point>-1){
				title=title.substring(0,point);
			}
			if("p".equals(title)){
				title="设计中报表";
			}
		}else{
			title=decode(title);
		}
		return title+"-ureport";
	}
	
	private String convertJson(Collection<ChartData> data){
		if(data==null || data.size()==0){
			return "";
		}
		ObjectMapper mapper=new ObjectMapper();
		try {
			String json = mapper.writeValueAsString(data);
			return json;
		} catch (Exception e) {
			throw new ReportComputeException(e);
		}
	}

	//查询按钮触发
	public void loadData(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		ReportDefinition reportDefinition=getReportDef(req);
		HtmlReport htmlReport = null;
		//根据报表中定义的是否分页
		if(!StringUtils.isEmpty(reportDefinition.getPaper())&&!StringUtils.isEmpty(reportDefinition.getPaper().getPagingMode())&& PagingMode.fixrows.toString().equals(reportDefinition.getPaper().getPagingMode().toString())){
			htmlReport=loadReportByIPage(req,reportDefinition,true,false);
		}else{
			htmlReport=loadReport(req,reportDefinition,true,false);
		}

		writeObjectToJson(resp, htmlReport);
	}

	public void loadPrintPages(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		ReportDefinition reportDefinition=getReportDef(req);
		Map<String, Object> parameters = buildParameters(req);
		parameters.put("querySqlFlag",true);
		Report report=reportBuilder.buildReport(reportDefinition, parameters,true);
		Map<String, ChartData> chartMap=report.getContext().getChartDataMap();
		if(chartMap.size()>0){
			CacheUtils.storeChartDataMap(chartMap);				
		}
		FullPageData pageData=PageBuilder.buildFullPageData(report);
		StringBuilder sb=new StringBuilder();
		List<List<Page>> list=pageData.getPageList();
		Context context=report.getContext();
		if(list.size()>0){
			for(int i=0;i<list.size();i++){
				List<Page> columnPages=list.get(i);
				if(i==0){
					String html=htmlProducer.produce(context,columnPages,pageData.getColumnMargin(),false);
					sb.append(html);											
				}else{
					String html=htmlProducer.produce(context,columnPages,pageData.getColumnMargin(),false);
					sb.append(html);											
				}
			}
		}else{
			List<Page> pages=report.getPages();
			for(int i=0;i<pages.size();i++){
				Page page=pages.get(i);
				if(i==0){
					String html=htmlProducer.produce(context,page, false);
					sb.append(html);
				}else{
					String html=htmlProducer.produce(context,page, true);
					sb.append(html);
				}
			}
		}
		Map<String,String> map=new HashMap<String,String>(1);
		map.put("html", sb.toString());
		writeObjectToJson(resp, map);
	}
	
	public void loadPagePaper(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		ReportDefinition report=getReportDef(req);
		Paper paper=report.getPaper();
		writeObjectToJson(resp, paper);
	}

	/**
	 * 基于数据库分页
	 * @param req
	 * @param reportDefinition
	 * @param querySqlFlag 是否执行报表查询sql
	 * @return
	 */
	private HtmlReport loadReportByIPage(HttpServletRequest req,ReportDefinition reportDefinition,Boolean querySqlFlag,Boolean firstFlag) {
		Map<String, Object> parameters = buildParameters(req);
		parameters.put("querySqlFlag",querySqlFlag);
		parameters.put("isPage",true);
		HtmlReport htmlReport=null;
		String file=req.getParameter("_u");
		file=decode(file);
		int pageIndex=StringUtils.isEmpty(req.getParameter("_i"))?1:Integer.valueOf(req.getParameter("_i"));

		if(file.equals(PREVIEW_KEY)){
			com.baomidou.mybatisplus.extension.plugins.pagination.Page page = getPageInfoByReportDef(pageIndex,reportDefinition);
			parameters.put("page", page);

			Report report=reportBuilder.buildReport(reportDefinition, parameters,false);
			Map<String, ChartData> chartMap=report.getContext().getChartDataMap();
			if(chartMap.size()>0){
				CacheUtils.storeChartDataMap(chartMap);
			}
			htmlReport=new HtmlReport();
			String html=null;
			//设置总页数
			htmlReport.setTotalPage(report.getTotalPage().intValue());
			//当前页
			htmlReport.setPageIndex(report.getPageIndex().intValue());
			//总条数
			htmlReport.setTotalRows(report.getTotalRows().intValue());
//			if(parameters.containsKey("page")){
//				htmlReport.setTotalPage(report.getTotalPage().intValue());
//				htmlReport.setPageIndex(report.getPageIndex().intValue());
//				htmlReport.setTotalRows(report.getTotalRows().intValue());
//			}
			html=htmlProducer.produce(report);

			if(report.getPaper().isColumnEnabled()){
				htmlReport.setColumn(report.getPaper().getColumnCount());
			}
			htmlReport.setChartDatas(report.getContext().getChartDataMap().values());
			String metadata = MetaDataUtil.parseMetaData(report.getMetadata(),parameters,firstFlag);
			htmlReport.setMetadata(metadata);
			htmlReport.setContent(html);
			htmlReport.setStyle(reportDefinition.getStyle());
			htmlReport.setFixRows(report.getPaper().getFixRows());
			htmlReport.setReportAlign(report.getPaper().getHtmlReportAlign().name());
			htmlReport.setHtmlIntervalRefreshValue(report.getPaper().getHtmlIntervalRefreshValue());
		}else{
			if(!StringUtils.isEmpty(pageIndex) && !"0".equals(pageIndex)){
				int index=Integer.valueOf(pageIndex);
				htmlReport=exportManager.exportHtml(reportDefinition,req.getContextPath(),parameters,index,firstFlag);
			}else{
				htmlReport=exportManager.exportHtml(reportDefinition,req.getContextPath(),parameters,firstFlag);
			}
		}
		return htmlReport;
	}

	/**
	 *
	 * @param req
	 * @param reportDefinition
	 * @param querySqlFlag 是否执行报表查询sql，不分页时，第一次进入根据报表配置是否自动加载来决定查询sql，查询时调用的loadData,默认查询
	 * @return
	 */
	private HtmlReport loadReport(HttpServletRequest req,ReportDefinition reportDefinition,Boolean querySqlFlag,Boolean firstFlag) {
		Map<String, Object> parameters = buildParameters(req);
		parameters.put("querySqlFlag",querySqlFlag);
		parameters.put("isPage",false);
		HtmlReport htmlReport=null;
		String file=req.getParameter("_u");
		file=decode(file);
		String pageIndex=req.getParameter("_i");

		if(file.equals(PREVIEW_KEY)){
			Report report=reportBuilder.buildReport(reportDefinition, parameters,false);
			Map<String, ChartData> chartMap=report.getContext().getChartDataMap();
			if(chartMap.size()>0){
				CacheUtils.storeChartDataMap(chartMap);				
			}
			htmlReport=new HtmlReport();
			String html=null;
			if(!StringUtils.isEmpty(pageIndex) && !"0".equals(pageIndex)){
				Context context=report.getContext();
				int index=Integer.valueOf(pageIndex);
				SinglePageData pageData=PageBuilder.buildSinglePageData(index, report);
				List<Page> pages=pageData.getPages();
				if(pages.size()==1){
					Page page=pages.get(0);
					html=htmlProducer.produce(context,page,false);					
				}else{
					html=htmlProducer.produce(context,pages,pageData.getColumnMargin(),false);					
				}
				htmlReport.setTotalPage(pageData.getTotalPages());
				htmlReport.setPageIndex(index);
			}else{
				html=htmlProducer.produce(report);				
			}
			if(report.getPaper().isColumnEnabled()){
				htmlReport.setColumn(report.getPaper().getColumnCount());				
			}
			htmlReport.setFixRows(report.getPaper().getFixRows());
			htmlReport.setChartDatas(report.getContext().getChartDataMap().values());
			String metadata = MetaDataUtil.parseMetaData(report.getMetadata(),parameters,firstFlag);
			htmlReport.setMetadata(metadata);
			htmlReport.setContent(html);
			htmlReport.setTotalPage(report.getPages().size());
			htmlReport.setStyle(reportDefinition.getStyle());
			//htmlReport.setSearchFormData(reportDefinition.buildSearchFormData(report.getContext().getDatasetMap(),parameters));
			htmlReport.setReportAlign(report.getPaper().getHtmlReportAlign().name());
			htmlReport.setHtmlIntervalRefreshValue(report.getPaper().getHtmlIntervalRefreshValue());
		}else{
			if(!StringUtils.isEmpty(pageIndex) && !"0".equals(pageIndex)){
				int index=Integer.valueOf(pageIndex);
				htmlReport=exportManager.exportHtml(reportDefinition,req.getContextPath(),parameters,index,firstFlag);
			}else{
				htmlReport=exportManager.exportHtml(reportDefinition,req.getContextPath(),parameters,firstFlag);
			}
		}
		return htmlReport;
	}

	private com.baomidou.mybatisplus.extension.plugins.pagination.Page getPageInfoByReportDef(Integer pageno,ReportDefinition reportDefinition){
		com.baomidou.mybatisplus.extension.plugins.pagination.Page page=null;
		Paper paper = reportDefinition.getPaper();
		if(paper != null){
			int perNum = paper.getFixRows();
			if (perNum > 0) {
				page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page(pageno, perNum);
			}
		}

		return page;
	}

	//获取报表定义
	private ReportDefinition getReportDef(HttpServletRequest req){
		String file=req.getParameter("_u");
		file=decode(file);
		if(StringUtils.isEmpty(file)){
			throw new ReportComputeException("Report file can not be null.");
		}
		ReportDefinition report=null;
		if(file.equals(PREVIEW_KEY)){
			report=(ReportDefinition)TempObjectCache.getObject(PREVIEW_KEY);
			if(report==null){
				throw new ReportDesignException("Report data has expired.");
			}
		}else{
			report=reportRender.getReportDefinition(file);
		}

		report = encodeMeta(report);
		if(report==null){
			throw new ReportDesignException("Report data has expired,can not do preview.");
		}
		return report;
	}
	
	
	private String buildCustomParameters(HttpServletRequest req){
		StringBuilder sb=new StringBuilder();
		Enumeration<?> enumeration=req.getParameterNames();
		while(enumeration.hasMoreElements()){
			Object obj=enumeration.nextElement();
			if(obj==null){
				continue;
			}
			String name=obj.toString();
			String value=req.getParameter(name);
			//通过网关，参数会带上session，session过滤掉，统一通过token
			if("session".equalsIgnoreCase(name)){
				continue;
			}
			if(name==null || value==null || (name.startsWith("_") && !"_n".equals(name))){
				continue;
			}
			if(sb.length()>0){
				sb.append("&");
			}
			sb.append(name);
			sb.append("=");
			sb.append(value);
		}
		return sb.toString();
	}
	
	private String buildExceptionMessage(Throwable throwable){
		Throwable root=buildRootException(throwable);
		StringWriter sw=new StringWriter();
		PrintWriter pw=new PrintWriter(sw);
		root.printStackTrace(pw);
		String trace=sw.getBuffer().toString();
		trace=trace.replaceAll("\n", "<br>");
		pw.close();
		return trace;
	}
	
	public void setExportManager(ExportManager exportManager) {
		this.exportManager = exportManager;
	}
	
	public void setReportBuilder(ReportBuilder reportBuilder) {
		this.reportBuilder = reportBuilder;
	}
	public void setReportRender(ReportRender reportRender) {
		this.reportRender = reportRender;
	}

	@Override
	public String url() {
		return "/preview";
	}
}
