/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bstek.ureport.console.ServiceSession;
import com.bstek.ureport.console.ServletAction;
import com.bstek.ureport.console.SpringContext;
import com.bstek.ureport.definition.ReportDefinition;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseServletAction
implements ServletAction {
    protected Throwable buildRootException(Throwable throwable) {
        if (throwable.getCause() == null) {
            return throwable;
        }
        return this.buildRootException(throwable.getCause());
    }

    protected String decode(String value) {
        if (value == null) {
            return value;
        }
        try {
            value = URLDecoder.decode(value, "utf-8");
            value = URLDecoder.decode(value, "utf-8");
            return value;
        }
        catch (Exception ex) {
            return value;
        }
    }

    protected String decodeContent(String content) {
        if (content == null) {
            return content;
        }
        try {
            content = URLDecoder.decode(content, "utf-8");
            return content;
        }
        catch (Exception ex) {
            return content;
        }
    }

    protected String encodeMetadata(String metadata) {
        String re = "";
        if (metadata == null) {
            return metadata;
        }
        try {
            if (metadata.indexOf("%7B") < 0) {
                JSONObject json = JSONObject.parseObject((String)metadata);
                re = URLEncoder.encode(metadata, "utf-8").replaceAll("\\+", "%20").replaceAll("\\!", "%21").replaceAll("\\'", "%27").replaceAll("\\(", "%28").replaceAll("\\)", "%29").replaceAll("\\~", "%7E");
                String msg = String.format("\u8f6c\u4e49\u524d %1$s %n \u8f6c\u4e49\u540e %2$s", metadata, re);
                System.out.println(msg);
                return re;
            }
            return metadata;
        }
        catch (Exception ex) {
            return metadata;
        }
    }

    protected ReportDefinition encodeMeta(ReportDefinition reportDef) {
        String metadata = this.encodeMetadata(reportDef.getMetadata());
        reportDef.setMetadata(metadata);
        return reportDef;
    }

    protected String getParameter(HttpServletRequest req, String key) {
        String value = req.getParameter(key);
        return this.decode(value);
    }

    protected Map<String, Object> buildParameters(HttpServletRequest req) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Enumeration enumeration = req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj == null) continue;
            String name = obj.toString();
            String value = req.getParameter(name);
            if (name == null || value == null || name.startsWith("_")) continue;
            parameters.put(name, this.decode(value));
        }
        return parameters;
    }

    protected void invokeMethod(String methodName, HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            Method method = this.getClass().getMethod(methodName, HttpServletRequest.class, HttpServletResponse.class);
            method.invoke((Object)this, req, resp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServletException((Throwable)ex);
        }
    }

    protected String retriveMethod(HttpServletRequest req) throws ServletException {
        String path = req.getContextPath() + "/ureport";
        String uri = req.getRequestURI();
        String targetUrl = uri.substring(path.length());
        this.handleSession(req);
        int slashPos = targetUrl.indexOf("/", 1);
        if (slashPos > -1) {
            String methodName = targetUrl.substring(slashPos + 1).trim();
            return methodName.length() > 0 ? methodName : null;
        }
        return null;
    }

    public void handleSession(HttpServletRequest req) {
        String menuCode = this.getParameter(req, "menuCode");
        String session = this.getParameter(req, "session");
        String entId = this.getParameter(req, "ent_id");
        String userId = this.getParameter(req, "user_id");
        ServiceSession contextSession = this.getSession(session, entId, userId);
        if (!StringUtils.isEmpty((CharSequence)menuCode)) {
            contextSession.setModuleCode(menuCode + "");
        }
        SpringContext.putSession(contextSession);
    }

    private ServiceSession getSession(String session, String entId, String userId) {
        ServiceSession response = new ServiceSession();
        if (StringUtils.isEmpty((CharSequence)session)) {
            if (!StringUtils.isEmpty((CharSequence)entId)) {
                response.setEnt_id(Long.parseLong(entId));
            } else {
                response.setEnt_id(0L);
            }
            if (!StringUtils.isEmpty((CharSequence)userId)) {
                response.setUser_id(Long.parseLong(userId));
            } else {
                response.setUser_id(0L);
            }
        } else {
            try {
                session = URLDecoder.decode(session, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                session = "{'ent_id':0,'user_id':0}";
            }
            response = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
        }
        return response;
    }

    protected String buildDownloadFileName(String reportFileName, String fileName, String extName) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            if (!(fileName = this.decode(fileName)).toLowerCase().endsWith(extName)) {
                fileName = fileName + extName;
            }
            return fileName;
        }
        int pos = reportFileName.indexOf(":");
        if (pos > 0) {
            reportFileName = reportFileName.substring(pos + 1, reportFileName.length());
        }
        if ((pos = reportFileName.toLowerCase().indexOf(".ureport.xml")) > 0) {
            reportFileName = reportFileName.substring(0, pos);
        }
        return "ureport-" + reportFileName + extName;
    }
}

