/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.html;

import com.alibaba.fastjson.JSONObject;
import com.bstek.ureport.build.ReportBuilder;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.cache.CacheUtils;
import com.bstek.ureport.chart.ChartData;
import com.bstek.ureport.console.MobileUtils;
import com.bstek.ureport.console.RenderPageServletAction;
import com.bstek.ureport.console.cache.TempObjectCache;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.console.html.Tools;
import com.bstek.ureport.definition.PagingMode;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.searchform.FormPosition;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.export.ExportManager;
import com.bstek.ureport.export.FullPageData;
import com.bstek.ureport.export.PageBuilder;
import com.bstek.ureport.export.ReportRender;
import com.bstek.ureport.export.SinglePageData;
import com.bstek.ureport.export.html.HtmlProducer;
import com.bstek.ureport.export.html.HtmlReport;
import com.bstek.ureport.export.html.SearchFormData;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.utils.MetaDataUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class HtmlPreviewServletAction
extends RenderPageServletAction {
    private ExportManager exportManager;
    private ReportBuilder reportBuilder;
    private ReportRender reportRender;
    private HtmlProducer htmlProducer = new HtmlProducer();
    private boolean useIpage = true;
    @Value(value="${prefixurl}")
    String prefixurl;

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            HtmlReport htmlReport = null;
            String errorMsg = null;
            ReportDefinition reportDefinition = null;
            try {
                reportDefinition = this.getReportDef(req);
                Boolean firstFlag = false;
                String pageIndex = req.getParameter("_i");
                if (!StringUtils.isEmpty((Object)reportDefinition.getPaper()) && !StringUtils.isEmpty((Object)reportDefinition.getPaper().getPagingMode()) && PagingMode.fixrows.toString().equals(reportDefinition.getPaper().getPagingMode().toString())) {
                    if (StringUtils.isEmpty((Object)pageIndex)) {
                        firstFlag = true;
                    }
                    htmlReport = firstFlag.booleanValue() ? this.loadReportByIPage(req, reportDefinition, reportDefinition.getPaper().isAutoloader(), firstFlag) : this.loadReportByIPage(req, reportDefinition, true, firstFlag);
                } else {
                    firstFlag = true;
                    htmlReport = this.loadReport(req, reportDefinition, reportDefinition.getPaper().isAutoloader(), firstFlag);
                }
                context.put("pagingMode", (Object)reportDefinition.getPaper().getPagingMode().toString());
            }
            catch (Exception ex) {
                if (!(ex instanceof ReportDesignException)) {
                    ex.printStackTrace();
                }
                errorMsg = this.buildExceptionMessage(ex);
            }
            String title = this.buildTitle(req);
            context.put("title", (Object)title);
            if (htmlReport == null) {
                context.put("content", (Object)("<div style='color:red'><strong>\u62a5\u8868\u8ba1\u7b97\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a</strong><br><div style=\"margin:10px\">" + errorMsg + "</div></div>"));
                context.put("error", (Object)true);
                context.put("searchFormJs", (Object)"");
                context.put("downSearchFormHtml", (Object)"");
                context.put("upSearchFormHtml", (Object)"");
                context.put("metadata", (Object)"");
            } else {
                SearchFormData formData = htmlReport.getSearchFormData();
                if (formData != null) {
                    context.put("searchFormJs", (Object)formData.getJs());
                    if (formData.getFormPosition().equals((Object)FormPosition.up)) {
                        context.put("upSearchFormHtml", (Object)formData.getHtml());
                        context.put("downSearchFormHtml", (Object)"");
                    } else {
                        context.put("downSearchFormHtml", (Object)formData.getHtml());
                        context.put("upSearchFormHtml", (Object)"");
                    }
                } else {
                    context.put("searchFormJs", (Object)"");
                    context.put("downSearchFormHtml", (Object)"");
                    context.put("upSearchFormHtml", (Object)"");
                }
                context.put("content", (Object)htmlReport.getContent());
                context.put("metadata", (Object)htmlReport.getMetadata());
                context.put("style", (Object)htmlReport.getStyle());
                context.put("reportAlign", (Object)htmlReport.getReportAlign());
                context.put("totalPage", (Object)htmlReport.getTotalPage());
                context.put("totalPageWithCol", (Object)htmlReport.getTotalPageWithCol());
                context.put("pageIndex", (Object)htmlReport.getPageIndex());
                context.put("pageSize", (Object)htmlReport.getFixRows());
                context.put("totalRows", (Object)htmlReport.getTotalRows());
                context.put("chartDatas", (Object)this.convertJson(htmlReport.getChartDatas()));
                context.put("error", (Object)false);
                context.put("file", (Object)req.getParameter("_u"));
                context.put("intervalRefreshValue", (Object)htmlReport.getHtmlIntervalRefreshValue());
                String customParameters = this.buildCustomParameters(req);
                context.put("customParameters", (Object)customParameters);
                context.put("_t", (Object)"");
                Tools tools = null;
                if (MobileUtils.isMobile(req)) {
                    tools = new Tools(false);
                    tools.setShow(false);
                } else {
                    String toolsInfo = req.getParameter("_t");
                    if (!StringUtils.isEmpty((Object)toolsInfo)) {
                        tools = new Tools(false);
                        if ("0".equals(toolsInfo)) {
                            tools.setShow(false);
                        } else {
                            String[] infos;
                            for (String name : infos = toolsInfo.split(",")) {
                                tools.doInit(name);
                            }
                        }
                        context.put("_t", (Object)toolsInfo);
                        context.put("hasTools", (Object)true);
                    } else {
                        tools = new Tools(true);
                    }
                }
                this.filterTools(reportDefinition, tools);
                context.put("tools", (Object)tools);
            }
            context.put("contextPath", (Object)req.getContextPath());
            context.put("prefixurl", (Object)this.prefixurl);
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("ureport-html/html-preview.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    private void filterTools(ReportDefinition reportDefinition, Tools tools) {
        tools.setPagingExcel(false);
        if ("fitpage".equals(reportDefinition.getPaper().getPagingMode().toString())) {
            tools.setSheetPagingExcel(false);
        }
    }

    private String buildTitle(HttpServletRequest req) {
        String title = req.getParameter("_title");
        if (StringUtils.isEmpty((Object)title)) {
            title = req.getParameter("_u");
            int point = (title = this.decode(title)).lastIndexOf(".ureport.xml");
            if (point > -1) {
                title = title.substring(0, point);
            }
            if ("p".equals(title)) {
                title = "\u8bbe\u8ba1\u4e2d\u62a5\u8868";
            }
        } else {
            title = this.decode(title);
        }
        return title + "-ureport";
    }

    private String convertJson(Collection<ChartData> data) {
        if (data == null || data.size() == 0) {
            return "";
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = mapper.writeValueAsString(data);
            return json;
        }
        catch (Exception e) {
            throw new ReportComputeException(e);
        }
    }

    public void loadData(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ReportDefinition reportDefinition = this.getReportDef(req);
        HtmlReport htmlReport = null;
        htmlReport = !StringUtils.isEmpty((Object)reportDefinition.getPaper()) && !StringUtils.isEmpty((Object)reportDefinition.getPaper().getPagingMode()) && PagingMode.fixrows.toString().equals(reportDefinition.getPaper().getPagingMode().toString()) ? this.loadReportByIPage(req, reportDefinition, true, false) : this.loadReport(req, reportDefinition, true, false);
        this.writeObjectToJson(resp, htmlReport);
    }

    public void loadPrintPages(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ReportDefinition reportDefinition = this.getReportDef(req);
        Map<String, Object> parameters = this.buildParameters(req);
        parameters.put("querySqlFlag", true);
        Report report = this.reportBuilder.buildReport(reportDefinition, parameters, Boolean.valueOf(true));
        Map chartMap = report.getContext().getChartDataMap();
        if (chartMap.size() > 0) {
            CacheUtils.storeChartDataMap((Map)chartMap);
        }
        FullPageData pageData = PageBuilder.buildFullPageData((Report)report);
        StringBuilder sb = new StringBuilder();
        List list = pageData.getPageList();
        com.bstek.ureport.build.Context context = report.getContext();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String html;
                List columnPages = (List)list.get(i);
                if (i == 0) {
                    html = this.htmlProducer.produce(context, columnPages, pageData.getColumnMargin(), false);
                    sb.append(html);
                    continue;
                }
                html = this.htmlProducer.produce(context, columnPages, pageData.getColumnMargin(), false);
                sb.append(html);
            }
        } else {
            List pages = report.getPages();
            for (int i = 0; i < pages.size(); ++i) {
                String html;
                Page page = (Page)pages.get(i);
                if (i == 0) {
                    html = this.htmlProducer.produce(context, page, false);
                    sb.append(html);
                    continue;
                }
                html = this.htmlProducer.produce(context, page, true);
                sb.append(html);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("html", sb.toString());
        this.writeObjectToJson(resp, map);
    }

    public void loadPagePaper(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ReportDefinition report = this.getReportDef(req);
        Paper paper = report.getPaper();
        this.writeObjectToJson(resp, paper);
    }

    private HtmlReport loadReportByIPage(HttpServletRequest req, ReportDefinition reportDefinition, Boolean querySqlFlag, Boolean firstFlag) {
        int pageIndex;
        Map<String, Object> parameters = this.buildParameters(req);
        parameters.put("querySqlFlag", querySqlFlag);
        parameters.put("isPage", true);
        HtmlReport htmlReport = null;
        String file = req.getParameter("_u");
        file = this.decode(file);
        int n = pageIndex = StringUtils.isEmpty((Object)req.getParameter("_i")) ? 1 : Integer.valueOf(req.getParameter("_i"));
        if (file.equals("p")) {
            JSONObject page = this.getPageInfoByReportDef(pageIndex, reportDefinition);
            parameters.put("page", page);
            Report report = this.reportBuilder.buildReport(reportDefinition, parameters, Boolean.valueOf(false));
            Map chartMap = report.getContext().getChartDataMap();
            if (chartMap.size() > 0) {
                CacheUtils.storeChartDataMap((Map)chartMap);
            }
            htmlReport = new HtmlReport();
            String html = null;
            htmlReport.setTotalPage(report.getTotalPage().intValue());
            htmlReport.setPageIndex(report.getPageIndex().intValue());
            htmlReport.setTotalRows(report.getTotalRows().intValue());
            html = this.htmlProducer.produce(report);
            if (report.getPaper().isColumnEnabled()) {
                htmlReport.setColumn(report.getPaper().getColumnCount());
            }
            htmlReport.setChartDatas(report.getContext().getChartDataMap().values());
            String metadata = MetaDataUtil.parseMetaData((String)report.getMetadata(), parameters, (boolean)firstFlag);
            htmlReport.setMetadata(metadata);
            htmlReport.setContent(html);
            htmlReport.setStyle(reportDefinition.getStyle());
            htmlReport.setFixRows(report.getPaper().getFixRows());
            htmlReport.setReportAlign(report.getPaper().getHtmlReportAlign().name());
            htmlReport.setHtmlIntervalRefreshValue(report.getPaper().getHtmlIntervalRefreshValue());
        } else if (!StringUtils.isEmpty((Object)pageIndex) && !"0".equals(pageIndex)) {
            int index = pageIndex;
            htmlReport = this.exportManager.exportHtml(reportDefinition, req.getContextPath(), parameters, index, firstFlag);
        } else {
            htmlReport = this.exportManager.exportHtml(reportDefinition, req.getContextPath(), parameters, firstFlag);
        }
        return htmlReport;
    }

    private HtmlReport loadReport(HttpServletRequest req, ReportDefinition reportDefinition, Boolean querySqlFlag, Boolean firstFlag) {
        Map<String, Object> parameters = this.buildParameters(req);
        parameters.put("querySqlFlag", querySqlFlag);
        parameters.put("isPage", false);
        HtmlReport htmlReport = null;
        String file = req.getParameter("_u");
        file = this.decode(file);
        String pageIndex = req.getParameter("_i");
        if (file.equals("p")) {
            Report report = this.reportBuilder.buildReport(reportDefinition, parameters, Boolean.valueOf(false));
            Map chartMap = report.getContext().getChartDataMap();
            if (chartMap.size() > 0) {
                CacheUtils.storeChartDataMap((Map)chartMap);
            }
            htmlReport = new HtmlReport();
            String html = null;
            if (!StringUtils.isEmpty((Object)pageIndex) && !"0".equals(pageIndex)) {
                com.bstek.ureport.build.Context context = report.getContext();
                int index = Integer.valueOf(pageIndex);
                SinglePageData pageData = PageBuilder.buildSinglePageData((int)index, (Report)report);
                List pages = pageData.getPages();
                if (pages.size() == 1) {
                    Page page = (Page)pages.get(0);
                    html = this.htmlProducer.produce(context, page, false);
                } else {
                    html = this.htmlProducer.produce(context, pages, pageData.getColumnMargin(), false);
                }
                htmlReport.setTotalPage(pageData.getTotalPages());
                htmlReport.setPageIndex(index);
            } else {
                html = this.htmlProducer.produce(report);
            }
            if (report.getPaper().isColumnEnabled()) {
                htmlReport.setColumn(report.getPaper().getColumnCount());
            }
            htmlReport.setFixRows(report.getPaper().getFixRows());
            htmlReport.setChartDatas(report.getContext().getChartDataMap().values());
            String metadata = MetaDataUtil.parseMetaData((String)report.getMetadata(), parameters, (boolean)firstFlag);
            htmlReport.setMetadata(metadata);
            htmlReport.setContent(html);
            htmlReport.setTotalPage(report.getPages().size());
            htmlReport.setStyle(reportDefinition.getStyle());
            htmlReport.setReportAlign(report.getPaper().getHtmlReportAlign().name());
            htmlReport.setHtmlIntervalRefreshValue(report.getPaper().getHtmlIntervalRefreshValue());
        } else if (!StringUtils.isEmpty((Object)pageIndex) && !"0".equals(pageIndex)) {
            int index = Integer.valueOf(pageIndex);
            htmlReport = this.exportManager.exportHtml(reportDefinition, req.getContextPath(), parameters, index, firstFlag);
        } else {
            htmlReport = this.exportManager.exportHtml(reportDefinition, req.getContextPath(), parameters, firstFlag);
        }
        return htmlReport;
    }

    private JSONObject getPageInfoByReportDef(Integer pageno, ReportDefinition reportDefinition) {
        int perNum;
        JSONObject page = new JSONObject();
        Paper paper = reportDefinition.getPaper();
        if (paper != null && (perNum = paper.getFixRows()) > 0) {
            page.put("page_no", (Object)pageno);
            page.put("page_size", (Object)perNum);
        }
        return page;
    }

    private ReportDefinition getReportDef(HttpServletRequest req) {
        String file = req.getParameter("_u");
        if (StringUtils.isEmpty((Object)(file = this.decode(file)))) {
            throw new ReportComputeException("Report file can not be null.");
        }
        ReportDefinition report = null;
        if (file.equals("p")) {
            report = (ReportDefinition)TempObjectCache.getObject("p");
            if (report == null) {
                throw new ReportDesignException("Report data has expired.");
            }
        } else {
            report = this.reportRender.getReportDefinition(file);
        }
        if ((report = this.encodeMeta(report)) == null) {
            throw new ReportDesignException("Report data has expired,can not do preview.");
        }
        return report;
    }

    private String buildCustomParameters(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        Enumeration enumeration = req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj == null) continue;
            String name = obj.toString();
            String value = req.getParameter(name);
            if ("session".equalsIgnoreCase(name) || name == null || value == null || name.startsWith("_") && !"_n".equals(name)) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(name);
            sb.append("=");
            sb.append(value);
        }
        return sb.toString();
    }

    private String buildExceptionMessage(Throwable throwable) {
        Throwable root = this.buildRootException(throwable);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        root.printStackTrace(pw);
        String trace = sw.getBuffer().toString();
        trace = trace.replaceAll("\n", "<br>");
        pw.close();
        return trace;
    }

    public void setExportManager(ExportManager exportManager) {
        this.exportManager = exportManager;
    }

    public void setReportBuilder(ReportBuilder reportBuilder) {
        this.reportBuilder = reportBuilder;
    }

    public void setReportRender(ReportRender reportRender) {
        this.reportRender = reportRender;
    }

    @Override
    public String url() {
        return "/preview";
    }
}

