/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.designer;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.console.RenderPageServletAction;
import com.bstek.ureport.console.designer.DataResult;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.definition.datasource.BuildinDatasource;
import com.bstek.ureport.definition.datasource.DataType;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.utils.ProcedureUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.beanutils.PropertyUtils;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.StringUtils;

public class DatasourceServletAction
extends RenderPageServletAction {
    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        }
    }

    public void loadBuildinDatasources(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArrayList<String> datasources = new ArrayList<String>();
        for (BuildinDatasource datasource : Utils.getBuildinDatasources()) {
            datasources.add(datasource.name());
        }
        this.writeObjectToJson(resp, datasources);
    }

    public void loadMethods(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String beanId = req.getParameter("beanId");
        Object obj = this.applicationContext.getBean(beanId);
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        ArrayList<String> result = new ArrayList<String>();
        for (Method method : methods) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 3) continue;
            Class<?> typeClass1 = types[0];
            Class<?> typeClass2 = types[1];
            Class<?> typeClass3 = types[2];
            if (!String.class.isAssignableFrom(typeClass1) || !String.class.isAssignableFrom(typeClass2) || !Map.class.isAssignableFrom(typeClass3)) continue;
            result.add(method.getName());
        }
        this.writeObjectToJson(resp, result);
    }

    public void buildClass(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String clazz = req.getParameter("clazz");
        String proxy = req.getParameter("proxy");
        String beanId = req.getParameter("beanId");
        ArrayList<Field> result = new ArrayList<Field>();
        if (!StringUtils.isEmpty((Object)proxy) && !StringUtils.isEmpty((Object)beanId)) {
            List<String> fields = this.buildClassRemote(proxy, beanId, clazz);
            if (!StringUtils.isEmpty(fields)) {
                for (String field : fields) {
                    result.add(new Field(field));
                }
            }
        } else {
            try {
                PropertyDescriptor[] propertyDescriptors;
                Class<?> targetClass = Class.forName(clazz);
                for (PropertyDescriptor pd : propertyDescriptors = PropertyUtils.getPropertyDescriptors(targetClass)) {
                    String name = pd.getName();
                    if ("class".equals(name)) continue;
                    result.add(new Field(name));
                }
            }
            catch (Exception ex) {
                throw new ReportDesignException(ex);
            }
        }
        this.writeObjectToJson(resp, result);
    }

    public List<String> buildClassRemote(String proxy, String beanId, String clazz) {
        String method = beanId + ".bulidUreportClass";
        ArrayList<String> fields = new ArrayList<String>();
        return fields;
    }

    public void buildDatabaseTables(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = this.buildConnection(req);
            DatabaseMetaData metaData = conn.getMetaData();
            String url = metaData.getURL();
            String schema = null;
            if (url.toLowerCase().contains("oracle")) {
                schema = metaData.getUserName();
            }
            ArrayList tables = new ArrayList();
            rs = metaData.getTables(null, schema, "%", new String[]{"TABLE", "VIEW"});
            while (rs.next()) {
                HashMap<String, String> table = new HashMap<String, String>();
                table.put("name", rs.getString("TABLE_NAME"));
                table.put("type", rs.getString("TABLE_TYPE"));
                tables.add(table);
            }
            this.writeObjectToJson(resp, tables);
        }
        catch (Exception ex) {
            try {
                throw new ServletException((Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeConnection((Connection)conn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeConnection((Connection)conn);
    }

    public void buildFields(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sql = req.getParameter("sql");
        String parameters = req.getParameter("parameters");
        Connection conn = null;
        final ArrayList fields = new ArrayList();
        try {
            conn = this.buildConnection(req);
            Map<String, Object> map = this.buildParameters(parameters);
            sql = this.parseSql(sql, map);
            if (ProcedureUtils.isProcedure((String)sql)) {
                List fieldsList = ProcedureUtils.procedureColumnsQuery((String)sql, map, (Connection)conn);
                fields.addAll(fieldsList);
            } else {
                SingleConnectionDataSource dataSource = new SingleConnectionDataSource(conn, false);
                NamedParameterJdbcTemplate jdbc = new NamedParameterJdbcTemplate((DataSource)dataSource);
                PreparedStatementCreator statementCreator = this.getPreparedStatementCreator(sql, (SqlParameterSource)new MapSqlParameterSource(map));
                jdbc.getJdbcOperations().execute(statementCreator, (PreparedStatementCallback)new PreparedStatementCallback<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                        ResultSet rs = null;
                        try {
                            rs = ps.executeQuery();
                            ResultSetMetaData metadata = rs.getMetaData();
                            int columnCount = metadata.getColumnCount();
                            for (int i = 0; i < columnCount; ++i) {
                                String columnName = metadata.getColumnLabel(i + 1);
                                fields.add(new Field(columnName));
                            }
                            Object var5_6 = null;
                            return var5_6;
                        }
                        finally {
                            JdbcUtils.closeResultSet((ResultSet)rs);
                        }
                    }
                });
            }
            this.writeObjectToJson(resp, fields);
        }
        catch (Exception ex) {
            throw new ReportDesignException(ex);
        }
        finally {
            JdbcUtils.closeConnection((Connection)conn);
        }
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource paramSource) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement((String)sql);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        Object[] params = NamedParameterUtils.buildValueArray((ParsedSql)parsedSql, (SqlParameterSource)paramSource, null);
        List declaredParameters = NamedParameterUtils.buildSqlParameterList((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sqlToUse, declaredParameters);
        return pscf.newPreparedStatementCreator(params);
    }

    public void previewData(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sql = req.getParameter("sql");
        String parameters = req.getParameter("parameters");
        Map<String, Object> map = this.buildParameters(parameters);
        sql = this.parseSql(sql, map);
        Connection conn = null;
        try {
            int size;
            conn = this.buildConnection(req);
            List list = null;
            if (ProcedureUtils.isProcedure((String)sql)) {
                list = ProcedureUtils.procedureQuery((String)sql, map, (Connection)conn);
            } else {
                SingleConnectionDataSource dataSource = new SingleConnectionDataSource(conn, false);
                NamedParameterJdbcTemplate jdbc = new NamedParameterJdbcTemplate((DataSource)dataSource);
                list = jdbc.queryForList(sql, map);
            }
            int currentTotal = size = list.size();
            if (currentTotal > 500) {
                currentTotal = 500;
            }
            ArrayList<Map<String, Object>> ls = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < currentTotal; ++i) {
                ls.add((Map)list.get(i));
            }
            DataResult result = new DataResult();
            ArrayList<String> fields = new ArrayList<String>();
            if (size > 0) {
                Map item = (Map)list.get(0);
                for (String name : item.keySet()) {
                    fields.add(name);
                }
            }
            result.setFields(fields);
            result.setCurrentTotal(currentTotal);
            result.setData(ls);
            result.setTotal(size);
            this.writeObjectToJson(resp, result);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String parseSql(String sql, Map<String, Object> parameters) {
        sql = sql.trim();
        Context context = new Context(this.applicationContext, parameters);
        if (sql.startsWith("${") && sql.endsWith("}")) {
            sql = sql.substring(2, sql.length() - 1);
            Expression expr = ExpressionUtils.parseExpression((String)sql);
            sql = this.executeSqlExpr(expr, context);
            return sql;
        }
        String sqlForUse = sql;
        Pattern pattern = Pattern.compile("\\$\\{.*?\\}");
        Matcher matcher = pattern.matcher(sqlForUse);
        while (matcher.find()) {
            String substr = matcher.group();
            String sqlExpr = substr.substring(2, substr.length() - 1);
            Expression expr = ExpressionUtils.parseExpression((String)sqlExpr);
            String result = this.executeSqlExpr(expr, context);
            sqlForUse = sqlForUse.replace(substr, result);
        }
        Utils.logToConsole((String)("DESIGN SQL:" + sqlForUse));
        return sqlForUse;
    }

    private String executeSqlExpr(Expression sqlExpr, Context context) {
        ObjectExpressionData data;
        Object obj;
        String sqlForUse = null;
        ExpressionData exprData = sqlExpr.execute(null, null, context);
        if (exprData instanceof ObjectExpressionData && (obj = (data = (ObjectExpressionData)exprData).getData()) != null) {
            String s = obj.toString();
            sqlForUse = s = s.replaceAll("\\\\", "");
        }
        return sqlForUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        String driver = req.getParameter("driver");
        String url = req.getParameter("url");
        Connection conn = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, username, password);
            map.put("result", true);
        }
        catch (Exception ex) {
            map.put("error", ex.toString());
            map.put("result", false);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        this.writeObjectToJson(resp, map);
    }

    private Map<String, Object> buildParameters(String parameters) throws IOException, JsonParseException, JsonMappingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parameters)) {
            return map;
        }
        ObjectMapper mapper = new ObjectMapper();
        List list = (List)mapper.readValue(parameters, ArrayList.class);
        for (Map param : list) {
            String name = param.get("name").toString();
            DataType type = DataType.valueOf((String)param.get("type").toString());
            String defaultValue = (String)param.get("defaultValue");
            if (defaultValue == null || defaultValue.equals("")) {
                switch (type) {
                    case Boolean: {
                        map.put(name, false);
                    }
                    case Date: {
                        map.put(name, new Date());
                    }
                    case Float: {
                        map.put(name, new Float(0.0f));
                    }
                    case Integer: {
                        map.put(name, 0);
                    }
                    case String: {
                        if (defaultValue != null && defaultValue.equals("")) {
                            map.put(name, "");
                            break;
                        }
                        map.put(name, "null");
                        break;
                    }
                    case List: {
                        map.put(name, new ArrayList());
                    }
                }
                continue;
            }
            map.put(name, type.parse((Object)defaultValue));
        }
        return map;
    }

    private Connection buildConnection(HttpServletRequest req) throws Exception {
        String type = req.getParameter("type");
        if (type.equals("jdbc")) {
            String username = req.getParameter("username");
            String password = req.getParameter("password");
            String driver = req.getParameter("driver");
            String url = req.getParameter("url");
            Class.forName(driver);
            Connection conn = DriverManager.getConnection(url, username, password);
            return conn;
        }
        String name = req.getParameter("name");
        Connection conn = Utils.getBuildinConnection((String)name);
        if (conn == null) {
            throw new ReportDesignException("Buildin datasource [" + name + "] not exist.");
        }
        return conn;
    }

    @Override
    public String url() {
        return "/datasource";
    }
}

