function enableColumnResize(table) {
    const headers = table.querySelectorAll('th.resize-handle');

    headers.forEach(header => {
    let startX = 0;
    let startWidth = 0;
    let column;

    header.addEventListener('mousedown', e => {
    startX = e.pageX;
    startWidth = header.offsetWidth;
    column = header.cellIndex;

    document.addEventListener('mousemove', resizeColumn);
    document.addEventListener('mouseup', stopResizing);
});

    function resizeColumn(e) {
    const width = startWidth + (e.pageX - startX);
    header.style.width = `${width}px`;

    const cells = Array.from(table.querySelectorAll(`td:nth-child(${column + 1})`));
    cells.forEach(cell => {
    cell.style.width = `${width}px`;
});
}

    function stopResizing() {
    document.removeEventListener('mousemove', resizeColumn);
    document.removeEventListener('mouseup', stopResizing);
}
});
}