/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.designer;

import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.definition.ColumnDefinition;
import com.bstek.ureport.definition.HeaderFooterDefinition;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.RowDefinition;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.searchform.SearchForm;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportDefinitionWrapper {
    private Paper paper;
    private HeaderFooterDefinition header;
    private HeaderFooterDefinition footer;
    private SearchForm searchForm;
    private String searchFormXml;
    private String metadata;
    private List<RowDefinition> rows;
    private List<ColumnDefinition> columns;
    private List<DatasourceDefinition> datasources;
    private Map<String, CellDefinition> cellsMap = new HashMap<String, CellDefinition>();

    public ReportDefinitionWrapper(ReportDefinition report) {
        this.paper = report.getPaper();
        this.header = report.getHeader();
        this.footer = report.getFooter();
        this.searchForm = report.getSearchForm();
        this.searchFormXml = report.getSearchFormXml();
        this.metadata = report.getMetadata();
        this.rows = report.getRows();
        this.columns = report.getColumns();
        this.datasources = report.getDatasources();
        for (CellDefinition cell : report.getCells()) {
            this.cellsMap.put(cell.getRowNumber() + "," + cell.getColumnNumber(), cell);
        }
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public List<DatasourceDefinition> getDatasources() {
        return this.datasources;
    }

    public HeaderFooterDefinition getFooter() {
        return this.footer;
    }

    public HeaderFooterDefinition getHeader() {
        return this.header;
    }

    public Paper getPaper() {
        return this.paper;
    }

    public SearchForm getSearchForm() {
        return this.searchForm;
    }

    public void setSearchForm(SearchForm searchForm) {
        this.searchForm = searchForm;
    }

    public Map<String, CellDefinition> getCellsMap() {
        return this.cellsMap;
    }

    public List<RowDefinition> getRows() {
        return this.rows;
    }

    public String getSearchFormXml() {
        return this.searchFormXml;
    }

    public void setSearchFormXml(String searchFormXml) {
        this.searchFormXml = searchFormXml;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }
}

