/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.importexcel;

import com.bstek.ureport.console.RenderPageServletAction;
import com.bstek.ureport.console.cache.TempObjectCache;
import com.bstek.ureport.console.importexcel.ExcelParser;
import com.bstek.ureport.console.importexcel.HSSFExcelParser;
import com.bstek.ureport.console.importexcel.XSSFExcelParser;
import com.bstek.ureport.definition.ReportDefinition;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.jakarta.JakartaServletFileUpload;

public class ImportExcelServletAction
extends RenderPageServletAction {
    private List<ExcelParser> excelParsers = new ArrayList<ExcelParser>();

    public ImportExcelServletAction() {
        this.excelParsers.add(new HSSFExcelParser());
        this.excelParsers.add(new XSSFExcelParser());
    }

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        DiskFileItemFactory factory = ((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setPath(Paths.get(tempDir, new String[0]))).setBufferSize(1000240)).get();
        JakartaServletFileUpload upload = new JakartaServletFileUpload((FileItemFactory)factory);
        ReportDefinition report = null;
        String errorInfo = null;
        try {
            List items = upload.parseRequest(req);
            for (FileItem item : items) {
                String fieldName = item.getFieldName();
                String name = item.getName().toLowerCase();
                if (!fieldName.equals("_excel_file") || !name.endsWith(".xls") && !name.endsWith(".xlsx")) continue;
                InputStream inputStream = item.getInputStream();
                for (ExcelParser parser : this.excelParsers) {
                    if (!parser.support(name)) continue;
                    report = parser.parse(inputStream);
                    break;
                }
                inputStream.close();
                break;
            }
            errorInfo = "\u8bf7\u9009\u62e9\u4e00\u4e2a\u5408\u6cd5\u7684Excel\u5bfc\u5165";
        }
        catch (Exception e) {
            e.printStackTrace();
            errorInfo = e.getMessage();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (report != null) {
            result.put("result", true);
            TempObjectCache.putObject("classpath:template/template.ureport.xml", report);
        } else {
            result.put("result", false);
            if (errorInfo != null) {
                result.put("errorInfo", errorInfo);
            }
        }
        this.writeObjectToJson(resp, result);
    }

    @Override
    public String url() {
        return "/import";
    }
}

