/*******************************************************************************
 * Copyright 2017 Bstek
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License.  You may obtain a copy
 * of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 ******************************************************************************/
package com.bstek.ureport.console;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import com.bstek.ureport.definition.ReportDefinition;


/**
 * @author Jacky.gao
 * @since 2016年6月3日
 */
public abstract class BaseServletAction implements ServletAction {
	protected Throwable buildRootException(Throwable throwable){
		if(throwable.getCause()==null){
			return throwable;
		}
		return buildRootException(throwable.getCause());
	}

	protected String decode(String value){
		if(value==null){
			return value;
		}
		try{
			value=URLDecoder.decode(value, "utf-8");
			value=URLDecoder.decode(value, "utf-8");
			return value;
		}catch(Exception ex){
			return value;
		}
	}
	protected String decodeContent(String content){
		if(content==null){
			return content;
		}
		try{
			content=URLDecoder.decode(content, "utf-8");
			return content;
		}catch(Exception ex){
			return content;
		}
	}


	
	protected String encodeMetadata(String metadata) {
		String re = "";
		if(metadata==null) {
			return metadata;
		}
		try {
			if(metadata.indexOf("%7B")<0) {
				JSONObject json  = JSONObject.parseObject(metadata);
				re = URLEncoder.encode(metadata, "utf-8").replaceAll("\\+", "%20")
						.replaceAll("\\!", "%21")
						.replaceAll("\\'", "%27")
						.replaceAll("\\(", "%28")
						.replaceAll("\\)", "%29")
						.replaceAll("\\~", "%7E");
				String msg = String.format("转义前 %1$s %n 转义后 %2$s", metadata, re);
//				System.out.println(msg);
				return re;
			}else{
				return metadata;
			}
		}catch(Exception ex) {
			return metadata;
		}
		
	}
	
	protected ReportDefinition encodeMeta(ReportDefinition reportDef) {
		String metadata = encodeMetadata(reportDef.getMetadata());
		reportDef.setMetadata(metadata);
		return reportDef;
	}

	protected  String getParameter(HttpServletRequest req,String key){
		String value=req.getParameter(key);
		return decode(value);
	}
	protected Map<String, Object> buildParameters(HttpServletRequest req) {
		Map<String,Object> parameters=new HashMap<String,Object>();
		Enumeration<?> enumeration=req.getParameterNames();
		while(enumeration.hasMoreElements()){
			Object obj=enumeration.nextElement();
			if(obj==null){
				continue;
			}
			String name=obj.toString();
			String value=req.getParameter(name);
			if(name==null || value==null || name.startsWith("_")){
				continue;
			}
			parameters.put(name, decode(value));
		}
		return parameters;
	}
	
	protected void invokeMethod(String methodName,HttpServletRequest req,HttpServletResponse resp) throws ServletException{
		try{
			Method method=this.getClass().getMethod(methodName, new Class<?>[]{HttpServletRequest.class,HttpServletResponse.class});			
			method.invoke(this, new Object[]{req,resp});
		}catch(Exception ex){
			ex.printStackTrace();
			throw new ServletException(ex);
		}
	}
	
	protected String retriveMethod(HttpServletRequest req) throws ServletException{
		String path=req.getContextPath()+UReportServlet.URL;
		String uri=req.getRequestURI();
		String targetUrl=uri.substring(path.length());
        //初始化session
		handleSession(req);
		int slashPos=targetUrl.indexOf("/",1);
		if(slashPos>-1){
			String methodName=targetUrl.substring(slashPos+1).trim();
			return methodName.length()>0 ? methodName : null;
		}
		return null;
	}

	public void handleSession(HttpServletRequest req){
		// 写入线程上下文
		String menuCode = getParameter(req, "menuCode");
		String moduleCode = getParameter(req, "moduleCode");
		String session = getParameter(req, "session");
		String entId = getParameter(req, "ent_id");
		String userId = getParameter(req, "user_id");
		ServiceSession contextSession = this.getSession(session, entId, userId);
		if (!StringUtils.isEmpty(menuCode)) {
			contextSession.setMenuCode(menuCode + "");
		}

		if (!StringUtils.isEmpty(moduleCode)) {
			contextSession.setModuleCode(moduleCode + "");
		}

		SpringContext.putSession(contextSession);
	}

	private ServiceSession getSession(String session,String entId,String userId){
		ServiceSession response = new ServiceSession();
		if(StringUtils.isEmpty(session)){
			if(!StringUtils.isEmpty(entId)){
				response.setEnt_id(Long.parseLong(entId));
			}else{
				response.setEnt_id(0L);
			}
			if (!StringUtils.isEmpty(userId)) {
				response.setUser_id(Long.parseLong(userId));
			}else{
				response.setUser_id(0L);
			}
		}else{
			try {
				session=URLDecoder.decode(session,"utf-8");
			} catch (UnsupportedEncodingException e) {
				// 构建缺省会话
				session = "{'ent_id':0,'user_id':0}";
			}
			response = JSON.parseObject(session,ServiceSession.class);
		}
		return  response;
	}

	protected String buildDownloadFileName(String reportFileName,String fileName,String extName){
		if(StringUtils.isNotBlank(fileName)){
			fileName=decode(fileName);
			if(!fileName.toLowerCase().endsWith(extName)){
				fileName=fileName+extName;
			}
			return fileName;
		}else{
			int pos=reportFileName.indexOf(":");
			if(pos>0){
				reportFileName=reportFileName.substring(pos+1,reportFileName.length());
			}
			pos=reportFileName.toLowerCase().indexOf(".ureport.xml");
			if(pos>0){
				reportFileName=reportFileName.substring(0,pos);
			}
			return "ureport-"+reportFileName+extName;
		}
	}
}
