/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import com.codepoetics.protonpack.AggregatingSpliterator;
import com.codepoetics.protonpack.GroupRunsSpliterator;
import com.codepoetics.protonpack.Indexed;
import com.codepoetics.protonpack.InterleavingSpliterator;
import com.codepoetics.protonpack.ListZippingSpliterator;
import com.codepoetics.protonpack.MergingSpliterator;
import com.codepoetics.protonpack.SkipUntilSpliterator;
import com.codepoetics.protonpack.TakeWhileSpliterator;
import com.codepoetics.protonpack.TriZippingSpliterator;
import com.codepoetics.protonpack.UnfoldSpliterator;
import com.codepoetics.protonpack.WindowedSpliterator;
import com.codepoetics.protonpack.ZippingSpliterator;
import com.codepoetics.protonpack.functions.TriFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class StreamUtils {
    private StreamUtils() {
    }

    protected static Runnable closerFor(Stream ... streams) {
        return StreamUtils.closerFor(Arrays.asList(streams));
    }

    private static <T> Runnable closerFor(List<Stream<T>> streams) {
        return () -> {
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (Stream stream : streams) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            if (!exceptions.isEmpty()) {
                Exception exception = (Exception)exceptions.remove(0);
                for (Exception suppressed : exceptions) {
                    exception.addSuppressed(suppressed);
                }
                throw new RuntimeException(exception);
            }
        };
    }

    public static LongStream indices() {
        return LongStream.iterate(0L, l -> l + 1L);
    }

    public static <T> Stream<Indexed<T>> zipWithIndex(Stream<T> source) {
        return (Stream)StreamUtils.zip(StreamUtils.indices().mapToObj(Long::valueOf), source, Indexed::index).onClose(source::close);
    }

    public static <L, R, O> Stream<O> zip(Stream<L> lefts, Stream<R> rights, BiFunction<L, R, O> combiner) {
        return (Stream)StreamSupport.stream(ZippingSpliterator.zipping(lefts.spliterator(), rights.spliterator(), combiner), false).onClose(StreamUtils.closerFor(lefts, rights));
    }

    public static <L, M, R, O> Stream<O> zip(Stream<L> lefts, Stream<M> middles, Stream<R> rights, TriFunction<L, M, R, O> combiner) {
        return (Stream)StreamSupport.stream(TriZippingSpliterator.zipping(lefts.spliterator(), middles.spliterator(), rights.spliterator(), combiner), false).onClose(StreamUtils.closerFor(lefts, middles, rights));
    }

    public static <T, O> Stream<O> zip(List<Stream<T>> streams, Function<List<T>, O> combiner) {
        List spliterators = streams.stream().map(BaseStream::spliterator).collect(Collectors.toList());
        return (Stream)StreamSupport.stream(ListZippingSpliterator.zipping(spliterators, combiner), false).onClose(StreamUtils.closerFor(streams));
    }

    private static boolean isSized(int characteristics) {
        return (characteristics & 0x40) != 0;
    }

    public static <T> Stream<T> takeWhile(Stream<T> source, Predicate<T> condition) {
        return (Stream)StreamSupport.stream(TakeWhileSpliterator.over(source.spliterator(), condition), false).onClose(source::close);
    }

    public static <T> Stream<T> takeWhileInclusive(Stream<T> source, Predicate<T> condition) {
        return (Stream)StreamSupport.stream(TakeWhileSpliterator.overInclusive(source.spliterator(), condition), false).onClose(source::close);
    }

    public static <T> Stream<T> takeUntil(Stream<T> source, Predicate<T> condition) {
        return StreamUtils.takeWhile(source, condition.negate());
    }

    public static <T> Stream<T> takeUntilInclusive(Stream<T> source, Predicate<T> condition) {
        return StreamUtils.takeWhileInclusive(source, condition.negate());
    }

    public static <T> Stream<T> skipWhile(Stream<T> source, Predicate<T> condition) {
        return (Stream)StreamSupport.stream(SkipUntilSpliterator.over(source.spliterator(), condition.negate()), false).onClose(source::close);
    }

    public static <T> Stream<T> skipWhileInclusive(Stream<T> source, Predicate<T> condition) {
        return (Stream)StreamSupport.stream(SkipUntilSpliterator.overInclusive(source.spliterator(), condition.negate()), false).onClose(source::close);
    }

    public static <T> Stream<T> skipUntil(Stream<T> source, Predicate<T> condition) {
        return (Stream)StreamSupport.stream(SkipUntilSpliterator.over(source.spliterator(), condition), false).onClose(source::close);
    }

    public static <T> Stream<T> skipUntilInclusive(Stream<T> source, Predicate<T> condition) {
        return (Stream)StreamSupport.stream(SkipUntilSpliterator.overInclusive(source.spliterator(), condition), false).onClose(source::close);
    }

    public static <T> Stream<T> unfold(T seed, Function<T, Optional<T>> generator) {
        return StreamSupport.stream(UnfoldSpliterator.over(seed, generator), false);
    }

    public static <T> Stream<List<T>> windowed(Stream<T> source, int windowSize) {
        return StreamUtils.windowed(source, windowSize, 1);
    }

    public static <T> Stream<List<T>> windowed(Stream<T> source, int windowSize, int skip) {
        return StreamUtils.windowed(source, windowSize, skip, false);
    }

    public static <T> Stream<List<T>> windowed(Stream<T> source, int windowSize, int skip, boolean allowLesserSize) {
        return (Stream)StreamSupport.stream(WindowedSpliterator.over(source.spliterator(), windowSize, skip, allowLesserSize), false).onClose(source::close);
    }

    public static <T extends Comparable<T>> Stream<List<T>> groupRuns(Stream<T> source) {
        return StreamUtils.groupRuns(source, Comparable::compareTo);
    }

    public static <T> Stream<List<T>> groupRuns(Stream<T> source, Comparator<T> comparator) {
        return (Stream)StreamSupport.stream(new GroupRunsSpliterator(source.spliterator(), comparator), false).onClose(source::close);
    }

    public static <T> Stream<T> interleave(Function<T[], Integer> selector, Stream<T> ... streams) {
        Spliterator[] spliterators = (Spliterator[])Stream.of(streams).map(s -> s.spliterator()).toArray(Spliterator[]::new);
        return (Stream)StreamSupport.stream(InterleavingSpliterator.interleaving(spliterators, selector), false).onClose(StreamUtils.closerFor(streams));
    }

    public static <T> Stream<T> interleave(Function<T[], Integer> selector, List<Stream<T>> streams) {
        Spliterator[] spliterators = (Spliterator[])streams.stream().map(s -> s.spliterator()).toArray(Spliterator[]::new);
        return (Stream)StreamSupport.stream(InterleavingSpliterator.interleaving(spliterators, selector), false).onClose(StreamUtils.closerFor(streams));
    }

    public static <T, O> Stream<O> merge(Supplier<O> unitSupplier, BiFunction<O, T, O> merger, Stream<T> ... streams) {
        Spliterator[] spliterators = (Spliterator[])Stream.of(streams).map(s -> s.spliterator()).toArray(Spliterator[]::new);
        return (Stream)StreamSupport.stream(MergingSpliterator.merging(spliterators, unitSupplier, merger), false).onClose(StreamUtils.closerFor(streams));
    }

    public static <T> Stream<List<T>> mergeToList(Stream<T> ... streams) {
        return StreamUtils.merge(ArrayList::new, (l, x) -> {
            l.add(x);
            return l;
        }, streams);
    }

    public static <T> Stream<T> reject(Stream<T> source, Predicate<? super T> predicate) {
        return source.filter(predicate.negate());
    }

    public static <T> Stream<List<T>> aggregate(Stream<T> source, BiPredicate<T, T> predicate) {
        return (Stream)StreamSupport.stream(new AggregatingSpliterator<Object>(source.spliterator(), (a, e) -> a.isEmpty() || predicate.test(a.get(a.size() - 1), e)), false).onClose(source::close);
    }

    public static <T> Stream<List<T>> aggregate(Stream<T> source, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Positive size expected, was: " + size);
        }
        return (Stream)StreamSupport.stream(new AggregatingSpliterator<Object>(source.spliterator(), (a, e) -> a.size() < size), false).onClose(source::close);
    }

    public static <T> Stream<List<T>> aggregateOnListCondition(Stream<T> source, BiPredicate<List<T>, T> predicate) {
        return (Stream)StreamSupport.stream(new AggregatingSpliterator(source.spliterator(), predicate), false).onClose(source::close);
    }

    public static <T> Stream<T> streamNullable(T nullable) {
        return StreamUtils.ofSingleNullable(nullable);
    }

    public static <T> Stream<T> ofSingleNullable(T nullable) {
        return null == nullable ? Stream.empty() : Stream.of(nullable);
    }

    public static <T> Stream<T> stream(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> ofNullable(Iterable<T> iterable) {
        return null == iterable ? Stream.empty() : StreamUtils.stream(iterable);
    }

    public static IntStream ofNullable(int[] nullable) {
        return null == nullable ? IntStream.empty() : Arrays.stream(nullable);
    }

    public static LongStream ofNullable(long[] nullable) {
        return null == nullable ? LongStream.empty() : Arrays.stream(nullable);
    }

    public static DoubleStream ofNullable(double[] nullable) {
        return null == nullable ? DoubleStream.empty() : Arrays.stream(nullable);
    }

    public static <T> Stream<T> ofNullable(T[] nullable) {
        return null == nullable ? Stream.empty() : Stream.of(nullable);
    }
}

