/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack.collectors;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class CompletableFutures {
    private CompletableFutures() {
    }

    public static <T> Collector<CompletableFuture<T>, ?, CompletableFuture<List<T>>> toFutureList() {
        return Collectors.collectingAndThen(Collectors.toList(), futures -> {
            AtomicLong resultsRemaining = new AtomicLong(futures.size());
            CompletableFuture result = new CompletableFuture();
            BiFunction<Object, Throwable, Void> handler = (success, failure) -> {
                if (failure == null) {
                    if (resultsRemaining.decrementAndGet() == 0L) {
                        result.complete(futures.stream().map(CompletableFutures::safeGet).collect(Collectors.toList()));
                    }
                } else {
                    result.completeExceptionally((Throwable)failure);
                }
                return null;
            };
            futures.forEach(future -> future.handle(handler));
            return result;
        });
    }

    private static <T> T safeGet(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("safeGet called on failed future: " + e);
        }
    }

    public static <A> Collector<CompletableFuture<A>, ?, CompletableFuture<Optional<A>>> reducing(BinaryOperator<A> reducer) {
        return CompletableFutures.toFuture(Optional::empty, (left, maybeRight) -> maybeRight.isPresent() ? maybeRight.map(right -> reducer.apply(right, left)) : Optional.of(left), (maybeLeft, maybeRight) -> maybeLeft.isPresent() ? maybeLeft.flatMap(left -> maybeRight.map(right -> reducer.apply(left, right))) : maybeRight);
    }

    public static <T, A> Collector<CompletableFuture<T>, ?, CompletableFuture<A>> toFuture(Supplier<A> identitySupplier, BiFunction<T, A, A> reducer, BinaryOperator<A> combiner) {
        return CompletableFutures.toFuture(identitySupplier, reducer, combiner, Function.identity());
    }

    public static <T, A, R> Collector<CompletableFuture<T>, ?, CompletableFuture<R>> toFuture(Supplier<A> identitySupplier, BiFunction<T, A, A> reducer, BinaryOperator<A> combiner, Function<? super A, ? extends R> completer) {
        return Collector.of(() -> FutureReducer.of(identitySupplier.get(), reducer, combiner), FutureReducer::addFuture, FutureReducer::combine, fr -> fr.complete().thenApply(completer), new Collector.Characteristics[0]);
    }

    private static final class CombinedFutureReducer<T, A>
    implements FutureReducer<T, A> {
        private final FutureReducer<T, A> left;
        private final FutureReducer<T, A> right;
        private final BinaryOperator<A> combiner;

        private CombinedFutureReducer(FutureReducer<T, A> left, FutureReducer<T, A> right, BinaryOperator<A> combiner) {
            this.left = left;
            this.right = right;
            this.combiner = combiner;
        }

        @Override
        public CompletableFuture<A> complete() {
            return this.left.complete().thenCombine(this.right.complete(), this.combiner);
        }

        @Override
        public FutureReducer<T, A> addFuture(CompletableFuture<T> future) {
            throw new IllegalStateException("Cannot add futures after combination");
        }

        @Override
        public FutureReducer<T, A> combine(FutureReducer<T, A> other) {
            return new CombinedFutureReducer<T, A>(this, other, this.combiner);
        }
    }

    private static final class SingleFutureReducer<T, A>
    implements FutureReducer<T, A> {
        private AtomicLong futureCount = new AtomicLong(0L);
        private long resultsReceived = 0L;
        private CompletableFuture<A> output = null;
        private Throwable exception = null;
        private A accumulator;
        private final BiFunction<T, A, A> reducer;
        private final BinaryOperator<A> combiner;

        private SingleFutureReducer(A accumulator, BiFunction<T, A, A> reducer, BinaryOperator<A> combiner) {
            this.accumulator = accumulator;
            this.reducer = reducer;
            this.combiner = combiner;
        }

        private synchronized void resultReceived(T result) {
            try {
                this.accumulator = this.reducer.apply(result, this.accumulator);
                ++this.resultsReceived;
                this.completeIfReady();
            }
            catch (Exception e) {
                this.exceptionReceived(e);
            }
        }

        private synchronized void exceptionReceived(Throwable exception) {
            this.exception = exception;
            this.completeIfReady();
        }

        @Override
        public synchronized CompletableFuture<A> complete() {
            this.output = new CompletableFuture();
            this.completeIfReady();
            return this.output;
        }

        private void completeIfReady() {
            if (this.output == null) {
                return;
            }
            if (this.exception != null) {
                this.output.completeExceptionally(this.exception);
            } else if (this.futureCount.get() == this.resultsReceived) {
                this.output.complete(this.accumulator);
            }
        }

        @Override
        public FutureReducer<T, A> addFuture(CompletableFuture<T> future) {
            this.futureCount.incrementAndGet();
            future.handle((result, error) -> {
                if (error != null) {
                    this.exceptionReceived((Throwable)error);
                } else {
                    this.resultReceived(result);
                }
                return null;
            });
            return this;
        }

        @Override
        public FutureReducer<T, A> combine(FutureReducer<T, A> other) {
            return new CombinedFutureReducer(this, other, this.combiner);
        }
    }

    private static interface FutureReducer<T, A> {
        public static <T, A> FutureReducer<T, A> of(A identity, BiFunction<T, A, A> reducer, BinaryOperator<A> combiner) {
            return new SingleFutureReducer(identity, reducer, combiner);
        }

        public CompletableFuture<A> complete();

        public FutureReducer<T, A> addFuture(CompletableFuture<T> var1);

        public FutureReducer<T, A> combine(FutureReducer<T, A> var1);
    }
}

