/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.aop.bean;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.tx.framework.utils.SocketManager;
import com.codingapi.tx.model.Request;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxTransactionLocal {
    private Logger logger = LoggerFactory.getLogger(TxTransactionLocal.class);
    private static final ThreadLocal<TxTransactionLocal> currentLocal = new InheritableThreadLocal<TxTransactionLocal>();
    private String groupId;
    private int maxTimeOut;
    private Map<String, String> cacheModelInfo = new ConcurrentHashMap<String, String>();
    private boolean hasIsGroup = false;
    private boolean hasStart = false;
    private boolean hasConnection = false;
    private String kid;
    private String type;
    private boolean readOnly = false;

    public boolean isHasIsGroup() {
        return this.hasIsGroup;
    }

    public void setHasIsGroup(boolean hasIsGroup) {
        this.hasIsGroup = hasIsGroup;
    }

    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public boolean isHasStart() {
        return this.hasStart;
    }

    public void setHasStart(boolean hasStart) {
        this.hasStart = hasStart;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean isHasConnection() {
        return this.hasConnection;
    }

    public void setHasConnection(boolean hasConnection) {
        this.hasConnection = hasConnection;
    }

    public int getMaxTimeOut() {
        return this.maxTimeOut;
    }

    public void setMaxTimeOut(int maxTimeOut) {
        this.maxTimeOut = maxTimeOut;
    }

    public static TxTransactionLocal current() {
        return currentLocal.get();
    }

    public static void setCurrent(TxTransactionLocal current) {
        currentLocal.set(current);
    }

    public void putLoadBalance(String key, String data) {
        this.cacheModelInfo.put(key, data);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("g", (Object)this.getGroupId());
        jsonObject.put("k", (Object)key);
        jsonObject.put("d", (Object)data);
        this.logger.debug("putLoadBalance--> start ");
        Request request = new Request("plb", jsonObject.toString());
        SocketManager.getInstance().sendMsg(request);
        this.logger.debug("putLoadBalance--> end");
    }

    public String getLoadBalance(String key) {
        String old = this.cacheModelInfo.get(key);
        this.logger.debug("cacheModelInfo->" + old);
        if (old == null) {
            this.logger.debug("getLoadBalance--> start");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("g", (Object)this.getGroupId());
            jsonObject.put("k", (Object)key);
            Request request = new Request("glb", jsonObject.toString());
            String json = SocketManager.getInstance().sendMsg(request);
            this.logger.debug("getLoadBalance--> end ,res - >" + json);
            if (StringUtils.isNotEmpty((String)json)) {
                return json;
            }
        }
        return old;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

