/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.control.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.tx.control.service.IActionService;
import com.codingapi.tx.control.service.TransactionControlService;
import com.codingapi.tx.framework.utils.SocketUtils;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class TransactionControlServiceImpl
implements TransactionControlService {
    private Logger logger = LoggerFactory.getLogger(TransactionControlServiceImpl.class);
    @Autowired
    private ApplicationContext spring;

    @Override
    public void notifyTransactionMsg(ChannelHandlerContext ctx, JSONObject resObj, String json) {
        String action = resObj.getString("a");
        String key = resObj.getString("k");
        IActionService actionService = (IActionService)this.spring.getBean(action, IActionService.class);
        String res = actionService.execute(resObj, json);
        JSONObject data = new JSONObject();
        data.put("k", (Object)key);
        data.put("a", (Object)action);
        JSONObject params = new JSONObject();
        params.put("d", (Object)res);
        data.put("p", (Object)params);
        SocketUtils.sendMsg(ctx, data.toString());
        this.logger.debug("send notify data ->" + data.toString());
    }
}

