/*
 * Decompiled with CFR 0.152.
 */
package com.dahantc.api.sms.json;

import com.dahantc.api.commons.EncryptUtil;
import com.dahantc.api.commons.MySecureProtocolSocketFactory;
import com.dahantc.api.sms.json.SmsData;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;

public class JSONHttpClient {
    private static final Logger LOG = Logger.getLogger(HttpClient.class);
    private static final AtomicBoolean isSwitch = new AtomicBoolean(false);
    private static final String SEND_URL = "/json/sms/Submit";
    private static final String GET_REPORT_URL = "/json/sms/Report";
    private static final String DELIVER_URL = "/json/sms/Deliver";
    private static final String BALANCE_URL = "/json/sms/Balance";
    private static final String BATCH_SEND_URL = "/json/sms/BatchSubmit";
    private static final String DEFAULT_RESPONSE = "{\"response\":{result:\"21\",desc:\"\u6570\u636e\u5305/\u77ed\u4fe1\u5185\u5bb9\u4e3a\u7a7a\"}}";
    private int conTimeOut = 30000;
    private int readTimeOut = 30000;
    private int retryCount = 3;
    private String masterUrl = "";
    private String slaveUrl = "";
    boolean isHttps = false;

    public JSONHttpClient(String masterURL) throws URIException {
        this(masterURL, null);
    }

    public JSONHttpClient(String masterURL, String slaveURL) throws URIException {
        this.masterUrl = this.getSchemaHost(masterURL);
        if (this.masterUrl == null || "".equals(this.masterUrl.trim())) {
            throw new URIException("master URL \u5730\u5740\u5fc5\u987b\u8f93\u5165");
        }
        this.slaveUrl = this.getSchemaHost(slaveURL);
    }

    private String getSchemaHost(String host) {
        if (host != null) {
            if (host.indexOf("http://") != -1) {
                return host;
            }
            if (host.indexOf("https://") != -1) {
                this.isHttps = true;
                return host;
            }
            return "http://" + host;
        }
        return null;
    }

    public String sendSms(String account, String password, String phones, String content, String sign, String subcode, String msgid, String sendtime) {
        JSONObject param = new JSONObject();
        param.put((Object)"account", (Object)account);
        param.put((Object)"password", (Object)EncryptUtil.MD5Encode(password));
        param.put((Object)"msgid", (Object)msgid);
        param.put((Object)"phones", (Object)phones);
        param.put((Object)"content", (Object)content);
        param.put((Object)"sign", (Object)sign);
        param.put((Object)"subcode", (Object)subcode);
        param.put((Object)"sendtime", (Object)sendtime);
        String requestData = param.toString();
        String resp = this.doPost(SEND_URL, requestData, false);
        return resp;
    }

    public String sendBatchSms(String account, String password, List<SmsData> list) {
        String resp = DEFAULT_RESPONSE;
        if (list != null && !list.isEmpty()) {
            JSONObject param = new JSONObject();
            param.put((Object)"account", (Object)account);
            param.put((Object)"password", (Object)EncryptUtil.MD5Encode(password));
            JSONArray array = new JSONArray();
            for (SmsData data : list) {
                JSONObject paramData = new JSONObject();
                paramData.put((Object)"msgid", (Object)data.getMsgid());
                paramData.put((Object)"phones", (Object)data.getPhones());
                paramData.put((Object)"content", (Object)data.getContent());
                paramData.put((Object)"sign", (Object)data.getSign());
                paramData.put((Object)"subcode", (Object)data.getSubcode());
                paramData.put((Object)"sendtime", (Object)data.getSendtime());
                array.add((Object)paramData);
            }
            param.put((Object)"data", (Object)array);
            String requestData = param.toString();
            resp = this.doPost(BATCH_SEND_URL, requestData, false);
        }
        return resp;
    }

    public String sendSms(String account, String password, String phones, String content, String sign, String subcode, String msgid) {
        return this.sendSms(account, password, phones, content, sign, subcode, msgid, "");
    }

    public String sendSms(String account, String password, String phones, String content, String sign, String subcode) {
        return this.sendSms(account, password, phones, content, sign, subcode, "", "");
    }

    public String getReport(String account, String password, String msgid, String phone) {
        JSONObject param = new JSONObject();
        param.put((Object)"account", (Object)account);
        param.put((Object)"password", (Object)EncryptUtil.MD5Encode(password));
        param.put((Object)"msgid", (Object)msgid);
        param.put((Object)"phone", (Object)phone);
        String requestData = param.toString();
        String resp = this.doPost(GET_REPORT_URL, requestData, false);
        return resp;
    }

    public String getReport(String account, String password) {
        return this.getReport(account, password, "", "");
    }

    public String getSms(String account, String password) {
        JSONObject param = new JSONObject();
        param.put((Object)"account", (Object)account);
        param.put((Object)"password", (Object)EncryptUtil.MD5Encode(password));
        String requestData = param.toString();
        String resp = this.doPost(DELIVER_URL, requestData, false);
        return resp;
    }

    public String getBalance(String account, String password) {
        JSONObject param = new JSONObject();
        param.put((Object)"account", (Object)account);
        param.put((Object)"password", (Object)EncryptUtil.MD5Encode(password));
        String requestData = param.toString();
        String resp = this.doPost(BALANCE_URL, requestData, false);
        return resp;
    }

    public String doPost(String url, String data, boolean isReconn) {
        String response = null;
        String requestURL = null;
        try {
            if (isSwitch.get()) {
                if (this.slaveUrl != null && !"".equals(this.slaveUrl.trim())) {
                    requestURL = String.valueOf(this.slaveUrl) + url;
                    response = this.request(requestURL, data);
                }
            } else {
                requestURL = String.valueOf(this.masterUrl) + url;
                response = this.request(requestURL, data);
            }
        }
        catch (ConnectTimeoutException e) {
            this.redirectURL(url, data, isReconn, requestURL, (Exception)((Object)e));
        }
        catch (ConnectException e) {
            this.redirectURL(url, data, isReconn, requestURL, e);
        }
        catch (Exception e) {
            LOG.error((Object)("\u8bbf\u95ee\uff1a" + requestURL + " \u5f02\u5e38:"), (Throwable)e);
            System.err.println(e);
        }
        return response;
    }

    private String redirectURL(String url, String data, boolean isReconn, String lastRequestURL, Exception e) {
        if (!isSwitch.get()) {
            if (!isReconn && this.slaveUrl != null && !"".equals(this.slaveUrl.trim())) {
                isSwitch.set(true);
                LOG.info((Object)("\u8bbf\u95ee\uff1a" + lastRequestURL + " \u5f02\u5e38,\u5730\u5740\u5df2\u7ecf\u5df2\u88ab\u81ea\u52a8\u5207\u6362\u5230\u4ece\u5730\u5740"));
                return this.doPost(url, data, true);
            }
            LOG.error((Object)("\u8bbf\u95ee\uff1a" + lastRequestURL + " \u5f02\u5e38:"), (Throwable)e);
        } else {
            if (!isReconn) {
                isSwitch.set(false);
                LOG.info((Object)("\u8bbf\u95ee\uff1a" + lastRequestURL + " \u5f02\u5e38,\u5730\u5740\u5df2\u7ecf\u5df2\u88ab\u81ea\u52a8\u5207\u6362\u5230\u4e3b\u5730\u5740"));
                return this.doPost(url, data, true);
            }
            LOG.error((Object)("\u8bbf\u95ee\uff1a" + lastRequestURL + " \u5f02\u5e38:"), (Throwable)e);
        }
        return null;
    }

    private String request(String url, String data) throws HttpException, IOException {
        String response = null;
        PostMethod postMethod = null;
        LOG.info((Object)("\u8bbf\u95ee\uff1a" + url + " \u8bf7\u6c42\u6570\u636e:" + data));
        try {
            if (this.isHttps) {
                MySecureProtocolSocketFactory fcty = new MySecureProtocolSocketFactory();
                Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)fcty, 443));
            }
            HttpClient client = new HttpClient(new HttpClientParams(), (HttpConnectionManager)new SimpleHttpConnectionManager(true));
            postMethod = new PostMethod(url);
            postMethod.setRequestHeader("Connection", "close");
            postMethod.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
            byte[] byteData = data.getBytes("utf-8");
            ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(byteData);
            postMethod.setRequestEntity((RequestEntity)requestEntity);
            HttpConnectionManagerParams managerParams = client.getHttpConnectionManager().getParams();
            postMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(this.retryCount, false));
            managerParams.setConnectionTimeout(this.conTimeOut);
            managerParams.setSoTimeout(this.readTimeOut);
            client.executeMethod((HttpMethod)postMethod);
            if (postMethod.getStatusCode() == 200) {
                response = postMethod.getResponseBodyAsString();
                LOG.info((Object)("\u8bbf\u95ee\uff1a" + url + " \u54cd\u5e94\u6570\u636e:" + response));
            } else {
                LOG.error((Object)("\u8bbf\u95ee\uff1a" + url + "\u5f02\u5e38\uff0c\u54cd\u5e94\u72b6\u6001\u7801\uff1a" + postMethod.getStatusCode() + ",\u54cd\u5e94\u5185\u5bb9\uff1a" + postMethod.getResponseBodyAsString()));
            }
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return response;
    }

    public int getConTimeOut() {
        return this.conTimeOut;
    }

    public void setConTimeOut(int conTimeOut) {
        this.conTimeOut = conTimeOut;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(int readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }
}

