/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.openapi.sdk.api.message;

import com.dianping.openapi.sdk.api.message.entity.ClientMessage;
import com.dianping.openapi.sdk.api.message.entity.ServerMessage;
import com.dianping.openapi.sdk.api.message.entity.WsContext;
import com.dianping.openapi.sdk.utils.JsonUtils;
import java.util.Date;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.PongMessage;
import javax.websocket.Session;

@ClientEndpoint
public class WsClientEndPoint {
    private WsContext wsContext;

    public WsClientEndPoint(WsContext wsContext) {
        this.wsContext = wsContext;
    }

    @OnOpen
    public void onOpen(Session session) {
        this.wsContext.getRunLogger().info("ws connect open");
    }

    @OnMessage
    public void onMessage(Session session, String message) {
        try {
            this.wsContext.getRunLogger().info("message[" + message + "]");
            ServerMessage serverMessage = (ServerMessage)JsonUtils.toBean(message, ServerMessage.class);
            if (this.wsContext.getMessageHandler() == null) {
                return;
            }
            boolean handleResult = this.wsContext.getMessageHandler().onMessage(serverMessage);
            if (handleResult) {
                ClientMessage clientMessage = new ClientMessage(serverMessage.getMsg_id(), serverMessage.getType(), "ack");
                session.getAsyncRemote().sendText(JsonUtils.toJson(clientMessage));
            }
        }
        catch (Exception e) {
            this.wsContext.getRunLogger().error("message error.", e);
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        this.wsContext.getRunLogger().info("ws connect close.CloseCode[" + reason.getCloseCode() + "]");
    }

    @OnMessage
    public void onPong(PongMessage pongMessage) {
        this.wsContext.getHeartBeat().setLastPong(new Date());
    }
}

