/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.openapi.sdk.executor;

import com.dianping.openapi.sdk.api.base.API;
import com.dianping.openapi.sdk.enums.HttpMethodEnum;
import com.dianping.openapi.sdk.exception.OpenAPIException;
import com.dianping.openapi.sdk.executor.ExecutionContext;
import com.dianping.openapi.sdk.executor.Executor;
import com.dianping.openapi.sdk.httpclient.OpenAPIHttpClient;
import com.google.common.base.Preconditions;
import java.io.IOException;

public abstract class AbstractExecutor
implements Executor {
    protected OpenAPIHttpClient httpClient;

    protected abstract void prepare(ExecutionContext var1);

    @Override
    public String execute(ExecutionContext context) {
        this.prepare(context);
        return this.doExecute(context);
    }

    protected String doExecute(ExecutionContext context) {
        Preconditions.checkArgument((this.httpClient != null ? 1 : 0) != 0, (Object)"Http client can't be null");
        API api = context.getApi();
        HttpMethodEnum method = api.getHttpMethod();
        String url = context.getUrl();
        try {
            if (HttpMethodEnum.GET.equals((Object)method)) {
                return this.httpClient.doGet(url, context.getParams());
            }
            if (context.getFileItemMap() == null || context.getFileItemMap().size() == 0) {
                return this.httpClient.doPost(url, context.getParams());
            }
            return OpenAPIHttpClient.doPost(url, context.getParams(), context.getFileItemMap());
        }
        catch (IOException e) {
            throw new OpenAPIException(e);
        }
    }
}

