/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.openapi.sdk.executor;

import com.dianping.openapi.sdk.api.base.API;
import com.dianping.openapi.sdk.api.base.request.BaseFileRequest;
import com.dianping.openapi.sdk.api.base.request.BaseSignRequest;
import com.dianping.openapi.sdk.exception.OpenAPIException;
import com.dianping.openapi.sdk.executor.AbstractExecutor;
import com.dianping.openapi.sdk.executor.ExecutionContext;
import com.dianping.openapi.sdk.executor.Executor;
import com.dianping.openapi.sdk.httpclient.OpenAPIHttpClient;
import com.dianping.openapi.sdk.sign.request.GenerateSignRequest;
import com.dianping.openapi.sdk.utils.GenerateSignUtils;
import com.dianping.openapi.sdk.utils.JsonUtils;
import com.dianping.openapi.sdk.utils.TimeUtil;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SignExecutor
extends AbstractExecutor
implements Executor {
    private BaseSignRequest baseSignRequest;

    public SignExecutor(OpenAPIHttpClient httpClient, BaseSignRequest baseSignRequest) {
        this.baseSignRequest = baseSignRequest;
        this.httpClient = httpClient;
    }

    @Override
    protected void prepare(ExecutionContext context) {
        if (this.baseSignRequest == null) {
            throw new OpenAPIException("BaseSignRequest is null");
        }
        API api = context.getApi();
        Map<String, Object> params = api.getAPIParams().toParams();
        HashMap executeParams = Maps.newHashMap();
        for (String key : params.keySet()) {
            Object value = params.get(key);
            String newValue = !(value instanceof String) ? JsonUtils.toJson(value) : value.toString();
            if (value instanceof Date) {
                Date tmp = (Date)value;
                newValue = TimeUtil.formatTime(tmp);
            }
            executeParams.put(key, newValue);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeStr = sdf.format(this.baseSignRequest.getTimestamp());
        executeParams.put("timestamp", timeStr);
        executeParams.put("format", this.baseSignRequest.getFormat());
        executeParams.put("app_key", this.baseSignRequest.getApp_key());
        executeParams.put("v", this.baseSignRequest.getV());
        executeParams.put("sign_method", this.baseSignRequest.getSign_method());
        if (StringUtils.isNotBlank((String)this.baseSignRequest.getSession())) {
            executeParams.put("session", this.baseSignRequest.getSession());
        }
        GenerateSignRequest request = new GenerateSignRequest();
        request.setParams(executeParams);
        request.setAppSecret(this.baseSignRequest.getApp_secret());
        request.setSignMethod(this.baseSignRequest.getSign_method());
        String paramSign = GenerateSignUtils.generateSign(request);
        executeParams.put("sign", paramSign);
        Class<?> requestClass = this.baseSignRequest.getClass();
        if (BaseFileRequest.class.isAssignableFrom(requestClass)) {
            BaseFileRequest fileRequest = (BaseFileRequest)this.baseSignRequest;
            context.setUrl(api.getHttpUrl());
            context.setFileItemMap(fileRequest.toFileItemMap());
        }
        context.setParams(executeParams);
    }
}

