/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.openapi.sdk.httpclient;

import com.dianping.openapi.sdk.api.base.API;
import com.dianping.openapi.sdk.api.base.request.BaseOAuthRequest;
import com.dianping.openapi.sdk.api.base.request.BaseSignRequest;
import com.dianping.openapi.sdk.api.base.response.BaseResponse;
import com.dianping.openapi.sdk.exception.OpenAPIException;
import com.dianping.openapi.sdk.executor.AbstractExecutor;
import com.dianping.openapi.sdk.executor.ExecutionContext;
import com.dianping.openapi.sdk.executor.SignExecutor;
import com.dianping.openapi.sdk.executor.TokenExecutor;
import com.dianping.openapi.sdk.httpclient.OpenAPIClient;
import com.dianping.openapi.sdk.httpclient.OpenAPIHttpClient;
import com.dianping.openapi.sdk.utils.JsonUtils;
import com.google.common.base.Preconditions;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class DefaultOpenAPIClient
implements OpenAPIClient {
    private OpenAPIHttpClient httpClient;
    private String domainUrl = null;
    private final String DEFAULT_DOMAIN = "https://openapi.dianping.com/";

    public DefaultOpenAPIClient() {
        this.httpClient = new OpenAPIHttpClient();
    }

    public DefaultOpenAPIClient(HttpClientBuilder httpClientBuilder) {
        this.httpClient = new OpenAPIHttpClient(httpClientBuilder);
    }

    public DefaultOpenAPIClient(CloseableHttpClient httpClient) {
        this.httpClient = new OpenAPIHttpClient(httpClient);
    }

    public DefaultOpenAPIClient(String domainUrl) {
        if (domainUrl != null && domainUrl.length() > 0) {
            this.domainUrl = domainUrl;
        }
        new DefaultOpenAPIClient();
    }

    public DefaultOpenAPIClient(HttpClientBuilder httpClientBuilder, String domainUrl) {
        if (domainUrl != null && domainUrl.length() > 0) {
            this.domainUrl = domainUrl;
        }
        this.httpClient = new OpenAPIHttpClient(httpClientBuilder);
    }

    public DefaultOpenAPIClient(CloseableHttpClient httpClient, String domainUrl) {
        if (domainUrl != null && domainUrl.length() > 0) {
            this.domainUrl = domainUrl;
        }
        this.httpClient = new OpenAPIHttpClient(httpClient);
    }

    @Override
    public String execute(API api) {
        Preconditions.checkArgument((api != null ? 1 : 0) != 0, (Object)"API can't be null");
        AbstractExecutor executor = null;
        switch (api.getAuthenticateType()) {
            case SIGN: {
                executor = new SignExecutor(this.httpClient, (BaseSignRequest)api.getAPIParams());
                break;
            }
            case OAUTH: {
                executor = new TokenExecutor(this.httpClient, (BaseOAuthRequest)api.getAPIParams());
                break;
            }
            default: {
                throw new OpenAPIException("Unknown Authenticate Type");
            }
        }
        ExecutionContext context = new ExecutionContext();
        context.setApi(api);
        context.setUrl(this.contactDomain(api.getHttpUrl(), this.domainUrl));
        return executor.execute(context);
    }

    @Override
    public <T extends BaseResponse> T invoke(API<T> api) {
        String executeResult = this.execute(api);
        return (T)((BaseResponse)JsonUtils.toBean(executeResult, api.getResponseClass()));
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public void close() {
        this.httpClient.destroyClient();
    }

    private String contactDomain(String methodUrl, String domainUrl) {
        if (domainUrl == null || domainUrl.length() == 0) {
            return methodUrl;
        }
        if (domainUrl.endsWith("/")) {
            return methodUrl.replace("https://openapi.dianping.com/", domainUrl);
        }
        return methodUrl.replace("https://openapi.dianping.com/", domainUrl + "/");
    }
}

