/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.openapi.sdk.httpclient;

import com.dianping.openapi.sdk.api.base.common.FileItem;
import com.dianping.openapi.sdk.enums.HttpMethodEnum;
import com.dianping.openapi.sdk.exception.OpenAPIException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class OpenAPIHttpClient {
    private CloseableHttpClient httpClient;

    public OpenAPIHttpClient() {
        this.httpClient = OpenAPIHttpClient.createSSLClientDefault();
    }

    public OpenAPIHttpClient(HttpClientBuilder httpClientBuilder) {
        this.httpClient = httpClientBuilder.build();
    }

    public OpenAPIHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void destroyClient() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (IOException e) {
            throw new OpenAPIException(e);
        }
    }

    public String doGet(String url, Map<String, String> paramMap) throws IOException {
        if (paramMap != null && !paramMap.isEmpty()) {
            String c = url.contains("?") ? "&" : "?";
            ArrayList<String> httpParams = new ArrayList<String>();
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                httpParams.add(String.format("%s=%s", URLEncoder.encode(entry.getKey()), URLEncoder.encode(entry.getValue())));
            }
            url = url + c + (httpParams == null ? null : StringUtils.join(httpParams.iterator(), (String)"&"));
        }
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("User-Agent", "dianping-openapi-java-sdk");
        return this.execute((HttpRequestBase)httpGet);
    }

    public String doPost(String url, Map<String, String> paramMap) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        if (paramMap != null && !paramMap.isEmpty()) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, "UTF-8"));
        }
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        httpPost.setHeader("User-Agent", "dianping-openapi-java-sdk");
        return this.execute((HttpRequestBase)httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> paramMap, Map<String, FileItem> fileItemMap) throws IOException {
        String boundary = System.currentTimeMillis() + "X";
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            String ctype = "multipart/form-data;boundary=" + boundary + ";charset=UTF-8";
            conn = null;
            URL httpUrl = new URL(url);
            conn = (HttpURLConnection)httpUrl.openConnection();
            conn.setRequestMethod(HttpMethodEnum.POST.getMethod());
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Accept", "application/json;charset=utf-8");
            conn.setRequestProperty("User-Agent", "dianping-openapi-java-sdk");
            conn.setRequestProperty("Content-Type", ctype);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            out = conn.getOutputStream();
            byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes("UTF-8");
            Set<Map.Entry<String, String>> textEntrySet = paramMap.entrySet();
            for (Map.Entry<String, String> entry : textEntrySet) {
                byte[] byArray = OpenAPIHttpClient.getTextEntry(entry.getKey(), entry.getValue(), "UTF-8");
                out.write(entryBoundaryBytes);
                out.write(byArray);
            }
            Set<Map.Entry<String, FileItem>> fileEntrySet = fileItemMap.entrySet();
            for (Map.Entry<String, FileItem> entry : fileEntrySet) {
                FileItem fileItem = entry.getValue();
                byte[] fileBytes = OpenAPIHttpClient.getFileEntry(entry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), "UTF-8");
                out.write(entryBoundaryBytes);
                out.write(fileBytes);
                out.write(fileItem.getContent());
            }
            byte[] byArray = ("\r\n--" + boundary + "--\r\n").getBytes("UTF-8");
            out.write(byArray);
            rsp = OpenAPIHttpClient.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = OpenAPIHttpClient.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return OpenAPIHttpClient.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = OpenAPIHttpClient.getStreamAsString(es, charset);
        if (StringUtils.isEmpty((String)msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = "UTF-8";
        if (!StringUtils.isEmpty((String)ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty((String)pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execute(HttpRequestBase request) throws IOException {
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
            StatusLine status = response.getStatusLine();
            if (status == null || status.getStatusCode() != 200) {
                throw new OpenAPIException("get http response error, http response code:" + String.valueOf(status != null ? Integer.valueOf(status.getStatusCode()) : null));
            }
            HttpEntity httpEntity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            EntityUtils.consume((HttpEntity)httpEntity);
            String string = responseString;
            return string;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public static CloseableHttpClient createSSLClientDefault() {
        try {
            X509TrustManager x509mgr = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{x509mgr}, null);
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return HttpClients.createDefault();
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }
}

