/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.openapi.sdk.utils;

import com.dianping.openapi.sdk.api.message.entity.ConnectConfig;
import com.dianping.openapi.sdk.sign.enums.SignMethodEnum;
import com.dianping.openapi.sdk.sign.request.GenerateSignRequest;
import com.dianping.openapi.sdk.utils.GenerateSignUtils;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class MessageUtils {
    public static String buildHandshakeURL(ConnectConfig connectConfig, String wsAddress) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", connectConfig.getApp().getAppKey());
        params.put("v", "1.0.0");
        params.put("timestamp", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        params.put("type", connectConfig.getType());
        params.put("clientId", connectConfig.getConnectId());
        GenerateSignRequest generateSignRequest = new GenerateSignRequest();
        generateSignRequest.setParams(params);
        generateSignRequest.setAppSecret(connectConfig.getApp().getAppSecret());
        generateSignRequest.setSignMethod(SignMethodEnum.MD5.getType());
        params.put("sign", GenerateSignUtils.generateSign(generateSignRequest));
        StringBuilder connectAddress = new StringBuilder(wsAddress + "?");
        for (Map.Entry param : params.entrySet()) {
            try {
                connectAddress.append(String.format("%s=%s&", param.getKey(), URLEncoder.encode(param.getValue().toString(), "UTF-8")));
            }
            catch (Exception exception) {}
        }
        return connectAddress.substring(0, connectAddress.length() - 1);
    }

    public static String createClientId() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

