/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.core;

import com.doudian.open.api.token.AccessTokenData;
import com.doudian.open.api.token.AccessTokenResponse;
import com.doudian.open.api.token.RefreshTokenResponse;

public class AccessToken {
    private String code;
    private String msg;
    private String subCode;
    private String subMsg;
    private AccessTokenData data;
    private String logId;
    private String appKey;

    public AccessTokenData getData() {
        return this.data;
    }

    public void setData(AccessTokenData data) {
        this.data = data;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public static AccessToken wrapWithAppKey(AccessTokenResponse response, String appKey) {
        AccessToken accessToken = new AccessToken();
        accessToken.data = (AccessTokenData)response.getData();
        accessToken.logId = response.getLogId();
        accessToken.code = response.getCode();
        accessToken.msg = response.getMsg();
        accessToken.subCode = response.getSubCode();
        accessToken.subMsg = response.getSubMsg();
        accessToken.appKey = appKey;
        return accessToken;
    }

    public static AccessToken wrapWithAppKey(RefreshTokenResponse response, String appKey) {
        AccessToken accessToken = new AccessToken();
        accessToken.data = (AccessTokenData)response.getData();
        accessToken.logId = response.getLogId();
        accessToken.code = response.getCode();
        accessToken.msg = response.getMsg();
        accessToken.subCode = response.getSubCode();
        accessToken.subMsg = response.getSubMsg();
        accessToken.appKey = appKey;
        return accessToken;
    }

    public static AccessToken wrapWithAppKey(String accessTokenStr, String refreshTokenStr, String appKey) {
        AccessToken accessToken = new AccessToken();
        AccessTokenData tokenData = new AccessTokenData();
        tokenData.setAccessToken(accessTokenStr);
        tokenData.setRefreshToken(refreshTokenStr);
        accessToken.data = tokenData;
        accessToken.appKey = appKey;
        return accessToken;
    }

    public static AccessToken wrap(String accessTokenStr, String refreshTokenStr) {
        return AccessToken.wrapWithAppKey(accessTokenStr, refreshTokenStr, null);
    }

    public boolean isSuccess() {
        return this.code != null && this.code.equals("10000");
    }

    public String getAccessToken() {
        if (this.data != null) {
            return this.data.getAccessToken();
        }
        return null;
    }

    public Long getExpireIn() {
        if (this.data != null) {
            return this.data.getExpiresIn();
        }
        return null;
    }

    public String getScope() {
        if (this.data != null) {
            return this.data.getScope();
        }
        return null;
    }

    public String getShopId() {
        if (this.data != null) {
            return this.data.getShopId();
        }
        return null;
    }

    public String getShopName() {
        if (this.data != null) {
            return this.data.getShopName();
        }
        return null;
    }

    public String getRefreshToken() {
        if (this.data != null) {
            return this.data.getRefreshToken();
        }
        return null;
    }

    public String getAuthorityId() {
        if (this.data != null) {
            return this.data.getAuthorityId();
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getSubCode() {
        return this.subCode;
    }

    public String getSubMsg() {
        return this.subMsg;
    }

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }
}

