/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.core;

import com.doudian.open.exception.DoudianOpException;
import com.doudian.open.utils.Logger;
import java.lang.reflect.Method;

public class DoudianBaseTokenClientHolder {
    private static final Logger LOG = Logger.getLogger(DoudianBaseTokenClientHolder.class);
    public static final DoudianBaseTokenClientHolder INSTANCE = new DoudianBaseTokenClientHolder();
    private volatile Object tokenService;
    private volatile Method getTokenMethod;
    private volatile Method refreshTokenMethod;
    private volatile boolean init;

    private DoudianBaseTokenClientHolder() {
    }

    public String refreshToken() {
        if (!this.init) {
            this.doInit();
        }
        if (this.tokenService == null) {
            throw new DoudianOpException(DoudianOpException.Code.CURRENT_ENV_NOT_LIGHT_APP);
        }
        try {
            return (String)this.refreshTokenMethod.invoke(this.tokenService, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getToken() {
        if (!this.init) {
            this.doInit();
        }
        if (this.tokenService == null) {
            throw new DoudianOpException(DoudianOpException.Code.CURRENT_ENV_NOT_LIGHT_APP);
        }
        try {
            return (String)this.getTokenMethod.invoke(this.tokenService, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInit() {
        DoudianBaseTokenClientHolder doudianBaseTokenClientHolder = this;
        synchronized (doudianBaseTokenClientHolder) {
            if (!this.init) {
                try {
                    Class<?> clientClass = Class.forName("com.jinritemai.cloud.base.core.service.TokenServiceImpl");
                    Class<?> springBeanGetterServiceClass = Class.forName("com.jinritemai.cloud.base.core.service.SpringBeanGetterService");
                    this.tokenService = springBeanGetterServiceClass.getDeclaredMethod("getTokenServiceBean", new Class[0]).invoke(null, new Object[0]);
                    this.getTokenMethod = clientClass.getDeclaredMethod("getToken", new Class[0]);
                    this.refreshTokenMethod = clientClass.getDeclaredMethod("refreshToken", new Class[0]);
                    this.init = true;
                }
                catch (ClassNotFoundException ignored) {
                    LOG.warning("TokenServiceImpl ClassNotFound", new Object[0]);
                    return;
                }
                catch (Exception e) {
                    LOG.warning("Failed to init TokenServiceImpl! %s", e.getMessage());
                    return;
                }
            }
        }
    }
}

