/*
 * Decompiled with CFR 0.152.
 */
package com.easy.base.component;

import com.easy.base.entity.AbstractEntityBean;
import com.easy.base.util.MessageSourceHelper;
import com.easy.base.util.SpringBeanFactory;
import java.lang.reflect.Field;
import java.util.Map;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

public abstract class BaseServiceImpl<T> {
    private String lastErrMessage = "";
    private String lastWarMessage = "";
    private int lastErrCode = 0;

    public String getLastWarMessage() {
        return this.lastWarMessage;
    }

    public void setLastWarMessage(String lastWarMessage) {
        this.lastWarMessage = lastWarMessage;
    }

    public String getLastErrMessage() {
        return this.lastErrMessage;
    }

    public void setLastErrMessage(String lastErrMessage) {
        this.lastErrMessage = lastErrMessage;
    }

    public void setLastErrMessage(String returncode, String formatmsg, Object ... args) {
        this.setLastErrCode(-1);
        this.setLastErrMessage(MessageSourceHelper.getDefault().getMessage(returncode, formatmsg, null, args));
    }

    public int getLastErrCode() {
        return this.lastErrCode;
    }

    public void setLastErrCode(int lastErrCode) {
        this.lastErrCode = lastErrCode;
    }

    public <X> X getBean(String beanname, Class<X> classzz) {
        return SpringBeanFactory.getBean(beanname, classzz);
    }

    protected void onAssistMap(Update update, Map<String, Object> dataMap, String fieldName) {
        this.onAssistMap(update, dataMap, fieldName, false);
    }

    protected void onAssistMap(Update update, Map<String, Object> dataMap, String fieldName, Boolean isOnInsert) {
        this.onAssistMap(update, dataMap, fieldName, false, isOnInsert);
    }

    protected void onAssistMap(Update update, Map<String, Object> dataMap, String fieldName, boolean isUnset, Boolean isOnInsert) {
        this.onAssistMap(update, dataMap, fieldName, fieldName, isUnset, isOnInsert);
    }

    protected void onAssistMap(Update update, Map<String, Object> dataMap, String getFieldName, String setFieldName, boolean isUnset, Boolean isOnInsert) {
        if (dataMap != null && dataMap.containsKey(getFieldName)) {
            Object fieldValue = dataMap.get(getFieldName);
            if (StringUtils.isEmpty((Object)fieldValue)) {
                if (isUnset) {
                    update.unset(setFieldName);
                }
            } else if (isOnInsert.booleanValue()) {
                update.setOnInsert(setFieldName, dataMap.get(getFieldName));
            } else {
                update.set(setFieldName, dataMap.get(getFieldName));
            }
        }
    }

    protected void onAssist(T bean, Update update, String fieldName) {
        this.onAssist(bean, update, fieldName, false);
    }

    protected void onAssist(T bean, Update update, String fieldName, Boolean isOnInsert) {
        this.onAssist(bean, update, fieldName, false, isOnInsert);
    }

    protected void onAssist(T bean, Update update, String fieldName, boolean isUnset, Boolean isOnInsert) {
        this.onAssist(bean, update, fieldName, fieldName, isUnset, isOnInsert);
    }

    protected void onAssist(T bean, Update update, String getFieldName, String setFieldName, boolean isUnset, Boolean isOnInsert) {
        Field field;
        if (bean instanceof Map) {
            Map objectMap = (Map)bean;
            this.onAssistMap(update, objectMap, getFieldName, setFieldName, isUnset, isOnInsert);
            return;
        }
        int pos = getFieldName.indexOf(".");
        if (pos >= 0) {
            getFieldName = getFieldName.substring(pos + 1);
        }
        if ((field = AbstractEntityBean.fetchDeclaredField(bean.getClass(), getFieldName)) != null) {
            Object value = null;
            try {
                value = field.get(bean);
            }
            catch (IllegalAccessException e) {
                value = null;
            }
            if (StringUtils.isEmpty((Object)value)) {
                if (isUnset) {
                    update.unset(setFieldName);
                }
            } else if (isOnInsert.booleanValue()) {
                update.setOnInsert(setFieldName, value);
            } else {
                update.set(setFieldName, value);
            }
        }
    }
}

