/*
 * Decompiled with CFR 0.152.
 */
package com.easy.base.component;

import com.easy.base.component.BaseCompomentServiceImpl;
import com.easy.base.storage.template.FMybatisTemplate;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.List;
import org.bson.BSONObject;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public abstract class JDBCCompomentServiceImpl<X>
extends BaseCompomentServiceImpl<FMybatisTemplate, X> {
    public JDBCCompomentServiceImpl(String collectionName, String keyfieldName) {
        super(collectionName, keyfieldName);
    }

    @Override
    protected long onCount(FMybatisTemplate template, Query query, String collectionName) {
        return template.count(query, collectionName);
    }

    @Override
    protected <T> List<T> onFind(FMybatisTemplate template, Query query, Class<T> entityClass, String collectionName) {
        return template.select(query, entityClass, collectionName);
    }

    protected abstract DBObject onBeforeRowInsert(Query var1, Update var2);

    protected DBObject onDefaultRowInsert(Query query, Update update) {
        BasicDBObject dbInsert = new BasicDBObject();
        DBObject dbUpdateObject = update.getUpdateObject();
        Object oDataSet = dbUpdateObject.get("$set");
        Object oDataInsert = dbUpdateObject.get("$setOnInsert");
        if (oDataSet != null && oDataSet instanceof DBObject) {
            dbInsert.putAll((BSONObject)((DBObject)oDataSet));
        }
        if (oDataInsert != null && oDataInsert instanceof DBObject) {
            dbInsert.putAll((BSONObject)((DBObject)oDataInsert));
        }
        dbInsert.putAll((BSONObject)query.getQueryObject());
        return dbInsert;
    }

    @Override
    protected void onUpsert(FMybatisTemplate template, Query query, Update update, String collectionName) {
        int n = template.update(query, update, collectionName);
        if (n <= 0) {
            DBObject dbInsert = this.onBeforeRowInsert(query, update);
            template.insert(dbInsert, collectionName);
        }
    }

    @Override
    protected void onRemove(FMybatisTemplate template, Query query, String collectionName) {
        template.delete(query, collectionName);
    }
}

