/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.annotation;

import com.efuture.business.annotation.HessianService;
import com.efuture.business.util.YmlFileUtil;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.remoting.caucho.HessianServiceExporter;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class HessianServiceScanner
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(HessianServiceScanner.class);
    private ApplicationContext applicationContext;
    private String basePackage;

    public HessianServiceScanner() {
    }

    public HessianServiceScanner(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Scanner scanner = new Scanner((BeanDefinitionRegistry)beanFactory);
        scanner.setResourceLoader((ResourceLoader)this.applicationContext);
        this.basePackage = YmlFileUtil.getYmlValue("base.hessian.basePackage");
        logger.info("HessianServiceScanner basePackage:" + this.basePackage);
        if (!StringUtils.isEmpty((Object)this.basePackage)) {
            scanner.scan(StringUtils.tokenizeToStringArray((String)this.basePackage, (String)",; \t\n"));
        }
    }

    private static Object getAnnotationValue(AnnotationMetadata amd, String name) {
        for (String type : amd.getAnnotationTypes()) {
            if (!type.equals(HessianService.class.getName())) continue;
            Map attributes = amd.getAnnotationAttributes(type);
            return attributes.get(name);
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    private final class Scanner
    extends ClassPathBeanDefinitionScanner {
        private BeanNameGenerator exporterBeanNameGenerator;
        private BeanNameGenerator beanNameGenerator;
        private BeanDefinitionRegistry registry;

        public Scanner(BeanDefinitionRegistry registry) {
            super(registry);
            HessianServiceScanner hessianServiceScanner2 = HessianServiceScanner.this;
            hessianServiceScanner2.getClass();
            this.exporterBeanNameGenerator = hessianServiceScanner2.new HessianServiceBeanNameGenerator(null);
            this.beanNameGenerator = new AnnotationBeanNameGenerator();
            this.registry = registry;
        }

        protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
            LinkedHashSet<BeanDefinitionHolder> beanDefinitions = new LinkedHashSet<BeanDefinitionHolder>();
            String[] var6 = basePackages;
            int var5 = basePackages.length;
            for (int var4 = 0; var4 < var5; ++var4) {
                String holder = var6[var4];
                Set candidates = this.findCandidateComponents(holder);
                for (BeanDefinition candidate : candidates) {
                    String originalBeanName = this.beanNameGenerator.generateBeanName(candidate, this.registry);
                    String beanName = this.exporterBeanNameGenerator.generateBeanName(candidate, this.registry);
                    if (!beanName.startsWith("/")) {
                        beanName = "/" + beanName;
                    }
                    BeanDefinitionBuilder hessianBeanDef = BeanDefinitionBuilder.genericBeanDefinition(HessianServiceExporter.class);
                    hessianBeanDef.addPropertyReference("service", originalBeanName);
                    ScannedGenericBeanDefinition bd = (ScannedGenericBeanDefinition)candidate;
                    String[] interfaces = bd.getMetadata().getInterfaceNames();
                    if (interfaces == null || interfaces.length == 0) {
                        throw new RuntimeException("@HessianService bean must implement at least one interface");
                    }
                    Class interf = null;
                    try {
                        Class definitionHolder = (Class)HessianServiceScanner.getAnnotationValue(bd.getMetadata(), "interf");
                        if (definitionHolder != null && definitionHolder != Object.class) {
                            if (!definitionHolder.isInterface()) {
                                throw new RuntimeException("@HessianService interf must be interface class");
                            }
                            interf = definitionHolder;
                        } else {
                            interf = Class.forName(interfaces[0]);
                        }
                    }
                    catch (ClassNotFoundException var17) {
                        continue;
                    }
                    hessianBeanDef.addPropertyValue("serviceInterface", (Object)interf.getName());
                    BeanDefinitionHolder var20 = new BeanDefinitionHolder((BeanDefinition)hessianBeanDef.getBeanDefinition(), beanName);
                    beanDefinitions.add(var20);
                    this.registerBeanDefinition(var20, this.registry);
                }
            }
            if (beanDefinitions.isEmpty()) {
                System.out.println("no service scaned");
            } else {
                for (BeanDefinitionHolder var18 : beanDefinitions) {
                    System.out.println("scanned service:" + var18.getBeanName());
                }
            }
            return beanDefinitions;
        }

        protected void registerDefaultFilters() {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(HessianService.class));
        }
    }

    private final class HessianServiceBeanNameGenerator
    extends AnnotationBeanNameGenerator {
        private HessianServiceBeanNameGenerator(HessianServiceBeanNameGenerator hessianServiceBeanNameGenerator) {
        }

        protected String determineBeanNameFromAnnotation(AnnotatedBeanDefinition annotatedDef) {
            AnnotationMetadata amd = annotatedDef.getMetadata();
            return (String)HessianServiceScanner.getAnnotationValue(amd, "value");
        }
    }
}

