/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.annotation;

import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.config.BaseUtilConfig;
import com.efuture.business.soa.client.SOAClient;
import com.efuture.business.util.YmlFileUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Order(value=-1)
@Component
public class ServiceInjectProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    @Autowired
    LoadBalancerClient loadBalancerClient;
    private ApplicationContext applicationContext;

    public ServiceInjectProcessor() {
    }

    public ServiceInjectProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> targeClass = bean.getClass(); targeClass != null; targeClass = targeClass.getSuperclass()) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(targeClass.getDeclaredFields())));
        }
        for (Field field : fieldList) {
            if (!field.isAnnotationPresent(SoaAnnotation.class)) continue;
            if (!field.getType().isInterface()) {
                throw new BeanCreationException("MyAnnotation field must be declared an interface");
            }
            try {
                this.hanldMyAnnotation(field, bean, field.getType());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void hanldMyAnnotation(Field field, Object bean, Class type) throws IllegalAccessException {
        block3: {
            Map beans = this.applicationContext.getBeansOfType(type);
            field.setAccessible(true);
            String injectVal = field.getAnnotation(SoaAnnotation.class).value();
            String isEnable = YmlFileUtil.getYmlValue("base.hessian.isEnable");
            if (!StringUtils.isEmpty((Object)injectVal) && !"N".equals(isEnable)) {
                long time = YmlFileUtil.getYmllong("base.hessian.timeOut");
                String eureka = BaseUtilConfig.eureka;
                if ("true".equals(eureka)) {
                    field.set(bean, SOAClient.getService(this.loadBalancerClient, type, injectVal, time));
                } else {
                    field.set(bean, SOAClient.getService(type, injectVal, time));
                }
                return;
            }
            Iterator iterator = beans.keySet().iterator();
            if (!iterator.hasNext()) break block3;
            String key = (String)iterator.next();
            field.set(bean, beans.get(key));
        }
    }

    private Object getTheSingletonObject(String beanName) {
        return this.applicationContext.getAutowireCapableBeanFactory().getBean(beanName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

