/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.efuture.business.bean.MybatisData;
import com.efuture.business.config.DataSourceConfig;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.util.db.MultipleDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
public class BaseUtilConfig {
    private static Logger logger = LoggerFactory.getLogger(BaseUtilConfig.class);
    public static String appPaths;
    public static String eureka;
    @Autowired
    private DataSourceConfig data;

    @Bean(name={"multipleDataSource"})
    public MultipleDataSource multipleDataSource() {
        MultipleDataSource multipleDataSource = new MultipleDataSource();
        HashMap<String, DruidDataSource> targetDataSources = new HashMap<String, DruidDataSource>();
        if (null == this.data || null == this.data.getDynamic()) {
            logger.debug("\u591a\u6570\u636e\u6e90\u521d\u59cb\u5316\u542f\u52a8\u4e2d\u672a\u914d\u7f6e\u6570\u636e multipleDataSource");
            multipleDataSource.setTargetDataSources(targetDataSources);
            return multipleDataSource;
        }
        Map<String, DruidDataSource> dynamic = this.data.getDynamic();
        for (String key : dynamic.keySet()) {
            targetDataSources.put(key, dynamic.get(key));
        }
        multipleDataSource.setTargetDataSources(targetDataSources);
        return multipleDataSource;
    }

    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactory(MultipleDataSource multipleDataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource((DataSource)((Object)multipleDataSource));
        if (null == this.data || null == this.data.getMybatis()) {
            logger.debug("\u591a\u6570\u636e\u6e90\u521d\u59cb\u5316\u542f\u52a8\u4e2d\u672a\u914d\u7f6emybatis \u76ee\u5f55 sqlSessionFactory");
            return bean.getObject();
        }
        MybatisData mybatisData = this.data.getMybatis();
        try {
            if (null != mybatisData) {
                bean.setTypeAliasesPackage(mybatisData.getMybatis_bean_package());
                bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(mybatisData.getMapper_xml_package()));
            }
        }
        catch (Exception e) {
            System.out.print(e.getMessage());
        }
        return bean.getObject();
    }

    @Bean(name={"transactionManager"})
    public DataSourceTransactionManager dataSourceTransactionManager(MultipleDataSource multipleDataSource) {
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
        dataSourceTransactionManager.setDataSource((DataSource)((Object)multipleDataSource));
        return dataSourceTransactionManager;
    }

    @Bean(name={"sqlSessionTemplate"})
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean(name={"jdbcTemplate"})
    @DependsOn(value={"multipleDataSource"})
    public JdbcTemplate jdbcTemplate(MultipleDataSource multipleDataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.setDataSource((DataSource)((Object)multipleDataSource));
        return jdbcTemplate;
    }

    @Bean
    public DataSourceTransactionManager transactionManager(MultipleDataSource dataSource) throws Exception {
        return new DataSourceTransactionManager((DataSource)((Object)dataSource));
    }

    @Bean
    public ServletRegistrationBean druidServlet() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{"/druid/*"});
        servletRegistrationBean.addInitParameter("allow", "");
        servletRegistrationBean.addInitParameter("deny", "192.168.1.73");
        servletRegistrationBean.addInitParameter("loginUsername", "admin");
        servletRegistrationBean.addInitParameter("loginPassword", "123456");
        servletRegistrationBean.addInitParameter("resetEnable", "false");
        return servletRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new WebStatFilter());
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid/*");
        return filterRegistrationBean;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer properties() {
        PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
        YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
        yaml.setResources(new Resource[]{new ClassPathResource("application.yml")});
        appPaths = yaml.getObject().getProperty("filePath");
        eureka = yaml.getObject().getProperty("eureka.client.enabled");
        logger.info("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6url:{}", (Object)appPaths);
        File file = new File(appPaths);
        File[] tempArray = file.listFiles();
        ArrayList<FileSystemResource> path = new ArrayList<FileSystemResource>();
        for (int i = 0; i < tempArray.length; ++i) {
            String temp;
            if ("application-soahost.yml".equals(tempArray[i].getName()) || !tempArray[i].isFile() || !"yml".equals(temp = BaseUtilConfig.getExtName(tempArray[i]))) continue;
            FileSystemResource fileSystemResource = new FileSystemResource(String.valueOf(tempArray[i]));
            path.add(fileSystemResource);
        }
        FileSystemResource[] fileSystemResources = new FileSystemResource[path.size()];
        for (int i = 0; i < path.size(); ++i) {
            fileSystemResources[i] = (FileSystemResource)path.get(i);
        }
        yaml.setResources((Resource[])fileSystemResources);
        GlobalInfo.process = BaseUtilConfig.getProperties(appPaths);
        configurer.setProperties(yaml.getObject());
        return configurer;
    }

    public static Properties getProperties(String path) {
        try {
            FileInputStream istr = new FileInputStream(path + "/process.properties");
            Properties p = new Properties();
            p.load(istr);
            ((InputStream)istr).close();
            return p;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getExtName(File file) {
        String name = file.getName();
        return name.lastIndexOf(".") == -1 ? "" : name.substring(name.lastIndexOf(".") + 1);
    }
}

