/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.config;

import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.util.RedisSerialize;
import com.efuture.business.util.RedisUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class RedisConfig {
    @Autowired
    private GlobalInfo globalInfo;

    @Bean
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxIdle(GlobalInfo.redismaxidle);
        jedisPoolConfig.setMaxTotal(GlobalInfo.redisMaxTotal);
        jedisPoolConfig.setMaxWaitMillis((long)GlobalInfo.redismaxWaitMillis);
        jedisPoolConfig.setMinEvictableIdleTimeMillis((long)GlobalInfo.redisminEvictableIdleTimeMillis);
        jedisPoolConfig.setNumTestsPerEvictionRun(GlobalInfo.redisnumTestsPerEvictionRun);
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis((long)GlobalInfo.redistimeBetweenEvictionRunsMillis);
        jedisPoolConfig.setTestOnBorrow(GlobalInfo.redistestOnBorrow);
        jedisPoolConfig.setTestWhileIdle(GlobalInfo.testWhileIdle);
        jedisPoolConfig.setTestOnReturn(GlobalInfo.redistestOnReturn);
        return jedisPoolConfig;
    }

    @Bean
    public JedisConnectionFactory JedisConnectionFactory(JedisPoolConfig jedisPoolConfig) {
        JedisConnectionFactory JedisConnectionFactory2 = new JedisConnectionFactory(jedisPoolConfig);
        JedisConnectionFactory2.setPoolConfig(jedisPoolConfig);
        JedisConnectionFactory2.setHostName(GlobalInfo.redisip);
        JedisConnectionFactory2.setPort(GlobalInfo.port);
        JedisConnectionFactory2.setDatabase(GlobalInfo.database < 0 ? 0 : GlobalInfo.database);
        JedisConnectionFactory2.setPassword(GlobalInfo.pwd);
        JedisConnectionFactory2.setTimeout(GlobalInfo.redispooltimeout);
        return JedisConnectionFactory2;
    }

    @Bean
    public JedisConnectionFactory JedisConnectionFactory(JedisPoolConfig jedisPoolConfig, RedisClusterConfiguration redisClusterConfiguration) {
        JedisConnectionFactory JedisConnectionFactory2 = new JedisConnectionFactory(redisClusterConfiguration, jedisPoolConfig);
        return JedisConnectionFactory2;
    }

    @Bean
    public RedisTemplate<String, Object> functionDomainRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        this.initDomainRedisTemplate((RedisTemplate<String, Object>)redisTemplate, redisConnectionFactory);
        return redisTemplate;
    }

    private void initDomainRedisTemplate(RedisTemplate<String, Object> redisTemplate, RedisConnectionFactory factory) {
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashValueSerializer((RedisSerializer)new RedisSerialize());
        redisTemplate.setValueSerializer((RedisSerializer)new RedisSerialize());
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setEnableTransactionSupport(true);
        redisTemplate.setConnectionFactory(factory);
    }

    @Bean(name={"redisUtil"})
    public RedisUtil redisUtil(RedisTemplate<String, Object> redisTemplate) {
        RedisUtil redisUtil = new RedisUtil();
        redisUtil.setRedisTemplate(redisTemplate);
        return redisUtil;
    }
}

