/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit;

import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.ManipulateStr;
import com.efuture.business.javaPos.struct.AnalyzeBarcodeDef;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Coupon;
import com.efuture.business.javaPos.struct.CouponGain;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.DzcGoodsDetail;
import com.efuture.business.javaPos.struct.ExceptPay;
import com.efuture.business.javaPos.struct.Gift;
import com.efuture.business.javaPos.struct.GiftsGroup;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.OperUser;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.PayMode;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentForPos;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.posManager.ElecScaleCodeRule;
import com.efuture.business.javaPos.struct.posManager.response.QueryAeonCouponOut;
import com.efuture.business.javaPos.struct.promotionCentre.SellCoupon;
import com.efuture.business.javaPos.struct.promotionCentre.SellDetail;
import com.efuture.business.javaPos.struct.promotionCentre.SellExceptPay;
import com.efuture.business.javaPos.struct.promotionCentre.SellPayment;
import com.efuture.business.javaPos.struct.promotionCentre.request.RemovePayIn;
import com.efuture.business.javaPos.struct.promotionCentre.response.CalSaleReturnOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.CalcOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.CalcsingleOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.ConfirmAffirmreturnOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.CouponGainCalcOut;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.UUIDUtils;
import com.product.model.ServiceSession;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PosLogicCompoment {
    private static final Logger LOGGER = LoggerFactory.getLogger(PosLogicCompoment.class);

    public DzcGoodsDetail analyzeBarcode(String inputBarcode, List<ElecScaleCodeRule> elecCodeRules, int mmdddays, int ddhhdays, String mode) {
        String code = null;
        double price = 0.0;
        double quantity = 0.0;
        String exp = null;
        DzcGoodsDetail dzcDetail = new DzcGoodsDetail();
        dzcDetail.setRetCode(0);
        try {
            int j;
            int i;
            ElecScaleCodeRule rule = null;
            for (i = 0; i < elecCodeRules.size(); ++i) {
                rule = elecCodeRules.get(i);
                int location = rule.getIdentifierPos();
                int length = inputBarcode.length();
                if (location > 0 && rule.getCodePos() > 0 && rule.getAmountPos() >= 0 && rule.getNumberPos() >= 0 && rule.getValidDatePos() >= 0 && location <= length && rule.getBarCodeLen() <= length && location + rule.getIdentifierLen() <= length && rule.getBarCodeLen() <= length && location + rule.getIdentifierLen() <= length && rule.getAmountPos() + rule.getAmountLen() <= length && rule.getCodePos() + rule.getCodeLen() <= length && rule.getNumberPos() + rule.getNumberLen() <= length && rule.getValidDatePos() + rule.getValidDateLen() <= length && inputBarcode.trim().length() == rule.getBarCodeLen() && inputBarcode.substring(location - 1, location + rule.getIdentifierLen() - 1).trim().equals(rule.getIdentifier().trim())) break;
            }
            if (i >= elecCodeRules.size()) {
                return dzcDetail;
            }
            code = inputBarcode.substring(rule.getCodePos() - 1, rule.getCodePos() + rule.getCodeLen() - 1);
            if (rule.getAmountLen() > 0) {
                j = rule.getAmountLen() - rule.getAmtDecimalPlace();
                StringBuffer sb = new StringBuffer();
                sb.append(inputBarcode.substring(rule.getAmountPos() - 1, rule.getAmountPos() + j - 1));
                sb.append(".");
                sb.append(inputBarcode.substring(rule.getAmountPos() + j - 1, rule.getAmountPos() + rule.getAmountLen() - 1));
                price = ManipulatePrecision.doubleConvert(Double.parseDouble(sb.toString()), 2, 1);
                if ("1".equals(mode)) {
                    if ("29".equals(rule.getIdentifier()) && code.length() == 4) {
                        code = "99" + code;
                    }
                    code = CastUtil.castAeonGoodsCode(code);
                } else if ("2".equals(mode)) {
                    code = CastUtil.castCNAeonGoodsCode(code);
                }
            } else {
                price = 0.0;
            }
            if (rule.getNumberLen() > 0) {
                j = rule.getNumberLen() - rule.getNumDecimalPlace();
                StringBuffer sb = new StringBuffer();
                sb.append(inputBarcode.substring(rule.getNumberPos() - 1, rule.getNumberPos() + j - 1));
                sb.append(".");
                sb.append(inputBarcode.substring(rule.getNumberPos() + j - 1, rule.getNumberPos() + rule.getNumberLen() - 1));
                quantity = ManipulatePrecision.doubleConvert(Double.parseDouble(sb.toString()), 4, 1);
            } else {
                quantity = 0.0;
            }
            if (price <= 0.0 && quantity <= 0.0) {
                return dzcDetail;
            }
            exp = rule.getValidDateLen() > 0 ? inputBarcode.substring(rule.getValidDatePos(), rule.getValidDatePos() + rule.getValidDateLen() - 1) : "";
            dzcDetail.setRetCode(1);
            if (exp.length() > 0) {
                dzcDetail.setRetCode(2);
                if ("1".equals(rule.getValidIdentifier())) {
                    LocalDate today = LocalDate.now();
                    LocalDate todayforCalc = today.plusDays(mmdddays);
                    todayforCalc = todayforCalc.minusDays(1L);
                    LocalDate expdate = LocalDate.of(today.getYear(), Integer.parseInt(exp.substring(0, 2)), Integer.parseInt(exp.substring(2)));
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    if (todayforCalc.getYear() != today.getYear()) {
                        if (!expdate.isBefore(today) || !todayforCalc.isBefore(expdate)) {
                            dzcDetail.setRetCode(1);
                            exp = expdate.format(df).toString();
                        }
                    } else if (!expdate.isBefore(today) && !todayforCalc.isBefore(expdate)) {
                        dzcDetail.setRetCode(1);
                        exp = expdate.format(df).toString();
                    }
                } else if ("2".equals(rule.getValidIdentifier())) {
                    LocalDateTime nowTime = LocalDateTime.now();
                    LocalDateTime nowTimeForCalc = LocalDateTime.of(nowTime.getYear(), nowTime.getMonth(), nowTime.getDayOfMonth(), nowTime.getHour(), 59);
                    nowTimeForCalc = nowTimeForCalc.plusDays(ddhhdays);
                    nowTimeForCalc = nowTimeForCalc.minusDays(1L);
                    LocalDateTime expTime = LocalDateTime.of(nowTime.getYear(), nowTime.getMonth(), Integer.parseInt(exp.substring(0, 2)), Integer.parseInt(exp.substring(2)), 59);
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:MM");
                    if (nowTimeForCalc.getMonth() != nowTime.getMonth()) {
                        if (!expTime.isBefore(nowTime) || !nowTimeForCalc.isBefore(expTime)) {
                            dzcDetail.setRetCode(1);
                            exp = expTime.format(df).toString();
                        }
                    } else if (!expTime.isBefore(nowTime) && !nowTimeForCalc.isBefore(expTime)) {
                        dzcDetail.setRetCode(1);
                        exp = expTime.format(df).toString();
                    }
                }
            }
            dzcDetail.setInputBarcode(inputBarcode);
            dzcDetail.setCode(code);
            dzcDetail.setDzcmsl(quantity);
            dzcDetail.setDzcmjg(price);
            dzcDetail.setExpTime(exp);
            return dzcDetail;
        }
        catch (Exception e) {
            e.printStackTrace();
            return dzcDetail;
        }
    }

    public CacheModel AddStampCodeGood(CacheModel cacheModel, String stampCode) {
        Goods good = new Goods();
        good.setFlowId(cacheModel.getGoodsList().size() + 1);
        good.setGoodsCode(stampCode);
        good.setBarNo(stampCode);
        good.setFlag("9");
        good.setAssistantId("");
        good.setGoodsName("\u5370\u82b1\u7801");
        good.setEnFname("StampCode");
        good.setSaleUnit("");
        good.setOrgCode(cacheModel.getOrder().getShopCode());
        good.setQty(1.0);
        good.setGoodsType("");
        good.setCategoryCode("");
        good.setListPrice(0.0);
        good.setSaleAmount(0.0);
        good.setSaleValue(0.0);
        good.setGuid(UUIDUtils.buildGuid());
        good.setPopDetailsInfo(new ArrayList<PopDetail>());
        good.setPrcutMode("0");
        cacheModel.getGoodsList().add(good);
        cacheModel.getOrder().setQty(cacheModel.getOrder().getQty() + 1);
        return cacheModel;
    }

    public Goods CalcGoodsAmount(GoodsInfo sg, String assistantId, boolean isdzcm, double dzcmsl, double dzcmjg, String eleMode, String originalBarNo, double qty) {
        double quantity = qty;
        double price = 0.0;
        double allprice = 0.0;
        double dzcprice = 0.0;
        double dzcmjgzk = 0.0;
        if (sg.getEscaleFlag() == 1 && !isdzcm) {
            return null;
        }
        if (isdzcm) {
            if (sg.getEWCCodeNum() > 0.0 && sg.getEWCCodeAmount() <= 0.0) {
                double jg;
                if (sg.getPartsNum() <= 0.0) {
                    sg.setPartsNum(1.0);
                }
                quantity = ManipulatePrecision.doubleConvert(dzcmsl / sg.getPartsNum(), 4, 1);
                price = ManipulatePrecision.doubleConvert(sg.getSalePrice(), 2, 1);
                allprice = quantity * price;
                dzcprice = 1.0;
                allprice = ManipulatePrecision.doubleConvert(allprice, 3, 0);
                if (ManipulatePrecision.doubleCompare(allprice = ManipulatePrecision.doubleConvert(allprice, 2, 1), jg = ManipulatePrecision.getDetailOverFlow(allprice, sg.getPrcutMode()), 2) != 0) {
                    dzcmjgzk = ManipulatePrecision.sub(allprice, jg);
                }
            } else if (sg.getEWCCodeNum() <= 0.0 && sg.getEWCCodeAmount() > 0.0) {
                if (sg.getSalePrice() <= 0.0 || "1".equals(eleMode) || "2".equals(eleMode)) {
                    quantity = 1.0;
                    allprice = price = dzcmjg;
                    sg.setSalePrice(price);
                    dzcprice = 1.0;
                } else {
                    quantity = ManipulatePrecision.doubleConvert(dzcmjg / sg.getSalePrice(), 4, 1);
                    price = sg.getSalePrice();
                    allprice = dzcmjg;
                    dzcprice = 2.0;
                }
            } else if (sg.getEWCCodeNum() > 0.0 && sg.getEWCCodeAmount() > 0.0) {
                if (sg.getPartsNum() <= 0.0) {
                    sg.setPartsNum(1.0);
                }
                quantity = ManipulatePrecision.doubleConvert(dzcmsl / sg.getPartsNum(), 4, 1);
                allprice = dzcmjg;
                LOGGER.info("salePrice=" + sg.getSalePrice() + "quantity=" + quantity + "allprice=" + allprice);
                if (sg.getSalePrice() > 0.0 && ManipulatePrecision.doubleCompare(sg.getSalePrice() * quantity, allprice, 2) > 0) {
                    if (ManipulatePrecision.doubleCompare(sg.getSalePrice() * quantity, allprice, 2) != 0) {
                        allprice = ManipulatePrecision.doubleConvert(sg.getSalePrice() * quantity, 2, 1);
                        dzcmjgzk = ManipulatePrecision.sub(allprice, dzcmjg);
                        dzcmjgzk = ManipulatePrecision.doubleConvert(dzcmjgzk, 2, 1);
                    }
                } else {
                    sg.setSalePrice(ManipulatePrecision.doubleConvert(dzcmjg / (dzcmsl / sg.getPartsNum()), 2, 1));
                }
                price = sg.getSalePrice();
            }
        }
        if (!this.checkFindGoodsAllowSale(sg, quantity, isdzcm, dzcmsl, dzcmjg)) {
            return null;
        }
        Goods saleGoodsDef = this.goodsInfo2Goods(sg, assistantId, quantity, price, allprice, isdzcm, dzcmjgzk, dzcmsl, dzcmjg, originalBarNo);
        saleGoodsDef = this.calcGoodsAmount(saleGoodsDef);
        return saleGoodsDef;
    }

    public boolean checkSyjRange(CacheModel cacheModel, GoodsInfo goodsInfo) {
        String[] codes;
        if (null == cacheModel.getSyjgroup()) {
            return true;
        }
        if (StringUtils.isBlank((String)cacheModel.getSyjgroup().getSourceitem())) {
            return true;
        }
        if ("ALL".equals(cacheModel.getSyjgroup().getSourceitem())) {
            return true;
        }
        for (String code : codes = cacheModel.getSyjgroup().getSourceitem().split(",")) {
            if ("1".equals(cacheModel.getSyjgroup().getSourcetype())) {
                if (!goodsInfo.getCategoryCode().equals(code)) continue;
                return true;
            }
            if ("2".equals(cacheModel.getSyjgroup().getSourcetype())) {
                if (!goodsInfo.getOrgCode().equals(code)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    protected Goods calcGoodsAmount(Goods saleGoodsDef) {
        double dzcmjgzk = 0.0;
        if (saleGoodsDef.getDzcDiscountValue() > 0.0) {
            dzcmjgzk = saleGoodsDef.getDzcDiscountValue();
        }
        this.clearAllDicountonGoods(saleGoodsDef);
        if (saleGoodsDef.getDzcDiscountValue() > 0.0) {
            saleGoodsDef.setDzcDiscountValue(dzcmjgzk);
        }
        saleGoodsDef.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(saleGoodsDef));
        saleGoodsDef.setTotalDiscountValue(PosLogicCompoment.getZZK(saleGoodsDef));
        saleGoodsDef.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(saleGoodsDef.getTotalDiscountValue() - saleGoodsDef.getNoDisAmountValue()));
        saleGoodsDef.setSaleAmount(saleGoodsDef.getSaleValue() - saleGoodsDef.getTotalDiscountValue());
        saleGoodsDef.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(saleGoodsDef.getTotalDiscountValue() - saleGoodsDef.getNoDisAmountValue()));
        return saleGoodsDef;
    }

    public static CacheModel CalcGoodsRebateByAmount(CacheModel cacheModel, int flow_id, String accreditNo, double discountAmount) {
        return PosLogicCompoment.CalcGoodsRebateByAmount(cacheModel, flow_id, accreditNo, discountAmount, 0, true, false);
    }

    protected static CacheModel CalcGoodsRebateByAmount(CacheModel cacheModel, int flow_id, String accreditNo, double discountAmount, int mode, boolean isZero, boolean isCheck) {
        if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6298\u6263");
            return cacheModel;
        }
        if (discountAmount < 0.0) {
            return cacheModel;
        }
        if (ManipulatePrecision.doubleCompare(discountAmount, 0.0, 2) < 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u6298\u8ba9\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0");
            return cacheModel;
        }
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        String flag = sg.getFlag();
        if (mode == 1) {
            discountAmount = ManipulatePrecision.doubleConvert(sg.getSaleAmount() + sg.getTempZrDiscount() - discountAmount);
        }
        if (flag.equals("0") || sg.getMinDiscount() * 100.0 >= 100.0 || !StringUtils.isBlank((String)sg.getSGoodsSno())) {
            cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4e0d\u5141\u8bb8\u6253\u6298");
            cacheModel.setCalcResult(-1);
            return cacheModel;
        }
        OperUser curGrant = cacheModel.getCurGrant();
        if (!isCheck && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
            curGrant = cacheModel.getCurTempGrant();
        }
        if (isCheck && !PosLogicCompoment.checkGoodsGrantRange(sg, curGrant.getGrantgz(), 1)) {
            cacheModel.setErrCode("1000");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u65e0\u6cd5\u5bf9\u8be5\u5546\u54c1\u8fdb\u884c\u6253\u6298");
            return cacheModel;
        }
        sg = cacheModel.getGoodsList().get(flow_id - 1);
        Goods oldsg = (Goods)sg.clone();
        if (ManipulatePrecision.doubleCompare(discountAmount, 0.0, 2) == 0) {
            sg.setTempZrDiscount(0.0);
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            PosLogicCompoment.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        if (isCheck && curGrant.getPrivdpzkl() <= 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("1000");
            cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
            return cacheModel;
        }
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            double MaxDiscountRate = 1.0 - sg.getMinDiscount();
            double MaxDiscountAmount = ManipulatePrecision.getDetailOverFlow(MaxDiscountRate * sg.getSaleValue(), precisionMode);
            double tempZrAmount = MaxDiscountAmount - PosLogicCompoment.getZZK(sg) + sg.getTempZrDiscount() + sg.getTempZzkDiscount() + sg.getTempZzrDiscount();
            tempZrAmount = ManipulatePrecision.getDetailOverFlow(tempZrAmount, precisionMode);
            if (tempZrAmount < 0.0) {
                tempZrAmount = 0.0;
            }
            if (discountAmount > tempZrAmount) {
                if (!isZero) {
                    discountAmount = tempZrAmount;
                    cacheModel.setErrMsg("\u6298\u8ba9\u91d1\u989d\u8d85\u51fa\u8be5\u5546\u54c1\u6700\u5927\u6298\u6263" + tempZrAmount);
                    cacheModel.setCalcResult(-1);
                    cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                    return cacheModel;
                }
                discountAmount = tempZrAmount;
            }
            if (isCheck) {
                double GrantDiscountRate = ManipulatePrecision.doubleConvert(curGrant.getPrivdpzkl() / 100.0, 2, 1);
                if (MaxDiscountRate > GrantDiscountRate) {
                    MaxDiscountRate = GrantDiscountRate;
                }
                MaxDiscountAmount = ManipulatePrecision.getDetailOverFlow(MaxDiscountRate * sg.getSaleValue(), precisionMode);
                tempZrAmount = MaxDiscountAmount - PosLogicCompoment.getZZK(sg) + sg.getTempZrDiscount() + sg.getTempZzkDiscount() + sg.getTempZzrDiscount();
                if (discountAmount > (tempZrAmount = ManipulatePrecision.getDetailOverFlow(tempZrAmount, precisionMode))) {
                    discountAmount = tempZrAmount;
                    cacheModel.setErrCode("1000");
                    cacheModel.setErrMsg("\u6298\u8ba9\u91d1\u989d\u8d85\u51fa\u8be5\u4eba\u5458\u6700\u5927\u6298\u6263\u7387" + curGrant.getPrivdpzkl());
                    cacheModel.setCalcResult(-1);
                    cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                    return cacheModel;
                }
            }
            sg.setTempZrDiscount(discountAmount);
            sg.setTempZzrDiscount(0.0);
            sg.setTempZzkDiscount(0.0);
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            if (PosLogicCompoment.getZZK(sg) > MaxDiscountAmount) {
                sg.setTempZrDiscount(sg.getTempZrDiscount() - PosLogicCompoment.getZZK(sg) + MaxDiscountAmount);
                sg.setTempZrDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZrDiscount(), precisionMode));
            }
            if (sg.getTempZrDiscount() < 0.0) {
                sg.setTempZrDiscount(0.0);
            }
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            if (isCheck) {
                cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
            }
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            if (cacheModel.getOrder().getTempZzk() < 100.0) {
                cacheModel = PosLogicCompoment.CalcOrderRebateByRate(cacheModel, accreditNo, 100.0);
            }
            if (cacheModel.getOrder().getTempZzr() > 0.0) {
                cacheModel = PosLogicCompoment.CalcOrderRebateByAmount(cacheModel, accreditNo, 0.0);
            }
            cacheModel.setCalcResult(0);
            cacheModel.setErrMsg("");
            PosLogicCompoment.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    public static CacheModel CalcGoodsRebateByRate(CacheModel cacheModel, int flow_id, String accreditNo, double discountRate) {
        return PosLogicCompoment.CalcGoodsRebateByRate(cacheModel, flow_id, accreditNo, discountRate, false);
    }

    protected static CacheModel CalcGoodsRebateByRate(CacheModel cacheModel, int flow_id, String accreditNo, double discountRate, boolean isCheck) {
        if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6298\u6263");
            return cacheModel;
        }
        if (ManipulatePrecision.doubleCompare(discountRate, 0.0, 2) < 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u6298\u6263\u7387\u8d85\u8fc7100%\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            return cacheModel;
        }
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        String flag = sg.getFlag();
        if (flag.equals("0") || sg.getMinDiscount() * 100.0 >= 100.0 || StringUtils.isNotBlank((String)sg.getSGoodsSno())) {
            cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4e0d\u5141\u8bb8\u6253\u6298");
            cacheModel.setCalcResult(-1);
            return cacheModel;
        }
        OperUser curGrant = cacheModel.getCurGrant();
        if (!isCheck && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
            curGrant = cacheModel.getCurTempGrant();
        }
        if (isCheck && !PosLogicCompoment.checkGoodsGrantRange(sg, curGrant.getGrantgz(), 1)) {
            cacheModel.setErrCode("1000");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u8303\u56f4\u65e0\u6cd5\u5bf9\u8be5\u5546\u54c1\u8fdb\u884c\u6253\u6298");
            return cacheModel;
        }
        sg = cacheModel.getGoodsList().get(flow_id - 1);
        Goods oldsg = sg.deepClone();
        double tempZr = oldsg.getTempZrDiscount();
        if (ManipulatePrecision.doubleCompare(discountRate, 100.0, 2) >= 0) {
            sg.setTempZkDiscount(0.0);
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            PosLogicCompoment.calcOrderAmount(cacheModel);
            sg.setTempZkl(100.0);
            return cacheModel;
        }
        if (isCheck && curGrant.getPrivdpzkl() <= 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("1000");
            cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
            return cacheModel;
        }
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            sg.setTempZrDiscount(0.0);
            sg.setTempZkDiscount(0.0);
            sg.setTempZzkDiscount(0.0);
            sg.setTempZzrDiscount(0.0);
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * (sg.getSaleValue() - PosLogicCompoment.getZZK(sg)), precisionMode));
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            if (PosLogicCompoment.getZZK(sg) > ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * (1.0 - sg.getMinDiscount()), precisionMode)) {
                sg.setTempZkDiscount(sg.getTempZkDiscount() - PosLogicCompoment.getZZK(sg) + ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * (1.0 - sg.getMinDiscount()), precisionMode));
                sg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZkDiscount(), precisionMode));
            }
            if (sg.getTempZkDiscount() < 0.0) {
                sg.setTempZkDiscount(0.0);
            }
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            double MaxDiscountRate = sg.getTempZkDiscount() / (sg.getSaleValue() - PosLogicCompoment.getZZK(sg) + sg.getTempZkDiscount());
            MaxDiscountRate = ManipulatePrecision.doubleConvert((1.0 - MaxDiscountRate) * 100.0, 2, 1);
            if (ManipulatePrecision.doubleCompare(MaxDiscountRate, discountRate, 2) > 0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8d85\u51fa\u5f53\u524d\u6700\u5927\u5546\u54c1\u6298\u6263\u7387" + MaxDiscountRate + ",\u4e0d\u5141\u8bb8\u6298\u6263");
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            if (isCheck && ManipulatePrecision.doubleCompare(curGrant.getPrivdpzkl(), 100.0 - discountRate, 2) < 0) {
                cacheModel.setErrCode("1000");
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u6298\u6263\u7387\u4e0d\u5141\u8bb8\u8d85\u51fa\u5f53\u524d\u6388\u6743\u4eba[" + curGrant.getCardno() + "]\u7684\u6700\u5927\u6298\u6263\u7387" + cacheModel.getCurGrant().getPrivdpzkl());
                return cacheModel;
            }
            sg.setTempZkDiscount(0.0);
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow((100.0 - discountRate) / 100.0 * (sg.getSaleValue() - PosLogicCompoment.getZZK(sg)), precisionMode));
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            LOGGER.info("discountRate=\u3010{}\u3011,getZZK=\u3010{}\u3011.salevalue=\u3010{}\u3011,MaxDiscountRate = \u3010{}\u3011", new Object[]{discountRate, PosLogicCompoment.getZZK(sg), sg.getSaleValue(), MaxDiscountRate});
            if (PosLogicCompoment.getZZK(sg) > ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * (100.0 - MaxDiscountRate) / 100.0, precisionMode)) {
                sg.setTempZkDiscount(sg.getTempZkDiscount() - PosLogicCompoment.getZZK(sg) + ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * (100.0 - MaxDiscountRate) / 100.0, precisionMode));
                sg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZkDiscount(), precisionMode));
            }
            if (sg.getTempZkDiscount() < 0.0) {
                sg.setTempZkDiscount(0.0);
            }
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            if (sg.getTempZkDiscount() > 0.0) {
                sg.setTempZkl(ManipulatePrecision.doubleConvert(discountRate, 2, 1));
            }
            if (isCheck) {
                cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
            }
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            if (tempZr > 0.0) {
                cacheModel = PosLogicCompoment.CalcGoodsRebateByAmount(cacheModel, flow_id, accreditNo, tempZr);
            }
            if (cacheModel.getOrder().getTempZzk() != 100.0) {
                cacheModel = PosLogicCompoment.CalcOrderRebateByRate(cacheModel, accreditNo, 100.0);
            }
            if (cacheModel.getOrder().getTempZzr() != 0.0) {
                cacheModel = PosLogicCompoment.CalcOrderRebateByAmount(cacheModel, accreditNo, 0.0);
            }
            cacheModel.setCalcResult(0);
            cacheModel.setErrMsg("");
            PosLogicCompoment.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    public static CacheModel CalcOrderRebateByRate(CacheModel cacheModel, String accreditNo, double discountRate) {
        return PosLogicCompoment.CalcOrderRebateByRate(cacheModel, accreditNo, discountRate, false);
    }

    protected static CacheModel CalcOrderRebateByRate(CacheModel cacheModel, String accreditNo, double discountRate, boolean isCheck) {
        if (cacheModel.getGoodsList().size() <= 0) {
            return cacheModel;
        }
        if (discountRate < 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u6298\u6263\u7387\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u503c");
            return cacheModel;
        }
        if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6298\u6263");
            return cacheModel;
        }
        OperUser curGrant = cacheModel.getCurGrant();
        if (!isCheck && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
            curGrant = cacheModel.getCurTempGrant();
        }
        if (ManipulatePrecision.doubleCompare(discountRate, 100.0, 2) >= 0) {
            for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods sg = cacheModel.getGoodsList().get(i);
                sg.setTempZzkDiscount(0.0);
                sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            }
            cacheModel.getOrder().setTempZzk(100.0);
            PosLogicCompoment.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        if (isCheck && curGrant.getPrivzpzkl() <= 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("1000");
            cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
            return cacheModel;
        }
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            if (!(sg.getTempZzrDiscount() > 0.0)) continue;
            sg.setTempZzrDiscount(0.0);
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
        }
        boolean haveRebate = false;
        boolean realHaveRebate = false;
        double maxDiscount = 0.0;
        double tempDiscount = 0.0;
        double lastDiscount = 0.0;
        double totalSaleAmount = 0.0;
        double totalDiscount = 0.0;
        double tempZzkAmount = 0.0;
        int lastRowNo = -1;
        String precisionMode = "0";
        ArrayList<Integer> matchRows = new ArrayList<Integer>();
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            String flag = sg.getFlag();
            precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
            if (flag.equals("0") || sg.getMinDiscount() * 100.0 >= 100.0 || StringUtils.isNotBlank((String)sg.getSGoodsSno())) continue;
            if (!(!isCheck && sg.getIsZzk() || PosLogicCompoment.checkGoodsGrantRange(sg, curGrant.getGrantgz(), 1))) {
                realHaveRebate = true;
                continue;
            }
            haveRebate = true;
            sg.setIsZzk(true);
            matchRows.add(i);
            precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
            double sMaxDiscount = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * sg.getSaleValue(), precisionMode);
            maxDiscount = ManipulatePrecision.doubleCompare(sg.getTotalDiscountValue(), sMaxDiscount, 2) > 0 ? (maxDiscount += sg.getTotalDiscountValue()) : (maxDiscount += sMaxDiscount);
            totalDiscount += ManipulatePrecision.getDetailOverFlow((100.0 - discountRate) / 100.0 * sg.getSaleAmount(), precisionMode);
            tempDiscount += ManipulatePrecision.getDetailOverFlow(sg.getTotalDiscountValue(), precisionMode);
            tempZzkAmount += sg.getTempZzkDiscount();
            totalSaleAmount = totalSaleAmount + sg.getSaleValue() - sg.getTotalDiscountValue();
            if (!(sMaxDiscount >= lastDiscount)) continue;
            lastDiscount = maxDiscount;
            lastRowNo = i;
        }
        if (!haveRebate) {
            if (realHaveRebate) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("1000");
                cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
                return cacheModel;
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u53ef\u6253\u6298\u5546\u54c1");
            return cacheModel;
        }
        double maxDiscountRate = (maxDiscount - tempDiscount + tempZzkAmount) / (totalSaleAmount + tempZzkAmount);
        if (maxDiscountRate < 0.0) {
            maxDiscountRate = 0.0;
        }
        if (ManipulatePrecision.doubleCompare(maxDiscountRate = ManipulatePrecision.doubleConvert((1.0 - maxDiscountRate) * 100.0, 2, 1), discountRate, 2) > 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8d85\u51fa\u5f53\u524d\u5546\u54c1\u6700\u5927\u6298\u6263\u7387" + maxDiscountRate + ",\u4e0d\u5141\u8bb8\u6298\u6263");
            return cacheModel;
        }
        if (isCheck && ManipulatePrecision.doubleCompare(curGrant.getPrivzpzkl(), 100.0 - discountRate, 2) < 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("1000");
            cacheModel.setErrMsg("\u6298\u6263\u7387\u4e0d\u5141\u8bb8\u8d85\u51fa\u5f53\u524d\u6388\u6743\u4eba[" + curGrant.getCardno() + "]\u7684\u6700\u5927\u6298\u6263\u7387" + cacheModel.getCurGrant().getPrivzpzkl());
            return cacheModel;
        }
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            sg.setTempZzkDiscount(0.0);
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
        }
        PosLogicCompoment.calcOrderAmount(cacheModel);
        precisionMode = DataExchageUtils.exchangePrecisionMode(cacheModel.getOrder().getPrecisionMode());
        double finalDiscountAmount = ManipulatePrecision.getDetailOverFlow((100.0 - discountRate) / 100.0 * (totalSaleAmount + tempZzkAmount), precisionMode);
        LOGGER.info("\u6700\u7ec8\u6298\u6263" + finalDiscountAmount);
        double allotAmount = 0.0;
        Iterator iterator = matchRows.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Goods sg = cacheModel.getGoodsList().get(i);
            if (i == lastRowNo) continue;
            precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
            double maxzzk = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * sg.getSaleValue() - sg.getTotalDiscountValue(), precisionMode);
            sg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(finalDiscountAmount / (maxDiscount - tempDiscount + tempZzkAmount) * maxzzk, precisionMode));
            LOGGER.info("maxDiscount\u6298\u6263" + maxDiscount + ",tempDiscount\u6298\u6263" + tempDiscount + ",tempZzkAmount\u6298\u6263" + tempZzkAmount + ",maxzzk\u6298\u6263" + maxzzk);
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            if (ManipulatePrecision.doubleCompare(sg.getTempZzkDiscount(), maxzzk, 2) > 0) {
                sg.setTempZzkDiscount(sg.getTempZzkDiscount() - PosLogicCompoment.getZZK(sg) + maxzzk);
                sg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZzkDiscount(), precisionMode));
            }
            if (sg.getTempZzkDiscount() < 0.0) {
                sg.setTempZzkDiscount(0.0);
            }
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            allotAmount += sg.getTempZzkDiscount();
        }
        if (lastRowNo >= 0) {
            Goods sg = cacheModel.getGoodsList().get(lastRowNo);
            precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
            sg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(finalDiscountAmount - allotAmount, precisionMode));
            double ftzk = ManipulatePrecision.doubleConvert(finalDiscountAmount - allotAmount);
            LOGGER.info("\u5206\u644a\u6298\u6263" + ftzk + ",lastRowNo" + lastRowNo);
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            if (PosLogicCompoment.getZZK(sg) > lastDiscount) {
                sg.setTempZzkDiscount(sg.getTempZzkDiscount() - PosLogicCompoment.getZZK(sg) + lastDiscount);
                sg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZzkDiscount(), precisionMode));
            }
            if (sg.getTempZzkDiscount() < 0.0) {
                sg.setTempZzkDiscount(0.0);
            }
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
        }
        if (isCheck) {
            cacheModel.getOrder().setTotalDiscAuthzCardNo(accreditNo);
        }
        cacheModel.getOrder().setTempZzk(ManipulatePrecision.doubleConvert(discountRate));
        PosLogicCompoment.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    public static CacheModel CalcOrderRebateByAmount(CacheModel cacheModel, String accreditNo, double discountAmount) {
        return PosLogicCompoment.CalcOrderRebateByAmount(cacheModel, accreditNo, discountAmount, 0, false);
    }

    protected static CacheModel CalcOrderRebateByAmount(CacheModel cacheModel, String accreditNo, double discountAmount, int mode, boolean isCheck) {
        try {
            if (cacheModel.getGoodsList().size() <= 0) {
                return cacheModel;
            }
            if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6298\u6263");
                return cacheModel;
            }
            if (ManipulatePrecision.doubleCompare(discountAmount, 0.0, 2) < 0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u6298\u8ba9\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0");
                return cacheModel;
            }
            if (mode == 1) {
                discountAmount = ManipulatePrecision.doubleConvert(cacheModel.getOrder().getSaleValue() - cacheModel.getOrder().getTotalDiscountValue() + cacheModel.getOrder().getTempZzr() - discountAmount);
            }
            OperUser curGrant = cacheModel.getCurGrant();
            if (!isCheck && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                curGrant = cacheModel.getCurTempGrant();
            }
            LOGGER.info("discountAmount1:\u3010{}\u3011", (Object)discountAmount);
            if (ManipulatePrecision.doubleCompare(discountAmount, 0.0, 2) == 0) {
                for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                    Goods sg = cacheModel.getGoodsList().get(i);
                    sg.setTempZzrDiscount(0.0);
                    sg.setIsZzr(false);
                    sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
                    sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
                    sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                    sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
                }
                cacheModel.getOrder().setTempZzr(0.0);
                PosLogicCompoment.calcOrderAmount(cacheModel);
                return cacheModel;
            }
            if (isCheck && curGrant.getPrivzpzkl() <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("1000");
                cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
                return cacheModel;
            }
            String precisionMode = "0";
            ArrayList<Integer> matchRows = new ArrayList<Integer>();
            double totalDiscount = 0.0;
            double realTotalAllowDiscount = 0.0;
            double totalAllowDiscount = 0.0;
            double totalOldZzrDiscount = 0.0;
            double totalOldZzkDiscount = 0.0;
            double lastDiscount = 0.0;
            double totalOldDiscount = 0.0;
            int lastRowNo = 0;
            for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods sg = cacheModel.getGoodsList().get(i);
                String flag = sg.getFlag();
                if (flag.equals("0") || sg.getMinDiscount() * 100.0 >= 100.0) continue;
                precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
                double tempAllowDiscount = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * sg.getSaleValue(), precisionMode);
                if (isCheck) {
                    realTotalAllowDiscount += tempAllowDiscount;
                    if (!PosLogicCompoment.checkGoodsGrantRange(sg, curGrant.getGrantgz(), 1)) {
                        continue;
                    }
                } else {
                    if (!sg.getIsZzr() && !PosLogicCompoment.checkGoodsGrantRange(sg, curGrant.getGrantgz(), 1)) continue;
                    realTotalAllowDiscount += tempAllowDiscount;
                }
                sg.setIsZzr(true);
                matchRows.add(i);
                totalAllowDiscount += tempAllowDiscount;
                totalOldZzrDiscount += sg.getTempZzrDiscount();
                totalOldZzkDiscount += sg.getTempZzkDiscount();
                totalOldDiscount += sg.getTotalDiscountValue();
                double maxAdjustDiscount = 0.0;
                maxAdjustDiscount = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * sg.getSaleValue() - sg.getTotalDiscountValue() + sg.getTempZzrDiscount(), precisionMode);
                if (ManipulatePrecision.doubleCompare(maxAdjustDiscount, 0.0, 2) < 0) {
                    maxAdjustDiscount = 0.0;
                }
                totalDiscount += maxAdjustDiscount;
                if (!(maxAdjustDiscount >= lastDiscount)) continue;
                lastDiscount = maxAdjustDiscount;
                lastRowNo = i;
            }
            if (realTotalAllowDiscount <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u5168\u5355\u6ca1\u6709\u53ef\u6298\u8ba9\u91d1\u989d");
                return cacheModel;
            }
            if (totalAllowDiscount <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("1000");
                cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u4eba[" + curGrant.getCardno() + "]\u6ca1\u6709\u53ef\u6298\u8ba9\u91d1\u989d");
                return cacheModel;
            }
            double tempDiscountAmount = totalDiscount;
            if (tempDiscountAmount < 0.0) {
                tempDiscountAmount = 0.0;
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u672c\u5355\u53ef\u6253\u6298\u91d1\u989d\u4e3a0");
                return cacheModel;
            }
            LOGGER.info("discountAmount:\u3010{}\u3011,tempDiscountAmount:\u3010{}\u3011", (Object)discountAmount, (Object)tempDiscountAmount);
            if (discountAmount > tempDiscountAmount) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8d85\u51fa\u6700\u5927\u6298\u8ba9\u91d1\u989d" + tempDiscountAmount + "\uff0c\u4e0d\u5141\u8bb8\u6298\u8ba9");
                return cacheModel;
            }
            String orderPrecisionMode = DataExchageUtils.exchangePrecisionMode(cacheModel.getOrder().getPrecisionMode());
            double maxDiscountAmount = ManipulatePrecision.getDetailOverFlow(curGrant.getPrivzpzkl() / 100.0 * (cacheModel.getOrder().getSaleValue() - cacheModel.getOrder().getTotalDiscountValue() + totalOldZzrDiscount + totalOldZzkDiscount), orderPrecisionMode);
            if (isCheck && ManipulatePrecision.doubleCompare(discountAmount, maxDiscountAmount, 2) > 0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("1000");
                cacheModel.setErrMsg("\u6298\u6263\u7387\u4e0d\u5141\u8bb8\u5927\u4e8e\u5f53\u524d\u6388\u6743\u4eba[" + curGrant.getCardno() + "]\u7684\u6700\u5927\u6298\u6263\u7387" + cacheModel.getCurGrant().getPrivzpzkl());
                return cacheModel;
            }
            double allotAmount = discountAmount;
            Iterator iterator = matchRows.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                LOGGER.info("matchRows" + i);
                Goods sg = cacheModel.getGoodsList().get(i);
                precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
                double maxzzr = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * sg.getSaleValue(), precisionMode);
                LOGGER.info("maxzzr" + maxzzr + "discountAmount" + discountAmount + ",totalDiscount" + totalDiscount);
                if (i == lastRowNo) continue;
                sg.setTempZzrDiscount(ManipulatePrecision.getDetailOverFlow(discountAmount * (maxzzr - sg.getTotalDiscountValue() + sg.getTempZzrDiscount()) / totalDiscount, precisionMode));
                sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
                if (ManipulatePrecision.doubleCompare(sg.getTempZzrDiscount(), maxzzr, 2) > 0) {
                    sg.setTempZzrDiscount(sg.getTempZzrDiscount() - PosLogicCompoment.getZZK(sg) + maxzzr);
                    sg.setTempZzrDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZzrDiscount(), precisionMode));
                }
                if (sg.getTempZzrDiscount() < 0.0) {
                    sg.setTempZzrDiscount(0.0);
                }
                allotAmount -= sg.getTempZzrDiscount();
                sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
                cacheModel.getGoodsList().set(i, sg);
            }
            if (allotAmount > 0.0) {
                Goods sg = cacheModel.getGoodsList().get(lastRowNo);
                precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
                sg.setTempZzrDiscount(ManipulatePrecision.getDetailOverFlow(allotAmount, precisionMode));
                if (sg.getTempZzrDiscount() > lastDiscount) {
                    sg.setTempZzrDiscount(sg.getAdjustDiscountValue() - PosLogicCompoment.getZZK(sg) - lastDiscount);
                    sg.setTempZzrDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZzrDiscount(), precisionMode));
                }
                if (sg.getTempZzrDiscount() < 0.0) {
                    sg.setTempZzrDiscount(0.0);
                }
                sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            }
            if (isCheck) {
                cacheModel.getOrder().setTotalDiscAuthzCardNo(accreditNo);
            }
            cacheModel.getOrder().setTempZzr(discountAmount);
            PosLogicCompoment.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8ba1\u7b97\u6574\u5355\u6298\u8ba9\u91d1\u989d\u5f02\u5e38");
            return cacheModel;
        }
    }

    protected CacheModel EditGoodsQty(CacheModel cacheModel, int flow_id, String accreditNo, double qty) {
        if (qty <= 0.0) {
            return cacheModel;
        }
        if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalNo()) && StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1\u6570\u91cf");
            return cacheModel;
        }
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        if (null == sg) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u67e5\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
            return cacheModel;
        }
        if (sg.getEscaleFlag().equals("Y")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u7535\u5b50\u79e4\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
            return cacheModel;
        }
        if (sg.getBarcodeDiscount() > 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u91d1\u989d\u7801\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
            return cacheModel;
        }
        if (sg.getFlag().equals("0")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8d60\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
            return cacheModel;
        }
        if (sg.getControlFlag()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u7ba1\u5236\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
            return cacheModel;
        }
        Goods oldsg = sg.deepClone();
        double tempzr = sg.getTempZrDiscount();
        double tempzkl = sg.getTempZkl();
        LOGGER.info("tempzkl" + tempzkl + ",tempzr" + tempzr);
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            block14: {
                int num;
                block12: {
                    block13: {
                        if (null != sg.getSGoodsSno() && sg.getSGoodsSno().length() > 0) break block12;
                        double oldQty = sg.getQty();
                        double newQty = qty;
                        sg.setQty(newQty);
                        sg.setSaleValue(ManipulatePrecision.getDetailOverFlow(newQty * sg.getSalePrice(), precisionMode));
                        sg.setTempZkDiscount(0.0);
                        sg.setTempZrDiscount(0.0);
                        sg.setTempZzkDiscount(0.0);
                        sg.setTempZzrDiscount(0.0);
                        sg.setPopDiscountValue(0.0);
                        if (null != sg.getPopDetailsInfo()) {
                            sg.getPopDetailsInfo().clear();
                        }
                        sg.setFixedDiscountValue(ManipulatePrecision.getDetailOverFlow(ManipulatePrecision.mul(ManipulatePrecision.div(sg.getFixedDiscountValue(), oldQty), newQty), precisionMode));
                        sg.setAdjustDiscountValue(ManipulatePrecision.getDetailOverFlow(PosLogicCompoment.getAdjustDiscount(sg), precisionMode));
                        sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
                        sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                        sg.setSaleAmount(ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() - sg.getTotalDiscountValue(), sg.getPrcutMode()));
                        sg.setTempZkl(tempzkl);
                        sg.setTempZrDiscount(tempzr);
                        cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
                        PosLogicCompoment.calcOrderAmount(cacheModel);
                        LOGGER.info("\u4fee\u6539\u5546\u54c1\u6570\u91cf\u5355\u884c\u6298\u6263" + tempzkl + ",\u6298\u8ba9" + tempzr);
                        if (tempzkl == 100.0) break block13;
                        cacheModel = PosLogicCompoment.CalcGoodsRebateByRate(cacheModel, flow_id, accreditNo, tempzkl);
                        break block14;
                    }
                    if (!(tempzr > 0.0)) break block14;
                    cacheModel = PosLogicCompoment.CalcGoodsRebateByAmount(cacheModel, flow_id, accreditNo, tempzr);
                    break block14;
                }
                List<Goods> goodslist = cacheModel.getGoodsList();
                int newnum = num = goodslist.size();
                for (int i = 0; i < num; ++i) {
                    Goods sGoods = goodslist.get(i);
                    if (null == sGoods.getSGoodsSno() || !sGoods.getSGoodsSno().equals(oldsg.getSGoodsSno())) continue;
                    double newQty = qty;
                    sGoods.setQty(newQty);
                    sGoods.setSaleValue(ManipulatePrecision.getDetailOverFlow(newQty * sGoods.getSalePrice(), precisionMode));
                    sGoods.setTempZkDiscount(0.0);
                    sGoods.setTempZzkDiscount(0.0);
                    sGoods.setTempZzrDiscount(0.0);
                    sGoods.setPopDiscountValue(0.0);
                    if (sGoods.getPopDetailsInfo() != null) {
                        sGoods.getPopDetailsInfo().clear();
                    }
                    sGoods.setAdjustDiscountValue(ManipulatePrecision.getDetailOverFlow(PosLogicCompoment.getAdjustDiscount(sGoods), precisionMode));
                    sGoods.setTotalDiscountValue(ManipulatePrecision.getDetailOverFlow(PosLogicCompoment.getZZK(sGoods), precisionMode));
                    sGoods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sGoods.getTotalDiscountValue() - sGoods.getNoDisAmountValue()));
                    sGoods.setSaleAmount(ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() - sGoods.getTotalDiscountValue(), precisionMode));
                    cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
                    cacheModel.getGoodsList().add(sGoods);
                    ++newnum;
                    PosLogicCompoment.calcOrderAmount(cacheModel);
                }
            }
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    protected CacheModel delOneGoods(CacheModel cacheModel, String accreditNo, int flow_id) {
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        if (null == sg) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u67e5\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
            return cacheModel;
        }
        cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
        cacheModel.getGoodsList().remove(flow_id - 1);
        for (int i = flow_id - 1; i < cacheModel.getGoodsList().size(); ++i) {
            cacheModel.getGoodsList().get(i).setFlowId(i + 1);
        }
        PosLogicCompoment.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    protected CacheModel EditGoodsPrice(CacheModel cacheModel, int flow_id, String accreditNo, double price) {
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        if (null == sg) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u67e5\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
            return cacheModel;
        }
        if (!"4".equals(sg.getGbmanamode()) && !SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
            if (null == cacheModel.getCurGrant().getPrivgj() || !"Y".equals(cacheModel.getCurGrant().getPrivgj())) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("1000");
                cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6539\u4ef7\u6743\u9650");
                return cacheModel;
            }
        } else if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6539\u4ef7");
            return cacheModel;
        }
        if (price < 0.0) {
            return cacheModel;
        }
        if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1\u4ef7\u683c");
            return cacheModel;
        }
        if (sg.getEscaleFlag().equals("Y")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u7535\u5b50\u79e4\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        if (sg.getFlag().equals("0")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8d60\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        if (null != sg.getSGoodsSno() && sg.getSGoodsSno().length() > 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5957\u9910\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        if (!SellType.ISBACK(cacheModel.getOrder().getOrderType()) && !PosLogicCompoment.checkGoodsGrantRange(sg, cacheModel.getCurGrant().getGrantgz(), 1)) {
            cacheModel.setErrCode("1000");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u8303\u56f4\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1\u4ef7\u683c");
            return cacheModel;
        }
        sg = cacheModel.getGoodsList().get(flow_id - 1);
        Goods oldsg = (Goods)sg.clone();
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            double newPrice = ManipulatePrecision.getDetailOverFlow(price, sg.getPrcutMode());
            if (null != sg.getGoodsType() && !sg.getGoodsType().equals("P") && !sg.getGoodsType().equals("Z") && !sg.getGoodsType().equals("15") && newPrice <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0");
                return cacheModel;
            }
            if (newPrice < sg.getMinSalePrice()) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4f4e\u4e8e" + ManipulatePrecision.doubleToString(sg.getMinSalePrice()));
                return cacheModel;
            }
            if (!("4".equals(sg.getGbmanamode()) || SellType.ISBACK(cacheModel.getOrder().getOrderType()) && StringUtils.isBlank((String)cacheModel.getOrder().getOriginTerminalSno()) || !(newPrice < sg.getListPrice() * cacheModel.getCurGrant().getAdjustLow()) && !(newPrice > sg.getListPrice() * cacheModel.getCurGrant().getAdjustUpper()))) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u4eba\u5458\u624b\u5de5\u6539\u4ef7\u8303\u56f4\u4e3a\u539f\u4ef7\u7684" + ManipulatePrecision.doubleToString(cacheModel.getCurGrant().getAdjustLow()) + "~" + ManipulatePrecision.doubleToString(cacheModel.getCurGrant().getAdjustUpper()) + "\u500d\u6570\u8303\u56f4\u5185");
                cacheModel.setErrCode("1000");
                return cacheModel;
            }
            sg.setSalePrice(newPrice);
            sg.setSaleValue(ManipulatePrecision.getDetailOverFlow(sg.getQty() * sg.getSalePrice(), precisionMode));
            sg.setTempZkl(100.0);
            sg.setTempZkDiscount(0.0);
            sg.setTempZrDiscount(0.0);
            sg.setTempZzkDiscount(0.0);
            sg.setTempZzrDiscount(0.0);
            sg.setAdjustDiscountValue(0.0);
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
            PosLogicCompoment.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    protected CacheModel FixGoodsPrice(CacheModel cacheModel, int flow_id, String accreditNo, double price) {
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        if (null == sg) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u67e5\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
            return cacheModel;
        }
        if (!"4".equals(sg.getGbmanamode()) && !SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
            if (cacheModel.getCurGrant().getPrivdpzkl() <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("1000");
                cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
                return cacheModel;
            }
        } else if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6539\u4ef7");
            return cacheModel;
        }
        if (price < 0.0) {
            return cacheModel;
        }
        if (sg.getEscaleFlag().equals("Y")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u7535\u5b50\u79e4\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        if (sg.getFlag().equals("0")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8d60\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        if (StringUtils.isNotBlank((String)sg.getSGoodsSno())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5957\u9910\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        if (!PosLogicCompoment.checkGoodsGrantRange(sg, cacheModel.getCurGrant().getGrantgz(), 1)) {
            cacheModel.setErrCode("1000");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u65e0\u6cd5\u5bf9\u8be5\u5546\u54c1\u8fdb\u884c\u6253\u6298");
            return cacheModel;
        }
        if (ManipulatePrecision.doubleCompare(price, sg.getSalePrice(), 2) > 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u4e00\u53e3\u4ef7\u540e\u4ef7\u683c\u4e0d\u80fd\u9ad8\u4e8e\u539f\u96f6\u552e\u4ef7");
            return cacheModel;
        }
        sg = cacheModel.getGoodsList().get(flow_id - 1);
        Goods oldsg = (Goods)sg.clone();
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        double tempzkl = oldsg.getTempZkl();
        double tempzr = oldsg.getTempZrDiscount();
        try {
            double MaxDiscountRate = 1.0 - sg.getMinDiscount();
            double MaxDiscountAmount = ManipulatePrecision.getDetailOverFlow(MaxDiscountRate * sg.getSaleValue(), precisionMode);
            double GrantDiscountRate = ManipulatePrecision.doubleConvert(cacheModel.getCurGrant().getPrivdpzkl() / 100.0, 2, 1);
            boolean isGrantRate = false;
            if (MaxDiscountRate > GrantDiscountRate) {
                MaxDiscountRate = GrantDiscountRate;
                isGrantRate = true;
            }
            MaxDiscountAmount = ManipulatePrecision.getDetailOverFlow(MaxDiscountRate * sg.getSaleValue(), precisionMode);
            MaxDiscountAmount = MaxDiscountAmount - sg.getTotalDiscountValue() + sg.getAdjustDiscountValue() - sg.getBarcodeDiscount();
            double newPrice = ManipulatePrecision.getDetailOverFlow(price, sg.getPrcutMode());
            if (null != sg.getGoodsType() && !sg.getGoodsType().equals("P") && !sg.getGoodsType().equals("Z") && !sg.getGoodsType().equals("15") && newPrice <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0");
                return cacheModel;
            }
            if (newPrice < sg.getMinSalePrice()) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4f4e\u4e8e" + ManipulatePrecision.doubleToString(sg.getMinSalePrice()));
                return cacheModel;
            }
            sg.setSaleValue(ManipulatePrecision.getDetailOverFlow(sg.getQty() * sg.getSalePrice(), precisionMode));
            sg.setTempZkl(100.0);
            sg.setTempZkDiscount(0.0);
            sg.setTempZrDiscount(0.0);
            sg.setTempZzkDiscount(0.0);
            sg.setTempZzrDiscount(0.0);
            sg.setFixedDiscountValue(ManipulatePrecision.getDetailOverFlow((sg.getSalePrice() - newPrice) * sg.getQty(), precisionMode));
            if (sg.getFixedDiscountValue() > MaxDiscountAmount) {
                if (isGrantRate) {
                    cacheModel.setErrCode("1000");
                    cacheModel.setErrMsg("\u4e00\u53e3\u4ef7\u6298\u6263\u91d1\u989d\u91d1\u989d\u8d85\u51fa\u8be5\u4eba\u5458\u6700\u5927\u6298\u6263\u7387" + cacheModel.getCurGrant().getPrivdpzkl());
                } else {
                    cacheModel.setErrMsg("\u4e00\u53e3\u4ef7\u6298\u6263\u91d1\u989d\u8d85\u51fa\u8be5\u5546\u54c1\u6700\u5927\u6298\u6263" + MaxDiscountAmount);
                }
                cacheModel.setCalcResult(-1);
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            sg.setTempZkl(tempzkl);
            sg.setTempZrDiscount(tempzr);
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
            PosLogicCompoment.calcOrderAmount(cacheModel);
            if (tempzkl < 100.0) {
                cacheModel = PosLogicCompoment.CalcGoodsRebateByRate(cacheModel, flow_id, accreditNo, tempzkl);
            } else if (tempzr > 0.0) {
                cacheModel = PosLogicCompoment.CalcGoodsRebateByAmount(cacheModel, flow_id, accreditNo, tempzr);
            }
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    protected CacheModel CalcAeonOldCoupon(CacheModel cacheModel, QueryAeonCouponOut coupon) {
        try {
            boolean isHaveCust = false;
            LocalDate fromDate = LocalDate.parse(coupon.getCouponDetailModel().getFromDate(), DateTimeFormatter.BASIC_ISO_DATE);
            LocalDate toDate = LocalDate.parse(coupon.getCouponDetailModel().getToDate(), DateTimeFormatter.BASIC_ISO_DATE);
            LocalDate nowDate = LocalDate.now();
            if (nowDate.isBefore(fromDate) || nowDate.isAfter(toDate)) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u4f18\u60e0\u5238\u4e0d\u5728\u6709\u6548\u671f\u5185");
                return cacheModel;
            }
            String memoStr = "";
            double matchAmount = 0.0;
            double maxMatchAmount = 0.0;
            ArrayList<Integer> matchRows = new ArrayList<Integer>();
            int maxMatchRow = 0;
            block2: for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods g = cacheModel.getGoodsList().get(i);
                if (g.getGoodsCode().equals(coupon.getCouponDetailModel().getCoupon()) || StringUtils.isBlank((String)g.getCategoryCode()) && StringUtils.isBlank((String)g.getArtCode())) continue;
                String artCode = g.getArtCode();
                if (cacheModel.getOrder().getSysPara().getBarCodeMode() != 2) {
                    artCode = g.getCategoryCode();
                }
                for (String category : coupon.getCouponCodes()) {
                    if (Long.parseLong(category) != Long.parseLong(artCode)) continue;
                    matchRows.add(i);
                    matchAmount = ManipulatePrecision.doubleConvert(matchAmount + g.getSaleAmount(), 2, 1);
                    if (!(g.getSaleAmount() >= maxMatchAmount)) continue block2;
                    maxMatchAmount = g.getSaleAmount();
                    maxMatchRow = i;
                    continue block2;
                }
            }
            double purchaseAmount = 0.0;
            double memberPurchaseAmount = 0.0;
            purchaseAmount = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getNormalPurchaseAmount() / 100.0, 2, 1);
            memberPurchaseAmount = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getJcardPurchaseAmount() / 100.0, 2, 1);
            if (null == cacheModel.getOrder().getConsumersData() || StringUtils.isBlank((String)cacheModel.getOrder().getConsumersData().getConsumersType())) {
                if (matchAmount < purchaseAmount) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u8ba2\u5355\u5546\u54c1\u4e0d\u6ee1\u8db3\u7528\u5238\u95e8\u574e\uff0c\u8fd8\u5dee" + ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getNormalPurchaseAmount() / 100.0 - matchAmount, 2, 1) + "\u5143");
                    return cacheModel;
                }
            } else {
                isHaveCust = true;
                if (matchAmount < memberPurchaseAmount) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u8ba2\u5355\u5546\u54c1\u4e0d\u6ee1\u8db3\u7528\u5238\u95e8\u574e\uff0c\u8fd8\u5dee" + ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getJcardPurchaseAmount() / 100.0 - matchAmount, 2, 1) + "\u5143");
                    return cacheModel;
                }
            }
            memoStr = memoStr + purchaseAmount + "@" + memberPurchaseAmount;
            double discountAmount = 0.0;
            double discountValue = 0.0;
            double memberDiscountValue = 0.0;
            if (coupon.getCouponDetailModel().getDiscountFlag().equals("A")) {
                memberDiscountValue = ManipulatePrecision.getDetailOverFlow(coupon.getCouponDetailModel().getJcardDiscountValue() / 100.0, "B");
                discountValue = ManipulatePrecision.getDetailOverFlow(coupon.getCouponDetailModel().getNormalDiscountValue() / 100.0, "B");
                discountAmount = isHaveCust ? memberDiscountValue : discountValue;
                memoStr = memoStr + ",A," + discountValue + "@" + memberDiscountValue;
            } else if (coupon.getCouponDetailModel().getDiscountFlag().equals("R")) {
                double discountRate = 0.0;
                memberDiscountValue = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getJcardDiscountValue() / 100.0, 2, 1);
                discountValue = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getNormalDiscountValue() / 100.0, 2, 1);
                discountRate = isHaveCust ? memberDiscountValue : discountValue;
                discountAmount = ManipulatePrecision.getDetailOverFlow(matchAmount * discountRate / 100.0, "B");
                memoStr = memoStr + ",R," + discountValue + "@" + memberDiscountValue;
            }
            if (discountAmount <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u4f18\u60e0\u5238\u672a\u4ea7\u751f\u4f18\u60e0\u91d1\u989d");
                return cacheModel;
            }
            if (discountAmount > matchAmount) {
                discountAmount = matchAmount;
            }
            double lastDiscountAmount = discountAmount;
            Iterator iterator = matchRows.iterator();
            while (iterator.hasNext()) {
                int matchRow;
                int i = matchRow = ((Integer)iterator.next()).intValue();
                if (matchRow == maxMatchRow) continue;
                Goods g = cacheModel.getGoodsList().get(i);
                double yhAmount = ManipulatePrecision.getDetailOverFlow(discountAmount * g.getSaleAmount() / matchAmount, "B");
                g.setPopDiscountValue(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() + yhAmount, 2, 1));
                lastDiscountAmount -= yhAmount;
                g.setTotalDiscountValue(PosLogicCompoment.getZZK(g));
                g.setSaleAmount(ManipulatePrecision.doubleConvert(g.getSaleValue() - g.getTotalDiscountValue()));
                g.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() - g.getNoDisAmountValue()));
                PopDetail pop = new PopDetail();
                pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
                pop.setPopDescribe(coupon.getCouponDetailModel().getDescription());
                pop.setPopMemo(coupon.getCouponDetailModel().getCoupon());
                pop.setDiscountAmount(yhAmount);
                pop.setPopMode("0");
                g.getPopDetailsInfo().add(pop);
            }
            if (lastDiscountAmount > 0.0) {
                Goods g = cacheModel.getGoodsList().get(maxMatchRow);
                lastDiscountAmount = ManipulatePrecision.getDetailOverFlow(lastDiscountAmount, "B");
                g.setPopDiscountValue(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() + lastDiscountAmount, 2, 1));
                g.setTotalDiscountValue(PosLogicCompoment.getZZK(g));
                g.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() - g.getNoDisAmountValue()));
                g.setSaleAmount(g.getSaleValue() - g.getTotalDiscountValue());
                PopDetail pop = new PopDetail();
                pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
                pop.setPopDescribe(coupon.getCouponDetailModel().getDescription());
                pop.setPopMemo(coupon.getCouponDetailModel().getCoupon());
                pop.setDiscountAmount(lastDiscountAmount);
                pop.setPopMode("0");
                g.getPopDetailsInfo().add(pop);
            }
            Goods couponGoods = new Goods();
            couponGoods.setGuid(UUIDUtils.buildGuid());
            couponGoods.setFlowId(cacheModel.getGoodsList().size() + 1);
            couponGoods.setGoodsCode(coupon.getCouponDetailModel().getCoupon());
            couponGoods.setGoodsName(coupon.getCouponDetailModel().getDescription());
            couponGoods.setBarNo(couponGoods.getGoodsCode());
            couponGoods.setSalePrice(0.0);
            couponGoods.setGoodsType("99");
            couponGoods.setGoodsNo(couponGoods.getGoodsCode());
            couponGoods.setQty(1.0);
            couponGoods.setSaleValue(0.0);
            couponGoods.setSaleAmount(0.0);
            couponGoods.setEscaleFlag("N");
            couponGoods.setCategoryCode("");
            couponGoods.setTempCategory("");
            couponGoods.setArtCode("");
            couponGoods.setPrcutMode("A");
            couponGoods.setRemark(memoStr + "," + coupon.getCouponDetailModel().getDescription());
            cacheModel.getGoodsList().add(couponGoods);
            PosLogicCompoment.calcOrderAmount(cacheModel);
            PosLogicCompoment.calcPayBalance(cacheModel);
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8ba1\u7b97\u4f18\u60e0\u5238\u53d1\u751f\u9519\u8bef");
            return cacheModel;
        }
    }

    protected CacheModel CalcAeonPrivilegeCoupon(CacheModel cacheModel, QueryAeonCouponOut coupon, String code1, String code2) {
        try {
            boolean isHaveCust = false;
            LocalDate fromDate = LocalDate.parse(coupon.getCouponDetailModel().getFromDate(), DateTimeFormatter.BASIC_ISO_DATE);
            LocalDate toDate = LocalDate.parse(coupon.getCouponDetailModel().getToDate(), DateTimeFormatter.BASIC_ISO_DATE);
            LocalDate nowDate = LocalDate.now();
            if (nowDate.isBefore(fromDate) || nowDate.isAfter(toDate)) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u4f18\u60e0\u5238\u4e0d\u5728\u6709\u6548\u671f\u5185");
                return cacheModel;
            }
            String memoStr = "";
            double matchAmount = 0.0;
            double maxMatchAmount = 0.0;
            ArrayList<Integer> matchRows = new ArrayList<Integer>();
            int maxMatchRow = 0;
            block2: for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods g = cacheModel.getGoodsList().get(i);
                if (g.getGoodsCode().equals(coupon.getCouponDetailModel().getCoupon()) || StringUtils.isBlank((String)g.getCategoryCode()) && StringUtils.isBlank((String)g.getArtCode())) continue;
                String artCode = g.getArtCode();
                if (cacheModel.getOrder().getSysPara().getBarCodeMode() != 2) {
                    artCode = g.getCategoryCode();
                }
                for (String category : coupon.getCouponCodes()) {
                    if (Long.parseLong(category) != Long.parseLong(artCode)) continue;
                    matchRows.add(i);
                    matchAmount = ManipulatePrecision.doubleConvert(matchAmount + g.getSaleAmount(), 2, 1);
                    if (!(g.getSaleAmount() >= maxMatchAmount)) continue block2;
                    maxMatchAmount = g.getSaleAmount();
                    maxMatchRow = i;
                    continue block2;
                }
            }
            double purchaseAmount = 0.0;
            double memberPurchaseAmount = 0.0;
            purchaseAmount = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getNormalPurchaseAmount() / 100.0, 2, 1);
            memberPurchaseAmount = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getJcardPurchaseAmount() / 100.0, 2, 1);
            if (null == cacheModel.getOrder().getConsumersData() || StringUtils.isBlank((String)cacheModel.getOrder().getConsumersData().getConsumersType())) {
                if (matchAmount < purchaseAmount) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u8ba2\u5355\u5546\u54c1\u4e0d\u6ee1\u8db3\u7528\u5238\u95e8\u574e\uff0c\u8fd8\u5dee" + ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getNormalPurchaseAmount() / 100.0 - matchAmount, 2, 1) + "\u5143");
                    return cacheModel;
                }
            } else {
                isHaveCust = true;
                if (matchAmount < memberPurchaseAmount) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u8ba2\u5355\u5546\u54c1\u4e0d\u6ee1\u8db3\u7528\u5238\u95e8\u574e\uff0c\u8fd8\u5dee" + ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getJcardPurchaseAmount() / 100.0 - matchAmount, 2, 1) + "\u5143");
                    return cacheModel;
                }
            }
            memoStr = memoStr + purchaseAmount + "@" + memberPurchaseAmount;
            double discountAmount = 0.0;
            double discountValue = 0.0;
            double memberDiscountValue = 0.0;
            if (coupon.getCouponDetailModel().getDiscountFlag().equals("A")) {
                discountValue = ManipulatePrecision.getDetailOverFlow(coupon.getCouponDetailModel().getJcardDiscountValue() / 100.0, "0");
                memberDiscountValue = ManipulatePrecision.getDetailOverFlow(coupon.getCouponDetailModel().getNormalDiscountValue() / 100.0, "0");
                discountAmount = isHaveCust ? discountValue : memberDiscountValue;
                memoStr = memoStr + ",A," + discountValue + "@" + memberDiscountValue;
            } else if (coupon.getCouponDetailModel().getDiscountFlag().equals("R")) {
                memberDiscountValue = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getJcardDiscountValue() / 100.0, 2, 1);
                discountValue = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getNormalDiscountValue() / 100.0, 2, 1);
                discountAmount = isHaveCust ? ManipulatePrecision.getDetailOverFlow(matchAmount * memberDiscountValue / 100.0, "B") : ManipulatePrecision.getDetailOverFlow(matchAmount * discountValue, "B");
                memoStr = memoStr + ",R," + discountValue + "@" + memberDiscountValue;
            }
            if (discountAmount <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u4f18\u60e0\u5238\u672a\u4ea7\u751f\u4f18\u60e0\u91d1\u989d");
                return cacheModel;
            }
            if (discountAmount > matchAmount) {
                discountAmount = matchAmount;
            }
            double lastDiscountAmount = discountAmount;
            Iterator iterator = matchRows.iterator();
            while (iterator.hasNext()) {
                int matchRow = (Integer)iterator.next();
                if (matchRow == maxMatchRow) continue;
                int i = matchRow;
                Goods g = cacheModel.getGoodsList().get(i);
                double yhAmount = ManipulatePrecision.getDetailOverFlow(discountAmount * g.getSaleAmount() / matchAmount, "B");
                g.setPopDiscountValue(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() + yhAmount, 2, 1));
                lastDiscountAmount -= yhAmount;
                g.setTotalDiscountValue(PosLogicCompoment.getZZK(g));
                g.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() - g.getNoDisAmountValue()));
                g.setSaleAmount(g.getSaleValue() - g.getTotalDiscountValue());
                PopDetail pop = new PopDetail();
                pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
                pop.setPopDescribe(coupon.getCouponDetailModel().getDescription() + "|" + code1 + "|" + code2);
                pop.setPopMemo(coupon.getCouponDetailModel().getCoupon());
                pop.setDiscountAmount(yhAmount);
                pop.setPopMode("0");
                g.getPopDetailsInfo().add(pop);
            }
            if (lastDiscountAmount > 0.0) {
                Goods g = cacheModel.getGoodsList().get(maxMatchRow);
                lastDiscountAmount = ManipulatePrecision.getDetailOverFlow(lastDiscountAmount, "B");
                g.setPopDiscountValue(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() + lastDiscountAmount, 2, 1));
                g.setTotalDiscountValue(PosLogicCompoment.getZZK(g));
                g.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() - g.getNoDisAmountValue()));
                g.setSaleAmount(g.getSaleValue() - g.getTotalDiscountValue());
                PopDetail pop = new PopDetail();
                pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
                pop.setPopDescribe(coupon.getCouponDetailModel().getDescription() + "|" + code1 + "|" + code2);
                pop.setPopMemo(coupon.getCouponDetailModel().getCoupon());
                pop.setDiscountAmount(lastDiscountAmount);
                pop.setPopMode("0");
                g.getPopDetailsInfo().add(pop);
            }
            Goods couponGoods = new Goods();
            couponGoods.setGuid(UUIDUtils.buildGuid());
            couponGoods.setFlowId(cacheModel.getGoodsList().size() + 1);
            couponGoods.setGoodsCode(coupon.getCouponDetailModel().getCoupon());
            couponGoods.setGoodsName("\u5168\u65e5\u901a\u5238");
            couponGoods.setBarNo(code1);
            couponGoods.setGoodsNo(code2);
            couponGoods.setSalePrice(0.0);
            couponGoods.setGoodsType("98");
            couponGoods.setGoodsNo(couponGoods.getGoodsCode());
            couponGoods.setQty(1.0);
            couponGoods.setSaleValue(0.0);
            couponGoods.setSaleAmount(0.0);
            couponGoods.setEscaleFlag("N");
            couponGoods.setCategoryCode("");
            couponGoods.setPrcutMode("A");
            couponGoods.setRemark(memoStr + "," + coupon.getCouponDetailModel().getDescription() + "|" + code1 + "|" + code2);
            couponGoods.setTempCategory("");
            couponGoods.setArtCode("");
            cacheModel.getGoodsList().add(couponGoods);
            PosLogicCompoment.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8ba1\u7b97\u4f18\u60e0\u5238\u53d1\u751f\u9519\u8bef");
            return cacheModel;
        }
    }

    public static CacheModel DelAeonOldCoupon(CacheModel cacheModel, String couponCode) {
        for (Goods sg : cacheModel.getGoodsList()) {
            if (null == sg || null == sg.getPopDetailsInfo()) continue;
            for (int i = 0; i < sg.getPopDetailsInfo().size(); ++i) {
                PopDetail pop = sg.getPopDetailsInfo().get(i);
                if (null == pop || !YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup()) || !pop.getPopMemo().equals(couponCode)) continue;
                sg.setPopDiscountValue(ManipulatePrecision.doubleConvert(sg.getPopDiscountValue() - pop.getDiscountAmount(), 2, 1));
                sg.getPopDetailsInfo().remove(pop);
                --i;
            }
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
        }
        PosLogicCompoment.calcOrderAmount(cacheModel);
        cacheModel.setGoodsList(PosLogicCompoment.sortGoodsList(cacheModel.getGoodsList()));
        return cacheModel;
    }

    public static Goods calcGoodsAmountAfterPromotion(Goods saleGoodsDef) {
        String precisionMode = saleGoodsDef.getPrcutMode();
        saleGoodsDef.setTotalDiscountValue(PosLogicCompoment.getZZK(saleGoodsDef));
        saleGoodsDef.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(saleGoodsDef.getTotalDiscountValue() - saleGoodsDef.getNoDisAmountValue()));
        saleGoodsDef.setSaleAmount(ManipulatePrecision.getDetailOverFlow(saleGoodsDef.getSaleValue() - saleGoodsDef.getTotalDiscountValue(), precisionMode));
        return saleGoodsDef;
    }

    public CacheModel calcOrderAmountAfterPopSave(CacheModel cacheModel) {
        Goods saleGoods = null;
        boolean sign = true;
        Order saleOrder = cacheModel.getOrder();
        List<Goods> goodslist = cacheModel.getGoodsList();
        saleOrder.setOughtPay(0.0);
        saleOrder.setSaleValue(0.0);
        saleOrder.setRealSaleValue(0.0);
        saleOrder.setTotalDiscountValue(0.0);
        saleOrder.setRealTotalDiscountValue(0.0);
        saleOrder.setMemberDiscAmount(0.0);
        saleOrder.setCouponDiscAmount(0.0);
        saleOrder.setPreferentialDiscAmount(0.0);
        saleOrder.setTemporaryDiscAmount(0.0);
        saleOrder.setMealDiscAmount(0.0);
        saleOrder.setNoDiscountValue(0.0);
        saleOrder.setQty(0);
        double oughtPay = 0.0;
        double saleValue = 0.0;
        double totalDiscountValue = 0.0;
        double noDiscountValue = 0.0;
        double memberDiscAmount = 0.0;
        double preferentialDiscAmount = 0.0;
        double temporaryDiscAmount = 0.0;
        double mealDiscountAmout = 0.0;
        double couponDiscountAmount = 0.0;
        int totalNum = 0;
        for (int i = 0; i < goodslist.size(); ++i) {
            saleGoods = goodslist.get(i);
            PosLogicCompoment.calcGoodsAmountAfterPromotion(saleGoods);
            int Qty = (int)saleGoods.getQty();
            if (saleGoods.getEscaleFlag().equals("Y")) {
                Qty = 1;
            }
            totalNum += Qty;
            saleValue = ManipulatePrecision.doubleConvert(saleValue + saleGoods.getSaleValue() * (double)sign, 2, 1);
            totalDiscountValue = ManipulatePrecision.doubleConvert(totalDiscountValue + saleGoods.getTotalDiscountValue() * (double)sign, 2, 1);
            memberDiscAmount = ManipulatePrecision.doubleConvert(memberDiscAmount + saleGoods.getCustomDiscountValue() * (double)sign, 2, 1);
            preferentialDiscAmount = ManipulatePrecision.doubleConvert(preferentialDiscAmount + saleGoods.getPopDiscountValue() * (double)sign, 2, 1);
            temporaryDiscAmount = ManipulatePrecision.doubleConvert(temporaryDiscAmount + saleGoods.getAdjustDiscountValue() * (double)sign, 2, 1);
            mealDiscountAmout = ManipulatePrecision.doubleConvert(mealDiscountAmout + saleGoods.getMealDiscountValue() * (double)sign, 2, 1);
            couponDiscountAmount = ManipulatePrecision.doubleConvert(couponDiscountAmount + saleGoods.getCouponValue() * (double)sign, 2, 1);
            noDiscountValue = ManipulatePrecision.doubleConvert(noDiscountValue + saleGoods.getNoDisAmountValue() * (double)sign, 2, 1);
        }
        oughtPay = saleValue - totalDiscountValue;
        double realOughtPay = ManipulatePrecision.getDetailOverFlow(oughtPay, saleOrder.getPrecisionMode());
        saleOrder.setOughtPay(realOughtPay);
        saleOrder.setSaleValue(saleValue);
        saleOrder.setTotalDiscountValue(totalDiscountValue);
        saleOrder.setMemberDiscAmount(memberDiscAmount);
        saleOrder.setPreferentialDiscAmount(preferentialDiscAmount);
        saleOrder.setTemporaryDiscAmount(temporaryDiscAmount);
        saleOrder.setCouponDiscAmount(couponDiscountAmount);
        saleOrder.setNoDiscountValue(noDiscountValue);
        saleOrder.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(totalDiscountValue - noDiscountValue));
        saleOrder.setRealSaleValue(ManipulatePrecision.doubleConvert(saleValue - noDiscountValue));
        saleOrder.setQty(totalNum);
        cacheModel.setOrder(saleOrder);
        return cacheModel;
    }

    public CacheModel RefreshAfterOrderSave(CacheModel cacheModel, CouponGainCalcOut promotionOut) {
        try {
            double revenuePoint;
            if (null == cacheModel || null == promotionOut) {
                return cacheModel;
            }
            cacheModel.getOrder().setSeqNo(promotionOut.getCalcBillid());
            if (null != promotionOut.getCoupons() && promotionOut.getCoupons().size() > 0) {
                for (int i = 0; i < promotionOut.getCoupons().size(); ++i) {
                    SellCoupon c = promotionOut.getCoupons().get(i);
                    if (null == c) continue;
                    if (cacheModel.getOrder().getCouponDetails() == null) {
                        cacheModel.getOrder().setCouponDetails(new ArrayList<Coupon>());
                    }
                    cacheModel.getOrder().getCouponDetails().add(Coupon.transferCoupon(c));
                }
            }
            List<SellDetail> listGoods = null;
            if (null != promotionOut.getBillDetail() && null != promotionOut.getBillDetail().getSellDetails()) {
                listGoods = promotionOut.getBillDetail().getSellDetails();
            }
            if (null != listGoods) {
                for (int i = 0; i < listGoods.size(); ++i) {
                    Goods goods2 = cacheModel.getGoodsList().get(i);
                    goods2 = Goods.transferGoods(listGoods.get(i), goods2, "0", cacheModel.getOrder().getSysPara().getCalcPriceType(), true, true, StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno()));
                    goods2.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(goods2));
                    goods2.setTotalDiscountValue(PosLogicCompoment.getZZK(goods2));
                    goods2.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods2.getRealTotalDiscountValue() - goods2.getNoDisAmountValue()));
                    goods2.setRealSalePrice(ManipulatePrecision.doubleConvert(goods2.getSalePrice() - goods2.getNoDisAmountValue() / goods2.getQty()));
                    cacheModel.getGoodsList().set(i, goods2);
                }
            }
            if (null != promotionOut.getBillDetail().getSellPayments()) {
                for (int i = 0; i < promotionOut.getBillDetail().getSellPayments().size(); ++i) {
                    Payment sp;
                    SellPayment sellPayment = promotionOut.getBillDetail().getSellPayments().get(i);
                    if (null == sellPayment) continue;
                    for (int j = 0; !(j >= cacheModel.getPayments().size() || null != (sp = cacheModel.getPayments().get(j)).getRownoId() && sp.getRownoId().equals(sellPayment.getRowNoId())); ++j) {
                        if (sp.getPayCode().equals(sellPayment.getPaycode()) && (null == sp.getPayCode() || sp.getPayCode().equals(""))) {
                            sp.setRownoId(sellPayment.getRowNoId());
                        }
                        cacheModel.getPayments().set(j, sp);
                    }
                }
            }
            if ("4".equals(cacheModel.getOrder().getOrderType()) && null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
                block6: for (Payment payment : cacheModel.getPayments()) {
                    if (!StringUtils.isNotBlank((String)payment.getPayNo())) continue;
                    String rownoid = payment.getRownoId();
                    block7: for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                        Goods g = cacheModel.getGoodsList().get(i);
                        for (int j = 0; j < g.getCouponUses().size(); ++j) {
                            CouponUse c = g.getCouponUses().get(j);
                            if (!rownoid.equals(c.getRownoId()) || !"A02".equals(c.getCouponGroup())) continue;
                            if (StringUtils.isNotBlank((String)c.getCouponNo())) continue block6;
                            c.setCouponNo(payment.getPayNo());
                            cacheModel.getGoodsList().get(i).getCouponUses().set(j, c);
                            continue block7;
                        }
                    }
                }
            }
            if ((revenuePoint = this.getRevenuePoint(promotionOut, cacheModel.getOrder())) < 0.0) {
                revenuePoint *= -1.0;
            }
            if (revenuePoint > 0.0 || cacheModel.getOrder().getOrderType().equals("4") && StringUtils.isBlank((String)cacheModel.getOrder().getOriginFlowNo())) {
                cacheModel.getOrder().setThisTimePoint(revenuePoint);
            }
            cacheModel = this.calcOrderAmountAfterPopSave(cacheModel);
            return cacheModel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected double getRevenuePoint(CouponGainCalcOut couponGainCalcOut, Order order) {
        double memberPoints = 0.0;
        List<SellCoupon> sellCoupons = null;
        sellCoupons = SellType.ISBACK(order.getOrderType()) ? couponGainCalcOut.getBillDetail().getCouponGains() : couponGainCalcOut.getCoupons();
        if (CollectionUtils.isNotEmpty(sellCoupons)) {
            for (SellCoupon sellCoupon : sellCoupons) {
                if (!"01".equals(sellCoupon.getCouponGroup())) continue;
                memberPoints = ManipulatePrecision.add(memberPoints, sellCoupon.getAmount());
            }
        }
        return ManipulatePrecision.getDetailOverFlow(memberPoints, "4");
    }

    public static void calcOrderAmount(CacheModel cacheModel) {
        Goods saleGoods = null;
        boolean sign = true;
        Order saleOrder = cacheModel.getOrder();
        List<Goods> goodslist = cacheModel.getGoodsList();
        saleOrder.setOughtPay(0.0);
        saleOrder.setRoundUpOverageValue(0.0);
        saleOrder.setSaleValue(0.0);
        saleOrder.setRealSaleValue(0.0);
        saleOrder.setTotalDiscountValue(0.0);
        saleOrder.setRealTotalDiscountValue(0.0);
        saleOrder.setMemberDiscAmount(0.0);
        saleOrder.setCouponDiscAmount(0.0);
        saleOrder.setPreferentialDiscAmount(0.0);
        saleOrder.setTemporaryDiscAmount(0.0);
        saleOrder.setMealDiscAmount(0.0);
        saleOrder.setNoDiscountValue(0.0);
        saleOrder.setQty(0);
        double oughtPay = 0.0;
        double saleValue = 0.0;
        double totalDiscountValue = 0.0;
        double noDiscountValue = 0.0;
        double memberDiscAmount = 0.0;
        double preferentialDiscAmount = 0.0;
        double temporaryDiscAmount = 0.0;
        double mealDiscountAmout = 0.0;
        double couponDiscountAmount = 0.0;
        int totalNum = 0;
        for (int i = 0; i < goodslist.size(); ++i) {
            saleGoods = goodslist.get(i);
            PosLogicCompoment.calcGoodsAmountAfterPromotion(saleGoods);
            int Qty = (int)saleGoods.getQty();
            if (saleGoods.getEscaleFlag().equals("Y")) {
                Qty = 1;
            }
            totalNum += Qty;
            saleValue = ManipulatePrecision.doubleConvert(saleValue + saleGoods.getSaleValue() * (double)sign, 2, 1);
            totalDiscountValue = ManipulatePrecision.doubleConvert(totalDiscountValue + saleGoods.getTotalDiscountValue() * (double)sign, 2, 1);
            memberDiscAmount = ManipulatePrecision.doubleConvert(memberDiscAmount + saleGoods.getCustomDiscountValue() * (double)sign, 2, 1);
            preferentialDiscAmount = ManipulatePrecision.doubleConvert(preferentialDiscAmount + saleGoods.getPopDiscountValue() * (double)sign, 2, 1);
            temporaryDiscAmount = ManipulatePrecision.doubleConvert(temporaryDiscAmount + saleGoods.getAdjustDiscountValue() * (double)sign, 2, 1);
            mealDiscountAmout = ManipulatePrecision.doubleConvert(mealDiscountAmout + saleGoods.getMealDiscountValue() * (double)sign, 2, 1);
            couponDiscountAmount = ManipulatePrecision.doubleConvert(couponDiscountAmount + saleGoods.getCouponValue() * (double)sign, 2, 1);
            noDiscountValue = ManipulatePrecision.doubleConvert(noDiscountValue + saleGoods.getNoDisAmountValue() * (double)sign, 2, 1);
        }
        oughtPay = saleValue - totalDiscountValue;
        double realOughtPay = ManipulatePrecision.getDetailOverFlow(oughtPay, saleOrder.getPrecisionMode());
        LOGGER.info("oughtPay:" + oughtPay + "  realOughtPay:" + realOughtPay);
        saleOrder.setOughtPay(realOughtPay);
        saleOrder.setRoundUpOverageValue(ManipulatePrecision.doubleConvert(saleValue - totalDiscountValue - realOughtPay));
        saleOrder.setSaleValue(saleValue);
        saleOrder.setTotalDiscountValue(totalDiscountValue);
        saleOrder.setMemberDiscAmount(memberDiscAmount);
        saleOrder.setPreferentialDiscAmount(preferentialDiscAmount);
        saleOrder.setTemporaryDiscAmount(temporaryDiscAmount);
        saleOrder.setCouponDiscAmount(couponDiscountAmount);
        saleOrder.setNoDiscountValue(noDiscountValue);
        saleOrder.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(totalDiscountValue - noDiscountValue));
        saleOrder.setRealSaleValue(ManipulatePrecision.doubleConvert(saleValue - noDiscountValue));
        saleOrder.setQty(totalNum);
        double existPay = 0.0;
        if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
            for (Payment p : cacheModel.getPayments()) {
                existPay = ManipulatePrecision.doubleConvert(existPay + p.getMoney(), 2, 1);
            }
        }
        if (ManipulatePrecision.doubleCompare(existPay, saleOrder.getOughtPay(), 2) > 0) {
            saleOrder.setOughtPay(existPay);
            saleOrder.setRoundUpOverageValue(0.0);
            saleOrder.setRemainValue(0.0);
        } else {
            saleOrder.setRemainValue(saleOrder.getOughtPay());
            saleOrder.setRoundUpOverageValue(ManipulatePrecision.sub(oughtPay, realOughtPay));
        }
    }

    public Goods clearAllDicountonGoods(Goods saleGoodsDef) {
        saleGoodsDef.setCouponValue(0.0);
        saleGoodsDef.setAdjustDiscountValue(0.0);
        saleGoodsDef.setTotalDiscountValue(0.0);
        saleGoodsDef.setRealTotalDiscountValue(0.0);
        saleGoodsDef.setCustomDiscountValue(0.0);
        saleGoodsDef.setPayDiscountValue(0.0);
        saleGoodsDef.setTempZkDiscount(0.0);
        saleGoodsDef.setTempZrDiscount(0.0);
        saleGoodsDef.setTempZzkDiscount(0.0);
        saleGoodsDef.setTempZzrDiscount(0.0);
        saleGoodsDef.setBarcodeDiscount(0.0);
        saleGoodsDef.setFixedDiscountValue(0.0);
        saleGoodsDef.setDzcDiscountValue(0.0);
        return saleGoodsDef;
    }

    public Goods calcCustRebate(Goods saleGoodsDef) {
        return saleGoodsDef;
    }

    public Goods calcBatchRebate(Goods saleGoodsDef) {
        return saleGoodsDef;
    }

    public static double getZZK(Goods saleGoodsDef) {
        String precisionMode = DataExchageUtils.exchangePrecisionMode(saleGoodsDef.getPrcutMode());
        double totalDiscountAmount = ManipulatePrecision.getDetailOverFlow(saleGoodsDef.getCouponValue() + saleGoodsDef.getPopDiscountValue() + saleGoodsDef.getAdjustDiscountValue() + saleGoodsDef.getCustomDiscountValue() + saleGoodsDef.getPayDiscountValue() + saleGoodsDef.getMealDiscountValue(), precisionMode);
        return totalDiscountAmount;
    }

    public static double getNoPrcutZZK(Goods saleGoodsDef) {
        return ManipulatePrecision.doubleConvert(saleGoodsDef.getCouponValue() + saleGoodsDef.getPopDiscountValue() + saleGoodsDef.getAdjustDiscountValue() + saleGoodsDef.getCustomDiscountValue() + saleGoodsDef.getPayDiscountValue() + saleGoodsDef.getMealDiscountValue(), 2, 1);
    }

    public static double getAdjustDiscount(Goods saleGoodsDef) {
        String precisionMode = DataExchageUtils.exchangePrecisionMode(saleGoodsDef.getPrcutMode());
        double adjustDiscount = ManipulatePrecision.getDetailOverFlow(saleGoodsDef.getTempZkDiscount() + saleGoodsDef.getTempZrDiscount() + saleGoodsDef.getTempZzkDiscount() + saleGoodsDef.getTempZzrDiscount() + saleGoodsDef.getBarcodeDiscount() + saleGoodsDef.getFixedDiscountValue() + saleGoodsDef.getDzcDiscountValue(), precisionMode);
        return adjustDiscount;
    }

    public String getSysParaValue(String mktCode, String code) {
        return "";
    }

    public Goods goodsInfo2Goods(GoodsInfo goodsInfo, String yyyh, double quantity, double price, double allprice, boolean dzcm, double dzcmjgzk, double dzcmsl, double dzcmjg, String originalBarNo) {
        Goods goods = new Goods();
        goods.setAssistantId("");
        if (StringUtils.isNotBlank((String)yyyh)) {
            goods.setAssistantId(yyyh);
        }
        goods.setTempZkl(100.0);
        goods.setGoodsCode(goodsInfo.getGoodsCode());
        goods.setBarNo(goodsInfo.getBarNo());
        goods.setGoodsNo(originalBarNo);
        goods.setGoodsName(goodsInfo.getGoodsName());
        goods.setGoodsType(goodsInfo.getGoodsType());
        goods.setSaleSpec(goodsInfo.getSaleSpec());
        goods.setSaleUnit(goodsInfo.getPartsUnit());
        goods.setListPrice(goodsInfo.getSalePrice());
        goods.setSalePrice(goodsInfo.getSalePrice());
        goods.setRealSalePrice(goodsInfo.getSalePrice());
        goods.setQty(quantity);
        goods.setOrgCode(goodsInfo.getOrgCode());
        goods.setCategoryCode(goodsInfo.getCategoryCode());
        goods.setIsfresh(goodsInfo.getIsfresh());
        goods.setGoodsUid(goodsInfo.getGoodsUid());
        goods.setBrandCode(goodsInfo.getBrandCode());
        goods.setBrandName(goodsInfo.getBrandName());
        goods.setSaleUnit(goodsInfo.getPartsUnit());
        goods.setPartsNum(goodsInfo.getPartsNum());
        goods.setMemberPrice(goodsInfo.getMemberPrice());
        goods.setWholeSalePrice(goodsInfo.getWholeSalePrice());
        goods.setPcs(goodsInfo.getPcs());
        goods.setColdTransFlag(goodsInfo.getColdTransFlag());
        goods.setProcessFlag(goodsInfo.getProcessFlag());
        goods.setVenderCode(goodsInfo.getVenderCode());
        goods.setArtCode(goodsInfo.getArtCode());
        goods.setTempCategory(goodsInfo.getCategoryCode());
        goods.setTopCategoryCode(goodsInfo.getTopCategoryCode());
        goods.setTopCategoryName(goodsInfo.getTopCategoryName());
        if (goodsInfo.getEscaleFlag() == 0) {
            goods.setEscaleFlag("N");
        } else {
            goods.setEscaleFlag("Y");
        }
        if (dzcm) {
            goods.setEscaleFlag("Y");
        }
        goods.setMinDiscount(goodsInfo.getMinDiscount());
        goods.setMinSalePrice(goodsInfo.getMinSalePrice());
        goods.setRemark(goodsInfo.getRemark());
        goods.setImageUrl(goodsInfo.getImageUrl());
        goods.setEnFname(goodsInfo.getEnSname());
        goods.setPrcutMode(goodsInfo.getPrcutMode());
        if (null == goods.getPrcutMode() || "".equals(goods.getPrcutMode())) {
            goods.setPrcutMode("0");
        }
        goods.setCouponValue(0.0);
        goods.setPopDiscountValue(0.0);
        goods.setAdjustDiscountValue(0.0);
        goods.setTotalDiscountValue(0.0);
        goods.setRealTotalDiscountValue(0.0);
        goods.setCustomDiscountValue(0.0);
        goods.setPayDiscountValue(0.0);
        goods.setDzcDiscountValue(0.0);
        goods.setTempZkDiscount(0.0);
        goods.setTempZrDiscount(0.0);
        goods.setTempZzkDiscount(0.0);
        goods.setTempZzrDiscount(0.0);
        goods.setSsgid("" + goodsInfo.getSsgid());
        if (dzcm) {
            goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(allprice, goods.getPrcutMode()));
            goods.setFlag("1");
            goods.setDzcDiscountValue(dzcmjgzk);
            goods.setEWCCodeAmount(dzcmjg);
            goods.setEWCCodeNum(dzcmsl);
        } else {
            goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(goods.getSalePrice() * goods.getQty(), goods.getPrcutMode()));
        }
        goods.setSaleAmount(ManipulatePrecision.getDetailOverFlow(goods.getSaleValue() - goods.getTotalDiscountValue(), goods.getPrcutMode()));
        goods.setPopDetailsInfo(new ArrayList<PopDetail>());
        goods.setCouponGains(new ArrayList<CouponGain>());
        goods.setCouponUses(new ArrayList<CouponUse>());
        goods.setRecycleFee(goodsInfo.getRecycleFee());
        goods.setControlFlag(goodsInfo.getControlFlag());
        goods.setLicense(goodsInfo.getLicense());
        goods.setGoodsDesc(goodsInfo.getGoodsDesc());
        goods.setStallCode(goodsInfo.getStallCode());
        if (StringUtils.isNotBlank((String)goodsInfo.getSeason()) && !"0".equals(goodsInfo.getSeason())) {
            goods.setSeason(goodsInfo.getSeason());
        }
        goods.setGoodsStatus(goodsInfo.getGoodsStatus());
        goods.setGbmanamode(goodsInfo.getGbmanamode());
        goods.setPrtDuplFlag(goodsInfo.getPrtDuplFlag());
        return goods;
    }

    public double getConvertPrice(double jg, int precision) {
        return ManipulatePrecision.doubleConvert(jg, precision, 1);
    }

    public boolean checkFindGoodsAllowSale(GoodsInfo sg, double quantity, boolean isdzcm, double dzcmsl, double dzcmjg) {
        return !(isdzcm ? sg.getEscaleFlag() == 1 && dzcmsl > 0.0 && ManipulatePrecision.doubleCompare(ManipulatePrecision.doubleConvert(dzcmsl / sg.getPartsNum(), 4, 1), quantity, 4) != 0 : sg.getEscaleFlag() == 1);
    }

    protected CacheModel CalcResponsePopSingle(CacheModel cacheModel, CalcsingleOut promotionOut, int flowid) {
        try {
            if (null == promotionOut) {
                return null;
            }
            if (null == promotionOut.getCalcBillid() || null == promotionOut.getBillDetail().getSellDetails()) {
                return null;
            }
            if (null == cacheModel.getOrder().getSeqNo() || "".equals(cacheModel.getOrder().getSeqNo())) {
                cacheModel.getOrder().setSeqNo(promotionOut.getCalcBillid());
            }
            List<SellDetail> listGoods = null;
            if (null != promotionOut.getBillDetail() && null != promotionOut.getBillDetail().getSellDetails()) {
                listGoods = promotionOut.getBillDetail().getSellDetails();
            }
            Goods sg = cacheModel.getGoodsList().get(flowid - 1);
            Goods.transferGoods(listGoods.get(0), sg, promotionOut.getCalcResult(), cacheModel.getOrder().getSysPara().getCalcPriceType(), true, false, false);
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setRealSalePrice(ManipulatePrecision.doubleConvert(sg.getSalePrice() - sg.getNoDisAmountValue() / sg.getQty()));
            if (PosLogicCompoment.getNoPrcutZZK(sg) != sg.getTotalDiscountValue()) {
                PopDetail tempPop = new PopDetail();
                double differenceAmout = ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - PosLogicCompoment.getNoPrcutZZK(sg), 2, 1);
                tempPop.setDiscountAmount(differenceAmout);
                tempPop.setPopMode("0");
                tempPop.setPopPolicyGroup(YPopStatusType.pop_policy_group_erpvip);
                tempPop.setPopPolicyType(YPopStatusType.pop_policy_group_erpvip);
                sg.getPopDetailsInfo().add(tempPop);
                sg.setPopDiscountValue(ManipulatePrecision.doubleConvert(sg.getPopDiscountValue() + differenceAmout, 2, 1));
            }
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            sg.setCalcMode(PosLogicCompoment.transSingleCalcMode(sg, cacheModel.getOrder().getCalcMarketingMode(), promotionOut.getCalcResult()));
            if (sg.getDisValue() > 0.0) {
                sg = PosLogicCompoment.calcGoodsBarcodeDiscAfterSingle(sg, sg.getDisMode(), sg.getDisValue(), sg.getDiscType());
            }
            cacheModel.getGoodsList().set(flowid - 1, sg);
            if (sg.getTempZkl() != 100.0) {
                cacheModel = PosLogicCompoment.CalcGoodsRebateByRate(cacheModel, flowid, cacheModel.getCurGrant().getGh(), sg.getTempZkl());
            }
            PosLogicCompoment.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected static CacheModel CalcResponsePopSingleAll(CacheModel cacheModel, CalcsingleOut promotionOut, boolean needCalcDisc) {
        try {
            if (null == promotionOut) {
                return null;
            }
            if (null == promotionOut.getCalcBillid() || null == promotionOut.getBillDetail().getSellDetails()) {
                return null;
            }
            cacheModel.getOrder().setSeqNo(promotionOut.getCalcBillid());
            List<SellDetail> listGoods = null;
            if (null != promotionOut.getBillDetail() && null != promotionOut.getBillDetail().getSellDetails()) {
                listGoods = promotionOut.getBillDetail().getSellDetails();
            }
            for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods sg = cacheModel.getGoodsList().get(i).deepClone();
                Goods.transferGoods(listGoods.get(i), sg, promotionOut.getCalcResult(), cacheModel.getOrder().getSysPara().getCalcPriceType(), true, false, false);
                double rate = sg.getTempZkl();
                double zrAmount = sg.getTempZrDiscount();
                sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setRealSalePrice(ManipulatePrecision.doubleConvert(sg.getSalePrice() - sg.getNoDisAmountValue() / sg.getQty()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
                if (PosLogicCompoment.getNoPrcutZZK(sg) != sg.getTotalDiscountValue()) {
                    PopDetail tempPop = new PopDetail();
                    double differenceAmout = ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - PosLogicCompoment.getNoPrcutZZK(sg), 2, 1);
                    tempPop.setDiscountAmount(differenceAmout);
                    tempPop.setPopMode("0");
                    tempPop.setPopPolicyGroup(YPopStatusType.pop_policy_group_erpvip);
                    tempPop.setPopPolicyType(YPopStatusType.pop_policy_group_erpvip);
                    sg.getPopDetailsInfo().add(tempPop);
                    sg.setPopDiscountValue(ManipulatePrecision.doubleConvert(sg.getPopDiscountValue() + differenceAmout, 2, 1));
                }
                sg.setCalcMode(PosLogicCompoment.transSingleCalcMode(sg, cacheModel.getOrder().getCalcMarketingMode(), promotionOut.getCalcResult()));
                if (sg.getDisValue() > 0.0) {
                    sg = PosLogicCompoment.calcGoodsBarcodeDiscAfterSingle(sg, sg.getDisMode(), sg.getDisValue(), sg.getDiscType());
                }
                cacheModel.getGoodsList().set(i, sg);
                if (!needCalcDisc) continue;
                if (rate < 100.0) {
                    cacheModel = PosLogicCompoment.CalcGoodsRebateByRate(cacheModel, sg.getFlowId(), cacheModel.getOrder().getTerminalOperatorAuthzCardNo(), rate);
                    continue;
                }
                if (!(zrAmount > 0.0)) continue;
                cacheModel = PosLogicCompoment.CalcGoodsRebateByAmount(cacheModel, sg.getFlowId(), cacheModel.getOrder().getTerminalOperatorAuthzCardNo(), zrAmount);
            }
            PosLogicCompoment.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected CacheModel CalcResponsePopOrder(CacheModel cacheModel, CalcOut promotionOut, String calcMode, boolean isCalcGifts, ServiceSession session) {
        try {
            double totalJf = 0.0;
            if (null == promotionOut) {
                cacheModel.setCalcResult(-1);
                return cacheModel;
            }
            int iRet = Convert.toInt(promotionOut.getCalcResult());
            if (isCalcGifts) {
                int i;
                if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
                    for (i = 0; i < cacheModel.getPayments().size(); ++i) {
                        if (!cacheModel.getPayments().get(i).getPayName().equals("\u652f\u4ed8\u6298\u6263")) continue;
                        cacheModel.getPayments().remove(i);
                        --i;
                    }
                }
                if (("0".equals(calcMode) || "2".equals(calcMode)) && null != promotionOut.getBillDetail() && null != promotionOut.getBillDetail().getSellPayments()) {
                    for (i = 0; i < promotionOut.getBillDetail().getSellPayments().size(); ++i) {
                        SellPayment p = promotionOut.getBillDetail().getSellPayments().get(i);
                        if (null == p) continue;
                        cacheModel.getPopPayments().add((SellPayment)p.clone());
                        Payment pay = new Payment();
                        pay = Payment.SellPaymentToPayment(p, pay);
                        pay.setRowno(cacheModel.getTempSalePayments().size() + 1);
                        cacheModel.getTempSalePayments().add(pay);
                    }
                }
            }
            if (null == cacheModel.getGiftsGroup()) {
                cacheModel.setGiftsGroup(new ArrayList<GiftsGroup>());
            }
            List<GiftsGroup> giftGroupList = cacheModel.getGiftsGroup();
            boolean isNeedOutGiftsInfo = true;
            if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOutSideGiftsInfo())) {
                isNeedOutGiftsInfo = false;
            }
            if (null != promotionOut.getGifts() && promotionOut.getGifts().size() > 0) {
                giftGroupList = new ArrayList<GiftsGroup>();
                for (int i = 0; i < promotionOut.getGifts().size(); ++i) {
                    Gift gift = null;
                    gift = Gift.transferGift(promotionOut.getGifts().get(i));
                    if (null == gift || "2".equals(gift.getMode())) continue;
                    if (null == gift.getExtjjg() || !gift.getExtjjg().equals("Y") && !gift.getExtjjg().equals("M")) {
                        if (giftGroupList.size() == 0) {
                            GiftsGroup giftGroup = new GiftsGroup();
                            giftGroup.setGiftGroup(new ArrayList<Gift>());
                            giftGroup.getGiftGroup().add(gift);
                            giftGroup.setGroupId(1);
                            giftGroupList.add(giftGroup);
                            continue;
                        }
                        boolean isOld = false;
                        for (int j = 0; j < giftGroupList.size(); ++j) {
                            Gift existGift = giftGroupList.get(j).getGiftGroup().get(0);
                            if (!(existGift.getGroup() + existGift.getGroupSelect()).equals(gift.getGroup() + gift.getGroupSelect())) continue;
                            giftGroupList.get(j).getGiftGroup().add(gift);
                            isOld = true;
                            break;
                        }
                        if (isOld) continue;
                        GiftsGroup giftGroup = new GiftsGroup();
                        giftGroup.setGiftGroup(new ArrayList<Gift>());
                        giftGroup.getGiftGroup().add(gift);
                        giftGroup.setGroupId(giftGroupList.size() + 1);
                        giftGroupList.add(giftGroup);
                        continue;
                    }
                    if (!gift.getExtjjg().equals("Y") || !isNeedOutGiftsInfo) continue;
                    String outSideGiftsInfo = "";
                    if (null != cacheModel.getOrder().getOutSideGiftsInfo()) {
                        outSideGiftsInfo = cacheModel.getOrder().getOutSideGiftsInfo();
                    }
                    if (gift.getMode().equals("0")) {
                        double qty;
                        double d = qty = gift.getLimitQty() > gift.getMaxQty() ? gift.getMaxQty() : gift.getLimitQty();
                        outSideGiftsInfo = outSideGiftsInfo.length() == 0 ? "\u672c\u7b14\u6709\u573a\u5916\u6ee1\u8d60," + gift.getName() + ",\u6570\u91cf" + qty : outSideGiftsInfo + "|\u672c\u7b14\u6709\u573a\u5916\u6ee1\u8d60," + gift.getName() + ",\u6570\u91cf" + qty;
                    } else if (gift.getMode().equals("1")) {
                        outSideGiftsInfo = outSideGiftsInfo.length() == 0 ? "\u672c\u7b14\u6709\u573a\u5916\u6362\u8d2d,\u89c4\u5219:" + gift.getName() : outSideGiftsInfo + "|\u672c\u7b14\u6709\u573a\u5916\u6362\u8d2d,\u89c4\u5219:" + gift.getName();
                    }
                    cacheModel.getOrder().setOutSideGiftsInfo(outSideGiftsInfo);
                }
                cacheModel.setGiftsGroup(giftGroupList);
            }
            if (null != promotionOut.getExceptPays()) {
                for (int i = 0; i < promotionOut.getExceptPays().size(); ++i) {
                    SellExceptPay exceptPay = promotionOut.getExceptPays().get(i);
                    String excepttype = this.getResultType(exceptPay);
                    if (YPopStatusType.order_pay_except.equals(excepttype)) {
                        String exceptPayCode = exceptPay.getPayCode();
                        boolean flag = true;
                        for (String paycode : cacheModel.getLimitedPayCodes()) {
                            if (!paycode.equals(exceptPayCode)) continue;
                            flag = false;
                            break;
                        }
                        if (!flag || !isCalcGifts) continue;
                        cacheModel.getLimitedPayDetails().add(ExceptPay.transferExceptPay(promotionOut.getExceptPays().get(i)));
                        cacheModel.getLimitedPayCodes().add(exceptPay.getPayCode());
                        continue;
                    }
                    if (!YPopStatusType.order_pay_zszk.equals(excepttype)) continue;
                    cacheModel.getExceptPayDetails().add(ExceptPay.transferExceptPay(promotionOut.getExceptPays().get(i)));
                }
            }
            if (null != promotionOut.getBillDetail()) {
                cacheModel.setGoodsList(this.refreshGoodsList(cacheModel.getGoodsList(), promotionOut.getBillDetail().getSellDetails(), promotionOut.getCalcResult(), cacheModel.getOrder().getSysPara().getCalcPriceType(), true, false));
            }
            boolean isdelete = false;
            if (!(!isCalcGifts || iRet != 0 || null != cacheModel.getGiftsGroup() && cacheModel.getGiftsGroup().size() != 0 || null != cacheModel.getExceptPayDetails() && cacheModel.getExceptPayDetails().size() != 0)) {
                int i;
                for (i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                    Goods sg = cacheModel.getGoodsList().get(i);
                    if (null == sg.getYhmiscanuse() || !sg.getYhmiscanuse().equals("N")) continue;
                    for (int j = 0; j < cacheModel.getPayments().size(); ++j) {
                        Payment sp = cacheModel.getPayments().get(j);
                        if (null == sp.getCouponType() || !sp.getCouponType().equals(sg.getGoodsCode())) continue;
                        cacheModel.getPayments().remove(j);
                    }
                    cacheModel.getGoodsList().remove(i);
                    --i;
                    isdelete = true;
                }
                if (isdelete) {
                    iRet = -999;
                    cacheModel.setCalcResult(iRet);
                    PosLogicCompoment.calcOrderAmount(cacheModel);
                    return cacheModel;
                }
                if (!(null == cacheModel.getTempSalePayments() || cacheModel.getTempSalePayments().size() <= 0 || calcMode.equals("5") || "6".equals(calcMode) || "7".equals(calcMode))) {
                    for (i = 0; i < cacheModel.getTempSalePayments().size(); ++i) {
                        Payment sp = cacheModel.getTempSalePayments().get(i);
                        if (null != sp.getPayName() && (sp.getPayName().startsWith("\u5370\u82b1\u5238") || sp.getPayName().startsWith("\u652f\u4ed8\u6298\u6263") || PosLogicCompoment.IsLimitedPayCode(sp.getPayCode(), cacheModel.getLimitedPayCodes()))) continue;
                        if ("2".equalsIgnoreCase(sp.getPopFlag())) {
                            sp.setPuid(UUIDUtils.buildPuid());
                            sp.setTerminalSno(cacheModel.getOrder().getTerminalSno());
                            sp.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                            sp.setIsAutoDelOnly(true);
                            sp.setFlag("1");
                            sp.setRowno(cacheModel.getPayments().size() + 1);
                            cacheModel.getPayments().add(sp);
                            continue;
                        }
                        if (!"0".equalsIgnoreCase(sp.getPopFlag())) continue;
                        sp.setPuid(UUIDUtils.buildPuid());
                        sp.setTerminalSno(cacheModel.getOrder().getTerminalSno());
                        sp.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                        sp.setIsAutoDelOnly(true);
                        sp.setFlag("1");
                        sp.setRowno(cacheModel.getPayments().size() + 1);
                        cacheModel.getPayments().add(sp);
                    }
                }
            }
            cacheModel.setCalcResult(iRet);
            PosLogicCompoment.calcOrderAmount(cacheModel);
            PosLogicCompoment.calcPayBalance(cacheModel);
            return cacheModel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            cacheModel.setCalcResult(-1);
            return cacheModel;
        }
    }

    protected CacheModel CalcOrderAfterCheckReturnMode0(CacheModel cacheModel, CalSaleReturnOut promotionOut, String noYpopCodes, ServiceSession session) {
        Goods sg;
        SellDetail g;
        int i;
        if (null == promotionOut) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u9000\u8d27\u6263\u56de\u65e0\u6570\u636e");
            return cacheModel;
        }
        if (null == promotionOut.getBillDetail() || null == promotionOut.getBillDetail().getSellDetails()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u9000\u8d27\u6263\u56de\u65e0\u8ba2\u5355\u6570\u636e");
            return cacheModel;
        }
        cacheModel.clearOrderlist();
        cacheModel.setRemainRefundAmount(0.0);
        int inNum = cacheModel.getGoodsList().size();
        int outNum = promotionOut.getBillDetail().getSellDetails().size();
        for (i = 0; i < inNum; ++i) {
            g = promotionOut.getBillDetail().getSellDetails().get(i);
            sg = cacheModel.getGoodsList().get(i);
            sg = Goods.transferGoods(g, sg, "0", cacheModel.getOrder().getSysPara().getCalcPriceType(), true, true, true);
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setRealSalePrice(ManipulatePrecision.doubleConvert(sg.getSalePrice() - sg.getNoDisAmountValue() / sg.getQty()));
            cacheModel.getGoodsList().set(i, sg);
        }
        PosLogicCompoment.calcOrderAmount(cacheModel);
        if (outNum > inNum) {
            for (i = inNum; i < outNum; ++i) {
                g = promotionOut.getBillDetail().getSellDetails().get(i);
                sg = Goods.BillDetailToRefundGiftGoods(g, cacheModel.getOrder().getPrecisionMode());
                sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
                cacheModel.getRefundGiftList().add(sg);
            }
        }
        if ((null == promotionOut.getBillDetail().getSellPayments() || promotionOut.getBillDetail().getSellPayments().size() <= 0) && cacheModel.getRefundGiftList().size() <= 0) {
            cacheModel.setCalcResult(0);
            return cacheModel;
        }
        if (cacheModel.getTempSalePayments().size() > 0) {
            cacheModel.getTempSalePayments().clear();
        }
        if (cacheModel.getPopPayments().size() > 0) {
            cacheModel.getPopPayments().clear();
        }
        if (cacheModel.getPayments().size() > 0) {
            cacheModel.getPayments().clear();
        }
        double remainRefundAmount = 0.0;
        remainRefundAmount = ManipulatePrecision.doubleConvert(promotionOut.getBillDetail().getDeduct() + promotionOut.getBillDetail().getRefund() + promotionOut.getBillDetail().getCompensate(), 2, 1);
        cacheModel.setRemainRefundAmount(remainRefundAmount);
        RemovePayIn removePayIn = new RemovePayIn();
        ArrayList<String> rowNoIdList = new ArrayList<String>();
        for (int i2 = 0; i2 < promotionOut.getBillDetail().getSellPayments().size(); ++i2) {
            Payment p;
            SellPayment sellPayment = promotionOut.getBillDetail().getSellPayments().get(i2);
            SellPayment pays = (SellPayment)sellPayment.clone();
            cacheModel.getPopPayments().add(pays);
            Payment porg = Payment.transferPayment(pays);
            if (!porg.getPayCode().equals("0706")) {
                cacheModel.getTempSalePayments().add(porg);
            }
            if (null == (p = (Payment)porg.clone()).getPayNo()) {
                p.setPayNo("");
            }
            p.setFlag("1");
            p.setPaymentSource("NY");
            p.setRowno(cacheModel.getPayments().size() + 1);
            p.setIsAutoDelOnly(true);
            p.setIsDirectDel(false);
            if (p.getPayCode().equals("0706")) {
                removePayIn.setCalcBillid(promotionOut.getCalcBilid());
                removePayIn.setChannelId(cacheModel.getOrder().getChannel());
                rowNoIdList.add(p.getRownoId());
                continue;
            }
            cacheModel.getPayments().add(p);
        }
        PosLogicCompoment.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    protected CacheModel CalcOrderAfterCheckReturnMode2(CacheModel cacheModel, String autoBackPayCode, String thMode) {
        PosLogicCompoment.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    protected CacheModel CalcOrderAfterAffirmReturn(CacheModel cacheModel, ConfirmAffirmreturnOut promotionOut) {
        try {
            int i;
            if (null == promotionOut || null == promotionOut.getBillDetail() || null == promotionOut.getBillDetail().getSellDetails()) {
                cacheModel.setErrMsg("\u8fd4\u56de\u6570\u636e\u4e0d\u5408\u6cd5");
                cacheModel.setCalcResult(-1);
            }
            List<SellDetail> listGoods = null;
            listGoods = promotionOut.getBillDetail().getSellDetails();
            if (null != listGoods) {
                for (i = 0; i < listGoods.size(); ++i) {
                    SellDetail g = listGoods.get(i);
                    Goods sg = cacheModel.getGoodsList().get(i);
                    boolean needYpopzke = false;
                    if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginIdSheetNo())) {
                        needYpopzke = true;
                    }
                    sg = Goods.transferGoods(g, sg, "0", cacheModel.getOrder().getSysPara().getCalcPriceType(), needYpopzke, false, true);
                    sg.setCalcMode(PosLogicCompoment.transSingleCalcMode(sg, cacheModel.getOrder().getCalcMarketingMode(), "0"));
                    sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
                    sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
                    sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                    sg.setRealSalePrice(ManipulatePrecision.doubleConvert(sg.getSalePrice() - sg.getNoDisAmountValue() / sg.getQty()));
                }
            }
            if (null != promotionOut.getBillDetail().getSellPayments()) {
                Payment sp;
                int j;
                SellPayment p;
                for (i = 0; i < cacheModel.getPayments().size(); ++i) {
                    Payment sp2 = cacheModel.getPayments().get(i);
                    if (null == sp2 || null == sp2.getPaymentSource() || sp2.getPaymentSource().length() < 3 || sp2.getPaymentSource().charAt(2) != 'Y' || promotionOut.getBillDetail().getSellPayments().size() < sp2.getPromotionRetrunRowNo() || null != sp2.getRownoId() && !"".equals(sp2.getRownoId())) continue;
                    SellPayment p2 = promotionOut.getBillDetail().getSellPayments().get(sp2.getPromotionRetrunRowNo());
                    if (!sp2.getPayCode().equals(p2.getPaycode()) || sp2.getPromotionRetrunRowNo() != p2.getRowNo()) continue;
                    sp2.setRownoId(p2.getRowNoId());
                    cacheModel.getPayments().set(i, sp2);
                }
                for (i = 0; i < promotionOut.getBillDetail().getSellPayments().size(); ++i) {
                    p = promotionOut.getBillDetail().getSellPayments().get(i);
                    boolean isUsed = false;
                    for (j = 0; j < cacheModel.getPayments().size(); ++j) {
                        sp = cacheModel.getPayments().get(j);
                        if (StringUtils.isNotBlank((String)sp.getRownoId())) {
                            if (!sp.getRownoId().equals(p.getRowNoId())) continue;
                            isUsed = true;
                            break;
                        }
                        if (!sp.getPayCode().equals(p.getPaycode()) || !sp.getPayType().equals(p.getPayType()) || null != sp.getRownoId() && !"".equals(sp.getRownoId()) || !StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) continue;
                        sp.setRownoId(p.getRowNoId());
                        isUsed = true;
                        break;
                    }
                    if (!isUsed) continue;
                }
                for (i = 0; i < promotionOut.getBillDetail().getSellPayments().size(); ++i) {
                    p = promotionOut.getBillDetail().getSellPayments().get(i);
                    boolean isUsed = false;
                    for (j = 0; j < cacheModel.getTempSalePayments().size(); ++j) {
                        sp = cacheModel.getTempSalePayments().get(j);
                        if (StringUtils.isNotBlank((String)sp.getRownoId())) {
                            if (!sp.getRownoId().equals(p.getRowNoId())) continue;
                            isUsed = true;
                            break;
                        }
                        if (!sp.getPayCode().equals(p.getPaycode()) || !sp.getPayType().equals(p.getPayType()) || !StringUtils.isNotBlank((String)sp.getRownoId()) || !StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) continue;
                        sp.setRownoId(p.getRowNoId());
                        isUsed = true;
                        break;
                    }
                    if (!isUsed) continue;
                }
            }
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.setErrMsg("\u8fd4\u56de\u6570\u636e\u4e0d\u5408\u6cd5");
            cacheModel.setCalcResult(-1);
            return cacheModel;
        }
    }

    public CacheModel CalcAdjustDiscAfterOrder(CacheModel cacheModel) {
        String ErrMsg = "";
        double tempZzk = cacheModel.getOrder().getTempZzk();
        double tempZzr = cacheModel.getOrder().getTempZzr();
        if (ManipulatePrecision.doubleCompare(tempZzk, 100.0, 2) != 0 && -1 == (cacheModel = PosLogicCompoment.CalcOrderRebateByRate(cacheModel, cacheModel.getCurGrant().getGh(), tempZzk)).getCalcResult()) {
            ErrMsg = ErrMsg + cacheModel.getErrMsg() + "|";
        }
        if (ManipulatePrecision.doubleCompare(tempZzr, 0.0, 2) > 0) {
            double discountAMount = tempZzr;
            if (discountAMount > cacheModel.getOrder().getOughtPay() - cacheModel.getOrder().getExistPay()) {
                discountAMount = ManipulatePrecision.getDetailOverFlow(cacheModel.getOrder().getOughtPay() - cacheModel.getOrder().getExistPay(), "B");
            }
            if (-1 == (cacheModel = PosLogicCompoment.CalcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), discountAMount)).getCalcResult()) {
                ErrMsg = ErrMsg + cacheModel.getErrMsg() + "|";
            }
        }
        cacheModel.setCalcResult(0);
        cacheModel.setErrMsg(ErrMsg);
        return cacheModel;
    }

    protected CacheModel CalcAdjustDiscAfterOrder(CacheModel cacheModel, String couponCode, String memoStr) {
        ArrayList<Integer> matchRows = new ArrayList<Integer>();
        double discountAmount = 0.0;
        double matchAmount = 0.0;
        double maxMatchAmount = 0.0;
        int maxMatchRow = 0;
        String[] couponInfo = memoStr.split(",");
        double purchaseAmount = Double.valueOf(couponInfo[0].split("@")[0]);
        double memberPurchaseAmount = Double.valueOf(couponInfo[0].split("@")[1]);
        String couponType = couponInfo[1];
        double discountValue = Double.valueOf(couponInfo[2].split("@")[0]);
        double memberDiscountValue = Double.valueOf(couponInfo[2].split("@")[1]);
        String popDescribe = couponInfo[3];
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            boolean isHaveCouponPop = false;
            double tempCouponAmount = 0.0;
            if ("98".equals(sg.getGoodsType()) || "99".equals(sg.getGoodsType()) || null == sg.getTempPopDetails() || sg.getTempPopDetails().size() == 0) continue;
            for (int j = 0; j < sg.getTempPopDetails().size(); ++j) {
                PopDetail pop = sg.getTempPopDetails().get(j);
                if (!YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup()) || !couponCode.equals(pop.getPopMemo())) continue;
                tempCouponAmount = ManipulatePrecision.getDetailOverFlow(tempCouponAmount + pop.getDiscountAmount(), "0");
                isHaveCouponPop = true;
                sg.getTempPopDetails().remove(j);
                --j;
                break;
            }
            if (!isHaveCouponPop) continue;
            matchRows.add(i);
            matchAmount = ManipulatePrecision.getDetailOverFlow(matchAmount + sg.getSaleAmount(), "0");
            if (!(sg.getSaleAmount() > maxMatchAmount)) continue;
            maxMatchAmount = sg.getSaleAmount();
            maxMatchRow = i;
        }
        LOGGER.info("\u7528\u5238\u95e8\u574e\u3010{}\u3011,\u5339\u914d\u91d1\u989d\u3010{}\u3011", (Object)memberPurchaseAmount, (Object)matchAmount);
        boolean isHaveCust = false;
        isHaveCust = null != cacheModel.getOrder().getConsumersData() && !StringUtils.isNotBlank((String)cacheModel.getOrder().getConsumersData().getConsumersType());
        if (isHaveCust) {
            if (matchAmount < memberPurchaseAmount) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8d2d\u4e70\u5546\u54c1\u672a\u8fbe\u5230\u5238" + couponCode + "\u4f18\u60e0\u6761\u4ef6,\u8fd8\u5dee" + ManipulatePrecision.getDetailOverFlow(memberPurchaseAmount - matchAmount, "0") + "\u5143");
                return cacheModel;
            }
        } else if (matchAmount < purchaseAmount) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8d2d\u4e70\u5546\u54c1\u672a\u8fbe\u5230\u5238" + couponCode + "\u4f18\u60e0\u6761\u4ef6,\u8fd8\u5dee" + ManipulatePrecision.getDetailOverFlow(purchaseAmount - matchAmount, "0") + "\u5143");
            return cacheModel;
        }
        if ("A".equals(couponType)) {
            discountAmount = isHaveCust ? memberDiscountValue : discountValue;
            if (discountAmount > matchAmount) {
                discountAmount = matchAmount;
            }
        } else {
            if (isHaveCust) {
                discountValue = memberDiscountValue;
            }
            discountAmount = ManipulatePrecision.getDetailOverFlow(matchAmount * discountValue / 100.0, "B");
        }
        if (discountAmount <= 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5238" + couponCode + "\u4f18\u60e0\u91d1\u989d\u4e3a0");
            return cacheModel;
        }
        if (discountAmount > cacheModel.getOrder().getOughtPay() - cacheModel.getOrder().getExistPay()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5238" + couponCode + "\u65e0\u6cd5\u4f7f\u7528");
            return cacheModel;
        }
        double lastDiscountAmount = discountAmount;
        Iterator tempCouponAmount = matchRows.iterator();
        while (tempCouponAmount.hasNext()) {
            int matchRow = (Integer)tempCouponAmount.next();
            if (matchRow == maxMatchRow) continue;
            int i = matchRow;
            Goods g = cacheModel.getGoodsList().get(i);
            double yhAmount = ManipulatePrecision.getDetailOverFlow(discountAmount * g.getSaleAmount() / matchAmount, "B");
            g.setPopDiscountValue(ManipulatePrecision.getDetailOverFlow(g.getPopDiscountValue() + yhAmount, "B"));
            lastDiscountAmount -= yhAmount;
            g.setTotalDiscountValue(PosLogicCompoment.getZZK(g));
            g.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() - g.getNoDisAmountValue()));
            g.setSaleAmount(g.getSaleValue() - g.getTotalDiscountValue());
            PopDetail pop = new PopDetail();
            pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
            pop.setPopDescribe(popDescribe);
            pop.setPopMemo(couponCode);
            pop.setDiscountAmount(yhAmount);
            pop.setPopMode("0");
            g.getPopDetailsInfo().add(pop);
        }
        if (lastDiscountAmount > 0.0) {
            Goods g = cacheModel.getGoodsList().get(maxMatchRow);
            lastDiscountAmount = ManipulatePrecision.doubleConvert(lastDiscountAmount, 2, 1);
            g.setPopDiscountValue(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() + lastDiscountAmount, 2, 1));
            g.setTotalDiscountValue(PosLogicCompoment.getZZK(g));
            g.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() - g.getNoDisAmountValue()));
            g.setSaleAmount(g.getSaleValue() - g.getTotalDiscountValue());
            PopDetail pop = new PopDetail();
            pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
            pop.setPopDescribe(popDescribe);
            pop.setPopMemo(couponCode);
            pop.setDiscountAmount(lastDiscountAmount);
            pop.setPopMode("0");
            g.getPopDetailsInfo().add(pop);
        }
        PosLogicCompoment.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    public static String transSingleCalcMode(Goods good, String calcModeIn, String calcModeOut) {
        block5: {
            try {
                if (null != good) {
                    if (ManipulateStr.readIndexChar(calcModeIn, 0) == '1' && ManipulateStr.readIndexChar(calcModeOut, 0) == '0') {
                        return "1";
                    }
                    if (!"0".equals(good.getCalcMode()) && !"1".equals(good.getCalcMode())) {
                        return "0";
                    }
                    break block5;
                }
                return "0";
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "0";
    }

    private static String getSingleCalcMode(CacheModel cacheModel, int goodsIndex, String cmdtype) {
        String calcMode = "0";
        if (YPopStatusType.cmdtype_calcsinglepop.equalsIgnoreCase(cmdtype)) {
            if (null == cacheModel || null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() <= 0) {
                return "0";
            }
            if (goodsIndex >= 0) {
                return String.valueOf(cacheModel.getGoodsList().get(goodsIndex - 1).getCalcMode());
            }
            for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods g = cacheModel.getGoodsList().get(i);
                if (null == g || !"1".equals(g.getCalcMode())) continue;
                return "1";
            }
        } else {
            if (YPopStatusType.cmdtype_calcorderpop.equalsIgnoreCase(cmdtype)) {
                if (null != cacheModel.getTempSalePayments() && cacheModel.getTempSalePayments().size() > 0) {
                    cacheModel.getOrder().setCalcMarketingMode("3");
                    return "3";
                }
                if (StringUtils.isBlank((String)cacheModel.getErrCode())) {
                    return "0";
                }
                return cacheModel.getOrder().getCalcMarketingMode();
            }
            if (YPopStatusType.cmdtype_ordersave.equalsIgnoreCase(cmdtype)) {
                return cacheModel.getOrder().getCalcMarketingMode();
            }
        }
        return calcMode;
    }

    public static double calcOrderOughtPay(double OughtPay, String precisionMode) {
        double saleyfje = ManipulatePrecision.getDetailOverFlow(OughtPay, precisionMode);
        return saleyfje;
    }

    protected List<Goods> refreshGoodsList(List<Goods> goodslist, List<SellDetail> sellDetails, String calcResult, List<String> noDisPopTypes, boolean needYpopzke, boolean needGrant) {
        if (null == sellDetails || sellDetails.size() <= 0) {
            return goodslist;
        }
        int j = 0;
        for (int i = 0; i < sellDetails.size(); ++i) {
            SellDetail popGoods;
            Goods sg;
            if (goodslist.size() <= i || (sg = Goods.transferGoods(popGoods = sellDetails.get(i), goodslist.get(i), calcResult, noDisPopTypes, needYpopzke, needGrant, false)) == null) continue;
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setRealSalePrice(ManipulatePrecision.doubleConvert(sg.getSalePrice() - sg.getNoDisAmountValue() / sg.getQty()));
            goodslist.set(j, sg);
            ++j;
        }
        return goodslist;
    }

    public static boolean IsLimitedPayCode(String payCode, List<String> limitedPayCodes) {
        if (null == payCode || null == limitedPayCodes || limitedPayCodes.size() <= 0) {
            return false;
        }
        for (int i = 0; i < limitedPayCodes.size(); ++i) {
            if (!payCode.equals(limitedPayCodes.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean IsExceptPayCode(String payCode, List<String> exceptPayCodes) {
        if (null == payCode || null == exceptPayCodes || exceptPayCodes.size() <= 0) {
            return false;
        }
        for (int i = 0; i < exceptPayCodes.size(); ++i) {
            if (!payCode.equals(exceptPayCodes.get(i))) continue;
            return true;
        }
        return false;
    }

    protected String getResultType(SellExceptPay except_pays) {
        if (except_pays == null) {
            return null;
        }
        if (YPopStatusType.order_pay_except.equalsIgnoreCase(except_pays.getMode())) {
            return YPopStatusType.order_pay_except;
        }
        if (YPopStatusType.order_pay_zszk.equalsIgnoreCase(except_pays.getMode())) {
            return YPopStatusType.order_pay_zszk;
        }
        return null;
    }

    public static CacheModel calcPayBalance(CacheModel cacheModel) {
        PosLogicCompoment.calcBalance(cacheModel);
        Order saleOrder = cacheModel.getOrder();
        double existPay = saleOrder.getExistPay();
        double balance = PosLogicCompoment.calcOrderOughtPay(saleOrder.getRemainValue(), cacheModel.getOrder().getPrecisionMode());
        if (ManipulatePrecision.doubleCompare(balance, 0.0, 2) == 0 && balance != saleOrder.getRemainValue()) {
            double overageValue = ManipulatePrecision.getDetailOverFlow(balance - saleOrder.getRemainValue() + saleOrder.getRoundUpOverageValue(), "9");
            boolean isMatchOverage = false;
            for (int i = cacheModel.getPayments().size() - 1; i >= 0; --i) {
                Payment pay = cacheModel.getPayments().get(i);
                if (!"Y".equals(pay.getIsOverage())) continue;
                pay.setOverage(overageValue);
                isMatchOverage = true;
                break;
            }
            if (!isMatchOverage) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8ba2\u5355\u652f\u4ed8\u884c\u4e0d\u652f\u6301\u627e\u96f6\u6216\u8005\u6ea2\u4f59.");
                return cacheModel;
            }
            PosLogicCompoment.calcBalance(cacheModel);
        }
        saleOrder.setExistPay(existPay);
        saleOrder.setRemainValue(balance);
        return cacheModel;
    }

    public static CacheModel calcBalance(CacheModel cacheModel) {
        PosLogicCompoment.calcOrderAmount(cacheModel);
        Order saleOrder = cacheModel.getOrder();
        List<Payment> payments = cacheModel.getPayments();
        double payAmount = 0.0;
        double overage = 0.0;
        for (Payment payment : payments) {
            if (!"1".equals(payment.getFlag())) continue;
            payAmount += payment.getMoney();
            overage += payment.getOverage();
        }
        double salezlexception = overage;
        double balance = saleOrder.getOughtPay() - payAmount - saleOrder.getRoundUpOverageValue() + overage;
        if (balance < 0.0) {
            balance = 0.0;
        }
        saleOrder.setExistPay(ManipulatePrecision.doubleConvert(payAmount, 2, 1));
        saleOrder.setOverageValue(salezlexception);
        saleOrder.setRemainValue(ManipulatePrecision.doubleConvert(balance, 2, 1));
        saleOrder.setChangeValue(0.0);
        cacheModel.setOrder(saleOrder);
        return cacheModel;
    }

    public static CacheModel calcPayAmout(CacheModel cacheModel, Payment payment) {
        cacheModel.setCalcResult(0);
        cacheModel = PosLogicCompoment.calcBalance(cacheModel);
        double amount = ManipulatePrecision.getMoneyByPrecision(payment.getAmount(), payment.getPrcutMode(), payment.getPrecision());
        payment.setAmount(amount);
        double balance = cacheModel.getOrder().getRemainValue();
        if (balance == 0.0 && ManipulatePrecision.getMoneyByPrecision(payment.getAmount() - balance, cacheModel.getPayMode().getRoundType(), cacheModel.getPayMode().getRoundPrecision()) > 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8ba2\u5355\u652f\u4ed8\u5df2\u7ecf\u8db3\u591f\uff0c\u4e0d\u9700\u8981\u518d\u652f\u4ed8");
            return cacheModel;
        }
        double money = ManipulatePrecision.mul(payment.getAmount(), payment.getRate(), 2);
        double changeValue = 0.0;
        double existPay = cacheModel.getOrder().getExistPay();
        double overage = cacheModel.getOrder().getOverageValue();
        LOGGER.info("money\u3010{}\u3011,balance\u3010{}\u3011,oughtPay\u3010{}\u3011,existPay\u3010{}\u3011", new Object[]{money, balance, cacheModel.getOrder().getOughtPay(), existPay});
        if (money - balance > 0.0) {
            double remainValue;
            String prcutMode = DataExchageUtils.exchangePrecisionMode(cacheModel.getPayMode().getRoundType());
            if (ManipulatePrecision.doubleCompare(ManipulatePrecision.getMoneyByPrecision(money - balance, prcutMode, cacheModel.getPayMode().getRoundPrecision()), 0.1, 2) >= 0 && "Y".equalsIgnoreCase(payment.getIsAllowCharge())) {
                changeValue = money - balance;
                Payment changePayment = PosLogicCompoment.createChangePayment(changeValue, payment, cacheModel);
                if (changePayment.getMoney() > cacheModel.getOrder().getSysPara().getMaxChangeValue()) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u627e\u96f6\u91d1\u989d[" + changePayment.getMoney() + "]\u8d85\u8fc7\u6700\u5927\u627e\u96f6\u91d1\u989d[" + cacheModel.getOrder().getSysPara().getMaxChangeValue() + "]");
                    return cacheModel;
                }
                if (changePayment.getMoney() > 0.0) {
                    cacheModel.getPayments().add(changePayment);
                    changeValue = changePayment.getMoney();
                }
                payment.setMoney(ManipulatePrecision.doubleConvert(money, 2, 1));
                double pOvrerage = ManipulatePrecision.sub(payment.getMoney(), balance + changeValue);
                payment.setOverage(ManipulatePrecision.getDetailOverFlow(pOvrerage, "0"));
                payment.setRoundUpOverageValue(ManipulatePrecision.sub(pOvrerage, payment.getOverage()));
                existPay = ManipulatePrecision.add(existPay, payment.getMoney());
                overage = ManipulatePrecision.add(overage, payment.getOverage());
                cacheModel.getPayments().add(payment);
                cacheModel.getOrder().setOverageValue(overage);
                remainValue = 0.0;
            } else if ("Y".equalsIgnoreCase(payment.getIsOverage())) {
                payment.setMoney(ManipulatePrecision.doubleConvert(money, 2, 1));
                double pOvrerage = ManipulatePrecision.sub(payment.getMoney(), cacheModel.getOrder().getOughtPay() - existPay);
                payment.setOverage(ManipulatePrecision.getDetailOverFlow(pOvrerage, "0"));
                payment.setRoundUpOverageValue(ManipulatePrecision.sub(pOvrerage, payment.getOverage()));
                changeValue = 0.0;
                remainValue = 0.0;
                cacheModel.getPayments().add(payment);
                existPay = ManipulatePrecision.add(existPay, payment.getMoney());
                overage = ManipulatePrecision.add(overage, payment.getOverage());
            } else {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8ba2\u5355\u652f\u4ed8\u884c\u4e0d\u652f\u6301\u627e\u96f6\u6216\u8005\u6ea2\u4f59");
                return cacheModel;
            }
            cacheModel.getOrder().setChangeValue(changeValue);
            cacheModel.getOrder().setRemainValue(remainValue);
            cacheModel.getOrder().setExistPay(PosLogicCompoment.calcOrderOughtPay(existPay, payment.getPrecision()));
            cacheModel.getOrder().setOverageValue(ManipulatePrecision.doubleConvert(overage += ManipulatePrecision.sub(cacheModel.getOrder().getExistPay(), existPay), 2, 1));
            if (ManipulatePrecision.doubleCompare(cacheModel.getOrder().getExistPay() - cacheModel.getOrder().getChangeValue(), cacheModel.getOrder().getOughtPay() + cacheModel.getOrder().getOverageValue(), 2) != 0) {
                cacheModel.getOrder().setPayOverageValue(cacheModel.getOrder().getExistPay() - cacheModel.getOrder().getChangeValue() - cacheModel.getOrder().getOughtPay() - cacheModel.getOrder().getOverageValue());
                cacheModel.getOrder().setOverageValue(cacheModel.getOrder().getExistPay() - cacheModel.getOrder().getChangeValue() - cacheModel.getOrder().getOughtPay());
            } else {
                cacheModel.getOrder().setPayOverageValue(0.0);
            }
        } else if (PosLogicCompoment.calcOrderOughtPay(money - balance, "0") < 0.0 && PosLogicCompoment.calcOrderOughtPay(balance - money, cacheModel.getOrder().getPrecisionMode()) == 0.0) {
            double remainValue = 0.0;
            changeValue = 0.0;
            payment.setMoney(ManipulatePrecision.doubleConvert(money, 2, 1));
            double poverage = ManipulatePrecision.sub(payment.getMoney(), balance);
            existPay += payment.getMoney();
            if ("Y".equalsIgnoreCase(payment.getIsOverage())) {
                payment.setOverage(ManipulatePrecision.getDetailOverFlow(poverage, "0"));
                payment.setRoundUpOverageValue(ManipulatePrecision.sub(poverage, payment.getOverage()));
                overage += payment.getOverage();
            } else {
                payment.setOverage(0.0);
                payment.setRoundUpOverageValue(0.0);
                boolean isOverageEnd = false;
                for (int i = cacheModel.getPayments().size() - 1; i >= 0; --i) {
                    Payment pay = cacheModel.getPayments().get(i);
                    if (!"Y".equals(pay.getIsOverage())) continue;
                    pay.setOverage(ManipulatePrecision.getDetailOverFlow(poverage, "0"));
                    pay.setRoundUpOverageValue(ManipulatePrecision.sub(poverage, pay.getOverage()));
                    overage += pay.getOverage();
                    isOverageEnd = true;
                    cacheModel.getPayments().set(i, pay);
                    break;
                }
                if (!isOverageEnd) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u8ba2\u5355\u652f\u4ed8\u884c\u4e0d\u652f\u6301\u6ea2\u4f59");
                    return cacheModel;
                }
            }
            cacheModel.getPayments().add(payment);
            cacheModel.getOrder().setExistPay(existPay);
            cacheModel.getOrder().setOverageValue(ManipulatePrecision.doubleConvert(overage, 2, 1));
            cacheModel.getOrder().setChangeValue(changeValue);
            cacheModel.getOrder().setRemainValue(remainValue);
            if (ManipulatePrecision.doubleCompare(cacheModel.getOrder().getExistPay() - cacheModel.getOrder().getChangeValue(), cacheModel.getOrder().getOughtPay() + cacheModel.getOrder().getOverageValue(), 2) != 0) {
                cacheModel.getOrder().setPayOverageValue(cacheModel.getOrder().getExistPay() - cacheModel.getOrder().getChangeValue() - cacheModel.getOrder().getOughtPay() - cacheModel.getOrder().getOverageValue());
                cacheModel.getOrder().setOverageValue(cacheModel.getOrder().getExistPay() - cacheModel.getOrder().getChangeValue() - cacheModel.getOrder().getOughtPay());
            } else {
                cacheModel.getOrder().setPayOverageValue(0.0);
            }
        } else {
            changeValue = 0.0;
            payment.setMoney(ManipulatePrecision.doubleConvert(money, 2, 1));
            payment.setOverage(0.0);
            payment.setRoundUpOverageValue(0.0);
            cacheModel.getPayments().add(payment);
            cacheModel = PosLogicCompoment.calcPayBalance(cacheModel);
            LOGGER.info("remainValue\u3010{}\u3011", (Object)cacheModel.getOrder().getRemainValue());
            if ("Y".equals(payment.getIsOverage()) && ManipulatePrecision.doubleCompare(cacheModel.getOrder().getRemainValue(), 0.0, 2) > 0 && ManipulatePrecision.doubleCompare(ManipulatePrecision.getMoneyByPrecision(cacheModel.getOrder().getRemainValue(), payment.getPrcutMode(), payment.getPrecision()), 0.0, 2) == 0) {
                LOGGER.info("setOverage");
                cacheModel.getPayments().get(cacheModel.getPayments().size() - 1).setOverage(-cacheModel.getOrder().getRemainValue());
                cacheModel = PosLogicCompoment.calcPayBalance(cacheModel);
            }
        }
        return cacheModel;
    }

    private static Payment createChangePayment(double changeValue, Payment payment, CacheModel cacheModel) {
        PayMode payMode = cacheModel.getPayMode();
        Payment p = new Payment();
        p.setFlag("2");
        p.setPuid(UUIDUtils.buildPuid());
        p.setRownoId(p.getPuid());
        p.setRowno(payment.getRowno() + 1);
        p.setRownoId("");
        p.setPayCode(payMode.getPayCode());
        p.setPayName(payMode.getPayName() + " \u627e\u96f6");
        p.setRate(payMode.getRate());
        p.setChargeRate(payMode.getRate());
        p.setTerminalNo(cacheModel.getOrder().getTerminalNo());
        p.setTerminalSno(cacheModel.getOrder().getTerminalSno());
        p.setPayType(payMode.getPayType());
        p.setPrcutMode(payMode.getRoundType());
        p.setPrecision(payMode.getRoundPrecision());
        String prcutMode = DataExchageUtils.exchangePrecisionMode(p.getPrcutMode());
        p.setAmount(ManipulatePrecision.getMoneyByPrecision(changeValue, prcutMode, p.getPrecision()));
        p.setMoney(ManipulatePrecision.getMoneyByPrecision(changeValue, prcutMode, p.getPrecision()));
        p.setOverage(0.0);
        p.setRoundUpOverageValue(0.0);
        return p;
    }

    public static CacheModel CalcDeletePay(CacheModel cacheModel) {
        List<Payment> payments = cacheModel.getPayments();
        PaymentForPos p = null;
        int zlRowNo = 0;
        int j = 1;
        for (int i = 0; i < payments.size(); ++i) {
            if (payments.get(i).getFlag().equals("2")) {
                p = payments.get(i);
                zlRowNo = i;
                continue;
            }
            payments.get(i).setRowno(j);
            ++j;
        }
        if (p == null) {
            PosLogicCompoment.calcPayBalance(cacheModel);
            return cacheModel;
        }
        payments.remove(zlRowNo);
        p.setFlag("1");
        ((Payment)p).setRowno(payments.size() + 1);
        cacheModel.setPayments(payments);
        cacheModel = PosLogicCompoment.calcPayBalance(cacheModel);
        PosLogicCompoment.calcPayBalance(cacheModel);
        return cacheModel;
    }

    public boolean isNoYpopPay(String noYpopPayCodes, String paycode) {
        if (StringUtils.isBlank((String)noYpopPayCodes)) {
            return false;
        }
        return noYpopPayCodes.contains(paycode);
    }

    public static boolean isNoYpopPay(List<String> limitedPayCodes, String paycode) {
        if (null == limitedPayCodes || limitedPayCodes.size() == 0) {
            return false;
        }
        for (String str : limitedPayCodes) {
            if (!str.equals(paycode)) continue;
            return true;
        }
        return false;
    }

    public List<Payment> getCouponPayments(List<Payment> payments) {
        if (null == payments || payments.size() == 0) {
            return null;
        }
        ArrayList<Payment> list = new ArrayList<Payment>();
        for (Payment payment : payments) {
            if (!"Y".equalsIgnoreCase(payment.getIsCoupon())) continue;
            list.add(payment);
        }
        return list;
    }

    public boolean checkBalance(CacheModel cacheModel) {
        Order saleOrder = cacheModel.getOrder();
        List<Goods> goodsList = cacheModel.getGoodsList();
        if (saleOrder.getSaleValue() == 0.0) {
            saleOrder.setSaleValue(ManipulatePrecision.doubleConvert(saleOrder.getOughtPay() + saleOrder.getTotalDiscountValue(), 2, 1));
        }
        if (ManipulatePrecision.doubleCompare(saleOrder.getOughtPay(), PosLogicCompoment.calcOrderOughtPay(saleOrder.getSaleValue() - saleOrder.getTotalDiscountValue(), saleOrder.getPrecisionMode()), 2) != 0) {
            cacheModel.setErrMsg("\u4ea4\u6613\u4e3b\u5355\u6570\u636e\u76f8\u4e92\u4e0d\u5e73!\n\n\u5e94\u6536\u91d1\u989d = " + ManipulatePrecision.doubleToString(saleOrder.getOughtPay()) + "\n\u5408\u8ba1\u91d1\u989d - \u5408\u8ba1\u6298\u6263 = " + PosLogicCompoment.calcOrderOughtPay(saleOrder.getSaleValue() - saleOrder.getTotalDiscountValue(), saleOrder.getPrecisionMode()));
            return false;
        }
        if (ManipulatePrecision.doubleCompare(saleOrder.getTotalDiscountValue(), saleOrder.getPreferentialDiscAmount() + saleOrder.getMemberDiscAmount() + saleOrder.getTemporaryDiscAmount() + saleOrder.getCouponDiscAmount(), 2) != 0) {
            cacheModel.setErrMsg("\u4ea4\u6613\u4e3b\u5355\u6570\u636e\u76f8\u4e92\u4e0d\u5e73!\n\n\u5408\u8ba1\u6298\u6263 = " + ManipulatePrecision.doubleToString(saleOrder.getTotalDiscountValue()) + "\n\u6298\u6263\u660e\u7ec6  = " + ManipulatePrecision.doubleToString(saleOrder.getPreferentialDiscAmount() + saleOrder.getMemberDiscAmount() + saleOrder.getTemporaryDiscAmount()));
            return false;
        }
        double amount = 0.0;
        for (int i = 0; i < goodsList.size(); ++i) {
            Goods goods = goodsList.get(i);
            if ("0".equals(goods.getFlag())) continue;
            if (goods.getQty() == 0.0 || goods.getQty() < 0.0) {
                cacheModel.setErrMsg("\u7b2c" + (i + 1) + "\u884c\u5546\u54c1 [" + goods.getGoodsCode() + "] \u6570\u91cf\u4e0d\u5408\u6cd5\n\u8bf7\u4fee\u6539\u6b64\u884c\u5546\u54c1\u6570\u91cf\u6216\u8005\u5220\u9664\u6b64\u5546\u54c1\u540e\u91cd\u65b0\u5f55\u5165");
                return false;
            }
            amount += ManipulatePrecision.doubleConvert(goods.getSaleAmount(), 2, 1);
        }
        amount = PosLogicCompoment.calcOrderOughtPay(amount, saleOrder.getPrecisionMode());
        if (ManipulatePrecision.doubleCompare(saleOrder.getOughtPay(), amount, 2) != 0) {
            cacheModel.setErrMsg("\u4ea4\u6613\u4e3b\u5355\u548c\u5546\u54c1\u660e\u7ec6\u4e0d\u5e73!\n\n\u4e3b\u5355\u5e94\u6536\u91d1\u989d  = " + ManipulatePrecision.doubleToString(saleOrder.getOughtPay()) + "\n\u5546\u54c1\u5408\u8ba1\u91d1\u989d  = " + ManipulatePrecision.doubleToString(amount));
            return false;
        }
        return true;
    }

    public boolean checkOrder(CacheModel cacheModel) {
        Order saleOrder = cacheModel.getOrder();
        List<Payment> payments = cacheModel.getPayments();
        if (saleOrder.getSaleValue() == 0.0) {
            saleOrder.setSaleValue(ManipulatePrecision.doubleConvert(saleOrder.getOughtPay() + saleOrder.getTotalDiscountValue(), 2, 1));
        }
        if (payments.size() > 0 && ManipulatePrecision.doubleCompare(saleOrder.getExistPay() - saleOrder.getChangeValue(), saleOrder.getOughtPay() - saleOrder.getRoundUpOverageValue() + saleOrder.getOverageValue(), 2) != 0) {
            cacheModel.setErrMsg("\u4ea4\u6613\u4e3b\u5355\u6570\u636e\u76f8\u4e92\u4e0d\u5e73!\n\n\u5b9e\u9645\u4ed8\u6b3e - \u627e\u96f6  = " + ManipulatePrecision.doubleToString(saleOrder.getExistPay() - saleOrder.getChangeValue()) + "\n\u5e94\u6536\u91d1\u989d + \u635f\u6ea2   = " + ManipulatePrecision.doubleToString(saleOrder.getOughtPay() - saleOrder.getRoundUpOverageValue() + saleOrder.getOverageValue()));
            return false;
        }
        double amount = 0.0;
        double changeValue = 0.0;
        for (int i = 0; i < payments.size(); ++i) {
            Payment payment = payments.get(i);
            if ("2".equals(payment.getFlag())) {
                changeValue += payment.getMoney();
                continue;
            }
            if ("3".equals(payment.getFlag())) continue;
            amount += payment.getMoney();
        }
        if (ManipulatePrecision.doubleCompare(PosLogicCompoment.calcOrderOughtPay(saleOrder.getExistPay(), saleOrder.getPrecisionMode()), PosLogicCompoment.calcOrderOughtPay(amount, saleOrder.getPrecisionMode()), 2) != 0) {
            cacheModel.setErrMsg("\u4ea4\u6613\u4e3b\u5355\u548c\u4ed8\u6b3e\u660e\u7ec6\u4e0d\u5e73!\n\n\u4e3b\u5355\u5b9e\u9645\u4ed8\u6b3e = " + ManipulatePrecision.doubleToString(PosLogicCompoment.calcOrderOughtPay(saleOrder.getExistPay(), saleOrder.getPrecisionMode())) + "\n\u4ed8\u6b3e\u5408\u8ba1\u91d1\u989d  = " + ManipulatePrecision.doubleToString(PosLogicCompoment.calcOrderOughtPay(amount, saleOrder.getPrecisionMode())));
            return false;
        }
        return true;
    }

    public double CalcPopDiscountAmount(CacheModel cacheModel) {
        double discountAmount = 0.0;
        List<Goods> goodsList = cacheModel.getGoodsList();
        for (Goods g : goodsList) {
            discountAmount += g.getPopDiscountValue();
        }
        return discountAmount;
    }

    public boolean JYPopDiscountAmount(double discountAmount, CacheModel cacheModel) {
        double newdiscountAmount = this.CalcPopDiscountAmount(cacheModel);
        return ManipulatePrecision.doubleCompare(discountAmount, newdiscountAmount, 2) == 0;
    }

    public CacheModel deletePopDetail(CacheModel cacheModel) {
        List<Goods> goodsList = cacheModel.getGoodsList();
        for (Goods g : goodsList) {
            if (g.getPopDetailsInfo() == null || g.getPopDetailsInfo().size() == 0) continue;
            ArrayList<PopDetail> popDetails = new ArrayList<PopDetail>();
            for (PopDetail p : g.getPopDetailsInfo()) {
                if (!p.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_goods) && !p.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_order) && !p.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_erpvip)) continue;
                popDetails.add(p);
            }
            g.getPopDetailsInfo().clear();
            g.setPopDetailsInfo(popDetails);
        }
        cacheModel.setGoodsList(goodsList);
        return cacheModel;
    }

    public CacheModel clearGoodsPop(CacheModel cacheModel) {
        List<Goods> goodsList = cacheModel.getGoodsList();
        for (int i = 0; i < goodsList.size(); ++i) {
            Goods g = goodsList.get(0);
            if ("9".equals(g.getFlag())) {
                goodsList.remove(i);
                --i;
                continue;
            }
            if (g.getPopDetailsInfo() == null || g.getPopDetailsInfo().size() == 0) continue;
            g.setFlowId(i + 1);
            g.getPopDetailsInfo().clear();
            g.setAdjustDiscountValue(0.0);
            g.setCouponValue(0.0);
            g.setPopDiscountValue(0.0);
            g.setAdjustDiscountValue(0.0);
            g.setTotalDiscountValue(0.0);
            g.setRealTotalDiscountValue(0.0);
            g.setCustomDiscountValue(0.0);
            g.setPayDiscountValue(0.0);
            g.setGiftTempAmount(0.0);
            g.setTempZkDiscount(0.0);
            g.setTempZrDiscount(0.0);
            g.setTempZzkDiscount(0.0);
            g.setTempZzrDiscount(0.0);
            g.setTempZkl(100.0);
            goodsList.set(i, g);
        }
        cacheModel.getOrder().setTempZzk(100.0);
        cacheModel.getOrder().setTempZzr(0.0);
        cacheModel.setGoodsList(goodsList);
        PosLogicCompoment.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    public static String getNewSGoodsSno(CacheModel cacheModel) {
        String nowSGoodsSnoString = "";
        if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() == 0) {
            return "1";
        }
        int i = cacheModel.getGoodsList().size();
        for (int j = i - 1; j > 0; --j) {
            Goods good = cacheModel.getGoodsList().get(j);
            if (!StringUtils.isNotBlank((String)good.getSGoodsSno())) continue;
            nowSGoodsSnoString = good.getSGoodsSno();
            break;
        }
        if (nowSGoodsSnoString.length() <= 0) {
            return "1";
        }
        int sno = Integer.valueOf(nowSGoodsSnoString);
        return String.valueOf(++sno);
    }

    public static boolean checkGoodsGrantRange(Goods good, String grantStr, int mode) {
        if (mode == 0) {
            return grantStr == null || grantStr.length() <= 0 || grantStr.equals("ALL") || grantStr.indexOf(good.getOrgCode()) != -1;
        }
        if (mode == 1) {
            if ("0".equals(good.getCategoryCode())) {
                return true;
            }
            if (StringUtils.isBlank((String)grantStr)) {
                return true;
            }
            if (!grantStr.equals("ALL")) {
                String[] categorys;
                for (String category : categorys = grantStr.split(",")) {
                    if (!category.equals(good.getCategoryCode())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public CacheModel CalcAmcPoints(CacheModel cacheModel, Payment payment) {
        cacheModel.setCalcResult(0);
        payment.setMoney(cacheModel.getOrder().getOughtPay());
        payment.setOverage(0.0);
        payment.setRoundUpOverageValue(0.0);
        double rate = payment.getMoney() / payment.getAmount();
        rate = ManipulatePrecision.doubleConvert(rate, 4, 1);
        payment.setRate(rate);
        cacheModel.getPayments().add(payment);
        cacheModel.getOrder().setExistPay(cacheModel.getOrder().getOughtPay());
        cacheModel.getOrder().setOverageValue(0.0);
        cacheModel.getOrder().setChangeValue(0.0);
        cacheModel.getOrder().setRemainValue(0.0);
        return cacheModel;
    }

    public CacheModel refreshTerminalSno(CacheModel cacheModel, String newTerminalSno) {
        cacheModel.getOrder().setTerminalSno(newTerminalSno);
        if (cacheModel.getPayments().size() > 0) {
            for (Payment p : cacheModel.getPayments()) {
                p.setTerminalSno(newTerminalSno);
            }
        }
        return cacheModel;
    }

    public CacheModel removeZzr(CacheModel cacheModel) {
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            if (!(sg.getTempZzrDiscount() > 0.0)) continue;
            sg.setTempZzrDiscount(0.0);
            sg.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
        }
        PosLogicCompoment.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    public CacheModel removeAeonCouponPopDetail(CacheModel cacheModel) {
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            sg.setTempPopDetails(new ArrayList<PopDetail>());
            if (null == sg.getPopDetailsInfo() || sg.getPopDetailsInfo().size() <= 0) continue;
            boolean isNeedCalc = false;
            for (int j = 0; j < sg.getPopDetailsInfo().size(); ++j) {
                PopDetail p = sg.getPopDetailsInfo().get(j);
                if (!YPopStatusType.pop_policy_group_aeoncoupon.equals(p.getPopPolicyGroup())) continue;
                sg.getTempPopDetails().add((PopDetail)p.clone());
                sg.getPopDetailsInfo().remove(j);
                sg.setPopDiscountValue(ManipulatePrecision.doubleConvert(sg.getPopDiscountValue() - p.getDiscountAmount(), 2, 1));
                --j;
                isNeedCalc = true;
            }
            if (!isNeedCalc) continue;
            sg.setTotalDiscountValue(PosLogicCompoment.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
        }
        PosLogicCompoment.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    public AnalyzeBarcodeDef analyzeCodeInfo(int codeMode, String barNo, String calcMode) {
        AnalyzeBarcodeDef out = new AnalyzeBarcodeDef();
        String barCodeNo = barNo;
        out.setOriginalBarNo(barCodeNo);
        out.setBarNo(barCodeNo);
        out.setBarNoMode(codeMode);
        out.setPriceMode(0);
        if (codeMode == 2 || codeMode == 3) {
            out.setPriceMode(2);
            if (barCodeNo.length() == 24 && barCodeNo.startsWith("92")) {
                if (barCodeNo.charAt(3) - 48 != Convert.convertProfitPriceCheckNum(barCodeNo.substring(4, 10))) {
                    out.setValidate(false);
                    return out;
                }
                if (Convert.convertProfitCheckNum(barCodeNo) != barCodeNo.charAt(barNo.length() - 1) - 48) {
                    out.setValidate(false);
                    return out;
                }
                char flag = barCodeNo.charAt(2);
                if (flag == '1') {
                    out.setDisMode(1);
                } else if (flag == '2') {
                    out.setDisMode(2);
                } else if (flag == '3') {
                    out.setDisMode(3);
                }
                out.setDisValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(barCodeNo.substring(4, 10)) / 100.0, 2, 1));
                out.setBarNo(barCodeNo.substring(10, 23));
                barCodeNo = barCodeNo.substring(10, 23);
            }
            if (codeMode == 2) {
                codeMode = 1;
            }
        }
        if (codeMode == 1) {
            if (barCodeNo.length() == 12) {
                out.setBarNo("0" + barCodeNo);
                out.setIsNeedFindDzc(false);
            } else if (barCodeNo.length() == 13 && barCodeNo.startsWith("210")) {
                out.setBarNo(CastUtil.castAeonGoodsCode(barCodeNo));
                out.setIsNeedFindDzc(false);
            } else if (barCodeNo.length() == 4) {
                out.setBarNo(CastUtil.castAeonGoodsCode("99" + barCodeNo));
                if (!"2".equals(calcMode)) {
                    out.setPriceMode(1);
                }
            } else if (barCodeNo.length() == 5) {
                out.setBarNo(CastUtil.castAeonGoodsCode(barCodeNo));
                if (!"2".equals(calcMode)) {
                    out.setPriceMode(1);
                }
            } else if (barCodeNo.length() == 7) {
                out.setBarNo(barCodeNo.replaceFirst("^0*", ""));
            }
        }
        return out;
    }

    public boolean checkGzRange(GoodsInfo goods, String mode, String gzInfo) {
        try {
            String[] gzStr;
            if ("N".equals(mode)) {
                return true;
            }
            if (StringUtils.isBlank((String)gzInfo)) {
                return true;
            }
            for (String gz : gzStr = gzInfo.split(",")) {
                if (!gz.equals(goods.getOrgCode())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean checkYyyRange(OperUser operuser, String mode, String gzInfo) {
        try {
            if (StringUtils.isBlank((String)operuser.getCardno())) {
                return true;
            }
            if (StringUtils.isBlank((String)operuser.getYyygz())) {
                return true;
            }
            if ("N".equals(mode) || "A".equals(mode)) {
                return true;
            }
            String[] yyygzInfo = operuser.getYyygz().split(",");
            if (0 == yyygzInfo.length) {
                return true;
            }
            if ("Y".equals(mode)) {
                String[] gzStr;
                if (StringUtils.isBlank((String)gzInfo)) {
                    return false;
                }
                for (String gz : gzStr = gzInfo.split(",")) {
                    for (String yyygz : yyygzInfo) {
                        if (!gz.equals(yyygz)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void reducePoints(CacheModel cacheModel, ServiceSession session) {
        cacheModel.getOrder().setTotalPoint(cacheModel.getOrder().getConsumersData().getPoint() + cacheModel.getOrder().getThisTimeUsedPoint() - cacheModel.getOrder().getThisTimePoint());
        cacheModel.getOrder().setGivePointFlag(1);
    }

    public void givePoints(CacheModel cacheModel, ServiceSession session) {
        cacheModel.getOrder().setTotalPoint(cacheModel.getOrder().getConsumersData().getPoint() - cacheModel.getOrder().getThisTimeUsedPoint() + cacheModel.getOrder().getThisTimePoint());
        cacheModel.getOrder().setGivePointFlag(1);
    }

    public Goods calcGoodsBarcodeDiscBeforeSingle(Goods goods, int disMode, double disValue, String discType) {
        if ("0".equals(discType)) {
            if (disMode == 1) {
                if (ManipulatePrecision.doubleCompare(disValue, goods.getSaleAmount(), 2) >= 0) {
                    goods.setBarcodeDiscount(goods.getSaleAmount());
                } else {
                    goods.setBarcodeDiscount(disValue);
                }
            } else if (disMode == 2) {
                String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                if (ManipulatePrecision.doubleCompare(disValue, 100.0, 2) > 0) {
                    return goods;
                }
                goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(goods.getSaleAmount() * disValue, precisionMode));
            } else if (disMode == 3) {
                if (ManipulatePrecision.doubleCompare(goods.getSaleAmount(), 0.0, 2) == 0) {
                    goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(disValue, goods.getPrcutMode()));
                } else if (ManipulatePrecision.doubleCompare(goods.getSaleAmount(), disValue, 2) > 0) {
                    String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                    goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(goods.getSaleAmount() - disValue, precisionMode));
                }
            }
            goods.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(PosLogicCompoment.getZZK(goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
            goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
            goods.setDisMode(disMode);
            goods.setDisValue(disValue);
            goods.setDiscType(discType);
            return goods;
        }
        if ("1".equals(discType)) {
            if (disMode == 1 || disMode == 2) {
                return goods;
            }
            if (disMode == 3) {
                if (ManipulatePrecision.doubleCompare(goods.getSaleAmount(), 0.0, 2) == 0) {
                    goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(disValue, goods.getPrcutMode()));
                } else if (ManipulatePrecision.doubleCompare(goods.getSaleAmount(), disValue, 2) > 0) {
                    String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                    goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(goods.getSaleAmount() - disValue, precisionMode));
                }
            }
            goods.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(PosLogicCompoment.getZZK(goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
            goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
            goods.setDisMode(disMode);
            goods.setDisValue(disValue);
            goods.setDiscType(discType);
            return goods;
        }
        return goods;
    }

    public static Goods calcGoodsBarcodeDiscAfterSingle(Goods goods, int disMode, double disValue, String discType) {
        if ("0".equals(discType)) {
            return goods;
        }
        if ("1".equals(discType)) {
            if (disMode == 1) {
                if (ManipulatePrecision.doubleCompare(disValue, goods.getSaleValue(), 2) >= 0) {
                    goods.setBarcodeDiscount(goods.getSaleValue());
                } else {
                    goods.setBarcodeDiscount(disValue);
                }
            } else if (disMode == 2) {
                String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                if (ManipulatePrecision.doubleCompare(disValue, 100.0, 2) > 0) {
                    return goods;
                }
                goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(goods.getSaleValue() * disValue, precisionMode));
            } else if (disMode == 3) {
                return goods;
            }
            goods.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(PosLogicCompoment.getZZK(goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
            goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
            goods.setDisMode(disMode);
            goods.setDisValue(disValue);
            goods.setDiscType(discType);
            return goods;
        }
        return goods;
    }

    public CacheModel addGiftsPrice(CacheModel cacheModel, List<Goods> giftsHaveNoPriceIn) {
        List<Goods> giftsHavePrice = cacheModel.getChoiceGiftsHavePrice();
        List<Goods> giftsHaveNoPrice = cacheModel.getChoiceGiftsHaveNoPrice();
        block0: for (Goods good : giftsHaveNoPriceIn) {
            for (Goods goodTemp : giftsHaveNoPrice) {
                if (!goodTemp.getGuid().equals(good.getGuid())) continue;
                Goods newsg = (Goods)goodTemp.clone();
                newsg.setPopDetailsInfo(new ArrayList<PopDetail>());
                for (PopDetail pop : goodTemp.getPopDetailsInfo()) {
                    PopDetail newPop = (PopDetail)pop.clone();
                    newsg.getPopDetailsInfo().add(newPop);
                }
                newsg.setSalePrice(good.getSalePrice());
                newsg.setSaleValue(ManipulatePrecision.doubleConvert(newsg.getQty() * newsg.getSalePrice(), 2, 1));
                newsg.setSaleAmount(newsg.getSaleValue());
                giftsHavePrice.add(newsg);
                continue block0;
            }
        }
        if (giftsHavePrice.size() > 0) {
            int flowId = cacheModel.getGoodsList().size() + 1;
            for (Goods good : giftsHavePrice) {
                good.setFlowId(flowId);
                cacheModel.getGoodsList().add(good);
                ++flowId;
            }
        }
        cacheModel.getChoiceGiftsHaveNoPrice().clear();
        cacheModel.getChoiceGiftsHavePrice().clear();
        PosLogicCompoment.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    public static List<Goods> sortGoodsList(List<Goods> goodsList) {
        goodsList.sort(new Comparator<Goods>(){

            @Override
            public int compare(Goods o1, Goods o2) {
                if (o1.getFlowId() < o2.getFlowId()) {
                    return -1;
                }
                return 0;
            }
        });
        int size = goodsList.size();
        for (int i = 0; i < size; ++i) {
            goodsList.get(i).setFlowId(i + 1);
        }
        return goodsList;
    }
}

