/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.struct;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.ManipulateStr;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.roc.BeanSellDetailExecuted;
import com.efuture.business.javaPos.struct.CouponGain;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.GoodsForPos;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.PopGain;
import com.efuture.business.javaPos.struct.PopReverse;
import com.efuture.business.javaPos.struct.PopUse;
import com.efuture.business.javaPos.struct.mainDataCentre.CategoryProperty;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersGainDetailModel;
import com.efuture.business.javaPos.struct.promotionCentre.SellCouponGain;
import com.efuture.business.javaPos.struct.promotionCentre.SellCouponUse;
import com.efuture.business.javaPos.struct.promotionCentre.SellDetail;
import com.efuture.business.javaPos.struct.promotionCentre.SellPopDetail;
import com.efuture.business.util.BeanCopierUtils;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.UUIDUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Goods
extends GoodsForPos
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String goodsUid;
    private String isfresh;
    private String goodsStatus;
    private String popFlag;
    private int originalFlowId;
    private String discType = "0";
    private double disValue;
    private int disMode;
    private double minDiscount;
    private double minSalePrice;
    private double stepValue;
    private double returnIntegral;
    private String calcMode;
    private List<PopDetail> tempPopDetails;
    private String expTime;
    private String yhmiscanuse;
    private String tempName;
    private String nojf;
    private boolean coldTransFlag = false;
    private List<CategoryProperty> categoryPropertys = new ArrayList<CategoryProperty>();
    private String stampAccount;
    private double stampFaceValue;
    private double stampRate;
    private String stampGroup;
    private String stampConsumersId;
    private String stampAccntExt;
    private boolean isHaveExceptUses;
    private boolean isNoBackGift = false;
    private double giftTempAmount;
    private String ssgid;
    private String prcutMode = "0";
    private double noDisAmountValue;
    private boolean isZzk = false;
    private boolean isZzr = false;
    private List<CouponUse> couponUses = new ArrayList<CouponUse>();
    private List<CouponUse> outCouponUses = new ArrayList<CouponUse>();
    private List<CouponGain> couponGains = new ArrayList<CouponGain>();
    private List<PopDetail> popDetailsInfo = new ArrayList<PopDetail>();
    private List<BeanSellDetailExecuted> onSaleExecuted;
    private String category;
    private String brand;
    public static Comparator<Goods> saleAmountComparator = new Comparator<Goods>(){

        @Override
        public int compare(Goods o1, Goods o2) {
            double saleAmount1 = o1.getSaleAmount();
            double saleAmount2 = o2.getSaleAmount();
            return ManipulatePrecision.sub(saleAmount2, saleAmount1) > 0.0 ? 1 : 0;
        }
    };
    public static Comparator<Goods> flowIdComparator = new Comparator<Goods>(){

        @Override
        public int compare(Goods o1, Goods o2) {
            int flowId1 = o1.getFlowId();
            int flowId2 = o2.getFlowId();
            return flowId2 - flowId1;
        }
    };

    public boolean getIsZzk() {
        return this.isZzk;
    }

    public void setIsZzk(boolean isZzk) {
        this.isZzk = isZzk;
    }

    public boolean getIsZzr() {
        return this.isZzr;
    }

    public void setIsZzr(boolean isZzr) {
        this.isZzr = isZzr;
    }

    public double getNoDisAmountValue() {
        return this.noDisAmountValue;
    }

    public void setNoDisAmountValue(double noDisAmountValue) {
        this.noDisAmountValue = noDisAmountValue;
    }

    public double getDisValue() {
        return this.disValue;
    }

    public void setDisValue(double disValue) {
        this.disValue = disValue;
    }

    public int getDisMode() {
        return this.disMode;
    }

    public void setDisMode(int disMode) {
        this.disMode = disMode;
    }

    public List<CouponUse> getOutCouponUses() {
        return this.outCouponUses;
    }

    public void setOutCouponUses(List<CouponUse> outCouponUses) {
        this.outCouponUses = outCouponUses;
    }

    public String getGoodsStatus() {
        return this.goodsStatus;
    }

    public void setGoodsStatus(String goodsStatus) {
        this.goodsStatus = goodsStatus;
    }

    public String getIsfresh() {
        return this.isfresh;
    }

    public void setIsfresh(String isfresh) {
        this.isfresh = isfresh;
    }

    public String getGoodsUid() {
        return this.goodsUid;
    }

    public void setGoodsUid(String goodsUid) {
        this.goodsUid = goodsUid;
    }

    public List<PopDetail> getPopDetailsInfo() {
        return this.popDetailsInfo;
    }

    public void setPopDetailsInfo(List<PopDetail> popDetailsInfo) {
        this.popDetailsInfo = popDetailsInfo;
    }

    public List<CouponUse> getCouponUses() {
        return this.couponUses;
    }

    public void setCouponUses(List<CouponUse> couponUses) {
        this.couponUses = couponUses;
    }

    public List<CouponGain> getCouponGains() {
        return this.couponGains;
    }

    public void setCouponGains(List<CouponGain> couponGains) {
        this.couponGains = couponGains;
    }

    public String getPrcutMode() {
        return this.prcutMode;
    }

    public void setPrcutMode(String prcutMode) {
        this.prcutMode = prcutMode;
    }

    public String getPopFlag() {
        return this.popFlag;
    }

    public void setPopFlag(String popFlag) {
        this.popFlag = popFlag;
    }

    public int getOriginalFlowId() {
        return this.originalFlowId;
    }

    public void setOriginalFlowId(int originalFlowId) {
        this.originalFlowId = originalFlowId;
    }

    public String getDiscType() {
        return this.discType;
    }

    public void setDiscType(String discType) {
        this.discType = discType;
    }

    public double getMinDiscount() {
        return this.minDiscount;
    }

    public void setMinDiscount(double minDiscount) {
        this.minDiscount = minDiscount;
    }

    public double getMinSalePrice() {
        return this.minSalePrice;
    }

    public void setMinSalePrice(double minSalePrice) {
        this.minSalePrice = minSalePrice;
    }

    public double getStepValue() {
        return this.stepValue;
    }

    public void setStepValue(double stepValue) {
        this.stepValue = stepValue;
    }

    public double getReturnIntegral() {
        return this.returnIntegral;
    }

    public void setReturnIntegral(double returnIntegral) {
        this.returnIntegral = returnIntegral;
    }

    public String getCalcMode() {
        return this.calcMode;
    }

    public void setCalcMode(String calcMode) {
        this.calcMode = calcMode;
    }

    public List<PopDetail> getTempPopDetails() {
        return this.tempPopDetails;
    }

    public void setTempPopDetails(List<PopDetail> tempPopDetails) {
        this.tempPopDetails = tempPopDetails;
    }

    public String getExpTime() {
        return this.expTime;
    }

    public void setExpTime(String expTime) {
        this.expTime = expTime;
    }

    public String getYhmiscanuse() {
        return this.yhmiscanuse;
    }

    public void setYhmiscanuse(String yhmiscanuse) {
        this.yhmiscanuse = yhmiscanuse;
    }

    public String getTempName() {
        return this.tempName;
    }

    public void setTempName(String tempName) {
        this.tempName = tempName;
    }

    public String getNojf() {
        return this.nojf;
    }

    public void setNojf(String nojf) {
        this.nojf = nojf;
    }

    public boolean getColdTransFlag() {
        return this.coldTransFlag;
    }

    public void setColdTransFlag(boolean coldTransFlag) {
        this.coldTransFlag = coldTransFlag;
    }

    public List<CategoryProperty> getCategoryPropertys() {
        return this.categoryPropertys;
    }

    public void setCategoryPropertys(List<CategoryProperty> originalCategoryPropertys) {
        this.categoryPropertys = originalCategoryPropertys;
    }

    public String getStampAccount() {
        return this.stampAccount;
    }

    public void setStampAccount(String stampAccount) {
        this.stampAccount = stampAccount;
    }

    public double getStampFaceValue() {
        return this.stampFaceValue;
    }

    public void setStampFaceValue(double stampFaceValue) {
        this.stampFaceValue = stampFaceValue;
    }

    public double getStampRate() {
        return this.stampRate;
    }

    public void setStampRate(double stampRate) {
        this.stampRate = stampRate;
    }

    public String getStampGroup() {
        return this.stampGroup;
    }

    public void setStampGroup(String stampGroup) {
        this.stampGroup = stampGroup;
    }

    public String getStampConsumersId() {
        return this.stampConsumersId;
    }

    public void setStampConsumersId(String stampConsumersId) {
        this.stampConsumersId = stampConsumersId;
    }

    public String getStampAccntExt() {
        return this.stampAccntExt;
    }

    public void setStampAccntExt(String stampAccntExt) {
        this.stampAccntExt = stampAccntExt;
    }

    public boolean getHaveExceptUses() {
        return this.isHaveExceptUses;
    }

    public void setHaveExceptUses(boolean isHaveExceptUses) {
        this.isHaveExceptUses = isHaveExceptUses;
    }

    public boolean getIsNoBackGift() {
        return this.isNoBackGift;
    }

    public void setIsNoBackGift(boolean isNoBackGift) {
        this.isNoBackGift = isNoBackGift;
    }

    public double getGiftTempAmount() {
        return this.giftTempAmount;
    }

    public void setGiftTempAmount(double giftTempAmount) {
        this.giftTempAmount = giftTempAmount;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getSsgid() {
        return this.ssgid;
    }

    public void setSsgid(String ssgid) {
        this.ssgid = ssgid;
    }

    public List<BeanSellDetailExecuted> getOnSaleExecuted() {
        return this.onSaleExecuted;
    }

    public void setOnSaleExecuted(List<BeanSellDetailExecuted> onSaleExecuted) {
        this.onSaleExecuted = onSaleExecuted;
    }

    public static Comparator<Goods> getSaleAmountComparator() {
        return saleAmountComparator;
    }

    public static void setSaleAmountComparator(Comparator<Goods> saleAmountComparator) {
        Goods.saleAmountComparator = saleAmountComparator;
    }

    public static Comparator<Goods> getFlowIdComparator() {
        return flowIdComparator;
    }

    public static void setFlowIdComparator(Comparator<Goods> flowIdComparator) {
        Goods.flowIdComparator = flowIdComparator;
    }

    public static Goods transferGoods(SellDetail sellDetail, Goods good, String calcResult, List<String> noDisPopTypes, boolean needYpopzke, boolean needGrant, boolean isSpecifyBack) {
        try {
            boolean hasErpVipPop = false;
            String preline = "";
            if (null == sellDetail || null == good) {
                return null;
            }
            good.setYhmiscanuse("");
            good.setNoDisAmountValue(0.0);
            if (good.getFlag().equals("9") && null != sellDetail.getYhMiscanUse() && !sellDetail.getYhMiscanUse().equals("Y")) {
                good.setYhmiscanuse("N");
            }
            if (StringUtils.isBlank((CharSequence)good.getTempName())) {
                good.setTempName(good.getGoodsName());
            } else {
                good.setGoodsName(good.getTempName());
            }
            if (needYpopzke) {
                good.setPopDiscountValue(ManipulatePrecision.doubleConvert(sellDetail.getTotalDiscount(), 2, 1));
            }
            good.setNojf(sellDetail.getNojf());
            good.setPopFlag(sellDetail.getFlag());
            good.setBarcodeDiscount(0.0);
            if (good.getPopDetailsInfo() != null) {
                good.getPopDetailsInfo().clear();
            }
            if (good.getCouponUses() != null) {
                good.getCouponUses().clear();
            }
            if (good.getCouponGains() != null) {
                good.getCouponGains().clear();
            }
            double noDisAmout = 0.0;
            if (null != sellDetail.getSellPopDetails() && sellDetail.getSellPopDetails().size() > 0) {
                double tempDiscount = 0.0;
                double adjustDiscount = 0.0;
                for (int i = 0; i < sellDetail.getSellPopDetails().size(); ++i) {
                    SellPopDetail pop = sellDetail.getSellPopDetails().get(i);
                    if (null == pop) continue;
                    if (!(null == pop.getPopPolicyGroup() || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_order) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_goods) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_erpvip) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_barcode_discA) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_barcode_discB))) {
                        if (ManipulateStr.readIndexChar(calcResult, 0) == '1') {
                            if (null == good.getPopDetailsInfo()) {
                                good.setPopDetailsInfo(new ArrayList<PopDetail>());
                            }
                            good.getPopDetailsInfo().add(PopDetail.transferPopDetail2(pop));
                            continue;
                        }
                        if (null == good.getPopDetailsInfo()) {
                            good.setPopDetailsInfo(new ArrayList<PopDetail>());
                        }
                        tempDiscount += pop.getDiscountAmount();
                        if (null != noDisPopTypes && !noDisPopTypes.isEmpty() && StringUtils.isNotBlank((CharSequence)pop.getPopPolicyType()) && noDisPopTypes.indexOf(pop.getPopPolicyType()) != -1) {
                            noDisAmout += pop.getDiscountAmount();
                        }
                        good.getPopDetailsInfo().add(PopDetail.transferPopDetail2(pop));
                        if (!StringUtils.isNotBlank((CharSequence)pop.getPopPolicySymbol())) continue;
                        preline = preline + pop.getPopPolicySymbol();
                        continue;
                    }
                    if (!YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_erpvip.equals(pop.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup())) continue;
                    hasErpVipPop = true;
                    if (needGrant) {
                        if (YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup())) {
                            adjustDiscount = ManipulatePrecision.doubleConvert(adjustDiscount + pop.getDiscountAmount());
                        }
                        if (YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup())) {
                            good.setBarcodeDiscount(ManipulatePrecision.doubleConvert(good.getBarcodeDiscount() + pop.getDiscountAmount(), 2, 1));
                        }
                        if (null == good.getPopDetailsInfo()) {
                            good.setPopDetailsInfo(new ArrayList<PopDetail>());
                        }
                        good.getPopDetailsInfo().add(PopDetail.transferPopDetail2(pop));
                        if (null == pop.getPopPolicySymbol() || "".equals(pop.getPopPolicySymbol())) continue;
                        preline = preline + pop.getPopPolicySymbol();
                        continue;
                    }
                    if (!YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup())) continue;
                    good.getPopDetailsInfo().add(PopDetail.transferPopDetail2(pop));
                    good.setBarcodeDiscount(ManipulatePrecision.doubleConvert(good.getBarcodeDiscount() + pop.getDiscountAmount(), 2, 1));
                }
                if (needGrant && isSpecifyBack) {
                    good.setAdjustDiscountValue(adjustDiscount);
                    good.setTempZrDiscount(adjustDiscount);
                }
                if (needYpopzke) {
                    good.setPopDiscountValue(ManipulatePrecision.doubleConvert(tempDiscount, 2, 1));
                }
            }
            good.setNoDisAmountValue(noDisAmout);
            if (!hasErpVipPop) {
                good.setCustomDiscountValue(0.0);
            }
            if (null != sellDetail.getCouponUses() && sellDetail.getCouponUses().size() > 0) {
                for (int i = 0; i < sellDetail.getCouponUses().size(); ++i) {
                    SellCouponUse use = sellDetail.getCouponUses().get(i);
                    if (null == good.getCouponUses()) {
                        good.setCouponUses(new ArrayList<CouponUse>());
                    }
                    good.getCouponUses().add(CouponUse.transferCouponUse(use));
                }
            }
            if (null != sellDetail.getCouponGains() && sellDetail.getCouponGains().size() > 0) {
                for (int i = 0; i < sellDetail.getCouponGains().size(); ++i) {
                    SellCouponGain gain = sellDetail.getCouponGains().get(i);
                    if (null == good.getCouponGains()) {
                        good.setCouponGains(new ArrayList<CouponGain>());
                    }
                    good.getCouponGains().add(CouponGain.transferCouponGain(gain, good.getFlowId()));
                }
            }
            if (!isSpecifyBack && StringUtils.isNotBlank((CharSequence)preline)) {
                good.setGoodsName("(" + preline + ")" + good.getGoodsName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return good;
    }

    public static SellDetail transferSellDetail(Goods goods, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId) {
        goods.setTempPopDetails(new ArrayList<PopDetail>());
        SellDetail sellDetail = new SellDetail();
        sellDetail.setRowNo(goods.getFlowId());
        sellDetail.setFlag(goods.getFlag());
        if (StringUtils.isNotBlank((CharSequence)goods.getSGoodsSno())) {
            sellDetail.setFlag("3");
        }
        if (StringUtils.isNotBlank((CharSequence)goods.getPopFlag())) {
            sellDetail.setFlag(goods.getPopFlag());
        }
        if (order.getConsumersData() != null && order.getConsumersData().getIsMami()) {
            sellDetail.setKlm("M");
        }
        sellDetail.setOriginalBillNo(order.getOriginSeqNo());
        sellDetail.setOriginalRowNo(goods.getOriginalFlowId());
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(order.getShopCode());
        sellDetail.setContract(order.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getSaleUnit());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrandCode());
        sellDetail.setCategory(goods.getCategoryCode());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getTotalDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setNojf(goods.getNojf());
        sellDetail.setManaUnit(order.getErpCode());
        sellDetail.setSupplier(goods.getVenderId());
        sellDetail.setCounter(goods.getSeason());
        if (goods.getIsNoBackGift()) {
            sellDetail.setPopTag("Y");
            if (goods.getSaleValue() == 0.0 && goods.getGiftTempAmount() > 0.0) {
                sellDetail.setListAmount(goods.getGiftTempAmount());
                sellDetail.setSaleAmount(goods.getGiftTempAmount());
            }
            sellDetail.setFlag("0");
        }
        if (StringUtils.isNotBlank((CharSequence)order.getStaffCardNo())) {
            sellDetail.setPopTag("S");
        }
        if (SellType.NOPOP(order.getOrderType())) {
            sellDetail.setFlag("Z");
        }
        if ("Y".equals(goods.getEscaleFlag())) {
            sellDetail.setFlag("D");
        }
        if (order.getPopmode() == 3) {
            sellDetail.setFlag("3");
        }
        boolean isSpecifyBack = false;
        boolean isHaveBarcodeDisc = false;
        if (SellType.ISBACK(order.getOrderType()) && StringUtils.isNotBlank((CharSequence)order.getOriginTerminalSno())) {
            isSpecifyBack = true;
        }
        if (!isSpecifyBack) {
            if (null != goods.getPopDetailsInfo() && goods.getPopDetailsInfo().size() > 0) {
                if (null == sellDetail.getSellPopDetails()) {
                    sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
                }
                for (PopDetail popDetail : goods.getPopDetailsInfo()) {
                    if (isRemoveAdjustDisc && YPopStatusType.pop_policy_group_grant_goods.equals(popDetail.getPopPolicyGroup()) || !YPopStatusType.pop_policy_group_barcode_discA.equals(popDetail.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_barcode_discB.equals(popDetail.getPopPolicyGroup())) continue;
                    if (isNewCalcId) {
                        // empty if block
                    }
                    isHaveBarcodeDisc = true;
                }
            }
        } else if (SellType.ISBACK(order.getOrderType()) && goods.getFlag().equals("0") && null != goods.getPopDetailsInfo() && goods.getPopDetailsInfo().size() > 0) {
            if (null == sellDetail.getSellPopDetails()) {
                sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
            }
            for (PopDetail popDetail : goods.getPopDetailsInfo()) {
            }
        }
        if (null != goods.getOutCouponUses() && goods.getOutCouponUses().size() > 0) {
            if (null == sellDetail.getCouponUses()) {
                sellDetail.setCouponUses(new ArrayList<SellCouponUse>());
            }
            for (CouponUse couponUse : goods.getOutCouponUses()) {
                sellDetail.getCouponUses().add(CouponUse.transferSellCouponUse(couponUse));
            }
        }
        if (ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getPopDiscountValue(), 2, 1) > 0.0) {
            if (null == sellDetail.getSellPopDetails()) {
                sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
            }
            if (SellType.ISSALE(order.getOrderType()) || null == order.getOriginIdSheetNo() || order.getOriginIdSheetNo().equals("")) {
                SellPopDetail sellPopDetail;
                if (!isRemoveAdjustDisc) {
                    if (ManipulatePrecision.doubleCompare(goods.getTempZzkDiscount(), 0.0, 2) > 0) {
                        sellPopDetail = new SellPopDetail();
                        sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZzkDiscount(), 6, 1));
                        sellPopDetail.setPopMode("0");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                        sellPopDetail.setPopDescribe("[" + order.getSysPara().getZpRateDes() + order.getTempZzk() + "%]");
                        sellPopDetail.setPopMemo("PRE:0");
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_order);
                        sellPopDetail.setRowNo(goods.getFlowId());
                        sellDetail.getSellPopDetails().add(sellPopDetail);
                    }
                    if (ManipulatePrecision.doubleCompare(goods.getTempZzrDiscount(), 0.0, 2) > 0) {
                        sellPopDetail = new SellPopDetail();
                        sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZzrDiscount(), 6, 1));
                        sellPopDetail.setPopMode("0");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                        sellPopDetail.setPopDescribe("[" + order.getSysPara().getZpAmountDes() + "]");
                        sellPopDetail.setPopMemo("PRE:0");
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_order);
                        sellPopDetail.setRowNo(goods.getFlowId());
                        sellDetail.getSellPopDetails().add(sellPopDetail);
                    }
                } else {
                    String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                    sellDetail.setTotalDiscount(ManipulatePrecision.getDetailOverFlow(sellDetail.getTotalDiscount() - goods.getTempZzkDiscount() - goods.getTempZzrDiscount(), precisionMode));
                    sellDetail.setSaleAmount(ManipulatePrecision.getDetailOverFlow(sellDetail.getSaleAmount() + goods.getTempZzkDiscount() + goods.getTempZzrDiscount(), goods.getPrcutMode()));
                    goods.setTempZzkDiscount(0.0);
                    goods.setTempZzrDiscount(0.0);
                    double d = ManipulatePrecision.getDetailOverFlow(goods.getTempZkDiscount() + goods.getTempZrDiscount() + goods.getTempZzkDiscount() + goods.getTempZzrDiscount() + goods.getBarcodeDiscount() + goods.getFixedDiscountValue(), precisionMode);
                    goods.setAdjustDiscountValue(d);
                }
                if (!isHaveBarcodeDisc && ManipulatePrecision.doubleCompare(goods.getBarcodeDiscount(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getBarcodeDiscount(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopDescribe(order.getSysPara().getBarCodeDes());
                    sellPopDetail.setRowNo(goods.getFlowId());
                    if (goods.getDisMode() == 3) {
                        sellPopDetail.setPrcMode("6");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discA);
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeA);
                        sellPopDetail.setPopDescribe("[" + order.getSysPara().getBarCodeDes() + "]");
                    } else if (goods.getDisMode() == 1) {
                        sellPopDetail.setPrcMode("6");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeB);
                    } else if (goods.getDisMode() == 2) {
                        sellPopDetail.setDiscountAmount(0.0);
                        sellPopDetail.setPrcMode("5");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                        sellPopDetail.setPopEventType(YPopStatusType.pop_type_barcodeB);
                        sellPopDetail.setDiscountRate(ManipulatePrecision.doubleConvert(1.0 - goods.getDisValue()));
                    }
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (ManipulatePrecision.doubleCompare(goods.getTempZkDiscount(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZkDiscount(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getDpRateDes() + goods.getTempZkl() + "%]");
                    sellPopDetail.setPopMemo("PRE:0");
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (ManipulatePrecision.doubleCompare(goods.getTempZrDiscount(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZrDiscount(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getDpAmountDes() + "]");
                    sellPopDetail.setPopMemo("PRE:0");
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (ManipulatePrecision.doubleCompare(goods.getFixedDiscountValue(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getFixedDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getDpAmountDes() + "]");
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (goods.getCustomDiscountValue() > 0.0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getCustomDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_erpvip);
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_policy_group_erpvip);
                    sellPopDetail.setPopMemo("PRE:1");
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (goods.getMealDiscountValue() > 0.0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getMealDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopMemo("PRE:1");
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
            }
        }
        sellDetail.setOriginalBillNo(order.getOriginFlowNo());
        sellDetail.setOriginalRowNo(goods.getOriginalFlowId());
        return sellDetail;
    }

    public static OrdersDetailModel transferOrdersDetailModel(Goods g) {
        OrdersDetailModel d = new OrdersDetailModel();
        d.setBonusPointAmount(BigDecimal.valueOf(g.getBonusPointAmount()));
        d.setScanCode(g.getGoodsNo());
        d.setAssistantId(g.getAssistantId());
        d.setSaleSpec(g.getSaleSpec());
        d.setCabinetGroup(g.getOrgCode());
        d.setGoodsName(g.getGoodsName());
        d.setEnFname(g.getEnFname());
        d.setRowNo(g.getFlowId());
        d.setGoodsCode(g.getGoodsCode());
        d.setBarNo(g.getBarNo());
        d.setBrandCode(g.getBrand());
        d.setGoodsUid(g.getGoodsUid());
        d.setCategoryCode(g.getCategory());
        d.setKlm(g.getKlm());
        d.setGoodType(g.getGoodsType());
        d.setGoodsFlag(g.getFlag());
        d.setPopTag(g.getPopFlag());
        d.setSalePrice(BigDecimal.valueOf(g.getSalePrice()));
        d.setListPrice(BigDecimal.valueOf(g.getListPrice()));
        d.setPartsNum(g.getPartsNum());
        d.setQty(g.getQty());
        d.setSaleUnit(g.getSaleUnit());
        d.setSaleValue(BigDecimal.valueOf(g.getSaleValue()));
        d.setCouponValue(BigDecimal.valueOf(g.getCouponValue()));
        d.setPopDiscountValue(BigDecimal.valueOf(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() - g.getNoDisAmountValue(), 2, 1)));
        d.setAdjustDiscountValue(BigDecimal.valueOf(ManipulatePrecision.doubleConvert(g.getAdjustDiscountValue(), 2, 1)));
        d.setPayDiscountValue(BigDecimal.valueOf(g.getNoDisAmountValue()));
        d.setTotalDiscountValue(BigDecimal.valueOf(g.getTotalDiscountValue()));
        d.setCustomDiscountValue(BigDecimal.valueOf(g.getCustomDiscountValue()));
        d.setSaleAmount(BigDecimal.valueOf(g.getSaleAmount()));
        d.setWeight(g.getWeight());
        d.setWeighGood(Goods.transferWeighGood(g.getEscaleFlag()) ? 1 : 0);
        d.setSsgid(Long.valueOf(g.getSsgid()));
        d.setSmGoodsSno(g.getSGoodsSno());
        d.setSmGoodsCode(g.getSGoodsCode());
        d.setCategoryPropertys(JSON.toJSONString(g.getCategoryPropertys()));
        d.setVenderCode(g.getVenderCode());
        if (g.getEWCCodeNum() > 0.0) {
            d.setCopies(1);
        } else {
            d.setCopies((int)g.getQty());
        }
        d.setStallCode(g.getStallCode());
        d.setAllowReturnCopies(g.getAllowReturnCopies());
        d.setMealDiscountValue(BigDecimal.valueOf(g.getMealDiscountValue()));
        d.setEatWay(g.getEatWay());
        d.setStallCode(g.getStallCode());
        d.setControlFlag(g.getControlFlag() ? 1 : 0);
        d.setLicense(g.getLicense());
        d.setPrtDuplFlag(g.getPrtDuplFlag() ? 1 : 0);
        d.setPrcutMode(g.getPrcutMode());
        d.setGoodsDesc(g.getGoodsDesc());
        d.setContractCode(g.getBackPrintNo());
        d.setProcessFlag(g.getProcessFlag());
        return d;
    }

    private static boolean transferWeighGood(String escaleFlag) {
        return "Y".equals(escaleFlag);
    }

    public static Goods transferGoods2(OrdersDetailModel g) {
        Goods goods = new Goods();
        goods.setGuid(UUIDUtils.buildGuid());
        goods = Goods.SaleOrderDetailToGoods(goods, g);
        goods.setPopDetailsInfo(new ArrayList<PopDetail>());
        return goods;
    }

    public static Goods SaleOrderDetailToGoods(Goods goods, OrdersDetailModel sod) {
        goods.setBonusPointAmount(CastUtil.castDouble(sod.getBonusPointAmount()));
        goods.setOrgCode(sod.getCabinetGroup());
        goods.setGoodsName(sod.getGoodsName());
        goods.setEnFname(sod.getEnFname());
        goods.setFlowId(sod.getRowNo());
        goods.setGoodsCode(sod.getGoodsCode());
        goods.setGoodsNo(goods.getGoodsCode());
        goods.setBarNo(sod.getBarNo());
        goods.setBrandCode(sod.getBrandCode());
        goods.setCategoryCode(sod.getCategoryCode());
        goods.setGoodsUid(sod.getGoodsUid());
        goods.setKlm(sod.getKlm());
        goods.setGoodsType(sod.getGoodType());
        goods.setFlag(sod.getGoodsFlag());
        goods.setPopFlag(sod.getPopTag());
        goods.setSalePrice(CastUtil.castDouble(sod.getSalePrice()));
        goods.setListPrice(CastUtil.castDouble(sod.getListPrice()));
        goods.setPartsNum(sod.getPartsNum());
        goods.setQty(sod.getQty());
        goods.setSaleUnit(sod.getGoodsUid());
        goods.setCouponValue(CastUtil.castDouble(sod.getCouponValue()));
        goods.setPopDiscountValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(sod.getPopDiscountValue()) + CastUtil.castDouble(sod.getPayDiscountValue())));
        goods.setAdjustDiscountValue(CastUtil.castDouble(sod.getAdjustDiscountValue()));
        goods.setNoDisAmountValue(CastUtil.castDouble(sod.getPayDiscountValue()));
        goods.setTotalDiscountValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(sod.getTotalDiscountValue())));
        goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
        goods.setCustomDiscountValue(CastUtil.castDouble(sod.getCustomDiscountValue()));
        goods.setSaleAmount(CastUtil.castDouble(sod.getSaleAmount()));
        goods.setRealSalePrice(ManipulatePrecision.doubleConvert(goods.getSalePrice() - goods.getNoDisAmountValue() / goods.getQty()));
        goods.setVenderId(sod.getVenderCode());
        goods.setWeight(sod.getWeight());
        goods.setEscaleFlag(sod.getWeighGood().toString().equalsIgnoreCase("1") ? "Y" : "N");
        goods.setSsgid(sod.getSsgid() + "");
        goods.setSGoodsSno(sod.getSmGoodsSno());
        goods.setSGoodsCode(sod.getSmGoodsCode());
        goods.setPrtDuplFlag(sod.getPrtDuplFlag().equals("1"));
        goods.setStallCode(sod.getStallCode());
        goods.setAllowReturnCopies(CastUtil.castDouble(sod.getAllowReturnCopies()));
        goods.setMealDiscountValue(CastUtil.castDouble(sod.getMealDiscountValue()));
        goods.setPopDetailsInfo(new ArrayList<PopDetail>());
        goods.setCouponUses(new ArrayList<CouponUse>());
        goods.setCouponGains(new ArrayList<CouponGain>());
        goods.setPrcutMode(sod.getPrcutMode());
        goods.setLicense(sod.getLicense());
        goods.setGoodsDesc(sod.getGoodsDesc());
        double saleValue = ManipulatePrecision.doubleConvert(CastUtil.castDouble(sod.getTotalDiscountValue()) + CastUtil.castDouble(sod.getSaleAmount()), 2, 1);
        goods.setSaleValue(saleValue);
        goods.setBackPrintNo(sod.getContractCode());
        goods.setEatWay(sod.getEatWay());
        goods.setProcessFlag(sod.getProcessFlag());
        goods.setVenderCode(sod.getVenderCode());
        goods.setAssistantId(sod.getAssistantId());
        return goods;
    }

    private static String transEscaleFlag(boolean weighGood) {
        if (weighGood) {
            return "Y";
        }
        return "N";
    }

    public static List<SellDetail> transferSellDetail(List<Goods> goodses, Order order, boolean isRemoveAdjustDisc) {
        if (goodses == null || goodses.size() == 0) {
            return null;
        }
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        for (Goods goods : goodses) {
            SellDetail sellDetail = Goods.transferSellDetail(goods, order, isRemoveAdjustDisc, false);
            sellDetails.add(sellDetail);
        }
        return sellDetails;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public static Goods findGoods(String guid, List<Goods> goodsList) {
        Goods result = null;
        for (Goods goods : goodsList) {
            if (!guid.equals(goods.getGuid())) continue;
            result = goods;
            break;
        }
        return result;
    }

    public static List<Goods> findGoodsByGoodsNo(String goodsNo, List<Goods> goodsList) {
        ArrayList<Goods> matchList = new ArrayList<Goods>();
        for (int i = goodsList.size() - 1; i >= 0; --i) {
            Goods goods = goodsList.get(i);
            if (!goodsNo.equals(goods.getGoodsNo())) continue;
            matchList.add(goods);
        }
        return matchList;
    }

    public static void transferGoodsInfoToGoods(GoodsInfo goodsInfo, Goods goods, double qty) {
        goods.setRecycleFee(goodsInfo.getRecycleFee());
        goods.setControlFlag(goodsInfo.getControlFlag());
        goods.setCategoryCode(goodsInfo.getCategoryCode());
        goods.setCategory(goodsInfo.getCategoryCode());
        goods.setArtCode(goodsInfo.getArtCode());
        goods.setIsfresh(goodsInfo.getIsfresh());
        goods.setBrandCode(goodsInfo.getBrandCode());
        goods.setBrand(goodsInfo.getBrandCode());
        goods.setGoodsUid(goodsInfo.getGoodsUid());
        goods.setBrandName(goodsInfo.getBrandName());
        goods.setSaleUnit(goodsInfo.getPartsUnit());
        goods.setPartsNum(goodsInfo.getPartsNum());
        goods.setPcs(goodsInfo.getPcs());
        if (goodsInfo.getEscaleFlag() == 0) {
            goods.setEscaleFlag("N");
        } else {
            goods.setEscaleFlag(goodsInfo.getEscaleFlag() == 1 ? "Y" : "N");
        }
        goods.setMinDiscount(goodsInfo.getMinDiscount());
        goods.setMinSalePrice(goodsInfo.getMinSalePrice());
        goods.setRemark(goodsInfo.getRemark());
        goods.setImageUrl(goodsInfo.getImageUrl());
        goods.setEnFname(goodsInfo.getEnFname());
        goods.setGoodsName(goodsInfo.getGoodsName());
        goods.setGoodsType(goodsInfo.getGoodsType());
        goods.setBarNo(goodsInfo.getBarNo());
        goods.setGoodsCode(goodsInfo.getGoodsCode());
        goods.setListPrice(goodsInfo.getSalePrice());
        goods.setSalePrice(goodsInfo.getSalePrice());
        goods.setRealSalePrice(goodsInfo.getSalePrice());
        goods.setMemberPrice(goodsInfo.getMemberPrice());
        goods.setWholeSalePrice(goodsInfo.getWholeSalePrice());
        if (StringUtils.isNotBlank((CharSequence)goodsInfo.getSeason()) && !"0".equals(goodsInfo.getSeason())) {
            goods.setSeason(goodsInfo.getSeason());
        }
        goods.setQty(qty);
        goods.setSaleValue(ManipulatePrecision.doubleConvert(goods.getSalePrice() * goods.getQty(), 2, 1));
        goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
        goods.setSsgid("" + goodsInfo.getSsgid());
        goods.setControlFlag(goodsInfo.getControlFlag());
        goods.setCategoryPropertys(goodsInfo.getCategoryPropertys());
        goods.setRecycleFee(goodsInfo.getRecycleFee());
        goods.setPrtDuplFlag(goodsInfo.getPrtDuplFlag());
        goods.setSsgid("" + goodsInfo.getSsgid());
        goods.setProcessFlag(goodsInfo.getProcessFlag());
        goods.setTempCategory(goodsInfo.getCategoryCode());
        goods.setVenderCode(goodsInfo.getVenderCode());
        goods.setPrcutMode(goodsInfo.getPrcutMode());
        goods.setGoodsStatus(goodsInfo.getGoodsStatus());
        goods.setGbmanamode(goodsInfo.getGbmanamode());
        goods.setTopCategoryCode(goodsInfo.getTopCategoryCode());
        goods.setTopCategoryName(goodsInfo.getTopCategoryName());
    }

    public static List<Goods> transferGoodsList(List<GoodsInfo> goodsInfoList) {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (GoodsInfo goodsInfo : goodsInfoList) {
            Goods goods = new Goods();
            Goods.transferGoodsInfoToGoods(goodsInfo, goods, 1.0);
            goodsList.add(goods);
        }
        return goodsList;
    }

    public static List<Goods> transferGoodsList(List<GoodsInfo> goodsInfoList, String goodsNo) {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (GoodsInfo goodsInfo : goodsInfoList) {
            Goods goods = new Goods();
            Goods.transferGoodsInfoToGoods(goodsInfo, goods, 1.0);
            goods.setGoodsNo(goodsNo);
            goodsList.add(goods);
        }
        return goodsList;
    }

    public static List<Goods> delMealGoods(String sGoodsSno, List<Goods> goodsList) {
        for (int i = 0; i < goodsList.size(); ++i) {
            Goods goods = goodsList.get(i);
            if (!sGoodsSno.equals(goods.getSGoodsSno())) continue;
            goodsList.remove(i);
            --i;
        }
        return goodsList;
    }

    public static List<GoodsForPos> transferGoodsToPosGoodsListForSave(List<Goods> goodsList, List<String> calcPriceType, boolean editDescribe) {
        ArrayList<GoodsForPos> list = new ArrayList<GoodsForPos>();
        for (Goods sg : goodsList) {
            if (sg.getIsNoBackGift()) continue;
            list.add(Goods.transferGoodsToPosGoods(sg, calcPriceType, editDescribe));
        }
        return list;
    }

    public static List<GoodsForPos> transferGoodsToPosGoodsList(List<Goods> goodsList, List<String> calcPriceType, boolean editDescribe) {
        ArrayList<GoodsForPos> list = new ArrayList<GoodsForPos>();
        if (null != goodsList) {
            for (Goods sg : goodsList) {
                if (sg.getIsNoBackGift()) continue;
                list.add(Goods.transferGoodsToPosGoods(Goods.removeSinglePopDetails(sg), calcPriceType, editDescribe));
            }
        }
        return list;
    }

    public static List<GoodsForPos> transferGoodsToPosGoodsListSingle(List<Goods> goodsList, List<String> calcPriceType) {
        ArrayList<GoodsForPos> list = new ArrayList<GoodsForPos>();
        if (null != goodsList) {
            for (Goods sg : goodsList) {
                if (sg.getIsNoBackGift()) continue;
                list.add(Goods.transferGoodsToPosGoods(Goods.removeSinglePopDetails(sg), calcPriceType, true));
            }
        }
        return list;
    }

    public Goods deepClone() {
        try {
            Goods newsg = new Goods();
            newsg = (Goods)this.clone();
            if (null != this.getPopDetailsInfo() && this.getPopDetailsInfo().size() > 0) {
                newsg.setPopDetailsInfo(new ArrayList<PopDetail>());
                for (PopDetail pop : this.getPopDetailsInfo()) {
                    PopDetail newPop = new PopDetail();
                    newPop = (PopDetail)pop.clone();
                    newsg.getPopDetailsInfo().add(newPop);
                }
            }
            if (null != this.getCouponUses() && this.getCouponUses().size() > 0) {
                newsg.setCouponUses(new ArrayList<CouponUse>());
                for (CouponUse couponUse : this.getCouponUses()) {
                    CouponUse newCouponUse = (CouponUse)couponUse.clone();
                    newsg.getCouponUses().add(newCouponUse);
                }
            }
            if (null != this.getCouponGains() && this.getCouponGains().size() > 0) {
                newsg.setCouponGains(new ArrayList<CouponGain>());
                for (CouponGain couponGain : this.getCouponGains()) {
                    CouponGain newCouponGain = (CouponGain)couponGain.clone();
                    newsg.getCouponGains().add(newCouponGain);
                }
            }
            if (null != this.getCategoryPropertys() && this.getCategoryPropertys().size() > 0) {
                newsg.setCategoryPropertys(new ArrayList<CategoryProperty>());
                for (CategoryProperty property : this.getCategoryPropertys()) {
                    CategoryProperty newProperty = (CategoryProperty)property.clone();
                    newsg.getCategoryPropertys().add(newProperty);
                }
            }
            return newsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this;
        }
    }

    public Goods deepCloneWithOutPopInfo() {
        try {
            Goods newsg = new Goods();
            newsg = (Goods)this.clone();
            newsg.setPopDetailsInfo(new ArrayList<PopDetail>());
            newsg.setCouponUses(new ArrayList<CouponUse>());
            newsg.setCouponGains(new ArrayList<CouponGain>());
            if (null != this.getCategoryPropertys() && this.getCategoryPropertys().size() > 0) {
                newsg.setCategoryPropertys(new ArrayList<CategoryProperty>());
                for (CategoryProperty property : this.getCategoryPropertys()) {
                    CategoryProperty newProperty = (CategoryProperty)property.clone();
                    newsg.getCategoryPropertys().add(newProperty);
                }
            }
            newsg.setCategoryPropertys(new ArrayList<CategoryProperty>());
            return newsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this;
        }
    }

    public static Goods removeConditionPopDetails(Goods orsg, List<String> calcPriceType) {
        if (null == orsg.getPopDetailsInfo() || orsg.getPopDetailsInfo().size() == 0) {
            return orsg;
        }
        Goods sg = orsg.deepClone();
        ArrayList<PopDetail> popDetails = new ArrayList<PopDetail>();
        for (int i = 0; i < sg.getPopDetailsInfo().size(); ++i) {
            PopDetail pop = sg.getPopDetailsInfo().get(i);
            if (!"0".equals(pop.getPopMode()) || null != pop.getPopPolicyType() && null != calcPriceType && calcPriceType.indexOf(pop.getPopPolicyType()) != -1 || YPopStatusType.pop_policy_group_point.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_pointbase.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_pointuse.equals(pop.getPopPolicyGroup())) continue;
            popDetails.add((PopDetail)pop.clone());
            if (null == pop.getPopPolicyGroup()) continue;
            if (YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_vip.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_prefe.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup())) {
                popDetails.add((PopDetail)pop.clone());
                continue;
            }
            if (YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_gift.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_promotion.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_discount.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_vipe.equals(pop.getPopPolicyGroup())) {
                popDetails.add((PopDetail)pop.clone());
                continue;
            }
            if (!YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_pointEx.equals(pop.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_paydisc.equals(pop.getPopPolicyGroup())) continue;
            popDetails.add((PopDetail)pop.clone());
        }
        sg.setPopDetailsInfo(popDetails);
        return sg;
    }

    public static Goods removeSinglePopDetails(Goods sg) {
        if (null == sg.getPopDetailsInfo() || sg.getPopDetailsInfo().size() == 0) {
            return sg;
        }
        for (int i = 0; i < sg.getPopDetailsInfo().size(); ++i) {
            PopDetail pop = sg.getPopDetailsInfo().get(i);
            if (null == pop.getPopPolicyGroup()) continue;
            if (YPopStatusType.pop_policy_group_point.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_pointbase.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_pointuse.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup())) {
                sg.getPopDetailsInfo().remove(i);
                --i;
                continue;
            }
            if (!YPopStatusType.pop_type_cwmz.equals(pop.getPopPolicyType())) continue;
            sg.getPopDetailsInfo().remove(i);
            --i;
        }
        return sg;
    }

    public static GoodsForPos transferGoodsToPosGoods(Goods sg, List<String> calcPriceType, boolean editDescribe) {
        GoodsForPos g = new GoodsForPos();
        BeanCopierUtils.copyProperties(sg, g);
        ArrayList<PopDetail> pops = new ArrayList<PopDetail>();
        List<PopDetail> popDetails = sg.getPopDetailsInfo();
        if (null != popDetails && popDetails.size() > 0) {
            for (PopDetail pop : popDetails) {
                if (null != calcPriceType && !calcPriceType.isEmpty() && calcPriceType.indexOf(pop.getPopPolicyType()) != -1) continue;
                PopDetail popInfo = new PopDetail();
                BeanCopierUtils.copyProperties(pop, popInfo);
                if (editDescribe && StringUtils.isNotBlank((CharSequence)popInfo.getPopDescribe())) {
                    popInfo.setPopDescribe(popInfo.getPopDescribe().split("]")[0] + "]");
                }
                pops.add(popInfo);
            }
        }
        g.setPopDetails(pops);
        return g;
    }

    public static Goods delZeroPop(Goods sg) {
        try {
            if (null != sg.getPopDetailsInfo()) {
                for (int i = 0; i < sg.getPopDetailsInfo().size(); ++i) {
                    PopDetail pop = sg.getPopDetailsInfo().get(i);
                    if (ManipulatePrecision.doubleCompare(pop.getDiscountAmount(), 0.0, 2) != 0) continue;
                    sg.getPopDetailsInfo().remove(i);
                    --i;
                }
            }
            return sg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return sg;
        }
    }

    public static List<Goods> combineSameGoods(List<Goods> goodslist) {
        ArrayList<Goods> newGoodsList = new ArrayList<Goods>();
        for (Goods salegoods : goodslist) {
            if (null == salegoods.getPopDetailsInfo()) {
                salegoods.setPopDetailsInfo(new ArrayList<PopDetail>());
            }
            if (null == salegoods.getCouponUses()) {
                salegoods.setCouponUses(new ArrayList<CouponUse>());
            }
            if (null == salegoods.getCouponGains()) {
                salegoods.setCouponGains(new ArrayList<CouponGain>());
            }
            if (null == salegoods.getCategoryPropertys()) {
                salegoods.setCategoryPropertys(new ArrayList<CategoryProperty>());
            }
            boolean isMerge = false;
            if (!"0".equals(salegoods.getGoodsType()) || ManipulatePrecision.doubleCompare(salegoods.getBarcodeDiscount(), 0.0, 2) > 0 || salegoods.getTempZrDiscount() > 0.0 || salegoods.getFixedDiscountValue() > 0.0 || "Y".equals(salegoods.getEscaleFlag()) || salegoods.getEWCCodeNum() > 0.0 || salegoods.getEWCCodeAmount() > 0.0) {
                Goods tempSg = salegoods.deepClone();
                newGoodsList.add(Goods.delZeroPop(tempSg));
                continue;
            }
            for (Goods newSg : newGoodsList) {
                if ((null != salegoods.getAssistantId() || null != newSg.getAssistantId()) && (null == salegoods.getAssistantId() || !salegoods.getAssistantId().equals(newSg.getAssistantId())) || !salegoods.getBarNo().equals(newSg.getBarNo()) || ManipulatePrecision.doubleCompare(salegoods.getSalePrice(), newSg.getSalePrice(), 2) != 0 || !salegoods.getFlag().equals(newSg.getFlag()) || (null != salegoods.getOrgCode() || null != newSg.getOrgCode()) && (null == salegoods.getOrgCode() || !salegoods.getOrgCode().equals(newSg.getOrgCode())) || ManipulatePrecision.doubleCompare(salegoods.getTempZkl(), newSg.getTempZkl(), 2) != 0 || !Convert.isListEqual(salegoods.getCategoryPropertys(), newSg.getCategoryPropertys())) continue;
                String precisionMode = DataExchageUtils.exchangePrecisionMode(salegoods.getPrcutMode());
                newSg.setSaleValue(ManipulatePrecision.getDetailOverFlow(newSg.getSaleValue() + salegoods.getSaleValue(), salegoods.getPrcutMode()));
                newSg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getTempZkDiscount() + salegoods.getTempZkDiscount(), "0"));
                newSg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getBarcodeDiscount() + salegoods.getBarcodeDiscount(), "0"));
                newSg.setTempZrDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getTempZrDiscount() + salegoods.getTempZrDiscount(), "0"));
                newSg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getTempZzkDiscount() + salegoods.getTempZzkDiscount(), "0"));
                newSg.setTempZzrDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getTempZzrDiscount() + salegoods.getTempZzrDiscount(), "0"));
                newSg.setFixedDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getFixedDiscountValue() + salegoods.getFixedDiscountValue(), "0"));
                newSg.setCouponValue(ManipulatePrecision.getDetailOverFlow(newSg.getCouponValue() + salegoods.getCouponValue(), "0"));
                newSg.setPopDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getPopDiscountValue() + salegoods.getPopDiscountValue(), "0"));
                newSg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getBarcodeDiscount() + salegoods.getBarcodeDiscount(), "0"));
                newSg.setAdjustDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getAdjustDiscountValue() + salegoods.getAdjustDiscountValue(), "0"));
                newSg.setCustomDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getCustomDiscountValue() + salegoods.getCustomDiscountValue(), "0"));
                newSg.setPayDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getPayDiscountValue() + salegoods.getPayDiscountValue(), "0"));
                newSg.setMealDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getMealDiscountValue() + salegoods.getMealDiscountValue(), "0"));
                newSg.setQty(ManipulatePrecision.getDetailOverFlow(newSg.getQty() + salegoods.getQty(), "0"));
                newSg.setTotalDiscountValue(PosLogicCompoment.getZZK(newSg));
                newSg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(newSg.getTotalDiscountValue() - newSg.getNoDisAmountValue()));
                newSg.setSaleAmount(newSg.getSaleValue() - newSg.getTotalDiscountValue());
                if (null != salegoods.getPopDetails()) {
                    for (PopDetail pop : salegoods.getPopDetailsInfo()) {
                        boolean popIsMerged = false;
                        if (ManipulatePrecision.doubleCompare(pop.getDiscountAmount(), 0.0, 2) == 0 || null == pop.getPopPolicyGroup()) continue;
                        for (PopDetail newPop : newSg.getPopDetailsInfo()) {
                            if (YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup())) {
                                if (!YPopStatusType.pop_policy_group_aeoncoupon.equals(newPop.getPopPolicyGroup()) || !pop.getPopMemo().equals(newPop.getPopMemo())) continue;
                                newPop.setDiscountAmount(ManipulatePrecision.getDetailOverFlow(newPop.getDiscountAmount() + pop.getDiscountAmount(), precisionMode));
                                popIsMerged = true;
                                break;
                            }
                            if (YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup())) {
                                if (!pop.getPopDescribe().equals(newPop.getPopDescribe())) continue;
                                newPop.setDiscountAmount(ManipulatePrecision.getDetailOverFlow(newPop.getDiscountAmount() + pop.getDiscountAmount(), precisionMode));
                                popIsMerged = true;
                                break;
                            }
                            if (pop.getPopEventId() != newPop.getPopEventId()) continue;
                            newPop.setDiscountAmount(ManipulatePrecision.getDetailOverFlow(newPop.getDiscountAmount() + pop.getDiscountAmount(), precisionMode));
                            popIsMerged = true;
                            break;
                        }
                        if (popIsMerged) continue;
                        newSg.getPopDetailsInfo().add(pop);
                    }
                }
                isMerge = true;
                break;
            }
            if (isMerge) continue;
            newGoodsList.add(salegoods);
        }
        return Goods.sortGoodsList(newGoodsList);
    }

    public static Goods BillDetailToRefundGiftGoods(SellDetail g, String prcutMode) {
        Goods sg = new Goods();
        sg.setPrcutMode(prcutMode);
        sg.setGuid(UUIDUtils.buildGuid());
        sg.setBarNo(g.getBarcode());
        sg.setBrandCode(g.getBrand());
        sg.setCategoryCode(g.getCategory());
        sg.setTempCategory(g.getCategory());
        sg.setArtCode("");
        sg.setPartsNum(g.getFactor());
        sg.setFlag(g.getFlag().substring(0, 1));
        if (g.getFlag().equals("4")) {
            sg.setEscaleFlag("Y");
            sg.setFlag("0");
        } else if (g.getFlag().equals("0")) {
            sg.setFlag("0");
            sg.setEscaleFlag("N");
        } else {
            sg.setFlag("0");
            sg.setEscaleFlag("N");
        }
        sg.setGoodsCode(g.getItemCode());
        sg.setGoodsName(g.getItemName());
        sg.setOriginalFlowId(g.getOriginalRowNo());
        sg.setSaleAmount(g.getSaleAmount());
        sg.setQty(g.getQty());
        sg.setFlowId(g.getRowNo());
        sg.setSaleUnit(g.getUnitcode());
        sg.setTotalDiscountValue(g.getTotalDiscount());
        sg.setSaleValue(g.getListAmount());
        sg.setOrgCode(g.getGz());
        sg.setVenderId(g.getSupplier());
        sg.setKlm(g.getKlm());
        sg.setPopDiscountValue(sg.getTotalDiscountValue());
        sg.setSalePrice(g.getPrice());
        sg.setGoodsType("0");
        sg = Goods.transferGoods(g, sg, "0", null, true, false, true);
        sg.setCalcMode("0");
        sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getRealTotalDiscountValue() - sg.getNoDisAmountValue()));
        sg.setPopGains(PopGain.sellGainListToPopGainList(g.getCGains()));
        sg.setPopUses(PopUse.sellUseListToPopUseList(g.getCUses()));
        sg.setPopReverses(PopReverse.sellReverseListToPopReverseList(g.getReverse()));
        return sg;
    }

    public static CouponGain transferCouponGain(OrdersGainDetailModel ordersGainDetail) {
        CouponGain couponGain = new CouponGain();
        couponGain.setAmount(ordersGainDetail.getAmount().doubleValue());
        couponGain.setCouponClass(ordersGainDetail.getCouponClass());
        couponGain.setCouponGroup(ordersGainDetail.getCouponGroup());
        couponGain.setCouponType(ordersGainDetail.getCouponType());
        couponGain.setPolicyId(ordersGainDetail.getPolicyId());
        couponGain.setEventId(ordersGainDetail.getEventId());
        return couponGain;
    }

    public static List<Goods> sortGoodsList(List<Goods> goodsList) {
        goodsList.sort(new Comparator<Goods>(){

            @Override
            public int compare(Goods o1, Goods o2) {
                if (o1.getFlowId() < o2.getFlowId()) {
                    return -1;
                }
                return 0;
            }
        });
        int size = goodsList.size();
        for (int i = 0; i < size; ++i) {
            goodsList.get(i).setFlowId(i + 1);
        }
        return goodsList;
    }
}

