/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.struct;

import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.DelGoodsInfo;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.GoodsForPos;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderBase;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentForPos;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersMemberModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel4Pos;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders;
import com.efuture.business.util.BeanCopierUtils;
import com.efuture.business.util.CastUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class OrderForPos
extends OrderBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<GoodsForPos> goodsList = new ArrayList<GoodsForPos>();
    private List<PaymentForPos> salePayments = new ArrayList<PaymentForPos>();
    private String message;
    private DelGoodsInfo delGood;

    public DelGoodsInfo getDelGood() {
        return this.delGood;
    }

    public void setDelGood(DelGoodsInfo delGood) {
        this.delGood = delGood;
    }

    public List<GoodsForPos> getGoodsList() {
        return this.goodsList;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public void setGoodsList(List<GoodsForPos> goodsList) {
        this.goodsList = goodsList;
    }

    public List<PaymentForPos> getSalePayments() {
        return this.salePayments;
    }

    public void setSalePayments(List<PaymentForPos> salePayments) {
        this.salePayments = salePayments;
    }

    public static OrderForPos toOrderForPos(SaleOrders saleOrders) {
        OrdersModel4Pos saleOrder = saleOrders.getOrders();
        List<OrdersDetailModel> saleOrderDetails = saleOrders.getOrdersDetail();
        OrderForPos order = new OrderForPos();
        OrdersMemberModel saleOrdersMember = saleOrders.getOrdersMember();
        order.setStaffCardNo(saleOrder.getStaffCardNo());
        order.setStaffType(saleOrder.getStaffCardType());
        order.setStaffNo(saleOrder.getStaffNo());
        order.setStaffSale(saleOrder.getStaffShopping() == 1);
        order.setEntId(saleOrder.getEntId());
        order.setChannel(saleOrder.getChannel());
        order.setFlowNo(saleOrder.getChannelSheetNo());
        order.setErpCode(saleOrder.getErpCode());
        ConsumersData cust = new ConsumersData();
        if ("1".equals(saleOrdersMember.getCusProperty())) {
            cust.setIsMami(true);
        } else {
            cust.setIsMami(false);
        }
        order.setUnavailablePoint(CastUtil.castDouble(saleOrdersMember.getUnavailablePoint()));
        order.setUnavailablePointDate(saleOrdersMember.getUnavailablePointDate());
        order.setThisTimePoint(CastUtil.castDouble(saleOrdersMember.getThisTimeGivePoint()));
        order.setThisTimeUsedPoint(CastUtil.castDouble(saleOrdersMember.getThisTimeUsedPoint()));
        order.setTotalPoint(CastUtil.castDouble(saleOrdersMember.getThisTimeUsablePoint()));
        cust.setPoint(CastUtil.castDouble(saleOrdersMember.getLastTimeUsablePoint()));
        cust.setConsumersCardExp(saleOrdersMember.getMembershipExpireDate());
        cust.setConsumersId(saleOrder.getCid());
        cust.setConsumersType(saleOrdersMember.getCusClass());
        cust.setConsumersCard(saleOrder.getCusCode());
        order.setConsumersData(cust);
        order.setTerminalNo(saleOrder.getTerminalNo());
        order.setTerminalSno(saleOrder.getTerminalSno());
        order.setTerminalOperator(saleOrder.getTerminalOperator());
        order.setShopId(Long.parseLong(saleOrder.getBusiTakeMarketCode()));
        order.setShopName(saleOrder.getBusiTakeMarket());
        order.setShopCode(saleOrder.getBusiTakeMarketCode());
        order.setTotalDiscountValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(saleOrder.getTotalDiscountValue())));
        order.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(saleOrder.getTotalDiscountValue()) - CastUtil.castDouble(saleOrder.getPayDiscountValue())));
        order.setMemberDiscAmount(CastUtil.castDouble(saleOrder.getCustomDiscountValue()));
        order.setPreferentialDiscAmount(CastUtil.castDouble(saleOrder.getPopDiscountValue()));
        order.setOverageValue(CastUtil.castDouble(saleOrder.getOverageValue()));
        order.setOrderType(saleOrder.getOrderType());
        order.setExistPay(CastUtil.castDouble(saleOrder.getFactPay()));
        order.setOughtPay(CastUtil.castDouble(saleOrder.getOughtPay()));
        order.setPayState(saleOrder.getPayState());
        order.setPointCardNo(saleOrdersMember.getJfkh());
        order.setRefundAuthzCardNo(saleOrder.getThsq());
        order.setTerminalOperatorAuthzCardNo(saleOrder.getGhsq());
        order.setMemberAuthzCardNo(saleOrder.getHysq());
        order.setTotalDiscAuthzCardNo(saleOrder.getSqkh());
        order.setSeqNo(saleOrder.getCalcBillId());
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            order.setSaleDate(sdf.format(saleOrder.getSaleDate()));
            if (null != saleOrder.getOriginSaleDate()) {
                order.setOriginSaleDate(sdf.format(saleOrder.getOriginSaleDate()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        order.setOriginTerminalNo(saleOrder.getOriginTerminalNo());
        order.setOriginTerminalSno(saleOrder.getOriginTerminalSno());
        order.setOriginShopName(saleOrder.getOriginMarket());
        order.setIdSheetNo(saleOrder.getSheetNo());
        order.setChangeValue(CastUtil.castDouble(saleOrder.getChangeValue()));
        order.setRoundUpOverageValue(CastUtil.castDouble(saleOrder.getRoundUpOverageValue()));
        int sumqty = 0;
        if (null != saleOrderDetails && saleOrderDetails.size() > 0) {
            for (OrdersDetailModel saleOrderDetail : saleOrderDetails) {
                if (saleOrderDetail.getWeighGood() == 1) {
                    ++sumqty;
                    continue;
                }
                sumqty += saleOrderDetail.getQty().intValue();
            }
        }
        order.setQty(sumqty);
        return order;
    }

    public static OrderForPos toOrderForPosSingle(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        if (null == order.getConsumersData() || StringUtils.isBlank((String)order.getConsumersData().getConsumersCard())) {
            order.setConsumersData(null);
        }
        OrderForPos ofp = new OrderForPos();
        BeanCopierUtils.copyProperties(order, ofp);
        List<GoodsForPos> goodListPops = Goods.transferGoodsToPosGoodsListSingle(cacheModel.getGoodsList(), cacheModel.getOrder().getSysPara().getCalcPriceType());
        ofp.setGoodsList(goodListPops);
        ofp.setSalePayments(Payment.transferPosPaymentList(cacheModel.getPayments()));
        if (null != cacheModel.getOrder().getDelGoods() && !StringUtils.isBlank((String)cacheModel.getOrder().getDelGoods().getBarNo())) {
            ofp.setDelGood(cacheModel.getOrder().getDelGoods());
        }
        return ofp;
    }

    public static OrderForPos toReturnOrderForPos(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        if (null == order.getConsumersData() || StringUtils.isBlank((String)order.getConsumersData().getConsumersCard())) {
            order.setConsumersData(null);
        }
        OrderForPos ofp = new OrderForPos();
        BeanCopierUtils.copyProperties(order, ofp);
        List<GoodsForPos> goodListPops = Goods.transferGoodsToPosGoodsListSingle(cacheModel.getReturnGoodsList(), cacheModel.getOrder().getSysPara().getCalcPriceType());
        ofp.setGoodsList(goodListPops);
        ofp.setSalePayments(Payment.transferPosPaymentList(cacheModel.getPayments()));
        if (null != cacheModel.getOrder().getDelGoods() && !StringUtils.isBlank((String)cacheModel.getOrder().getDelGoods().getBarNo())) {
            ofp.setDelGood(cacheModel.getOrder().getDelGoods());
        }
        return ofp;
    }

    public static OrderForPos toOrderForPosOrderSave(CacheModel cacheModel, List<Goods> printGoods) {
        Order order = cacheModel.getOrder();
        if (null == order.getConsumersData() || StringUtils.isBlank((String)order.getConsumersData().getConsumersCard())) {
            order.setConsumersData(null);
        }
        OrderForPos ofp = new OrderForPos();
        BeanCopierUtils.copyProperties(order, ofp);
        List<GoodsForPos> goodListPops = Goods.transferGoodsToPosGoodsListForSave(printGoods, cacheModel.getOrder().getSysPara().getCalcPriceType(), true);
        ofp.setGoodsList(goodListPops);
        ofp.setSalePayments(Payment.transferPosPaymentList(cacheModel.getPayments()));
        if (null != cacheModel.getOrder().getDelGoods() && !StringUtils.isBlank((String)cacheModel.getOrder().getDelGoods().getBarNo())) {
            ofp.setDelGood(cacheModel.getOrder().getDelGoods());
        }
        return ofp;
    }

    public static OrderForPos toOrderForReturnQuery(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        if (null == order.getConsumersData() || StringUtils.isBlank((String)order.getConsumersData().getConsumersCard())) {
            order.setConsumersData(null);
        }
        OrderForPos ofp = new OrderForPos();
        BeanCopierUtils.copyProperties(order, ofp);
        List<GoodsForPos> goodListPops = Goods.transferGoodsToPosGoodsListSingle(cacheModel.getReturnGoodsList(), cacheModel.getOrder().getSysPara().getCalcPriceType());
        ofp.setGoodsList(goodListPops);
        ofp.setSalePayments(Payment.transferPosPaymentList(cacheModel.getReturnPayments()));
        if (null != cacheModel.getOrder().getDelGoods() && !StringUtils.isBlank((String)cacheModel.getOrder().getDelGoods().getBarNo())) {
            ofp.setDelGood(cacheModel.getOrder().getDelGoods());
        }
        return ofp;
    }

    public static OrderForPos toOrderForPos(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        if (null == order.getConsumersData() || StringUtils.isBlank((String)order.getConsumersData().getConsumersCard())) {
            order.setConsumersData(null);
        }
        OrderForPos ofp = new OrderForPos();
        BeanCopierUtils.copyProperties(order, ofp);
        List<GoodsForPos> goodListPops = Goods.transferGoodsToPosGoodsList(cacheModel.getGoodsList(), cacheModel.getOrder().getSysPara().getCalcPriceType(), false);
        ofp.setGoodsList(goodListPops);
        ofp.setSalePayments(Payment.transferPosPaymentList(cacheModel.getPayments()));
        if (null != cacheModel.getOrder().getDelGoods() && !StringUtils.isBlank((String)cacheModel.getOrder().getDelGoods().getBarNo())) {
            ofp.setDelGood(cacheModel.getOrder().getDelGoods());
        }
        return ofp;
    }
}

