/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.struct;

import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.PaymentForPos;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPayModel;
import com.efuture.business.javaPos.struct.promotionCentre.SellPayment;
import com.efuture.business.util.BeanCopierUtils;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.UUIDUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class Payment
extends PaymentForPos
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String couponGroup;
    private String couponType;
    private String couponEventScd;
    private long couponEventId;
    private long couponPolicyId;
    private List<String> couponMutex;
    private String couponPayToken;
    private double overPay;
    private String couponIsCash;
    private int rowno;
    private String rownoId;
    private double remainCharge;
    private String dxtype;
    private double chargeRate;
    private String isAllowCharge;
    private String isOverage;
    private double minVal;
    private double maxVal;
    private String prcutMode;
    private String precision;
    private double roundUpOverageValue;
    private String custmnerName;
    private String expiryDate;
    private int installmentTerms;
    private double firstInstallmentAmount;
    private String firstPaymentDueDate;
    private String finalPyamentDueDate;
    private String deliveryMemoNumber;
    private String additionalData;
    private double monthlyInstallment;
    private boolean octopusIsSmart;
    private String octopusTranscationTime;
    private String octopusLastAddValDate;
    private String octopusLastAddValType;
    private String paymentSource;
    private String isCoupon = "N";
    private int promotionRetrunRowNo;
    private boolean isDirectDel = false;
    private boolean isAutoDelOnly = false;
    private boolean isHaveDelDiscount = false;
    private String passwd;
    private String bankType;
    private boolean mCreditsFlag = true;
    private boolean mInvoiceFlag = true;
    private String mName;
    private String merchantsCode;
    private String merchantsId;
    private boolean creditsFlag = true;
    private boolean invoiceFlag = true;
    private boolean pfCreditsFlag = true;
    private boolean pfInvoiceFlag = true;
    private String pfName;
    private String platformId;
    private String platformCode;
    private boolean alreadyAllot;
    private boolean isSuccess = true;

    public boolean getIsSuccess() {
        return this.isSuccess;
    }

    public void setIsSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public boolean getAlreadyAllot() {
        return this.alreadyAllot;
    }

    public void setAlreadyAllot(boolean alreadyAllot) {
        this.alreadyAllot = alreadyAllot;
    }

    public boolean getMCreditsFlag() {
        return this.mCreditsFlag;
    }

    public void setMCreditsFlag(boolean mCreditsFlag) {
        this.mCreditsFlag = mCreditsFlag;
    }

    public boolean getMInvoiceFlag() {
        return this.mInvoiceFlag;
    }

    public void setMInvoiceFlag(boolean mInvoiceFlag) {
        this.mInvoiceFlag = mInvoiceFlag;
    }

    public boolean getCreditsFlag() {
        return this.creditsFlag;
    }

    public void setCreditsFlag(boolean creditsFlag) {
        this.creditsFlag = creditsFlag;
    }

    public boolean getInvoiceFlag() {
        return this.invoiceFlag;
    }

    public void setInvoiceFlag(boolean invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }

    public boolean getPfCreditsFlag() {
        return this.pfCreditsFlag;
    }

    public void setPfCreditsFlag(boolean pfCreditsFlag) {
        this.pfCreditsFlag = pfCreditsFlag;
    }

    public boolean getPfInvoiceFlag() {
        return this.pfInvoiceFlag;
    }

    public void setPfInvoiceFlag(boolean pfInvoiceFlag) {
        this.pfInvoiceFlag = pfInvoiceFlag;
    }

    public String getmName() {
        return this.mName;
    }

    public void setmName(String mName) {
        this.mName = mName;
    }

    public String getMerchantsCode() {
        return this.merchantsCode;
    }

    public void setMerchantsCode(String merchantsCode) {
        this.merchantsCode = merchantsCode;
    }

    public String getMerchantsId() {
        return this.merchantsId;
    }

    public void setMerchantsId(String merchantsId) {
        this.merchantsId = merchantsId;
    }

    public String getPfName() {
        return this.pfName;
    }

    public void setPfName(String pfName) {
        this.pfName = pfName;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public String getPlatformCode() {
        return this.platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public String getBankType() {
        return this.bankType;
    }

    public void setBankType(String bankType) {
        this.bankType = bankType;
    }

    public boolean getIsHaveDelDiscount() {
        return this.isHaveDelDiscount;
    }

    public void setIsHaveDelDiscount(boolean isHaveDelDiscount) {
        this.isHaveDelDiscount = isHaveDelDiscount;
    }

    public boolean getOctopusIsSmart() {
        return this.octopusIsSmart;
    }

    public void setOctopusIsSmart(boolean octopusIsSmart) {
        this.octopusIsSmart = octopusIsSmart;
    }

    public String getOctopusTranscationTime() {
        return this.octopusTranscationTime;
    }

    public void setOctopusTranscationTime(String octopusTranscationTime) {
        this.octopusTranscationTime = octopusTranscationTime;
    }

    public String getOctopusLastAddValDate() {
        return this.octopusLastAddValDate;
    }

    public void setOctopusLastAddValDate(String octopusLastAddValDate) {
        this.octopusLastAddValDate = octopusLastAddValDate;
    }

    public String getOctopusLastAddValType() {
        return this.octopusLastAddValType;
    }

    public void setOctopusLastAddValType(String octopusLastAddValType) {
        this.octopusLastAddValType = octopusLastAddValType;
    }

    public boolean getIsAutoDelOnly() {
        return this.isAutoDelOnly;
    }

    public void setIsAutoDelOnly(boolean isAutoDelOnly) {
        this.isAutoDelOnly = isAutoDelOnly;
    }

    public boolean getIsDirectDel() {
        return this.isDirectDel;
    }

    public void setIsDirectDel(boolean isDirectDel) {
        this.isDirectDel = isDirectDel;
    }

    public int getPromotionRetrunRowNo() {
        return this.promotionRetrunRowNo;
    }

    public void setPromotionRetrunRowNo(int promotionRetrunRowNo) {
        this.promotionRetrunRowNo = promotionRetrunRowNo;
    }

    public String getIsCoupon() {
        return this.isCoupon;
    }

    public String getCustmnerName() {
        return this.custmnerName;
    }

    public void setCustmnerName(String custmnerName) {
        this.custmnerName = custmnerName;
    }

    public String getFirstPaymentDueDate() {
        return this.firstPaymentDueDate;
    }

    public void setFirstPaymentDueDate(String firstPaymentDueDate) {
        this.firstPaymentDueDate = firstPaymentDueDate;
    }

    public String getFinalPyamentDueDate() {
        return this.finalPyamentDueDate;
    }

    public void setFinalPyamentDueDate(String finalPyamentDueDate) {
        this.finalPyamentDueDate = finalPyamentDueDate;
    }

    public double getMonthlyInstallment() {
        return this.monthlyInstallment;
    }

    public void setMonthlyInstallment(double monthlyInstallment) {
        this.monthlyInstallment = monthlyInstallment;
    }

    public void setIsCoupon(String isCoupon) {
        this.isCoupon = isCoupon;
    }

    public String getPaymentSource() {
        return this.paymentSource;
    }

    public void setPaymentSource(String paymentSource) {
        this.paymentSource = paymentSource;
    }

    public List<String> getCouponMutex() {
        return this.couponMutex;
    }

    public void setCouponMutex(List<String> couponMutex) {
        this.couponMutex = couponMutex;
    }

    public String getCouponPayToken() {
        return this.couponPayToken;
    }

    public void setCouponPayToken(String couponPayToken) {
        this.couponPayToken = couponPayToken;
    }

    public String getRownoId() {
        return this.rownoId;
    }

    public void setRownoId(String rownoId) {
        this.rownoId = rownoId;
    }

    public double getRemainCharge() {
        return this.remainCharge;
    }

    public void setRemainCharge(double remainCharge) {
        this.remainCharge = remainCharge;
    }

    public String getCouponGroup() {
        return this.couponGroup;
    }

    public void setCouponGroup(String couponGroup) {
        this.couponGroup = couponGroup;
    }

    public String getCouponType() {
        return this.couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public String getCouponEventScd() {
        return this.couponEventScd;
    }

    public void setCouponEventScd(String couponEventScd) {
        this.couponEventScd = couponEventScd;
    }

    public long getCouponEventId() {
        return this.couponEventId;
    }

    public void setCouponEventId(long couponEventId) {
        this.couponEventId = couponEventId;
    }

    public long getCouponPolicyId() {
        return this.couponPolicyId;
    }

    public void setCouponPolicyId(long couponPolicyId) {
        this.couponPolicyId = couponPolicyId;
    }

    public double getOverPay() {
        return this.overPay;
    }

    public void setOverPay(double overPay) {
        this.overPay = overPay;
    }

    public String getCouponIsCash() {
        return this.couponIsCash;
    }

    public void setCouponIsCash(String couponIsCash) {
        this.couponIsCash = couponIsCash;
    }

    public String getDxtype() {
        return this.dxtype;
    }

    public void setDxtype(String dxtype) {
        this.dxtype = dxtype;
    }

    public int getRowno() {
        return this.rowno;
    }

    public void setRowno(int rowno) {
        this.rowno = rowno;
    }

    public double getChargeRate() {
        return this.chargeRate;
    }

    public void setChargeRate(double chargeRate) {
        this.chargeRate = chargeRate;
    }

    public String getIsAllowCharge() {
        return this.isAllowCharge;
    }

    public void setIsAllowCharge(String isAllowCharge) {
        this.isAllowCharge = isAllowCharge;
    }

    public String getIsOverage() {
        return this.isOverage;
    }

    public void setIsOverage(String isOverage) {
        this.isOverage = isOverage;
    }

    public double getMinVal() {
        return this.minVal;
    }

    public void setMinVal(double minVal) {
        this.minVal = minVal;
    }

    public double getMaxVal() {
        return this.maxVal;
    }

    public void setMaxVal(double maxVal) {
        this.maxVal = maxVal;
    }

    public String getPrcutMode() {
        return this.prcutMode;
    }

    public void setPrcutMode(String prcutMode) {
        this.prcutMode = prcutMode;
    }

    public String getPrecision() {
        return this.precision;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public double getRoundUpOverageValue() {
        return this.roundUpOverageValue;
    }

    public void setRoundUpOverageValue(double roundUpOverageValue) {
        this.roundUpOverageValue = roundUpOverageValue;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public int getInstallmentTerms() {
        return this.installmentTerms;
    }

    public void setInstallmentTerms(int installmentTerms) {
        this.installmentTerms = installmentTerms;
    }

    public double getFirstInstallmentAmount() {
        return this.firstInstallmentAmount;
    }

    public void setFirstInstallmentAmount(double firstInstallmentAmount) {
        this.firstInstallmentAmount = firstInstallmentAmount;
    }

    public String getDeliveryMemoNumber() {
        return this.deliveryMemoNumber;
    }

    public void setDeliveryMemoNumber(String deliveryMemoNumber) {
        this.deliveryMemoNumber = deliveryMemoNumber;
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    public void setAutoDelOnly(boolean isAutoDelOnly) {
        this.isAutoDelOnly = isAutoDelOnly;
    }

    public static SellPayment transferSellPayment(Payment payment) {
        return Payment.transferSellPayment(payment, false);
    }

    public static SellPayment transferSellPayment(Payment payment, boolean isBack) {
        return Payment.transferSellPayment(payment, false, isBack);
    }

    public static SellPayment transferSellPayment(Payment payment, boolean isExceptPay, boolean isBack) {
        SellPayment sellPayment = new SellPayment();
        sellPayment.setRowNo(payment.getRowno());
        sellPayment.setFlag(DataExchageUtils.getPopPayFlag(payment, isExceptPay, isBack));
        sellPayment.setPayType(payment.getPayType());
        sellPayment.setPaycode(payment.getPayCode());
        sellPayment.setPayName(payment.getPayName());
        sellPayment.setCopType(payment.getCouponType());
        if (null != payment.getPayNo() && payment.getPayNo().length() > 100) {
            sellPayment.setPayNo(payment.getPayNo().substring(0, 100));
        } else {
            sellPayment.setPayNo(payment.getPayNo());
        }
        sellPayment.setPayMemo(payment.getMemo());
        sellPayment.setRate(payment.getRate());
        sellPayment.setAmount(payment.getAmount());
        sellPayment.setMoney(payment.getMoney());
        sellPayment.setOverage(payment.getOverage());
        sellPayment.setConsumersId(payment.getConsumersId());
        sellPayment.setCouponGroup(payment.getCouponGroup());
        sellPayment.setCouponEventScd(payment.getCouponEventScd());
        sellPayment.setCouponEventId(payment.getCouponEventId());
        sellPayment.setCouponPolicyId(payment.getCouponPolicyId());
        sellPayment.setCouponMutex(payment.getCouponMutex());
        sellPayment.setCouponPayToken(payment.getCouponPayToken());
        sellPayment.setCouponTraceSeqNo(payment.getCouponTraceSeqno());
        sellPayment.setCouponBalance(payment.getCouponBalance());
        sellPayment.setOverPay(payment.getOverPay());
        sellPayment.setCouponIsCash(payment.getCouponIsCash());
        sellPayment.setCashCost(payment.getCashCost());
        sellPayment.setRowNoId(payment.getRownoId());
        sellPayment.setDxtype(payment.getDxtype());
        sellPayment.setRemainCharge(payment.getRemainCharge());
        sellPayment.setAlreadyAllot(payment.getAlreadyAllot());
        return sellPayment;
    }

    public static Payment transferPayment(SellPayment s) {
        Payment p = new Payment();
        p.setPuid(UUIDUtils.buildPuid());
        return Payment.SellPaymentToPayment(s, p);
    }

    public static Payment SellPaymentToPayment(SellPayment s, Payment p) {
        p.setRowno(s.getRowNo());
        p.setFlag(DataExchageUtils.getSalePayFlag(s.getFlag()));
        p.setPopFlag(s.getFlag());
        p.setPayType(s.getPayType());
        p.setPayCode(s.getPaycode());
        p.setPayName(s.getPayName());
        p.setCouponType(s.getCopType());
        p.setPayNo(s.getPayNo());
        p.setMemo(s.getPayMemo());
        p.setRate(s.getRate());
        p.setAmount(s.getAmount());
        p.setMoney(s.getMoney());
        p.setOverage(s.getOverage());
        p.setConsumersId(s.getConsumersId());
        p.setCouponGroup(s.getCouponGroup());
        p.setCouponEventScd(s.getCouponEventScd());
        p.setCouponEventId(s.getCouponEventId());
        p.setCouponPolicyId(s.getCouponPolicyId());
        p.setCouponMutex(s.getCouponMutex());
        p.setCouponPayToken(s.getCouponPayToken());
        p.setCouponTraceSeqno(s.getCouponTraceSeqNo());
        p.setCouponBalance(s.getCouponBalance());
        p.setOverPay(s.getOverPay());
        p.setCouponIsCash(s.getCouponIsCash());
        p.setCashCost(s.getCashCost());
        p.setRownoId(s.getRowNoId());
        p.setRemainCharge(s.getRemainCharge());
        p.setDxtype(s.getDxtype());
        p.setAlreadyAllot(s.getAlreadyAllot());
        return p;
    }

    public static OrdersPayModel transferOrdersPayModel(Payment payment) {
        OrdersPayModel saleOrderPay = new OrdersPayModel();
        saleOrderPay.setCouponEventId(payment.getCouponEventId());
        saleOrderPay.setMoney(BigDecimal.valueOf(payment.getMoney()));
        saleOrderPay.setRate(payment.getRate());
        saleOrderPay.setCopType(payment.getCouponType());
        saleOrderPay.setPayName(payment.getPayName());
        saleOrderPay.setMerchantId(payment.getMisMerchantId());
        saleOrderPay.setTerminalId(payment.getMisTerminalId());
        saleOrderPay.setPayMemo(payment.getPayMemo());
        saleOrderPay.setOverage(BigDecimal.valueOf(payment.getOverage()));
        saleOrderPay.setCouponPolicyId(payment.getCouponPolicyId());
        saleOrderPay.setPayType(payment.getPayType());
        saleOrderPay.setCouponTraceSeqno("" + payment.getCouponTraceSeqno());
        saleOrderPay.setFlag(CastUtil.castInt(payment.getFlag()));
        saleOrderPay.setCouponGroup(payment.getCouponGroup());
        saleOrderPay.setCouponBalance(BigDecimal.valueOf(payment.getCouponBalance()));
        saleOrderPay.setPayCode(payment.getPayCode());
        saleOrderPay.setAmount(BigDecimal.valueOf(payment.getAmount()));
        saleOrderPay.setDiscountValue(BigDecimal.valueOf(payment.getDiscountValue()));
        saleOrderPay.setPayChannelDiscountValue(BigDecimal.valueOf(payment.getPayChannelDiscountValue()));
        saleOrderPay.setMerchantDiscountValue(BigDecimal.valueOf(payment.getMerchantDiscountValue()));
        saleOrderPay.setInvoiceFlag(payment.getInvoiceFlag() ? 1 : 0);
        if (null != payment.getPayNo() && payment.getPayNo().length() > 100) {
            saleOrderPay.setPayNo(payment.getPayNo().substring(0, 100));
        } else {
            saleOrderPay.setPayNo(payment.getPayNo());
        }
        if (null != payment.getRefCode() && payment.getRefCode().length() > 100) {
            saleOrderPay.setRefCode(payment.getRefCode().substring(0, 100));
        } else {
            saleOrderPay.setRefCode(payment.getRefCode());
        }
        if (null != payment.getAuthCode() && payment.getAuthCode().length() > 100) {
            saleOrderPay.setAuthCode(payment.getAuthCode().substring(0, 100));
        } else {
            saleOrderPay.setAuthCode(payment.getAuthCode());
        }
        saleOrderPay.setCouponEventScd(payment.getCouponEventScd());
        saleOrderPay.setRowNo(Long.valueOf(payment.getRowno()));
        saleOrderPay.setBatchNo(payment.getBatchNo());
        saleOrderPay.setTrace(payment.getTrace());
        saleOrderPay.setConsumersId(CastUtil.castLong(payment.getConsumersId()));
        saleOrderPay.setCouponIsClass(payment.getCouponIsCash());
        saleOrderPay.setDxtype(payment.getDxtype());
        saleOrderPay.setCashCost(BigDecimal.valueOf(payment.getCashCost()));
        saleOrderPay.setRoundUpOverageValue(BigDecimal.valueOf(payment.getRoundUpOverageValue()));
        saleOrderPay.setExpiryDate(payment.getExpiryDate());
        saleOrderPay.setInstallmentTerms(payment.getInstallmentTerms());
        saleOrderPay.setFirstInstallmentAmount(BigDecimal.valueOf(payment.getFirstInstallmentAmount()));
        saleOrderPay.setFirstPaymentDueDate(payment.getFirstPaymentDueDate());
        saleOrderPay.setFinalPyamentDueDate(payment.getFinalPyamentDueDate());
        saleOrderPay.setPosEntryMode(payment.getPosEntryMode());
        saleOrderPay.setDeliveryMemoNumber(payment.getDeliveryMemoNumber());
        saleOrderPay.setTrackData(payment.getTrackData());
        saleOrderPay.setDescription(payment.getDescription());
        saleOrderPay.setMonthlyInstallment(BigDecimal.valueOf(payment.getMonthlyInstallment()));
        if (null != payment.getBankName() && payment.getBankName().length() > 0) {
            saleOrderPay.setPayName(payment.getBankName());
        }
        if (null != payment.getBankType() && payment.getBankType().length() > 0) {
            saleOrderPay.setPayMemo(payment.getBankType());
        }
        return saleOrderPay;
    }

    public static Payment transferPayment2(OrdersPayModel saleOrderPay) {
        Payment p = new Payment();
        p.setPuid(UUIDUtils.buildPuid());
        p.setRownoId(p.getPuid());
        return Payment.SaleOrderPayToPayment(saleOrderPay, p);
    }

    public static Payment SaleOrderPayToPayment(OrdersPayModel saleOrderPay, Payment p) {
        p.setCouponEventId(saleOrderPay.getCouponEventId());
        p.setMoney(CastUtil.castDouble(saleOrderPay.getMoney()));
        p.setRate(saleOrderPay.getRate());
        p.setCouponType(saleOrderPay.getCopType());
        p.setPayName(saleOrderPay.getPayName());
        p.setMisMerchantId(saleOrderPay.getMerchantId());
        p.setPayMemo(saleOrderPay.getPayMemo());
        p.setOverage(CastUtil.castDouble(saleOrderPay.getOverage()));
        p.setCouponPolicyId(saleOrderPay.getCouponPolicyId());
        p.setPayType(saleOrderPay.getPayType());
        p.setCouponTraceSeqno(CastUtil.castLong(saleOrderPay.getCouponTraceSeqno()));
        p.setFlag(String.valueOf(saleOrderPay.getFlag()));
        p.setCouponGroup(saleOrderPay.getCouponGroup());
        p.setCouponBalance(CastUtil.castDouble(saleOrderPay.getCouponBalance()));
        p.setPayCode(saleOrderPay.getPayCode());
        p.setAmount(CastUtil.castDouble(saleOrderPay.getAmount()));
        p.setPayNo(saleOrderPay.getPayNo());
        p.setCouponEventScd(saleOrderPay.getCouponEventScd());
        p.setRowno(saleOrderPay.getRowNo().intValue());
        p.setBatchNo(saleOrderPay.getBatchNo());
        p.setRefCode(saleOrderPay.getRefCode());
        p.setTrace(saleOrderPay.getTrace());
        p.setConsumersId(String.valueOf(saleOrderPay.getConsumersId()));
        p.setCouponIsCash(saleOrderPay.getCouponIsClass());
        p.setDxtype(saleOrderPay.getDxtype());
        p.setCashCost(CastUtil.castDouble(saleOrderPay.getCashCost()));
        p.setMisTerminalId(saleOrderPay.getTerminalId());
        p.setBatchNo(saleOrderPay.getBatchNo());
        p.setAuthCode(saleOrderPay.getAuthCode());
        p.setCouponType(saleOrderPay.getCopType());
        p.setRoundUpOverageValue(CastUtil.castDouble(saleOrderPay.getRoundUpOverageValue()));
        p.setOverPay(0.0);
        p.setExpiryDate(saleOrderPay.getExpiryDate());
        p.setInstallmentTerms(saleOrderPay.getInstallmentTerms());
        p.setFirstInstallmentAmount(CastUtil.castDouble(saleOrderPay.getFirstInstallmentAmount()));
        p.setFirstPaymentDueDate(saleOrderPay.getFirstPaymentDueDate());
        p.setFinalPyamentDueDate(saleOrderPay.getFinalPyamentDueDate());
        p.setPosEntryMode(saleOrderPay.getPosEntryMode());
        p.setDeliveryMemoNumber(saleOrderPay.getDeliveryMemoNumber());
        p.setTrackData(saleOrderPay.getTrackData());
        p.setDescription(saleOrderPay.getDescription());
        p.setMonthlyInstallment(CastUtil.castDouble(saleOrderPay.getMonthlyInstallment()));
        p.setMerchantDiscountValue(CastUtil.castDouble(saleOrderPay.getMerchantDiscountValue()));
        p.setDiscountValue(CastUtil.castDouble(saleOrderPay.getDiscountValue()));
        p.setPayChannelDiscountValue(CastUtil.castDouble(saleOrderPay.getPayChannelDiscountValue()));
        return p;
    }

    public static List<SellPayment> transferSellPayment(List<Payment> payments, boolean isBack) {
        if (payments == null || payments.size() == 0) {
            return null;
        }
        ArrayList<SellPayment> sellPayments = new ArrayList<SellPayment>();
        boolean needMinus = false;
        for (int i = 0; i < payments.size(); ++i) {
            Payment payment = payments.get(i);
            if (payment.getMerchantDiscountValue() > 0.0 || payment.getPayChannelDiscountValue() > 0.0) {
                Payment p = (Payment)payment.clone();
                p.setAmount(ManipulatePrecision.doubleConvert(p.getMoney() - p.getMerchantDiscountValue() - p.getPayChannelDiscountValue()));
                p.setMoney(p.getAmount());
                p.setRate(1.0);
                SellPayment sellPayment = Payment.transferSellPayment(p, isBack);
                sellPayments.add(sellPayment);
                if (payment.getMerchantDiscountValue() > 0.0) {
                    p.setAmount(p.getMerchantDiscountValue());
                    p.setMoney(p.getAmount());
                    p.setRate(1.0);
                    p.setCouponType("MERCHANTDISCOUNT");
                    p.setPuid(p.getPuid() + "1");
                    p.setRownoId(p.getRownoId() + "1");
                    sellPayment = Payment.transferSellPayment(p, isBack);
                    sellPayments.add(sellPayment);
                }
                if (!(payment.getPayChannelDiscountValue() > 0.0)) continue;
                p.setAmount(p.getPayChannelDiscountValue());
                p.setMoney(p.getAmount());
                p.setRate(1.0);
                p.setCouponType("PLATFORMDISCOUNT");
                p.setPuid(p.getPuid() + "2");
                p.setRownoId(p.getRownoId() + "2");
                sellPayment = Payment.transferSellPayment(p, isBack);
                sellPayments.add(sellPayment);
                continue;
            }
            if (!"2".equals(payment.getFlag())) {
                SellPayment sellPayment = Payment.transferSellPayment(payment, isBack);
                if (needMinus) {
                    sellPayment.setAmount(ManipulatePrecision.doubleConvert(sellPayment.getAmount() - payments.get(i - 1).getAmount()));
                    sellPayment.setMoney(ManipulatePrecision.doubleConvert(sellPayment.getMoney() - payments.get(i - 1).getMoney()));
                    needMinus = false;
                }
                sellPayments.add(sellPayment);
                continue;
            }
            needMinus = true;
        }
        return sellPayments;
    }

    public static List<SellPayment> transferSellPaymentForReturn(CacheModel cacheModel) {
        if (null == cacheModel) {
            return null;
        }
        if (null == cacheModel.getOrder()) {
            return null;
        }
        ArrayList<SellPayment> sellPayments = new ArrayList<SellPayment>();
        if (null == cacheModel.getTempSalePayments() || cacheModel.getTempSalePayments().size() > 0) {
            List<Payment> TempSalePayments = cacheModel.getTempSalePayments();
            for (Payment payment : TempSalePayments) {
                SellPayment sellPayment = Payment.transferSellPayment(payment, true);
                sellPayment.setFlag(payment.getPopFlag());
                sellPayments.add(sellPayment);
            }
        }
        for (int i = 0; i < cacheModel.getPayments().size(); ++i) {
            Payment payment = cacheModel.getPayments().get(i);
            if ("NY".equals(payment.getPaymentSource())) continue;
            SellPayment sellPayment = Payment.transferSellPayment(payment, true);
            sellPayments.add(sellPayment);
        }
        return sellPayments;
    }

    public static List<Payment> transferPayment(List<SellPayment> sellPayments) {
        if (sellPayments == null || sellPayments.size() == 0) {
            return null;
        }
        ArrayList<Payment> payments = new ArrayList<Payment>();
        for (SellPayment sellPayment : sellPayments) {
            Payment payment = Payment.transferPayment(sellPayment);
            payments.add(payment);
        }
        return payments;
    }

    public static List<PaymentForPos> transferPosPaymentList(List<Payment> payments) {
        if (payments == null || payments.size() == 0) {
            return new ArrayList<PaymentForPos>(1);
        }
        ArrayList<PaymentForPos> paymentsForPos = new ArrayList<PaymentForPos>();
        for (Payment payment : payments) {
            PaymentForPos paymentForPos = new PaymentForPos();
            BeanCopierUtils.copyProperties(payment, paymentForPos);
            paymentsForPos.add(paymentForPos);
        }
        return paymentsForPos;
    }

    public static List<OrdersPayModel> transferOrdersPayModel(List<Payment> payments) {
        if (payments == null || payments.size() == 0) {
            return null;
        }
        ArrayList<OrdersPayModel> saleOrderPays = new ArrayList<OrdersPayModel>();
        for (Payment payment : payments) {
            OrdersPayModel saleOrderPay = Payment.transferOrdersPayModel(payment);
            saleOrderPays.add(saleOrderPay);
        }
        return saleOrderPays;
    }

    public static List<Payment> transferPayment3(List<OrdersPayModel> saleOrderPays) {
        if (saleOrderPays == null || saleOrderPays.size() == 0) {
            return null;
        }
        ArrayList<Payment> payments = new ArrayList<Payment>();
        for (OrdersPayModel saleOrderPay : saleOrderPays) {
            Payment payment = Payment.transferPayment2(saleOrderPay);
            payments.add(payment);
        }
        return payments;
    }
}

