/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.struct.orderCentre;

import com.product.exception.ServiceRuntimeException;

public enum OrderTypeEnum {
    LSXS("1", "OR", "\u96f6\u552e\u9500\u552e"),
    HCLS("2", "RV", "\u7ea2\u51b2\u96f6\u552e"),
    LSTH("4", "RE", "\u96f6\u552e\u9000\u8d27"),
    HCTH("3", "RC", "\u7ea2\u51b2\u96f6\u552e\u9000\u8d27"),
    WKZF("5", "TA", "\u5c3e\u6b3e\u652f\u4ed8"),
    WKQX("6", "TC", "\u5c3e\u6b3e\u53d6\u6d88");

    private String code;
    private String prefix;
    private String chineseName;

    private OrderTypeEnum(String code, String prefix, String chineseName) {
        this.code = code;
        this.prefix = prefix;
        this.chineseName = chineseName;
    }

    public String export() {
        return String.format("[%s]%s", this.getCode(), this.getChineseName());
    }

    public static String export(String code) {
        for (OrderTypeEnum o : OrderTypeEnum.values()) {
            if (!o.code.equals(code)) continue;
            return String.format("[%s]%s", o.code, o.chineseName);
        }
        throw new ServiceRuntimeException(String.format("ENUM ERROR[%s:%s]", OrderTypeEnum.class.getSimpleName(), code));
    }

    public static OrderTypeEnum instance(String code) {
        for (OrderTypeEnum o : OrderTypeEnum.values()) {
            if (!o.code.equals(code)) continue;
            return o;
        }
        throw new ServiceRuntimeException(String.format("ENUM ERROR[%s:%s]", OrderTypeEnum.class.getSimpleName(), code));
    }

    public static String chinese(String code) {
        for (OrderTypeEnum o : OrderTypeEnum.values()) {
            if (!o.code.equals(code)) continue;
            return o.chineseName;
        }
        throw new ServiceRuntimeException(String.format("ENUM ERROR[OrderTypeEnum:%d]", code));
    }

    public String getCode() {
        return this.code;
    }

    public String getChineseName() {
        return this.chineseName;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

