/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.struct.orderCentre;

import com.efuture.business.bean.SellType;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Coupon;
import com.efuture.business.javaPos.struct.CouponGain;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailPopModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersExtModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersGainDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersGainModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersMemberModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel4Pos;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPayModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersUseCouponModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SaleOrders
implements Serializable {
    private static final long serialVersionUID = 1L;
    private OrdersModel4Pos orders;
    private OrdersExtModel ordersExt;
    private OrdersMemberModel ordersMember;
    private List<OrdersDetailModel> ordersDetail;
    private List<OrdersDetailPopModel> ordersDetailPop;
    private List<OrdersUseCouponModel> ordersUseCoupon;
    private List<OrdersGainDetailModel> ordersGainDetail;
    private List<OrdersGainModel> ordersGain;
    private List<OrdersPayModel> ordersPay;
    private int rePrintCnt;

    public int getRePrintCnt() {
        return this.rePrintCnt;
    }

    public void setRePrintCnt(int rePrintCnt) {
        this.rePrintCnt = rePrintCnt;
    }

    public OrdersModel4Pos getOrders() {
        return this.orders;
    }

    public void setOrders(OrdersModel4Pos orders) {
        this.orders = orders;
    }

    public OrdersMemberModel getOrdersMember() {
        return this.ordersMember;
    }

    public void setOrdersMember(OrdersMemberModel ordersMember) {
        this.ordersMember = ordersMember;
    }

    public List<OrdersDetailModel> getOrdersDetail() {
        return this.ordersDetail;
    }

    public void setOrdersDetail(List<OrdersDetailModel> ordersDetail) {
        this.ordersDetail = ordersDetail;
    }

    public List<OrdersDetailPopModel> getOrdersDetailPop() {
        return this.ordersDetailPop;
    }

    public void setOrdersDetailPop(List<OrdersDetailPopModel> ordersDetailPop) {
        this.ordersDetailPop = ordersDetailPop;
    }

    public List<OrdersUseCouponModel> getOrdersUseCoupon() {
        return this.ordersUseCoupon;
    }

    public void setOrdersUseCoupon(List<OrdersUseCouponModel> ordersUseCoupon) {
        this.ordersUseCoupon = ordersUseCoupon;
    }

    public List<OrdersGainDetailModel> getOrdersGainDetail() {
        return this.ordersGainDetail;
    }

    public void setOrdersGainDetail(List<OrdersGainDetailModel> ordersGainDetail) {
        this.ordersGainDetail = ordersGainDetail;
    }

    public List<OrdersGainModel> getOrdersGain() {
        return this.ordersGain;
    }

    public void setOrdersGain(List<OrdersGainModel> ordersGain) {
        this.ordersGain = ordersGain;
    }

    public List<OrdersPayModel> getOrdersPay() {
        return this.ordersPay;
    }

    public void setOrdersPay(List<OrdersPayModel> ordersPay) {
        this.ordersPay = ordersPay;
    }

    public static SaleOrders fromCacheModel(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        boolean isCold = true;
        for (Goods g : cacheModel.getGoodsList()) {
            if (g.getColdTransFlag()) continue;
            isCold = false;
            break;
        }
        if (isCold) {
            order.setColdStorage(true);
        }
        SaleOrders saleOrder = Order.toSaleOrder(order);
        saleOrder = SaleOrders.gainSaleOrderDetailAndSaleOrderDetailPop(saleOrder, cacheModel.getGoodsList());
        saleOrder.setOrdersPay(Payment.transferOrdersPayModel(cacheModel.getPayments()));
        saleOrder = SaleOrders.gainSaleOrderGainDetailAndSaleOrderUseCoupon(saleOrder, cacheModel.getGoodsList());
        if (null != order.getCouponDetails() && order.getCouponDetails().size() > 0) {
            if (order.getOrderType().equals("4") && StringUtils.isBlank((String)order.getOriginTerminalSno())) {
                for (int i = 0; i < order.getCouponDetails().size(); ++i) {
                    Coupon c = order.getCouponDetails().get(i);
                    if (!c.getCouponGroup().equals("01")) continue;
                    c.setAmount(Math.abs(c.getAmount()));
                }
            }
            saleOrder.setOrdersGain(Coupon.transferOrdersGainModel(order.getCouponDetails()));
        }
        return saleOrder;
    }

    private static SaleOrders gainSaleOrderDetailAndSaleOrderDetailPop(SaleOrders saleOrder, List<Goods> goodsList) {
        ArrayList<OrdersDetailModel> details = new ArrayList<OrdersDetailModel>();
        ArrayList<OrdersDetailPopModel> pops = new ArrayList<OrdersDetailPopModel>();
        if (goodsList == null || goodsList.size() == 0) {
            return saleOrder;
        }
        for (Goods g : goodsList) {
            OrdersDetailModel d = Goods.transferOrdersDetailModel(g);
            if (SellType.ISBACK(saleOrder.getOrders().getOrderType())) {
                d.setOldRowNo(g.getOriginalFlowId());
            }
            details.add(d);
            List<OrdersDetailPopModel> dPops = PopDetail.transferOrdersDetailPopModel(g, g.getPopDetailsInfo());
            if (dPops == null || dPops.size() <= 0) continue;
            pops.addAll(dPops);
        }
        if (details.size() > 0) {
            saleOrder.setOrdersDetail(details);
        }
        if (pops.size() > 0) {
            saleOrder.setOrdersDetailPop(pops);
        }
        return saleOrder;
    }

    private static SaleOrders gainSaleOrderGainDetailAndSaleOrderUseCoupon(SaleOrders saleOrder, List<Goods> goodsList) {
        if (goodsList == null || goodsList.size() == 0) {
            return saleOrder;
        }
        ArrayList<CouponGain> couponGains = new ArrayList<CouponGain>();
        ArrayList<CouponUse> couponUses = new ArrayList<CouponUse>();
        for (Goods g : goodsList) {
            if (g.getCouponGains() != null && g.getCouponGains().size() > 0) {
                couponGains.addAll(g.getCouponGains());
            }
            if (g.getCouponUses() == null || g.getCouponUses().size() <= 0) continue;
            couponUses.addAll(g.getCouponUses());
        }
        if (couponGains.size() > 0) {
            saleOrder.setOrdersGainDetail(CouponGain.transferSaleOrderGainModel(couponGains));
        }
        if (couponUses.size() > 0) {
            saleOrder.setOrdersUseCoupon(CouponUse.transferOrdersUseCouponModel(couponUses));
        }
        return saleOrder;
    }

    public OrdersExtModel getOrdersExt() {
        return this.ordersExt;
    }

    public void setOrdersExt(OrdersExtModel ordersExt) {
        this.ordersExt = ordersExt;
    }
}

