/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.struct.promotionCentre.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.business.javaPos.struct.mainDataCentre.response.GetGoodsDetailOut;
import com.efuture.business.javaPos.struct.promotionCentre.BillDetail;
import com.efuture.business.javaPos.struct.promotionCentre.SellConsData;
import com.efuture.business.javaPos.struct.promotionCentre.SellDetail;
import com.efuture.business.javaPos.struct.promotionCentre.SellPopDetail;
import com.efuture.business.javaPos.struct.request.AddBatchGoodsIn;
import com.efuture.business.javaPos.struct.request.QueryGoodIn;
import com.efuture.business.javaPos.struct.request.SkuSearchIn;
import com.product.model.ServiceSession;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CalcsingleIn {
    @JSONField(name="calc_mode")
    private String calcMode;
    @JSONField(name="bill_detail")
    private BillDetail billDetail;
    @JSONField(name="calc_billid")
    private String calcBillid;

    public String getCalcMode() {
        return this.calcMode;
    }

    public void setCalcMode(String calcMode) {
        this.calcMode = calcMode;
    }

    public BillDetail getBillDetail() {
        return this.billDetail;
    }

    public void setBillDetail(BillDetail billDetail) {
        this.billDetail = billDetail;
    }

    public String getCalcBillid() {
        return this.calcBillid;
    }

    public void setCalcBillid(String calcBillid) {
        this.calcBillid = calcBillid;
    }

    public static CalcsingleIn build(Goods goods, SkuSearchIn skuSearchIn) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode("0");
        BillDetail billDetail = new BillDetail();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        billDetail.setChannel("" + skuSearchIn.getChannel());
        billDetail.setSaleDate(format.format(new Date()));
        billDetail.setTermInvoiceNo(1L);
        billDetail.setMarket(skuSearchIn.getShopCode());
        billDetail.setTermNo(skuSearchIn.getTerminalNo());
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setRowNo(goods.getFlowId());
        sellDetail.setFlag(goods.getFlag());
        if (null != goods.getSGoodsSno() && goods.getSGoodsSno().length() > 0) {
            sellDetail.setFlag("3");
        }
        sellDetail.setKlm(goods.getKlm());
        sellDetail.setOriginalRowNo(1);
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(skuSearchIn.getShopCode());
        sellDetail.setContract(skuSearchIn.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getSaleUnit());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrandCode());
        sellDetail.setCategory(goods.getCategoryCode());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getAdjustDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setNojf(goods.getNojf());
        sellDetail.setManaUnit(skuSearchIn.getErpCode());
        sellDetail.setSupplier(goods.getVenderId());
        sellDetails.add(sellDetail);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    public static CalcsingleIn build(GoodsInfo goods, GetGoodsDetailIn skuSearchIn) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode("0");
        BillDetail billDetail = new BillDetail();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        billDetail.setChannel("" + skuSearchIn.getChannel());
        billDetail.setSaleDate(format.format(new Date()));
        billDetail.setTermInvoiceNo(1L);
        billDetail.setMarket(skuSearchIn.getShopCode());
        billDetail.setTermNo(skuSearchIn.getTerminalNo());
        billDetail.setConsumersType("01");
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setRowNo(1);
        sellDetail.setFlag("1");
        sellDetail.setOriginalRowNo(1);
        sellDetail.setMarket(skuSearchIn.getShopCode());
        sellDetail.setContract(skuSearchIn.getShopCode());
        sellDetail.setQty(1.0);
        sellDetail.setManaUnit(skuSearchIn.getErpCode());
        sellDetails.add(sellDetail);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    public static CalcsingleIn build(Goods goods, QueryGoodIn queryGoodIn) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode("0");
        BillDetail billDetail = new BillDetail();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        billDetail.setChannel(queryGoodIn.getChannel());
        billDetail.setSaleDate(format.format(new Date()));
        billDetail.setTermInvoiceNo(1L);
        billDetail.setMarket(queryGoodIn.getShopCode());
        billDetail.setTermNo(queryGoodIn.getTerminalNo());
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
        sellDetail.setRowNo(goods.getFlowId());
        sellDetail.setFlag(goods.getFlag());
        if (null != goods.getSGoodsSno() && goods.getSGoodsSno().length() > 0) {
            sellDetail.setFlag("3");
        }
        sellDetail.setKlm(goods.getKlm());
        sellDetail.setOriginalRowNo(1);
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(queryGoodIn.getShopCode());
        sellDetail.setContract(queryGoodIn.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getSaleUnit());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrandCode());
        sellDetail.setCategory(goods.getCategoryCode());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getTotalDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setNojf(goods.getNojf());
        sellDetail.setManaUnit(queryGoodIn.getErpCode());
        sellDetail.setSupplier(goods.getVenderId());
        sellDetail.setCounter(goods.getSeason());
        if (ManipulatePrecision.doubleCompare(goods.getBarcodeDiscount(), 0.0, 2) > 0) {
            SellPopDetail sellPopDetail = new SellPopDetail();
            sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getBarcodeDiscount(), 6, 1));
            sellPopDetail.setPopMode("0");
            sellPopDetail.setPopDescribe("[\u6761\u7801\u4f18\u60e0]");
            sellPopDetail.setRowNo(goods.getFlowId());
            if (goods.getDisMode() == 3) {
                sellPopDetail.setPrcMode("6");
                sellPopDetail.setPopDescribe("[\u6761\u7801\u4f18\u60e0]");
            } else if (goods.getDisMode() == 1) {
                sellPopDetail.setPrcMode("6");
            } else if (goods.getDisMode() == 2) {
                sellPopDetail.setDiscountAmount(0.0);
                sellPopDetail.setPrcMode("5");
                sellPopDetail.setDiscountRate(ManipulatePrecision.doubleConvert(1.0 - goods.getDisValue()));
            }
            sellDetail.getSellPopDetails().add(sellPopDetail);
        }
        sellDetails.add(sellDetail);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    public static CalcsingleIn buildAddGoodsCalc(ServiceSession session, AddBatchGoodsIn in, GetGoodsDetailOut goodsDetail, String consumersId, String qty) {
        GoodsInfo goodsInfo = goodsDetail.getGoods().get(0);
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        BillDetail billDetail = new BillDetail();
        billDetail.setConsumersCardNo(consumersId);
        SellConsData sellConsData = new SellConsData();
        ArrayList<String> consumersGrps = new ArrayList<String>();
        sellConsData.setConsumersGrps(consumersGrps);
        billDetail.setConsumersData(sellConsData);
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setQty(new Integer(qty).intValue());
        sellDetail.setPrice(goodsInfo.getSalePrice());
        sellDetail.setBarcode(goodsInfo.getBarNo());
        sellDetails.add(sellDetail);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    public static CalcsingleIn buildGetSaleGoodsInfoCalc(ServiceSession session, String calcMode, Goods goods, Order order, boolean isRefreshBillId) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode(calcMode);
        BillDetail billDetail = Order.transferBillDetail(order);
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail transferSellDetail = new SellDetail();
        sellDetails.add(transferSellDetail);
        if (!isRefreshBillId) {
            calcsingleIn.setCalcBillid(order.getSeqNo());
        }
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    public static CalcsingleIn buildAddBatchGoodsCalc(ServiceSession session, List<Goods> goodsList, Order order) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode("0");
        BillDetail billDetail = Order.transferBillDetail(order);
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        for (Goods goods : goodsList) {
            goods.setPopDetailsInfo(new ArrayList<PopDetail>());
            SellDetail transferSellDetail = Goods.transferSellDetail(goods, order, true, false);
            sellDetails.add(transferSellDetail);
        }
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        calcsingleIn.setCalcBillid("");
        return calcsingleIn;
    }

    public static CalcsingleIn memberLoginCreateCalcsingleIn(Order order, List<Goods> goodsList) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        BillDetail billDetail = Order.transferBillDetail(order);
        List<SellDetail> sellDetails = Goods.transferSellDetail(goodsList, order, false);
        for (Goods goods : goodsList) {
            for (SellDetail sellDetail : sellDetails) {
                if (goods.getFlowId() != sellDetail.getRowNo()) continue;
                sellDetail.setSellPopDetails(PopDetail.transferSellPopDetail(goods.getPopDetailsInfo(), order, goods));
            }
        }
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        calcsingleIn.setCalcMode(order.getCalcMarketingMode());
        calcsingleIn.setCalcBillid(order.getSeqNo());
        calcsingleIn.setCalcMode("0");
        calcsingleIn.calcBillid = "";
        return calcsingleIn;
    }
}

