/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.util.ClassUtil;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MpBaseServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<M, T>
implements IService<T> {
    private static final Logger log = LoggerFactory.getLogger(MpBaseServiceImpl.class);
    @Autowired
    private DbTools dbTools;
    protected String tableName = this.getTableName();

    protected String getTableName() {
        return ClassUtil.getTableName(this.entityClass);
    }

    protected void setDataSourceKey(String mkt) {
        if ("Y".equals(GlobalInfo.centrally) && StringUtils.isNotBlank((String)mkt)) {
            MultipleDataSource.setDataSourceKey(this.dbTools.FilterDatesrc(this.tableName, mkt));
        } else {
            this.setDataSourceKey();
        }
    }

    protected void setDataSourceKey() {
        MultipleDataSource.setDataSourceKey(this.dbTools.FilterDatesrc(this.tableName));
    }

    public List<T> listByMap(Map<String, Object> columnMap) {
        String mkt = columnMap.containsKey("mkt") ? columnMap.get("mkt").toString() : null;
        this.setDataSourceKey(mkt);
        return this.getBaseMapper().selectByMap(columnMap);
    }

    public List<T> list(Wrapper<T> queryWrapper) {
        this.setDataSourceKey();
        return this.getBaseMapper().selectList(queryWrapper);
    }

    public boolean update(T entity, Wrapper<T> updateWrapper) {
        this.setDataSourceKey();
        return SqlHelper.retBool((Integer)this.getBaseMapper().update(entity, updateWrapper));
    }

    public boolean updateById(T entity) {
        this.setDataSourceKey();
        return SqlHelper.retBool((Integer)this.getBaseMapper().updateById(entity));
    }
}

