/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateHelpUtil {
    public static final String SIMPLEDATETIME = "yyyy-MM-dd HH:mm:ss";

    public static String nowToString(String formatString) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(formatString);
        return formatter.format(currentTime);
    }

    public static String nowToString() {
        return DateHelpUtil.nowToString(SIMPLEDATETIME);
    }

    public static String getYestoryDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String yestoday = sdf.format(calendar.getTime());
        return yestoday;
    }

    public static String getAfterDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String afterDay = sdf.format(calendar.getTime());
        return afterDay;
    }

    public static String getYestoryDate(String date) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sdf.parse(date));
        calendar.add(5, -1);
        String afterDay = sdf.format(calendar.getTime());
        return afterDay;
    }

    public static String getAfterDay(String date) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sdf.parse(date));
        calendar.add(5, 1);
        String afterDay = sdf.format(calendar.getTime());
        return afterDay;
    }

    public static String getAfterDayByDay(int day) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, day);
        String afterDay = sdf.format(calendar.getTime());
        return afterDay;
    }

    public static String getTodayDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(new Date());
        return date;
    }

    public static String getThisYear() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(1, 0);
        Date y = c.getTime();
        String year = format.format(y);
        return year;
    }

    public static String getLastYear() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(1, -1);
        Date y = c.getTime();
        String year = format.format(y);
        return year;
    }

    public static String getDateStringFromMillisecond(Long millisecond) {
        Date date = new Date(millisecond);
        SimpleDateFormat format = new SimpleDateFormat(SIMPLEDATETIME);
        return format.format(date);
    }

    public static String getDateString2FromMillisecond(Long millisecond) {
        Date date = new Date(millisecond);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    public static String getDateStringFromDate(String format, Date date) {
        SimpleDateFormat dateformat = new SimpleDateFormat(format);
        return dateformat.format(date);
    }

    public static int differentDaysByMillisecond(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }
}

